/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.rule;

import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.shrek.service.ShrekCubeServiceHelper;
import kd.epm.eb.common.shrek.service.ShrekServiceFactory;
import kd.epm.eb.common.shrek.util.ShrekOlapUtils;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.DatasetServiceHelper;

public class KuaCubeUpgradeServiceImpl
implements IUpgradeService {
    private static final Log log = LogFactory.getLog(KuaCubeUpgradeServiceImpl.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(false);
        try {
            List models;
            SqlBuilder sql = new SqlBuilder();
            sql.append("select top 50,0 fid, fshownumber,fdatasource,freporttype from t_eb_model where freporttype = '7' order by fid desc", new Object[0]);
            try (DataSet ds = DB.queryDataSet((String)"queryModel", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
                models = CommonServiceHelper.transDataSet((DataSet)ds);
            }
            for (Map model : models) {
                Model model1 = new Model();
                model1.setId((Long)model.get("fid"));
                model1.setNumber((String)model.get("fshownumber"));
                model1.setDataSourceId((Long)model.get("fdatasource"));
                model1.setReportType((String)model.get("freporttype"));
                try {
                    this.updateByModel(model1);
                }
                catch (Exception e) {
                    log.error("KuaCubeUpgradeServiceImpl-error:", (Throwable)e);
                }
            }
            result.setSuccess(true);
        }
        catch (Throwable e) {
            result.setLog(CommonServiceHelper.getStackTraceStr((Throwable)e));
        }
        return result;
    }

    public void updateByModel(Model model) {
        List datasets = DatasetServiceHelper.getAllDatasets((Long)model.getId());
        for (Dataset dataset : datasets) {
            OlapConnection connection = ShrekCubeServiceHelper.getConnection((Model)model, (Dataset)dataset);
            Throwable throwable = null;
            try {
                String cubeNumber = ShrekOlapUtils.getCubeNumber((Dataset)dataset);
                ShrekServiceFactory.SHREK_CUBE.alterCubeDatabase(connection, cubeNumber, model.getNumber());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (connection == null) continue;
                if (throwable != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                connection.close();
            }
        }
    }
}

