/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.rule;

import com.alibaba.fastjson.JSON;
import com.google.common.graph.Graph;
import com.google.common.graph.MutableGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.bizrule.RuleGraphService;
import kd.epm.eb.business.bizrule.RuleRelationService;
import kd.epm.eb.business.bizrule.entity.GraphNode;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.openapi.entity.EBApiResult;
import kd.epm.eb.common.thread.EpmThreadPools;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.ruleexec.command.RuleExecCommand;
import kd.epm.eb.formplugin.ruleexec.consumer.JobRuleExecConsumer;
import kd.epm.eb.formplugin.ruleexec.entity.RuleCase;
import kd.epm.eb.formplugin.ruleexec.entity.RuleCaseExecContext;
import kd.epm.eb.formplugin.ruleexec.entity.RuleRow;
import kd.epm.eb.formplugin.ruleexec.enums.RuleExecCaseTypeEnum;
import kd.epm.eb.formplugin.ruleexec.service.RuleCaseService;
import kd.epm.eb.formplugin.ruleexec.service.RuleExecLogService;
import kd.epm.eb.olap.impl.bizrule.RuleCacheService;
import kd.epm.eb.olap.impl.bizrule.entity.RuleDto;
import kd.epm.eb.service.rule.RuleExecCaseRequestEntry;
import org.apache.commons.collections4.CollectionUtils;

public class RuleExecCaseService {
    private static final Log log = LogFactory.getLog(RuleExecCaseService.class);

    public static RuleExecCaseService getInstance() {
        return Singleton.INSTANCE.instance;
    }

    public void submitRuleCase(List<RuleCaseExecContext> ruleCaseExecContexts) {
        for (RuleCaseExecContext ctx : ruleCaseExecContexts) {
            RuleExecCommand ruleExecCommand = new RuleExecCommand();
            ruleExecCommand.setRuleCase(ctx.getRuleCase());
            ruleExecCommand.setTaskLogId(ctx.getLogId());
            JobRuleExecConsumer ruleExecConsumer = new JobRuleExecConsumer(ruleExecCommand);
            EpmThreadPools.ruleCaseExecConsumerThreadPool.submit((Runnable)ruleExecConsumer);
        }
    }

    public ApiResult executeRuleExecCase(Map<String, Object> params) {
        log.info("executeRuleExecCaseParams:{}", params);
        if (params == null || params.size() == 0) {
            return EBApiResult.fail((String)ResManager.loadKDString((String)"\u53c2\u6570\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u3002", (String)"RuleExecCaseService_0", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        RuleExecCaseRequestEntry requestEntry = (RuleExecCaseRequestEntry)JSON.parseObject((String)JSON.toJSONString(params), RuleExecCaseRequestEntry.class);
        return this.executeRuleExecCase(requestEntry);
    }

    private ApiResult executeRuleExecCase(RuleExecCaseRequestEntry requestEntry) {
        Set<Long> releaseRelateRuleSet;
        Map<String, Set<String>> memberInfo = requestEntry.getMemberInfo();
        if (memberInfo == null || memberInfo.isEmpty()) {
            return EBApiResult.fail((String)ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u53c2\u6570\u672a\u4f20\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RuleExecCaseService_1", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        String modelNumber = requestEntry.getModelNumber();
        if (StringUtils.isEmpty((String)modelNumber)) {
            return EBApiResult.fail((String)ResManager.loadKDString((String)"\u4f53\u7cfb\u7f16\u7801\u53c2\u6570\u672a\u4f20\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RuleExecCaseService_2", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        String ruleExecCaseNumber = requestEntry.getRuleExecCaseNumber();
        if (StringUtils.isEmpty((String)ruleExecCaseNumber)) {
            return EBApiResult.fail((String)ResManager.loadKDString((String)"\u89c4\u5219\u6267\u884c\u65b9\u6848\u7f16\u7801\u53c2\u6570\u672a\u4f20\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RuleExecCaseService_3", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        QFilter modelNumQf = new QFilter("shownumber", "=", (Object)modelNumber);
        DynamicObject modelObj = QueryServiceHelper.queryOne((String)"epm_model", (String)"id,number", (QFilter[])modelNumQf.toArray());
        if (modelObj == null) {
            return EBApiResult.fail((String)ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u76f8\u5e94\u7684\u4f53\u7cfb\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RuleExecCaseService_4", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        long modelId = modelObj.getLong("id");
        QFilter modelIdQf = new QFilter("model", "=", (Object)modelId);
        modelIdQf.and("number", "=", (Object)ruleExecCaseNumber);
        DynamicObject caseObj = QueryServiceHelper.queryOne((String)"eb_ruleexeccase", (String)"id", (QFilter[])modelIdQf.toArray());
        if (caseObj == null) {
            return EBApiResult.fail((String)ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u76f8\u5e94\u7684\u89c4\u5219\u6267\u884c\u65b9\u6848\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RuleExecCaseService_5", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        long caseId = caseObj.getLong("id");
        caseObj = BusinessDataServiceHelper.loadSingle((Object)caseId, (String)"eb_ruleexeccase");
        caseObj = RuleCaseService.getInstance().updateCaseEntity(caseObj);
        RuleCase ruleCase = RuleCase.of((DynamicObject)caseObj);
        String type = ruleCase.getType();
        if (RuleExecCaseTypeEnum.RANGE.getCode().equals(type)) {
            return EBApiResult.fail((String)ResManager.loadKDString((String)"\u4ec5\u5141\u8bb8\u6267\u884c\u6309\u4e1a\u52a1\u89c4\u5219\u8bbe\u7f6e\u7684\u89c4\u5219\u6267\u884c\u65b9\u6848\u3002", (String)"RuleExecCaseService_6", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        Boolean allowDisable = ruleCase.getAllowDisable();
        List rowList = ruleCase.getRowList();
        if (CollectionUtils.isEmpty((Collection)rowList)) {
            return EBApiResult.fail((String)ResManager.loadKDString((String)"\u89c4\u5219\u6267\u884c\u65b9\u6848\u4e2d\u65e0\u53ef\u6267\u884c\u7684\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RuleExecCaseService_7", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        Set<RuleDto> releaseRuleSet = rowList.stream().map(RuleRow::getRuleDto).filter(RuleDto::getStatus).collect(Collectors.toSet());
        Set<RuleDto> unReleaseRuleSet = rowList.stream().map(RuleRow::getRuleDto).filter(e -> e.getStatus() == false).collect(Collectors.toSet());
        if (!allowDisable.booleanValue() && CollectionUtils.isNotEmpty(unReleaseRuleSet)) {
            return EBApiResult.fail((String)ResManager.loadKDString((String)"\u5bf9\u5e94\u89c4\u5219\u6267\u884c\u65b9\u6848\u4e0d\u5141\u8bb8\u672a\u53d1\u5e03\u7684\u89c4\u5219\u6267\u884c\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RuleExecCaseService_8", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        Long bizModelId = ruleCase.getBizModelId();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        List<String> dimNumbers = modelCacheHelper.getDimensionList().stream().map(BaseCache::getNumber).collect(Collectors.toList());
        HashSet bizModelDimSet = new HashSet(dimNumbers);
        HashSet<String> memberInfoDimSet = new HashSet<String>(memberInfo.keySet());
        memberInfoDimSet.removeAll(bizModelDimSet);
        if (CollectionUtils.isNotEmpty(memberInfoDimSet)) {
            for (String memberInfoDim : memberInfoDimSet) {
                memberInfo.remove(memberInfoDim);
            }
        }
        HashMap<String, Set<String>> _memberInfo = new HashMap<String, Set<String>>(memberInfo.size());
        memberInfo.forEach((dimNum, memSet) -> {
            for (String mem : memSet) {
                Member member = modelCacheHelper.getMemberByAnyView(bizModelId, dimNum, mem);
                if (member == null) continue;
                Set memberNumSet = _memberInfo.computeIfAbsent((String)dimNum, k -> new HashSet(16));
                memberNumSet.add(member.getNumber());
            }
        });
        if (_memberInfo.isEmpty()) {
            return EBApiResult.fail((String)ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u53c2\u6570\u5305\u542b\u4e0d\u5b58\u5728\u7684\u7ef4\u5ea6\u6210\u5458\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RuleExecCaseService_9", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        Set<Long> unReleaseRelateRuleSet = this.getRelateRuleSet(_memberInfo, unReleaseRuleSet, bizModelId, modelCacheHelper, dimNumbers);
        ArrayList<Object> relateRuleRows = new ArrayList<Object>(16);
        if (CollectionUtils.isNotEmpty(unReleaseRelateRuleSet)) {
            List collect = rowList.stream().filter(e -> unReleaseRelateRuleSet.contains(e.getRuleDto().getId())).collect(Collectors.toList());
            collect = collect.stream().distinct().collect(Collectors.toList());
            relateRuleRows.addAll(collect);
        }
        if (CollectionUtils.isNotEmpty(releaseRelateRuleSet = this.getRelateRuleSet(_memberInfo, releaseRuleSet, bizModelId, modelCacheHelper, dimNumbers))) {
            Map<Long, RuleRow> ruleRowMap = rowList.stream().filter(e -> releaseRelateRuleSet.contains(e.getRuleDto().getId())).collect(Collectors.toMap(e -> e.getRuleDto().getId(), v -> v, (v1, v2) -> v1));
            List list = RuleCacheService.getInstance().listRuleFromLocalCache(bizModelId).getRuleDtoList();
            MutableGraph graph = RuleGraphService.getInstance().getDagGraphByBizmodel(list);
            while (!graph.nodes().isEmpty()) {
                Set zeroNodes = RuleGraphService.getInstance().getZeroNodes((Graph)graph);
                for (GraphNode _zeroNode : zeroNodes) {
                    if (!ruleRowMap.containsKey(_zeroNode.getNodeId())) continue;
                    relateRuleRows.add(ruleRowMap.get(_zeroNode.getNodeId()));
                }
                zeroNodes.forEach(arg_0 -> ((MutableGraph)graph).removeNode(arg_0));
            }
        }
        if (CollectionUtils.isNotEmpty(relateRuleRows)) {
            for (RuleRow ruleRow : relateRuleRows) {
                ruleRow.setFillExecRange(_memberInfo);
            }
            ruleCase.setRowList(relateRuleRows);
            Long logId = RuleExecLogService.getInstance().createJonLog(modelId, ruleCase.getCaseNumber() + "-" + ruleCase.getCaseName());
            RuleExecCommand ruleExecCommand = new RuleExecCommand();
            ruleExecCommand.setRuleCase(ruleCase);
            ruleExecCommand.setTaskLogId(logId);
            ruleExecCommand.setReleaseRulePushExecution(Boolean.valueOf(true));
            ruleExecCommand.doExecute();
        }
        ApiResult success = ApiResult.success(null);
        success.setMessage(ResManager.loadKDString((String)"\u89c4\u5219\u6267\u884c\u65b9\u6848\u6267\u884c\u5b8c\u6210\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u6267\u884c\u8bb0\u5f55\u3002", (String)"RuleExecCaseService_10", (String)"epm-eb-mservice", (Object[])new Object[0]));
        return success;
    }

    private Set<Long> getRelateRuleSet(Map<String, Set<String>> memberInfo, Set<RuleDto> releaseRuleSet, Long bizModelId, IModelCacheHelper modelCacheHelper, List<String> dimNumbers) {
        HashSet<Long> relateRuleSet = new HashSet<Long>(16);
        for (RuleDto ruleDto : releaseRuleSet) {
            boolean relate = RuleRelationService.getInstance().checkRelate(memberInfo, ruleDto.getLeftMembers(), dimNumbers);
            if (!relate) continue;
            relateRuleSet.add(ruleDto.getId());
        }
        return relateRuleSet;
    }

    private static enum Singleton {
        INSTANCE;

        private final RuleExecCaseService instance = new RuleExecCaseService();
    }
}

