/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.rule;

import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.bizrule.RuleRelationService;
import kd.epm.eb.common.thread.EpmThreadPools;
import kd.epm.eb.common.utils.UpdateRecordHelper;
import kd.epm.eb.formplugin.rulemanage.utils.RuleUtils;
import kd.epm.eb.olap.impl.bizrule.RuleService;

public class UpdateOldRuleService {
    private static final Log log = LogFactory.getLog(UpdateOldRuleService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void autoUpdateOldRule(Long modelId, boolean hasAuto) {
        log.info("autoUpdateOldRule_modelId:" + modelId);
        DLock lock = DLock.create((String)UpdateOldRuleService.class.getName());
        if (lock.tryLock()) {
            try {
                if (!hasAuto) {
                    RuleRelationService.getInstance().updateOldData(modelId.longValue(), false);
                    RuleService.getInstance().deleteRuleFromCacheByModel(modelId);
                    EpmThreadPools.CommPools.execute(() -> {
                        try {
                            RuleUtils.fixErrorData((Long)modelId);
                        }
                        catch (Exception e) {
                            log.error("autoUpdateOldRule_fixErrorData_error:", (Throwable)e);
                        }
                        try {
                            RuleUtils.createMemberReference((Long)modelId);
                        }
                        catch (Exception e) {
                            log.error("autoUpdateOldRule_createMemberReference_error:", (Throwable)e);
                        }
                    });
                }
                if (hasAuto && !UpdateRecordHelper.isUpdated((String)("oldrule_" + modelId))) {
                    RuleRelationService.getInstance().updateOldData(modelId.longValue(), false);
                    RuleService.getInstance().deleteRuleFromCacheByModel(modelId);
                    UpdateRecordHelper.addRecord((String)("oldrule_" + modelId), null, null, (boolean)true);
                    EpmThreadPools.CommPools.execute(() -> {
                        try {
                            RuleUtils.fixErrorData((Long)modelId);
                        }
                        catch (Exception e) {
                            log.error("autoUpdateOldRule_fixErrorData_error:", (Throwable)e);
                        }
                        try {
                            RuleUtils.createMemberReference((Long)modelId);
                        }
                        catch (Exception e) {
                            log.error("autoUpdateOldRule_createMemberReference_error:", (Throwable)e);
                        }
                    });
                }
            }
            catch (Throwable e) {
                log.error("autoUpdateOldRule_updateOldData_error:", e);
            }
            finally {
                lock.unlock();
            }
        }
    }
}

