/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.scheme;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.service.HandleErrorInfoHelper;
import org.apache.commons.collections4.CollectionUtils;

public class RptSchemeUpgradeServiceImpl
implements IUpgradeService {
    private static final Log log = LogFactory.getLog(RptSchemeUpgradeServiceImpl.class);
    private final DBRoute epmRoute = new DBRoute("epm");
    private final LoadingCache<Long, IModelCacheHelper> modelLoadingCache = CacheBuilder.newBuilder().maximumSize(50L).expireAfterAccess(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Long, IModelCacheHelper>(){

        public IModelCacheHelper load(Long modelId) {
            return ModelCacheContext.getOrCreate((Long)modelId);
        }
    });

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try (TXHandle tx = TX.required((String)"RptSchemeUpgradeServiceImpl");){
            try {
                this.updateRptScheme();
                result.setSuccess(true);
            }
            catch (Exception e) {
                tx.markRollback();
                HandleErrorInfoHelper.handle(result, e);
            }
        }
        return result;
    }

    private void updateRptScheme() {
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(16);
        try (DataSet dataSet = DB.queryDataSet((String)"getRptSchemeInfo", (DBRoute)this.epmRoute, (String)"select t.fid, t.fmodelid, t.fbizrangeid, t.forgviewid from t_eb_rptscheme t where t.forgviewid = 0 or t.forgviewid is null");){
            for (Row row : dataSet) {
                try {
                    long id = row.getLong("fid");
                    long modelId = row.getLong("fmodelid");
                    long bizRangeId = row.getLong("fbizrangeid");
                    IModelCacheHelper modelCache = (IModelCacheHelper)this.modelLoadingCache.getUnchecked((Object)modelId);
                    Map viewsByBusModel = modelCache.getViewsByBusModelIncludeBase(Long.valueOf(bizRangeId));
                    Long viewId = viewsByBusModel.getOrDefault(SysDimensionEnum.Entity.getNumber(), 0L);
                    if (viewId <= 0L) continue;
                    Object[] oneRowVal = new Object[]{viewId, id};
                    paramList.add(oneRowVal);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        if (CollectionUtils.isNotEmpty(paramList)) {
            String sql = "update t_eb_rptscheme set forgviewid = ? where fid = ?";
            DB.executeBatch((DBRoute)this.epmRoute, (String)sql, paramList);
        }
    }
}

