/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.task;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.epm.eb.common.utils.StringUtils;

public class TaskListUpgradeServiceImpl
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        Throwable throwable;
        TXHandle tx;
        UpgradeResult result;
        block21: {
            UpgradeResult upgradeResult;
            block22: {
                block23: {
                    result = new UpgradeResult();
                    result.setSuccess(true);
                    tx = TX.requiresNew((String)"BgmdTaskListUpgrade");
                    throwable = null;
                    String msg = this.checkTableExist();
                    if (!StringUtils.isNotEmpty((String)msg)) break block21;
                    result.setLog(msg);
                    upgradeResult = result;
                    if (tx == null) break block22;
                    if (throwable == null) break block23;
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block22;
                }
                tx.close();
            }
            return upgradeResult;
        }
        try {
            try {
                List<String> modelIds = this.queryModelIds();
                if (!modelIds.isEmpty()) {
                    this.upgradeTaskList(modelIds, result);
                }
            }
            catch (Exception e) {
                result.setSuccess(false);
                StackTraceElement[] arr = e.getStackTrace();
                StringBuilder sb = new StringBuilder();
                for (StackTraceElement ele : arr) {
                    sb.append(ele.toString()).append("\r\n");
                }
                if (result.getLog() != null) {
                    result.setLog(result.getLog() + "--\r\n---" + e.getMessage());
                } else {
                    result.setLog(e.getMessage());
                }
                result.setErrorInfo(sb.toString());
                tx.markRollback();
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        catch (Throwable throwable4) {
            throw throwable4;
        }
        finally {
            if (tx != null) {
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    tx.close();
                }
            }
        }
        return result;
    }

    private void upgradeTaskList(List<String> modelIds, UpgradeResult result) {
        String sql = "select distinct t1.ftasklistid,t4.fbizmodelid  from t_eb_task t1  left join t_eb_taskreftemplate t2 on t1.fid=t2.fid  left join t_eb_template t3 on t2.ftemplateid=t3.fid  left join t_eb_dataset t4 on t3.fdatasetid=t4.fid  where t4.fbizmodelid is not null  and t1.fmodelid in(" + String.join((CharSequence)",", modelIds) + ")";
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        try {
            try (DataSet dataSet = DB.queryDataSet((String)"", (DBRoute)DBRoute.of((String)"epm"), (String)sql, null);){
                for (Row row : dataSet) {
                    Long ftaskListId = row.getLong("ftasklistid");
                    Long fbizModelId = row.getLong("fbizmodelid");
                    if (ftaskListId == null || fbizModelId == null) continue;
                    params.add(new Object[]{fbizModelId, ftaskListId});
                }
            }
            if (!params.isEmpty()) {
                sql = "update t_eb_tasklist set fbizmodelid = ? where fbizmodelid=0 and fid = ?";
                DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)sql, params);
            }
        }
        catch (Exception e) {
            result.setErrorInfo(e.getMessage() + ";" + sql + ";");
        }
    }

    private String checkTableExist() {
        if (!DB.exitsTable((DBRoute)DBRoute.of((String)"epm"), (String)"t_eb_model")) {
            return "table t_eb_model does't exist, so don't need upgrade.";
        }
        if (!DB.exitsTable((DBRoute)DBRoute.of((String)"epm"), (String)"t_eb_tasklist")) {
            return "table t_eb_tasklist does't exist, so don't need upgrade.";
        }
        return "";
    }

    private List<String> queryModelIds() {
        ArrayList<String> modelIds = new ArrayList<String>();
        try (DataSet ds = DB.queryDataSet((String)"queryEpmModel", (DBRoute)DBRoute.of((String)"epm"), (String)"select fid from t_eb_model where freporttype='7'", null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                modelIds.add(row.getString("fid"));
            }
        }
        return modelIds;
    }
}

