/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.epm.eb.common.utils.IDUtils;

public class TaskPackageOrderUpgradeServiceImpl
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        try (TXHandle tx = TX.requiresNew((String)"TaskPackageOrderUpgrade");){
            try {
                this.upgradeTaskPackageOrder(result);
            }
            catch (Exception e) {
                result.setSuccess(false);
                StackTraceElement[] arr = e.getStackTrace();
                StringBuilder sb = new StringBuilder();
                for (StackTraceElement ele : arr) {
                    sb.append(ele.toString()).append("\r\n");
                }
                if (result.getLog() != null) {
                    result.setLog(result.getLog() + "--\r\n---" + e.getMessage());
                } else {
                    result.setLog(e.getMessage());
                }
                result.setErrorInfo(sb.toString());
                tx.markRollback();
            }
        }
        return result;
    }

    private void upgradeTaskPackageOrder(UpgradeResult result) {
        Map<Long, List<Long>> taskPackageMap = this.queryModelTaskPackageMap();
        result.setLog(String.format("taskPackageMap size %s.", taskPackageMap.size()));
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (Map.Entry<Long, List<Long>> entry : taskPackageMap.entrySet()) {
            List<Long> taskPackageIds = entry.getValue();
            for (int i = 0; i < taskPackageIds.size(); ++i) {
                params.add(new Object[]{i + 1, taskPackageIds.get(i)});
            }
        }
        if (!params.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)"update t_eb_tasklist set ftpseq = ? where fid = ? ", params);
        }
    }

    private Map<Long, List<Long>> queryModelTaskPackageMap() {
        HashMap<Long, List<Long>> taskPackageMap = new HashMap<Long, List<Long>>(16);
        try (DataSet ds = DB.queryDataSet((String)"queryTaskPackage", (DBRoute)DBRoute.of((String)"epm"), (String)"select fid,fmodelid from t_eb_tasklist where 1=1 order by fcreatedate;", null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                Long taskPackageId = row.getLong("fid");
                Long modelId = row.getLong("fmodelid");
                if (!IDUtils.isNotEmptyLong((Long)taskPackageId).booleanValue() || !IDUtils.isNotEmptyLong((Long)modelId).booleanValue()) continue;
                List taskPackageIds = taskPackageMap.computeIfAbsent(modelId, e -> new ArrayList(10));
                taskPackageIds.add(taskPackageId);
            }
        }
        return taskPackageMap;
    }
}

