/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.templateperm;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.templateperm.TemplateTypeEnum;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.StringUtils;

public class TemplatePermUpgradeServiceImpl
implements IUpgradeService {
    private static final Log log = LogFactory.getLog(TemplatePermUpgradeServiceImpl.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            List<Object[]> params = this.getToUpgradeSignKeys();
            this.batchUpgrade(params);
            result.setSuccess(true);
        }
        catch (Exception exception) {
            result.setSuccess(false);
            result.setErrorInfo(CommonServiceHelper.getStackTraceStr((Throwable)exception));
            log.error((Throwable)exception);
        }
        return result;
    }

    private List<Object[]> getToUpgradeSignKeys() {
        ArrayList<Object[]> params = new ArrayList<Object[]>(16);
        String sql = "select fid, ftemplatetype, ftemplateid, fapplytemplateid, fusertype, fuserid, fentitytype, fentityid, fsign_key from t_eb_templateuser";
        try (DataSet ds = DB.queryDataSet((String)"queryTemplatePerm", (DBRoute)DBRoute.of((String)"epm"), (String)sql);){
            while (ds.hasNext()) {
                String entityType;
                Row row = ds.next();
                String signKey = row.getString("fsign_key");
                if (StringUtils.isNotEmpty((String)signKey)) continue;
                StringBuilder signKeyBuilder = new StringBuilder();
                String templateType = row.getString("ftemplatetype");
                if (TemplateTypeEnum.APPLY.getCode().equals(templateType)) {
                    signKeyBuilder.append(row.getLong("fapplytemplateid"));
                } else {
                    signKeyBuilder.append(row.getLong("ftemplateid"));
                }
                signKeyBuilder.append("!").append(templateType).append("!");
                signKeyBuilder.append(row.getLong("fuserid")).append("!").append(row.getString("fusertype")).append("!");
                Object entityId = row.get("fentityid");
                if (entityId == null) {
                    signKeyBuilder.append("0!");
                    entityType = SysDimensionEnum.Entity.getMemberTreemodel();
                } else {
                    signKeyBuilder.append(entityId).append("!");
                    entityType = row.getString("fentitytype");
                    if (StringUtils.isEmpty((String)entityType)) {
                        entityType = SysDimensionEnum.Entity.getMemberTreemodel();
                    }
                }
                signKeyBuilder.append(entityType);
                params.add(new Object[]{signKeyBuilder.toString(), row.getLong("fid")});
            }
        }
        return params;
    }

    private void batchUpgrade(List<Object[]> params) {
        if (params.size() == 0) {
            return;
        }
        String updateSql = "update t_eb_templateuser set fsign_key = ? where fid = ?";
        DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)updateSql, params);
    }
}

