/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.upgrade;

import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.DBServiceHelper;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.UpdateRecordHelper;
import org.apache.commons.collections4.CollectionUtils;

public class ControlRuleGroupDimAndOboMemberUpgradeImpl
implements IUpgradeService {
    private static final String PLANT_KEY = "groupDimUpgrade";
    private static final Log log = LogFactory.getLog(ControlRuleGroupDimAndOboMemberUpgradeImpl.class);
    private List<Object[]> insertList;
    private List<Object[]> groupDimUpdateList;
    private List<Object[]> oboMemberUpdateList;

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result;
        block15: {
            try (TXHandle tx = TX.requiresNew((String)"ControlRuleGroupDimAndOboMemberUpgradeService");){
                try {
                    if (!UpdateRecordHelper.isUpdated((String)PLANT_KEY)) {
                        result = this.upgrade();
                        result.setLog("controlrule groupdimandobomember upgrade success.");
                        UpdateRecordHelper.addRecord((String)PLANT_KEY, null, null, (boolean)true);
                        break block15;
                    }
                    result = new UpgradeResult();
                    result.setLog("this script had invoke.");
                }
                catch (Throwable ex) {
                    log.error("controlrule.groupdimandobomember.upgrade.error", ex);
                    result = new UpgradeResult();
                    result.setSuccess(false);
                    result.setErrorInfo(ex.getMessage());
                    tx.markRollback();
                }
            }
        }
        return result;
    }

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        return null;
    }

    private UpgradeResult upgrade() {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        LogStats stats = new LogStats("budget-upgrade-log:");
        stats.addInfo("begin-controlrule-groupdimandobomember-upgrade.");
        Map<String, List<Long>> allGroupControlRuleMap = this.getAllGroupControlRuleMap();
        ArrayList<String> modelAndBussList = new ArrayList<String>(allGroupControlRuleMap.keySet());
        HashMap<String, List<Long>> controlDimMap = new HashMap<String, List<Long>>(16);
        for (String string : modelAndBussList) {
            String[] stringArray = string.split("_");
            Long modelId = IDUtils.toLong((Object)stringArray[0]);
            Long bussModelId = IDUtils.toLong((Object)stringArray[1]);
            List<Long> controlDimList = this.getControlDimList(modelId, bussModelId);
            controlDimMap.put(string, controlDimList);
        }
        Map<Long, List<Map<String, Object>>> allControlRuleGroupDimMap = this.getAllControlRuleGroupDimMap();
        this.groupDimUpdateList = new ArrayList<Object[]>(16);
        this.insertList = new ArrayList<Object[]>(16);
        for (Map.Entry<String, List<Long>> entry : allGroupControlRuleMap.entrySet()) {
            String modelAndBussKey = entry.getKey();
            List controlDimIds = (List)controlDimMap.get(modelAndBussKey);
            if (CollectionUtils.isEmpty((Collection)controlDimIds)) continue;
            List<Long> controlRuleIds = entry.getValue();
            for (Long controlRuleId : controlRuleIds) {
                List<Map<String, Object>> controlRuleGroupDimsByRuleId = allControlRuleGroupDimMap.get(controlRuleId);
                if (CollectionUtils.isNotEmpty(controlRuleGroupDimsByRuleId)) {
                    Map<Long, Map> controlRuleGroupDimMapByGroupDimId = controlRuleGroupDimsByRuleId.stream().collect(Collectors.toMap(e -> (Long)e.get("fgroupdim"), e -> e, (v1, v2) -> v1));
                    for (int i = 0; i < controlDimIds.size(); ++i) {
                        Long controlDimId = (Long)controlDimIds.get(i);
                        if (controlRuleGroupDimMapByGroupDimId.get(controlDimId) != null) {
                            Map objectMap = controlRuleGroupDimMapByGroupDimId.get(controlDimId);
                            Object[] objectsEntry = new Object[]{i + 1, objectMap.get("fentryid")};
                            this.groupDimUpdateList.add(objectsEntry);
                            continue;
                        }
                        this.insertGroupDimRow(controlRuleId, i, controlDimId);
                    }
                    continue;
                }
                for (int i = 0; i < controlDimIds.size(); ++i) {
                    Long controlDimId = (Long)controlDimIds.get(i);
                    this.insertGroupDimRow(controlRuleId, i, controlDimId);
                }
            }
        }
        this.insertRows("fid, fentryid, fseq, fgroupdim, fisobodim, fobodimindex, fismemberrange", "t_eb_controlrulegroupdim", this.insertList);
        this.groupDimUpdateRows("t_eb_controlrulegroupdim", this.groupDimUpdateList);
        Map<Long, List<Map<String, Object>>> map = this.getAllControlRuleOboRangeMap();
        ArrayList<Long> arrayList = new ArrayList<Long>(map.keySet());
        if (CollectionUtils.isNotEmpty(arrayList)) {
            Map<Long, Long> dimIdMap = this.getDimIdMapByMemberIds(arrayList);
            this.oboMemberUpdateList = new ArrayList<Object[]>(16);
            for (Map.Entry<Long, List<Map<String, Object>>> entry : map.entrySet()) {
                Long oboMemberId = entry.getKey();
                List<Map<String, Object>> oboMemberList = entry.getValue();
                for (Map<String, Object> objectMap : oboMemberList) {
                    Object[] objectsEntry = new Object[]{dimIdMap.get(oboMemberId), objectMap.get("fentryid")};
                    this.oboMemberUpdateList.add(objectsEntry);
                }
            }
            this.oboMemberUpdateRows("t_eb_controlruleoborange", this.oboMemberUpdateList);
        }
        stats.addInfo("end-controlrule-groupdimandobomember-upgrade.");
        result.setLog(stats.toString());
        return result;
    }

    private void insertGroupDimRow(Long controlRuleId, int i, Long controlDimId) {
        Object[] objectsEntry = new Object[]{controlRuleId, DBServiceHelper.genGlobalLongId(), 0, controlDimId, Character.valueOf('1'), i + 1, Character.valueOf('0')};
        this.insertList.add(objectsEntry);
    }

    private Map<Long, Long> getDimIdMapByMemberIds(List<Long> oboMemberIdList) {
        HashMap<Long, Long> dimIdMap = new HashMap<Long, Long>(16);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid ,fdimensionid from t_eb_structofdefined where ", new Object[0]);
        sqlBuilder.appendIn("fid", new ArrayList<Long>(oboMemberIdList));
        try (DataSet ds = DB.queryDataSet((String)"queryDimIdsByMemberIds", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sqlBuilder);){
            if (ds != null) {
                for (Row row : ds) {
                    dimIdMap.put(row.getLong("fid"), row.getLong("fdimensionid"));
                }
            }
        }
        return dimIdMap;
    }

    private Map<Long, List<Map<String, Object>>> getAllControlRuleOboRangeMap() {
        HashMap<Long, List<Map<String, Object>>> controlRuleOboRangeMap = new HashMap<Long, List<Map<String, Object>>>(16);
        String sql = "select fid ,fentryid ,fobomember ,fmemrange from t_eb_controlruleoborange;";
        try (DataSet ds = DB.queryDataSet((String)"queryAllControlRuleOboRange", (DBRoute)BgBaseConstant.epm, (String)sql, null);){
            if (ds != null) {
                for (Row row : ds) {
                    HashMap<String, Object> controlRuleOboRange = new HashMap<String, Object>(16);
                    controlRuleOboRange.put("fid", row.getLong("fid"));
                    controlRuleOboRange.put("fentryid", row.getLong("fentryid"));
                    controlRuleOboRange.put("fobomember", row.getLong("fobomember"));
                    controlRuleOboRange.put("fmemrange", row.getString("fmemrange"));
                    List controlRuleOboRangeList = controlRuleOboRangeMap.computeIfAbsent(row.getLong("fobomember"), k -> new ArrayList(16));
                    controlRuleOboRangeList.add(controlRuleOboRange);
                }
            }
        }
        return controlRuleOboRangeMap;
    }

    private Map<Long, List<Map<String, Object>>> getAllControlRuleGroupDimMap() {
        HashMap<Long, List<Map<String, Object>>> controlRuleGroupDimMap = new HashMap<Long, List<Map<String, Object>>>(16);
        String sql = "select fid ,fentryid ,fgroupdim ,fisobodim ,fobodimindex from t_eb_controlrulegroupdim;";
        try (DataSet ds = DB.queryDataSet((String)"queryAllControlRuleGroupDim", (DBRoute)BgBaseConstant.epm, (String)sql, null);){
            if (ds != null) {
                for (Row row : ds) {
                    HashMap<String, Constable> controlRuleGroupDim = new HashMap<String, Constable>(16);
                    controlRuleGroupDim.put("fid", row.getLong("fid"));
                    controlRuleGroupDim.put("fentryid", row.getLong("fentryid"));
                    controlRuleGroupDim.put("fgroupdim", row.getLong("fgroupdim"));
                    controlRuleGroupDim.put("fisobodim", row.getBoolean("fisobodim"));
                    controlRuleGroupDim.put("fobodimindex", row.getLong("fobodimindex"));
                    List controlRuleGroupDimList = controlRuleGroupDimMap.computeIfAbsent(row.getLong("fid"), k -> new ArrayList(16));
                    controlRuleGroupDimList.add(controlRuleGroupDim);
                }
            }
        }
        return controlRuleGroupDimMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<Long> getControlDimList(Long modelId, Long bussModelId) {
        ArrayList<Long> controlDimList = new ArrayList<Long>(16);
        StringBuilder sb = new StringBuilder();
        sb.append("select fid from t_eb_dimension where fmodelid = ").append(modelId).append(" and fissysdimension = '0' order by fdseq;");
        ArrayList<Long> dimList = new ArrayList<Long>(16);
        try (DataSet ds = DB.queryDataSet((String)"queryUserDefinedDimension", (DBRoute)BgBaseConstant.epm, (String)sb.toString(), null);){
            if (ds != null) {
                for (Row row : ds) {
                    dimList.add(row.getLong("fid"));
                }
            }
        }
        if (IDUtils.isNotEmptyLong((Long)bussModelId).booleanValue()) {
            StringBuilder sb1 = new StringBuilder();
            sb1.append("select fdimensionid from t_eb_controldimdetail where fid = (select fid from t_eb_bgmcontroldimension where fmodel = ").append(modelId).append(" and fbasedatafield = ").append(bussModelId).append(");");
            DataSet ds = DB.queryDataSet((String)"queryControlDimension", (DBRoute)BgBaseConstant.epm, (String)sb1.toString(), null);
            Object object = null;
            try {
                if (ds == null) return controlDimList;
                for (Row row : ds) {
                    if (!dimList.contains(row.getLong("fdimensionid"))) continue;
                    controlDimList.add(row.getLong("fdimensionid"));
                }
                return controlDimList;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (ds != null) {
                    if (object != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        } else {
            controlDimList.addAll(dimList);
        }
        return controlDimList;
    }

    private void insertRows(String fieldStr, String ebTableName, List<Object[]> paramsList) {
        StringBuilder sql = new StringBuilder();
        sql.append("insert into ").append(ebTableName).append("(").append(fieldStr).append(") values(");
        int length = fieldStr.split(",").length;
        for (int i = 0; i < length; ++i) {
            sql.append("?,");
        }
        sql.deleteCharAt(sql.length() - 1).append(")");
        if (paramsList != null && paramsList.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)sql.toString(), paramsList);
        }
    }

    public void groupDimUpdateRows(String ebTableName, List<Object[]> paramsList) {
        if (paramsList == null || paramsList.isEmpty()) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("update ").append(ebTableName).append(" set fobodimindex = ? where fentryid = ?;");
        DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)sql.toString(), paramsList);
    }

    public void oboMemberUpdateRows(String ebTableName, List<Object[]> paramsList) {
        if (paramsList == null || paramsList.isEmpty()) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("update ").append(ebTableName).append(" set fobodim = ? where fentryid = ?;");
        DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)sql.toString(), paramsList);
    }

    private Map<String, List<Long>> getAllGroupControlRuleMap() {
        HashMap<String, List<Long>> groupControlRuleByModelAndBuss = new HashMap<String, List<Long>>(16);
        String sql = "select fid ,fmodelid ,fbussmodelid from t_eb_controlrulemain where fgroupid > 0;";
        try (DataSet ds = DB.queryDataSet((String)"queryAllGroupControlRule", (DBRoute)BgBaseConstant.epm, (String)sql, null);){
            if (ds != null) {
                for (Row row : ds) {
                    List groupControlRules = groupControlRuleByModelAndBuss.computeIfAbsent(row.getLong("fmodelid") + "_" + row.getLong("fbussmodelid"), k -> new ArrayList(16));
                    groupControlRules.add(row.getLong("fid"));
                }
            }
        }
        return groupControlRuleByModelAndBuss;
    }
}

