/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.DBServiceHelper;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.SqlBatchUtils;
import org.apache.commons.collections4.CollectionUtils;

public class ControlRuleGroupUserDefineDimUpgradeImpl
implements IUpgradeService {
    private static final Log log = LogFactory.getLog(ControlRuleGroupUserDefineDimUpgradeImpl.class);
    private static final int MAX_USER_DEFINED = 7;
    private List<Object[]> insertList;

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = null;
        try (TXHandle tx = TX.requiresNew((String)"ControlRuleGroupUserDefineDimUpgrade");){
            try {
                result = this.upgrade();
                result.setLog("controlrule groupuserdefinedim upgrade success.");
            }
            catch (Throwable ex) {
                log.error("controlrule.groupuserdefinedim.upgrade.error", ex);
                result = new UpgradeResult();
                result.setSuccess(false);
                result.setErrorInfo(ex.getMessage());
                tx.markRollback();
            }
        }
        return result;
    }

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        return null;
    }

    private UpgradeResult upgrade() {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        LogStats stats = new LogStats("budget-upgrade-log:");
        stats.addInfo("begin-controlrule-groupuserdefinedim-upgrade.");
        if (SqlBatchUtils.hasData((String)"t_eb_controlrulegroupdim")) {
            stats.addInfo("controlrule groupuserdefinedim has data.");
            stats.addInfo("end-controlrule-groupuserdefinedim-upgrade.");
            result.setLog(stats.toString());
            return result;
        }
        List<Map<String, Object>> allControlRuleGroupUserDefinedDim = this.getAllControlRuleGroupUserDefinedDim();
        if (CollectionUtils.isNotEmpty(allControlRuleGroupUserDefinedDim)) {
            this.controlRuleGroupUserDefineDimUpgrade(allControlRuleGroupUserDefinedDim);
            stats.addInfo("controlrule groupuserdefinedim upgrade success.");
        } else {
            stats.addInfo("controlrule groupuserdefinedim has no data.");
        }
        stats.addInfo("end-controlrule-groupuserdefinedim-upgrade.");
        result.setLog(stats.toString());
        return result;
    }

    private void controlRuleGroupUserDefineDimUpgrade(List<Map<String, Object>> allControlRuleGroupUserDefinedDim) {
        this.insertList = new ArrayList<Object[]>(16);
        for (Map<String, Object> map : allControlRuleGroupUserDefinedDim) {
            for (int i = 1; i <= 7; ++i) {
                Long dimId = (Long)map.get("dim" + i + "Id");
                if (IDUtils.isEmptyLong((Long)dimId).booleanValue()) continue;
                Object[] objectsEntry = new Object[]{map.get("id"), DBServiceHelper.genGlobalLongId(), 0, map.get("dim" + i + "Id"), Character.valueOf('0')};
                this.insertList.add(objectsEntry);
            }
        }
        this.insertRows("fid, fentryid, fseq, fgroupdim, fisobodim", "t_eb_controlrulegroupdim", this.insertList);
    }

    private void insertRows(String fieldStr, String ebTableName, List<Object[]> paramsList) {
        StringBuilder sql = new StringBuilder();
        sql.append("insert into ").append(ebTableName).append("(").append(fieldStr).append(") values(");
        int length = fieldStr.split(",").length;
        for (int i = 0; i < length; ++i) {
            sql.append("?,");
        }
        sql.deleteCharAt(sql.length() - 1).append(")");
        if (paramsList != null && paramsList.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)sql.toString(), paramsList);
        }
    }

    private List<Map<String, Object>> getAllControlRuleGroupUserDefinedDim() {
        ArrayList<Map<String, Object>> controlRuleGroupUserDefinedDims = new ArrayList<Map<String, Object>>(16);
        String sql = "select distinct a.fid as id ,b.fuserdefineddimid1 as dim1Id ,b.fuserdefineddimid2 as dim2Id ,b.fuserdefineddimid3 as dim3Id ,b.fuserdefineddimid4 as dim4Id ,b.fuserdefineddimid5 as dim5Id ,b.fuserdefineddimid6 as dim6Id ,b.fuserdefineddimid7 as dim7Id from t_eb_controlrulemain a join t_eb_controlruledefineds b on a.fid = b.fid and a.fgroupid > 0;";
        try (DataSet ds = DB.queryDataSet((String)"queryAllControlRuleGroupUserDefinedDim", (DBRoute)BgBaseConstant.epm, (String)sql, null);){
            if (ds != null) {
                for (Row row : ds) {
                    boolean upgradeFlag = false;
                    for (int i = 1; i <= 7; ++i) {
                        Long dimId = row.getLong("dim" + i + "Id");
                        if (dimId <= 0L) continue;
                        upgradeFlag = true;
                        break;
                    }
                    if (!upgradeFlag) continue;
                    HashMap<String, Long> controlRuleGroupUserDefinedDim = new HashMap<String, Long>(16);
                    controlRuleGroupUserDefinedDim.put("id", row.getLong("id"));
                    controlRuleGroupUserDefinedDim.put("dim1Id", row.getLong("dim1Id"));
                    controlRuleGroupUserDefinedDim.put("dim2Id", row.getLong("dim2Id"));
                    controlRuleGroupUserDefinedDim.put("dim3Id", row.getLong("dim3Id"));
                    controlRuleGroupUserDefinedDim.put("dim4Id", row.getLong("dim4Id"));
                    controlRuleGroupUserDefinedDim.put("dim5Id", row.getLong("dim5Id"));
                    controlRuleGroupUserDefinedDim.put("dim6Id", row.getLong("dim6Id"));
                    controlRuleGroupUserDefinedDim.put("dim7Id", row.getLong("dim7Id"));
                    controlRuleGroupUserDefinedDims.add(controlRuleGroupUserDefinedDim);
                }
            }
        }
        return controlRuleGroupUserDefinedDims;
    }
}

