/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.upgrade;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.DBServiceHelper;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.UpdateRecordHelper;
import org.apache.commons.collections4.CollectionUtils;

public class ControlRuleGroupUserDefinedMemUpgradeImpl
implements IUpgradeService {
    private static final String PLANT_KEY = "groupUserDefMemUpgrade";
    private static final Log log = LogFactory.getLog(ControlRuleGroupUserDefinedMemUpgradeImpl.class);
    private List<Object[]> insertNewList;
    private List<Object[]> insertBackupList;
    private Map<Long, Long> memberIdMap;

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result;
        block15: {
            try (TXHandle tx = TX.requiresNew((String)"ControlRuleGroupUserDefinedMemUpgradeService");){
                try {
                    if (!UpdateRecordHelper.isUpdated((String)PLANT_KEY)) {
                        result = this.upgrade();
                        result.setLog("controlrule groupuserdefinedmem upgrade success.");
                        UpdateRecordHelper.addRecord((String)PLANT_KEY, null, null, (boolean)true);
                        break block15;
                    }
                    result = new UpgradeResult();
                    result.setLog("this script had invoke.");
                }
                catch (Throwable ex) {
                    log.error("controlrule.groupuserdefinedmem.upgrade.error", ex);
                    result = new UpgradeResult();
                    result.setSuccess(false);
                    result.setErrorInfo(ex.getMessage());
                    tx.markRollback();
                }
            }
        }
        return result;
    }

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        return null;
    }

    private UpgradeResult upgrade() {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        LogStats stats = new LogStats("budget-upgrade-log:");
        stats.addInfo("begin-controlrule-groupuserdefinedmem-upgrade.");
        Map<Long, List<Long>> controlRuleAccountMap = this.getAllGroupControlRuleAccountIdMap();
        Map<Long, List<Map<String, Object>>> controlRuleUserDefinedMap = this.getAllGroupControlRuleUserDefinedMap();
        this.insertRows("fid ,fentryid ,fgroupaccount ,fuserdefineddimid1 ,fuserdefineddimid2 ,fuserdefineddimid3 ,fuserdefineddimid4 ,fuserdefineddimid5 ,fuserdefineddimid6 ,fuserdefineddimid7 ,fuserdefinedid1 ,fuserdefinedid2 ,fuserdefinedid3 ,fuserdefinedid4 ,fuserdefinedid5 ,fuserdefinedid6 ,fuserdefinedid7", "t_eb_controlruledef_bak", this.insertBackupList);
        this.insertNewList = new ArrayList<Object[]>(16);
        ArrayList<Long> delRuleIds = new ArrayList<Long>(controlRuleAccountMap.size());
        for (Map.Entry<Long, List<Long>> accountEntry : controlRuleAccountMap.entrySet()) {
            List curGroupMemberIds = new ArrayList<List<Long>>(16);
            HashMap<Integer, Set> chooseMemberIdMap = new HashMap<Integer, Set>(16);
            Long ruleId = accountEntry.getKey();
            List<Long> accounts = accountEntry.getValue();
            curGroupMemberIds.add(accounts);
            List<Map<String, Object>> userDefineds = controlRuleUserDefinedMap.get(ruleId);
            if (CollectionUtils.isNotEmpty(userDefineds)) {
                if (IDUtils.isNotEmptyLong((Long)((Long)userDefineds.get(0).get("fgroupaccount"))).booleanValue()) continue;
                delRuleIds.add(ruleId);
                for (Map map : userDefineds) {
                    for (int i = 1; i <= 7; ++i) {
                        if (map.get("fuserdefinedid" + i) == null) continue;
                        Set memberIdSet = chooseMemberIdMap.computeIfAbsent(i, f -> Sets.newLinkedHashSet());
                        memberIdSet.add((Long)map.get("fuserdefinedid" + i));
                    }
                }
                for (int i = 1; i <= 7; ++i) {
                    ArrayList<Long> arrayList = new ArrayList<Long>(16);
                    Set members = (Set)chooseMemberIdMap.get(i);
                    if (CollectionUtils.isEmpty((Collection)members)) {
                        arrayList.add(0L);
                    } else {
                        arrayList.addAll(members);
                    }
                    curGroupMemberIds.add(arrayList);
                }
                curGroupMemberIds = Lists.cartesianProduct(curGroupMemberIds);
                for (List list : curGroupMemberIds) {
                    Object[] objectsEntry = new Object[17];
                    objectsEntry[0] = ruleId;
                    objectsEntry[1] = DBServiceHelper.genGlobalLongId();
                    int index = 2;
                    for (int i = 0; i < list.size(); ++i) {
                        if (i == 0) {
                            objectsEntry[index++] = list.get(i);
                            continue;
                        }
                        objectsEntry[index++] = this.memberIdMap.get(list.get(i));
                        objectsEntry[index++] = list.get(i);
                    }
                    this.insertNewList.add(objectsEntry);
                }
                continue;
            }
            delRuleIds.add(ruleId);
            for (Long l : accounts) {
                Object[] objectsEntry = new Object[]{ruleId, DBServiceHelper.genGlobalLongId(), l, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L};
                this.insertNewList.add(objectsEntry);
            }
        }
        if (CollectionUtils.isNotEmpty(delRuleIds)) {
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("delete from t_eb_controlruledefineds where ", new Object[0]).appendIn("fid", delRuleIds);
            DB.execute((DBRoute)BgBaseConstant.epm, (SqlBuilder)sqlBuilder);
        }
        this.insertRows("fid ,fentryid ,fgroupaccount ,fuserdefineddimid1 ,fuserdefinedid1 ,fuserdefineddimid2 ,fuserdefinedid2 ,fuserdefineddimid3 ,fuserdefinedid3 ,fuserdefineddimid4 ,fuserdefinedid4 ,fuserdefineddimid5 ,fuserdefinedid5 ,fuserdefineddimid6 ,fuserdefinedid6 ,fuserdefineddimid7 ,fuserdefinedid7", "t_eb_controlruledefineds", this.insertNewList);
        stats.addInfo("end-controlrule-groupuserdefinedmem-upgrade.");
        result.setLog(stats.toString());
        return result;
    }

    private Map<Long, List<Long>> getAllGroupControlRuleAccountIdMap() {
        HashMap<Long, List<Long>> groupControlRuleAccountIdMap = new HashMap<Long, List<Long>>(16);
        String sql = "select fid ,faccountid from t_eb_controlruleaccount where fid in (select fid from t_eb_controlrulemain where fgroupid > 0);";
        try (DataSet ds = DB.queryDataSet((String)"queryAllGroupControlRuleAccount", (DBRoute)BgBaseConstant.epm, (String)sql, null);){
            if (ds != null) {
                for (Row row : ds) {
                    List groupControlRuleAccountIds = groupControlRuleAccountIdMap.computeIfAbsent(row.getLong("fid"), k -> new ArrayList(16));
                    groupControlRuleAccountIds.add(row.getLong("faccountid"));
                }
            }
        }
        return groupControlRuleAccountIdMap;
    }

    private Map<Long, List<Map<String, Object>>> getAllGroupControlRuleUserDefinedMap() {
        HashMap<Long, List<Map<String, Object>>> groupControlRuleUserDefinedMap = new HashMap<Long, List<Map<String, Object>>>(16);
        String sql = "select fid ,fentryid ,fgroupaccount ,fuserdefineddimid1 ,fuserdefineddimid2 ,fuserdefineddimid3 ,fuserdefineddimid4 ,fuserdefineddimid5 ,fuserdefineddimid6 ,fuserdefineddimid7 ,fuserdefinedid1 ,fuserdefinedid2 ,fuserdefinedid3 ,fuserdefinedid4 ,fuserdefinedid5 ,fuserdefinedid6 ,fuserdefinedid7 from t_eb_controlruledefineds where fid in (select fid from t_eb_controlrulemain where fgroupid > 0);";
        this.insertBackupList = new ArrayList<Object[]>(16);
        this.memberIdMap = new HashMap<Long, Long>(16);
        try (DataSet ds = DB.queryDataSet((String)"queryAllGroupControlRuleUserDefined", (DBRoute)BgBaseConstant.epm, (String)sql, null);){
            if (ds != null) {
                for (Row row : ds) {
                    HashMap<String, Long> groupControlRuleUserDefined = new HashMap<String, Long>(16);
                    groupControlRuleUserDefined.put("fid", row.getLong("fid"));
                    groupControlRuleUserDefined.put("fgroupaccount", row.getLong("fgroupaccount"));
                    groupControlRuleUserDefined.put("fuserdefineddimid1", row.getLong("fuserdefineddimid1"));
                    groupControlRuleUserDefined.put("fuserdefineddimid2", row.getLong("fuserdefineddimid2"));
                    groupControlRuleUserDefined.put("fuserdefineddimid3", row.getLong("fuserdefineddimid3"));
                    groupControlRuleUserDefined.put("fuserdefineddimid4", row.getLong("fuserdefineddimid4"));
                    groupControlRuleUserDefined.put("fuserdefineddimid5", row.getLong("fuserdefineddimid5"));
                    groupControlRuleUserDefined.put("fuserdefineddimid6", row.getLong("fuserdefineddimid6"));
                    groupControlRuleUserDefined.put("fuserdefineddimid7", row.getLong("fuserdefineddimid7"));
                    groupControlRuleUserDefined.put("fuserdefinedid1", row.getLong("fuserdefinedid1"));
                    groupControlRuleUserDefined.put("fuserdefinedid2", row.getLong("fuserdefinedid2"));
                    groupControlRuleUserDefined.put("fuserdefinedid3", row.getLong("fuserdefinedid3"));
                    groupControlRuleUserDefined.put("fuserdefinedid4", row.getLong("fuserdefinedid4"));
                    groupControlRuleUserDefined.put("fuserdefinedid5", row.getLong("fuserdefinedid5"));
                    groupControlRuleUserDefined.put("fuserdefinedid6", row.getLong("fuserdefinedid6"));
                    groupControlRuleUserDefined.put("fuserdefinedid7", row.getLong("fuserdefinedid7"));
                    List groupControlRuleUserDefineds = groupControlRuleUserDefinedMap.computeIfAbsent(row.getLong("fid"), k -> new ArrayList(16));
                    groupControlRuleUserDefineds.add(groupControlRuleUserDefined);
                    this.memberIdMap.put(row.getLong("fuserdefinedid1"), row.getLong("fuserdefineddimid1"));
                    this.memberIdMap.put(row.getLong("fuserdefinedid2"), row.getLong("fuserdefineddimid2"));
                    this.memberIdMap.put(row.getLong("fuserdefinedid3"), row.getLong("fuserdefineddimid3"));
                    this.memberIdMap.put(row.getLong("fuserdefinedid4"), row.getLong("fuserdefineddimid4"));
                    this.memberIdMap.put(row.getLong("fuserdefinedid5"), row.getLong("fuserdefineddimid5"));
                    this.memberIdMap.put(row.getLong("fuserdefinedid6"), row.getLong("fuserdefineddimid6"));
                    this.memberIdMap.put(row.getLong("fuserdefinedid7"), row.getLong("fuserdefineddimid7"));
                    Object[] objectsEntry = new Object[]{row.getLong("fid"), DBServiceHelper.genGlobalLongId(), row.getLong("fgroupaccount"), row.getLong("fuserdefineddimid1"), row.getLong("fuserdefineddimid2"), row.getLong("fuserdefineddimid3"), row.getLong("fuserdefineddimid4"), row.getLong("fuserdefineddimid5"), row.getLong("fuserdefineddimid6"), row.getLong("fuserdefineddimid7"), row.getLong("fuserdefinedid1"), row.getLong("fuserdefinedid2"), row.getLong("fuserdefinedid3"), row.getLong("fuserdefinedid4"), row.getLong("fuserdefinedid5"), row.getLong("fuserdefinedid6"), row.getLong("fuserdefinedid7")};
                    this.insertBackupList.add(objectsEntry);
                }
            }
        }
        return groupControlRuleUserDefinedMap;
    }

    private void insertRows(String fieldStr, String ebTableName, List<Object[]> paramsList) {
        StringBuilder sql = new StringBuilder();
        sql.append("insert into ").append(ebTableName).append("(").append(fieldStr).append(") values(");
        int length = fieldStr.split(",").length;
        for (int i = 0; i < length; ++i) {
            sql.append("?,");
        }
        sql.deleteCharAt(sql.length() - 1).append(")");
        if (paramsList != null && paramsList.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)sql.toString(), paramsList);
        }
    }
}

