/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.upgrade;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.StringUtils;

public class ControlTypeUserDefinedDimUpgradeImpl
implements IUpgradeService {
    private static final Log log = LogFactory.getLog(ControlTypeUserDefinedDimUpgradeImpl.class);
    private static final int MAX_USER_DEFINED = 7;
    private List<Object[]> updateList;

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = null;
        try (TXHandle tx = TX.requiresNew((String)"ControlTypeUserDefinedDimUpgrade");){
            try {
                result = this.upgrade();
                result.setLog("controltype userdefineddim upgrade success.");
            }
            catch (Throwable ex) {
                log.error("controltype.userdefineddim.upgrade.error", ex);
                result = new UpgradeResult();
                result.setSuccess(false);
                result.setErrorInfo(ex.getMessage());
                tx.markRollback();
            }
        }
        return result;
    }

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        return null;
    }

    private UpgradeResult upgrade() {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        LogStats stats = new LogStats("budget-upgrade-log:");
        stats.addInfo("begin-controltype-userdefineddim-upgrade.");
        Map<String, List<Map<String, Object>>> controlTypeUserDefinedDimMap = this.getAllControlTypeUserDefinedDim();
        if (!controlTypeUserDefinedDimMap.isEmpty()) {
            Map<Long, Map<String, Object>> userDefinedMemberMap = this.getUserDefinedMemberByMemberIds(controlTypeUserDefinedDimMap);
            this.controlTypeUserDefinedDimUpgrade(userDefinedMemberMap, controlTypeUserDefinedDimMap);
            stats.addInfo("controltype userdefineddim upgrade success.");
        } else {
            stats.addInfo("controltype userdefineddim has no data.");
        }
        stats.addInfo("end-controltype-userdefineddim-upgrade.");
        result.setLog(stats.toString());
        return result;
    }

    private Map<Long, Map<String, Object>> getUserDefinedMemberByMemberIds(Map<String, List<Map<String, Object>>> controlTypeUserDefinedDimMap) {
        ArrayList<Long> memberIds = new ArrayList<Long>(16);
        for (Map.Entry<String, List<Map<String, Object>>> entry : controlTypeUserDefinedDimMap.entrySet()) {
            List<Map<String, Object>> value = entry.getValue();
            for (Map<String, Object> map : value) {
                for (int i = 1; i <= 7; ++i) {
                    Long memId = (Long)map.get("memId" + i);
                    Long dimId = (Long)map.get("dim" + i + "Id");
                    if (memId <= 0L || dimId != 0L) continue;
                    memberIds.add(memId);
                }
            }
        }
        LinkedHashMap userDefinedMemberMap = Maps.newLinkedHashMap();
        String sql = "select fid ,fdimensionid from t_eb_structofdefined where fid in (" + StringUtils.join(memberIds, (String)",") + ");";
        try (DataSet ds = DB.queryDataSet((String)"queryUserDefinedMemberByMemberIds", (DBRoute)BgBaseConstant.epm, (String)sql, null);){
            if (ds != null) {
                for (Row row : ds) {
                    Map userDefinedMember = userDefinedMemberMap.computeIfAbsent(row.getLong("fid"), f -> Maps.newLinkedHashMap());
                    userDefinedMember.put("fid", row.getLong("fid"));
                    userDefinedMember.put("fdimensionid", row.getLong("fdimensionid"));
                }
            }
        }
        return userDefinedMemberMap;
    }

    private void controlTypeUserDefinedDimUpgrade(Map<Long, Map<String, Object>> controlUserDefinedDimMap, Map<String, List<Map<String, Object>>> controlTypeUserDefinedDimMap) {
        this.updateList = new ArrayList<Object[]>(16);
        for (Map.Entry<String, List<Map<String, Object>>> entry : controlTypeUserDefinedDimMap.entrySet()) {
            List<Map<String, Object>> value = entry.getValue();
            for (Map<String, Object> map : value) {
                Object[] objectsEntry = new Object[15];
                objectsEntry[0] = map.get("dim1Id");
                objectsEntry[1] = map.get("dim2Id");
                objectsEntry[2] = map.get("dim3Id");
                objectsEntry[3] = map.get("dim4Id");
                objectsEntry[4] = map.get("dim5Id");
                objectsEntry[5] = map.get("dim6Id");
                objectsEntry[6] = map.get("dim7Id");
                objectsEntry[7] = map.get("memId1");
                objectsEntry[8] = map.get("memId2");
                objectsEntry[9] = map.get("memId3");
                objectsEntry[10] = map.get("memId4");
                objectsEntry[11] = map.get("memId5");
                objectsEntry[12] = map.get("memId6");
                objectsEntry[13] = map.get("memId7");
                for (int i = 1; i <= 7; ++i) {
                    Map<String, Object> userDefinedMem;
                    Long memId = (Long)map.get("memId" + i);
                    Long dimId = (Long)map.get("dim" + i + "Id");
                    objectsEntry[i - 1] = memId;
                    if (memId > 0L && dimId == 0L && (userDefinedMem = controlUserDefinedDimMap.get(memId)) != null && userDefinedMem.size() > 0) {
                        dimId = (Long)userDefinedMem.get("fdimensionid");
                    }
                    objectsEntry[i - 1 + 7] = dimId;
                }
                objectsEntry[14] = map.get("id");
                this.updateList.add(objectsEntry);
            }
            this.updateRows("t_eb_controlruledefineds", this.updateList);
        }
    }

    public void updateRows(String ebTableName, List<Object[]> paramsList) {
        if (paramsList == null || paramsList.isEmpty()) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("update ").append(ebTableName).append(" set fuserdefinedid1 = ?,fuserdefinedid2 = ?,fuserdefinedid3 = ?,fuserdefinedid4 = ?,fuserdefinedid5 = ?,fuserdefinedid6 = ?,fuserdefinedid7 = ?, \nfuserdefineddimid1 = ?,fuserdefineddimid2 = ?,fuserdefineddimid3 = ?,fuserdefineddimid4 = ?,fuserdefineddimid5 = ?,fuserdefineddimid6 = ?,fuserdefineddimid7 = ? where fid = ?;");
        DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)sql.toString(), paramsList);
    }

    private Map<String, List<Map<String, Object>>> getAllControlTypeUserDefinedDim() {
        LinkedHashMap controlTypeUserDefinedDimMap = Maps.newLinkedHashMap();
        String sql = "select a.fid as id ,a.fmodelid as modelId ,a.fbussmodelid as bussModelId ,b.fuserdefineddimid1 as dim1Id ,b.fuserdefineddimid2 as dim2Id ,b.fuserdefineddimid3 as dim3Id ,b.fuserdefineddimid4 as dim4Id ,b.fuserdefineddimid5 as dim5Id ,\nb.fuserdefineddimid6 as dim6Id ,b.fuserdefineddimid7 as dim7Id ,b.fuserdefinedid1 as memId1 ,b.fuserdefinedid2 as memId2 ,b.fuserdefinedid3 as memId3 ,b.fuserdefinedid4 as memId4 ,b.fuserdefinedid5 as memId5 ,\nb.fuserdefinedid6 as memId6 ,b.fuserdefinedid7 as memId7 from t_eb_controlrulemain a left join t_eb_controlruledefineds b on a.fid = b.fid order by a.fmodelid ,a.fbussmodelid ;";
        try (DataSet ds = DB.queryDataSet((String)"queryAllControlUserDefinedDim", (DBRoute)BgBaseConstant.epm, (String)sql, null);){
            if (ds != null) {
                for (Row row : ds) {
                    boolean upgradeFlag = false;
                    LinkedHashMap controlTypeUserDefinedDim = Maps.newLinkedHashMap();
                    for (int i = 1; i <= 7; ++i) {
                        boolean dimIdFlag;
                        Long dimId = row.getLong("dim" + i + "Id");
                        Long memId = row.getLong("memId" + i);
                        boolean memIdFlag = memId != null && memId > 0L;
                        boolean bl = dimIdFlag = dimId == null || dimId == 0L;
                        if (!memIdFlag || !dimIdFlag) continue;
                        upgradeFlag = true;
                        break;
                    }
                    if (!upgradeFlag) continue;
                    controlTypeUserDefinedDim.put("id", row.getLong("id"));
                    controlTypeUserDefinedDim.put("modelId", row.getLong("modelId"));
                    controlTypeUserDefinedDim.put("bussModelId", row.getLong("bussModelId"));
                    controlTypeUserDefinedDim.put("dim1Id", row.getLong("dim1Id"));
                    controlTypeUserDefinedDim.put("dim2Id", row.getLong("dim2Id"));
                    controlTypeUserDefinedDim.put("dim3Id", row.getLong("dim3Id"));
                    controlTypeUserDefinedDim.put("dim4Id", row.getLong("dim4Id"));
                    controlTypeUserDefinedDim.put("dim5Id", row.getLong("dim5Id"));
                    controlTypeUserDefinedDim.put("dim6Id", row.getLong("dim6Id"));
                    controlTypeUserDefinedDim.put("dim7Id", row.getLong("dim7Id"));
                    controlTypeUserDefinedDim.put("memId1", row.getLong("memId1"));
                    controlTypeUserDefinedDim.put("memId2", row.getLong("memId2"));
                    controlTypeUserDefinedDim.put("memId3", row.getLong("memId3"));
                    controlTypeUserDefinedDim.put("memId4", row.getLong("memId4"));
                    controlTypeUserDefinedDim.put("memId5", row.getLong("memId5"));
                    controlTypeUserDefinedDim.put("memId6", row.getLong("memId6"));
                    controlTypeUserDefinedDim.put("memId7", row.getLong("memId7"));
                    String key = row.getLong("modelId") + "-" + row.getLong("bussModelId");
                    List controlTypeUserDefinedDims = controlTypeUserDefinedDimMap.computeIfAbsent(key, f -> Lists.newLinkedList());
                    controlTypeUserDefinedDims.add(controlTypeUserDefinedDim);
                }
            }
        }
        return controlTypeUserDefinedDimMap;
    }
}

