/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.upgrade;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.service.upgrade.UpgradeResult;
import kd.epm.eb.common.bgmddatalock.BgmdDataLockPeriodTreeNode;
import kd.epm.eb.common.bgmddatalock.BgmdDataLockUtils;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.Pair;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.service.upgrade.AbstractUpgradeImpl;

public class DataLockUpgradeImpl
extends AbstractUpgradeImpl {
    Map<Long, Set<String>> existNames = new HashMap<Long, Set<String>>();

    @Override
    public UpgradeResult beforeExecuteSqlWithResult(UpgradeResult result, Object[] params) {
        String sql2;
        Long paramModelId = null;
        if (params != null) {
            paramModelId = (Long)params[0];
            sql2 = "select fmodelid,fbusinessmodelid,fyearid,fversionid,fdatatypeid,faudittrailid,fentitynumber,fperiodinteger from t_bgmd_datalock where fmodelid = " + paramModelId + " and fbusinessmodelid != 0";
        } else {
            sql2 = "select fmodelid,fbusinessmodelid,fyearid,fversionid,fdatatypeid,faudittrailid,fentitynumber,fperiodinteger from t_bgmd_datalock where fmodelid != 0 and fbusinessmodelid != 0";
        }
        final BaseData baseData = new BaseData();
        this.queryBaseData(baseData, paramModelId);
        ArrayList<Pair> needSave = new ArrayList<Pair>(16);
        BgmdDataLockPeriodTreeNode rootNode = BgmdDataLockUtils.getPeriodTreeNode((String)"yeartotal");
        Long modelId = null;
        try (DataSet ds = DB.queryDataSet((String)"DataLockUpgradeImpl", (DBRoute)BgBaseConstant.epm, (String)sql2, null);){
            DataSet[] dataSets1;
            for (DataSet dataSet1 : dataSets1 = ds.splitByGroup(new String[]{"fmodelid", "fbusinessmodelid"})) {
                DataSet copy = dataSet1.copy();
                Long busModelId = null;
                Long viewId = null;
                if (dataSet1.hasNext()) {
                    Row next = dataSet1.next();
                    if (modelId != null && !modelId.equals(next.getLong("fmodelid"))) {
                        this.existNames.clear();
                    }
                    modelId = next.getLong("fmodelid");
                    busModelId = next.getLong("fbusinessmodelid");
                    Map viewIds = BusinessModelServiceHelper.getViewIds((Long)busModelId, (boolean)true);
                    if (viewIds != null) {
                        viewId = (Long)viewIds.get(SysDimensionEnum.Entity.getNumber());
                    }
                }
                if (modelId == null || busModelId == null || viewId == null || baseData.hasUpgradeModelMap.contains(modelId)) continue;
                DataSet[] dataSets2 = copy.splitByGroup(new String[]{"fversionid", "fdatatypeid", "faudittrailid"});
                ArrayList<Pair> value = new ArrayList<Pair>(16);
                for (DataSet dataSet2 : dataSets2) {
                    Long versionId = null;
                    Long datatypeId = null;
                    Long auditTrailId = null;
                    ArrayList<Object[]> value1 = new ArrayList<Object[]>();
                    HashSet<String> userPeriods = new HashSet<String>();
                    while (dataSet2.hasNext()) {
                        Long yearId;
                        String yearNumber;
                        Row next = dataSet2.next();
                        if (versionId == null) {
                            versionId = next.getLong("fversionid");
                            datatypeId = next.getLong("fdatatypeid");
                            auditTrailId = next.getLong("faudittrailid");
                            if (!baseData.versionIdToNumMap.containsKey(versionId) || !baseData.datatypeIdToNumMap.containsKey(datatypeId) || !baseData.audittrailIdToNumMap.containsKey(auditTrailId)) break;
                        }
                        if ((yearNumber = baseData.periodIdToNumMap.get(yearId = next.getLong("fyearid"))) == null || yearNumber.length() != 6) continue;
                        String entityNumber = next.getString("fentitynumber");
                        Integer periodInt = next.getInteger("fperiodinteger");
                        if (periodInt == 0) continue;
                        HashSet<String> lockedPeriods = new HashSet<String>(16);
                        this.dfs(rootNode, periodInt, yearNumber, lockedPeriods);
                        userPeriods.addAll(lockedPeriods);
                        for (String lockedPeriod : lockedPeriods) {
                            value1.add(new Object[]{entityNumber, lockedPeriod});
                        }
                    }
                    if (versionId == null || datatypeId == null || auditTrailId == null || value1.isEmpty()) continue;
                    ArrayList<String> userPeriodList = new ArrayList<String>(userPeriods);
                    userPeriodList.sort(new Comparator<String>(){

                        @Override
                        public int compare(String o1, String o2) {
                            return baseData.periodNumToSeqMap.get(o1) - baseData.periodNumToSeqMap.get(o2);
                        }
                    });
                    value.add(Pair.onePair((Object)new Object[]{versionId, datatypeId, auditTrailId, userPeriodList}, value1));
                }
                if (modelId == null || busModelId == null || viewId == null || value.isEmpty()) continue;
                needSave.add(Pair.onePair((Object)new Object[]{modelId, busModelId, viewId}, value));
            }
        }
        ArrayList<Object[]> params1 = new ArrayList<Object[]>();
        ArrayList<Object[]> params2 = new ArrayList<Object[]>();
        ArrayList<Object[]> params3 = new ArrayList<Object[]>();
        ArrayList<Object[]> params4 = new ArrayList<Object[]>();
        ArrayList<Object[]> params5 = new ArrayList<Object[]>();
        ArrayList<Object[]> params6 = new ArrayList<Object[]>();
        for (Pair pair1 : needSave) {
            Object[] key1 = (Object[])pair1.getKey();
            List value1 = (List)pair1.getValue();
            for (Pair pair2 : value1) {
                Object[] key2 = (Object[])pair2.getKey();
                Object[] param1 = new Object[]{baseData.getId(), key1[0], key1[1], baseData.getUserId(), baseData.getDate(), key1[2], this.getName(baseData, (Long)key1[0], (Long)key2[0], (Long)key2[1], (Long)key2[2])};
                params1.add(param1);
                params2.add(new Object[]{baseData.getId(), param1[0], key2[0]});
                params3.add(new Object[]{baseData.getId(), param1[0], key2[1]});
                params4.add(new Object[]{baseData.getId(), param1[0], key2[2]});
                List userPeriods = (List)key2[3];
                for (String userPeriod : userPeriods) {
                    Long periodId = baseData.periodNumToIdMap.get(userPeriod);
                    if (periodId == null) continue;
                    params5.add(new Object[]{baseData.getId(), param1[0], periodId});
                }
                List value2 = (List)pair2.getValue();
                for (Object[] objects : value2) {
                    params6.add(new Object[]{baseData.getId(), objects[0], objects[1], param1[0]});
                }
            }
            if (params6.size() <= 5000) continue;
            this.saves(params1, params2, params3, params4, params5, params6);
        }
        this.saves(params1, params2, params3, params4, params5, params6);
        return null;
    }

    private void saves(List<Object[]> params1, List<Object[]> params2, List<Object[]> params3, List<Object[]> params4, List<Object[]> params5, List<Object[]> params6) {
        String insertSql1 = "insert into t_bgmd_datalockcase(fid,fmodelid,fbusinessmodelid,fcreaterid,fcreatedate,fentityviewid,fname) values (?,?,?,?,?,?,?)";
        String insertSql2 = "insert into t_bgmd_datalockcase_v(fpkid,fid,fbasedataid) values (?,?,?)";
        String insertSql3 = "insert into t_bgmd_datalockcase_dt(fpkid,fid,fbasedataid) values (?,?,?)";
        String insertSql4 = "insert into t_bgmd_datalockcase_at(fpkid,fid,fbasedataid) values (?,?,?)";
        String insertSql5 = "insert into t_bgmd_datalockcase_bp(fpkid,fid,fbasedataid) values (?,?,?)";
        String insertSql6 = "insert into t_bgmd_datalockcasedetail(fid,fentity,fperiod,fcaseid) values (?,?,?,?)";
        this.save(insertSql1, params1);
        this.save(insertSql2, params2);
        this.save(insertSql3, params3);
        this.save(insertSql4, params4);
        this.save(insertSql5, params5);
        this.save(insertSql6, params6);
    }

    private String getName(BaseData baseData, Long modelId, Long versionId, Long dataTypeId, Long auditTrailId) {
        String versionName = baseData.versionIdToNameMap.get(versionId);
        String datatypeName = baseData.datatypeIdToNameMap.get(dataTypeId);
        String auditTrailName = baseData.audittrailIdToNameMap.get(auditTrailId);
        String name = versionName + "_" + datatypeName + "_" + auditTrailName;
        Set names = this.existNames.computeIfAbsent(modelId, v -> new HashSet());
        if (names.add(name)) {
            return name;
        }
        name = name + "_";
        int index = 1;
        String name2;
        while (!names.add(name2 = name + index)) {
            ++index;
        }
        return name2;
    }

    private void queryBaseData(BaseData baseData, Long modelId) {
        String name;
        String sql5;
        String sql4;
        String sql3;
        String sql2;
        String sql1;
        if (modelId != null) {
            sql1 = "select a.fid,a.fnumber,a.fseq,b.fname from t_eb_structofbperiod a left join  t_eb_structofbperiod_l b on a.fid = b.fid where b.flocaleid = 'zh_CN' and fmodelid = " + modelId;
            sql2 = "select a.fid,a.fnumber,a.fseq,b.fname from t_eb_structofversion a left join  t_eb_structofversion_l b on a.fid = b.fid where b.flocaleid = 'zh_CN' and fmodelid = " + modelId;
            sql3 = "select a.fid,a.fnumber,a.fseq,b.fname from t_eb_structofdatetype a left join  t_eb_structofdatetype_l b on a.fid = b.fid where b.flocaleid = 'zh_CN' and fmodelid = " + modelId;
            sql4 = "select a.fid,a.fnumber,a.fseq,b.fname from t_eb_structofaudittrial a left join  t_eb_structofaudittrial_l b on a.fid = b.fid where b.flocaleid = 'zh_CN' and fmodelid = " + modelId;
            sql5 = "select fid,fmodelid from t_bgmd_datalockcase where fmodelid = " + modelId;
        } else {
            sql1 = "select a.fid,a.fnumber,a.fseq,b.fname from t_eb_structofbperiod a left join  t_eb_structofbperiod_l b on a.fid = b.fid where b.flocaleid = 'zh_CN' and fmodelid in (select fmodelid from t_bgmd_datalock)";
            sql2 = "select a.fid,a.fnumber,a.fseq,b.fname from t_eb_structofversion a left join  t_eb_structofversion_l b on a.fid = b.fid where b.flocaleid = 'zh_CN' and fmodelid in (select fmodelid from t_bgmd_datalock)";
            sql3 = "select a.fid,a.fnumber,a.fseq,b.fname from t_eb_structofdatetype a left join  t_eb_structofdatetype_l b on a.fid = b.fid where b.flocaleid = 'zh_CN' and fmodelid in (select fmodelid from t_bgmd_datalock)";
            sql4 = "select a.fid,a.fnumber,a.fseq,b.fname from t_eb_structofaudittrial a left join  t_eb_structofaudittrial_l b on a.fid = b.fid where b.flocaleid = 'zh_CN' and fmodelid in (select fmodelid from t_bgmd_datalock)";
            sql5 = "select fid,fmodelid from t_bgmd_datalockcase";
        }
        try (DataSet ds = DB.queryDataSet((String)"queryBaseData1", (DBRoute)BgBaseConstant.epm, (String)sql1, null);){
            for (Row row : ds) {
                Long periodId = row.getLong("fid");
                String periodNumber = row.getString("fnumber");
                Integer seq = row.getInteger("fseq");
                baseData.periodIdToNumMap.put(periodId, periodNumber);
                baseData.periodNumToIdMap.put(periodNumber, periodId);
                baseData.periodNumToSeqMap.put(periodNumber, seq);
            }
        }
        ds = DB.queryDataSet((String)"queryBaseData2", (DBRoute)BgBaseConstant.epm, (String)sql2, null);
        var9_9 = null;
        try {
            for (Row row : ds) {
                Long versionId = row.getLong("fid");
                String versionNumber = row.getString("fnumber");
                String versionName = row.getString("fname");
                baseData.versionIdToNumMap.put(versionId, versionNumber);
                baseData.versionIdToNameMap.put(versionId, versionName);
            }
        }
        catch (Throwable throwable) {
            var9_9 = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (var9_9 != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        var9_9.addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        ds = DB.queryDataSet((String)"queryBaseData3", (DBRoute)BgBaseConstant.epm, (String)sql3, null);
        var9_9 = null;
        try {
            for (Row row : ds) {
                Long datatypeId = row.getLong("fid");
                String datatypeNumber = row.getString("fnumber");
                name = row.getString("fname");
                baseData.datatypeIdToNumMap.put(datatypeId, datatypeNumber);
                baseData.datatypeIdToNameMap.put(datatypeId, name);
            }
        }
        catch (Throwable throwable) {
            var9_9 = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (var9_9 != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        var9_9.addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        ds = DB.queryDataSet((String)"queryBaseData4", (DBRoute)BgBaseConstant.epm, (String)sql4, null);
        var9_9 = null;
        try {
            for (Row row : ds) {
                Long audittrailId = row.getLong("fid");
                String audittrailNumber = row.getString("fnumber");
                name = row.getString("fname");
                baseData.audittrailIdToNumMap.put(audittrailId, audittrailNumber);
                baseData.audittrailIdToNameMap.put(audittrailId, name);
            }
        }
        catch (Throwable throwable) {
            var9_9 = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (var9_9 != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        var9_9.addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        ds = DB.queryDataSet((String)"queryBaseData5", (DBRoute)BgBaseConstant.epm, (String)sql5, null);
        var9_9 = null;
        try {
            for (Row row : ds) {
                baseData.hasUpgradeModelMap.add(row.getLong("fmodelid"));
            }
        }
        catch (Throwable throwable) {
            var9_9 = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (var9_9 != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        var9_9.addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
    }

    private void save(String sql, List<Object[]> params) {
        if (!params.isEmpty()) {
            DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)sql, params);
            params.clear();
        }
    }

    private void dfs(BgmdDataLockPeriodTreeNode rootNode, Integer periodInt, String yearNumber, Set<String> sets) {
        if (BgmdDataLockUtils.checkLock((int)periodInt, (int)rootNode.getPeriods())) {
            sets.add(yearNumber + rootNode.getRealNumber());
            return;
        }
        List children = rootNode.getChildren();
        if (children != null) {
            for (BgmdDataLockPeriodTreeNode child : children) {
                this.dfs(child, periodInt, yearNumber, sets);
            }
        }
    }

    static class BaseData {
        Date date = new Date();
        Long userId = UserUtils.getUserId();
        long[] ids;
        int i = 0;
        Map<Long, String> periodIdToNumMap = new HashMap<Long, String>(16);
        Map<String, Long> periodNumToIdMap = new HashMap<String, Long>(16);
        Map<String, Integer> periodNumToSeqMap = new HashMap<String, Integer>(16);
        Map<Long, String> versionIdToNumMap = new HashMap<Long, String>(16);
        Map<Long, String> datatypeIdToNumMap = new HashMap<Long, String>(16);
        Map<Long, String> audittrailIdToNumMap = new HashMap<Long, String>(16);
        Map<Long, String> versionIdToNameMap = new HashMap<Long, String>(16);
        Map<Long, String> datatypeIdToNameMap = new HashMap<Long, String>(16);
        Map<Long, String> audittrailIdToNameMap = new HashMap<Long, String>(16);
        Set<Long> hasUpgradeModelMap = new HashSet<Long>(16);

        BaseData() {
        }

        private Date getDate() {
            return this.date;
        }

        private Long getUserId() {
            return this.userId;
        }

        private long getId() {
            if (this.ids == null || this.i == 5000) {
                this.i = 0;
                this.ids = DB.genGlobalLongIds((int)5000);
            }
            return this.ids[this.i++];
        }
    }
}

