/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.upgrade;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.utils.UpdateRecordHelper;

public class DelExecuteAnalyseSchemeMemQuoteServiceImpl
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try (TXHandle tx = TX.requiresNew((String)"DelExecuteAnalyseSchemeMemQuoteServiceImpl");){
            try {
                if (!UpdateRecordHelper.isUpdated((String)"DelExeAnalyseSchemeMemQuote")) {
                    String log = this.execute();
                    UpdateRecordHelper.addRecord((String)"DelExeAnalyseSchemeMemQuote", (String)log, null, (boolean)true);
                }
                result.setSuccess(true);
            }
            catch (Exception e) {
                result.setSuccess(false);
                StackTraceElement[] arr = e.getStackTrace();
                StringBuilder sb = new StringBuilder();
                for (StackTraceElement ele : arr) {
                    sb.append(ele.toString()).append("\r\n");
                }
                result.setLog(e.getMessage());
                result.setErrorInfo(sb.toString());
                tx.markRollback();
            }
        }
        return result;
    }

    public String execute() {
        int count = 0;
        String sql = "select fid from t_eb_execschemeentity";
        try (DataSet ds = DB.queryDataSet((String)"queryScheme", (DBRoute)BgBaseConstant.epm, (String)sql);){
            if (ds != null) {
                ArrayList<Long> schemeIds = new ArrayList<Long>(16);
                for (Row row : ds) {
                    Long fid = row.getLong("fid");
                    schemeIds.add(fid);
                    if (schemeIds.size() > 5000) {
                        this.deleteQuote(schemeIds);
                        schemeIds.clear();
                    }
                    ++count;
                }
                if (!schemeIds.isEmpty()) {
                    this.deleteQuote(schemeIds);
                }
            }
        }
        return String.format("schemeAmount:%s", count);
    }

    private void deleteQuote(List<Long> schemeIds) {
        DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"delete", (Object[])new Object[]{MemberQuoteResourceEnum.ExecAnalyseScheme.getType(), schemeIds});
    }
}

