/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.upgrade;

import java.util.Arrays;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.epm.eb.common.control.dimmaterule.DimmateruleUtils;
import kd.epm.eb.common.utils.UpdateRecordHelper;

public class DimmateRuleUpgradeImpl
implements IUpgradeService {
    private static final Log log = LogFactory.getLog(DimmateRuleUpgradeImpl.class);
    private static final String EXCUTEFLAG = "dimmateruleupgradeflag";

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try (TXHandle tx = TX.requiresNew((String)"ControlTypeUserDefinedDimUpgrade");){
            try {
                if (!UpdateRecordHelper.isUpdated((String)EXCUTEFLAG)) {
                    DimmateruleUtils.getInstance().ruleBillUpgrade(null);
                    UpdateRecordHelper.addRecord((String)EXCUTEFLAG, null, null, (boolean)true);
                }
                result.setSuccess(true);
                result.setLog("dimmaterule-upgrade-success");
            }
            catch (Throwable ex) {
                log.info("dimmaterule-upgrade-error:", (Object)ex);
                log.info("dimmaterule-upgrade-error:", (Object)Arrays.toString(ex.getStackTrace()));
                result.setLog("dimmaterule-upgrade-error");
                result.setSuccess(false);
                result.setErrorInfo(ex.getMessage());
                tx.markRollback();
            }
        }
        return result;
    }
}

