/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.upgrade;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.SqlBatchUtils;
import kd.epm.eb.common.utils.UpdateRecordHelper;
import org.apache.commons.collections4.CollectionUtils;

public class ReportQueryCatalogUpgradeServiceImpl
implements IUpgradeService {
    private static final Log log = LogFactory.getLog(ReportQueryCatalogUpgradeServiceImpl.class);
    private Map<Long, Long> rootSelfMap = new HashMap<Long, Long>(16);
    private Map<Long, Map<String, Object>> rootDataMap = new HashMap<Long, Map<String, Object>>(16);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try (TXHandle tx = TX.requiresNew((String)"ReportQueryCatalogUpgradeServiceImpl");){
            try {
                if (!UpdateRecordHelper.isUpdated((String)"ReportQueryCatalogUpgradeV1")) {
                    this.execute();
                    UpdateRecordHelper.addRecord((String)"ReportQueryCatalogUpgradeV1", null, null, (boolean)true);
                }
                result.setSuccess(true);
            }
            catch (Exception e) {
                result.setSuccess(false);
                StackTraceElement[] arr = e.getStackTrace();
                StringBuilder sb = new StringBuilder();
                for (StackTraceElement ele : arr) {
                    sb.append(ele.toString()).append("\r\n");
                }
                result.setLog(e.getMessage());
                result.setErrorInfo(sb.toString());
                tx.markRollback();
            }
        }
        return result;
    }

    private void execute() {
        this.updateSelfNumber();
        this.updateName();
        if (CollectionUtils.isNotEmpty(this.rootDataMap.keySet())) {
            this.presetSelfCatalog();
            this.updateCatalog();
            this.updateReportQuery();
        }
    }

    private void updateSelfNumber() {
        String updateSelfNumberSql = "update t_eb_reportcatalog set fnumber = '01_sys_1' where fnumber = '01_sys'";
        DB.execute((DBRoute)BgBaseConstant.epm, (String)updateSelfNumberSql);
    }

    private void presetSelfCatalog() {
        String selfStr = ResManager.loadKDString((String)"\u79c1\u6709", (String)"ReportQueryCatalogUpgradeServiceImpl_2", (String)"epm-eb-mservice", (Object[])new Object[0]);
        String insertSql = "insert into t_eb_reportcatalog(fid,fnumber,fstatus,fcreatorid,fcreatetime,fmodifierid,fmodifytime,fenable,flongnumber,flevel,fisleaf,fparentid,fmodelid,fsequence) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        String insertLSql = "insert into t_eb_reportcatalog_l (fpkid,fid,flocaleid,fname,ffullname) values (?,?,?,?,?)";
        ArrayList<Object[]> params = new ArrayList<Object[]>(10);
        ArrayList<Object[]> strParams = new ArrayList<Object[]>(10);
        String[] strings = GlobalIdUtil.genStringIds((int)this.rootDataMap.size());
        long[] longs = GlobalIdUtil.genGlobalLongIds((int)this.rootDataMap.size());
        Date date = new Date();
        int index = 0;
        for (Map.Entry<Long, Map<String, Object>> entry : this.rootDataMap.entrySet()) {
            Long key = entry.getKey();
            Map<String, Object> value = entry.getValue();
            Object[] objects = new Object[]{longs[index], "01_sys", value.get("fstatus") == null ? "C" : value.get("fstatus"), value.get("fcreatorid") == null ? Long.valueOf(0L) : value.get("fcreatorid"), date, value.get("fcreatorid") == null ? Long.valueOf(0L) : value.get("fcreatorid"), date, value.get("fenable"), "root.01_sys", 2, value.get("fisleaf"), key, value.get("fmodelid"), 1};
            params.add(objects);
            this.rootSelfMap.put(key, longs[index]);
            Object[] values = new Object[]{strings[index], longs[index], "zh_CN", selfStr, ResManager.loadResFormat((String)"\u5168\u90e8\u5206\u7c7b.(1%)", (String)"ReportQueryCatalogUpgradeServiceImpl_1", (String)"epm-eb-mservice", (Object[])new Object[]{selfStr})};
            strParams.add(values);
            ++index;
        }
        if (CollectionUtils.isNotEmpty(params)) {
            DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)insertSql, params);
            DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)insertLSql, strParams);
        }
    }

    private void updateReportQuery() {
        String queryRootReportQuerySql = "select fid,freportcatalogid from t_eb_reportquery where freportcatalogid in (" + SqlBatchUtils.getBatchParamsSql((int)this.rootDataMap.size()) + ")";
        ArrayList<Object[]> params = new ArrayList<Object[]>(10);
        try (DataSet dataSet = DB.queryDataSet((String)"selectRootRptQuery", (DBRoute)BgBaseConstant.epm, (String)queryRootReportQuerySql, (Object[])this.rootDataMap.keySet().toArray());){
            while (dataSet != null && dataSet.hasNext()) {
                Row next = dataSet.next();
                Long freportcatalogid = this.rootSelfMap.get(next.getLong("freportcatalogid"));
                if (!IDUtils.isNotNull((Long)freportcatalogid)) continue;
                Object[] objects = new Object[]{freportcatalogid, next.getLong("fid")};
                params.add(objects);
            }
        }
        String updateSql = "update t_eb_reportquery set freportcatalogid = ? where fid = ?";
        if (CollectionUtils.isNotEmpty(params)) {
            DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)updateSql, params);
        }
    }

    private void updateCatalog() {
        String queryRootChildCatalogSql = "select fid,fparentid from t_eb_reportcatalog where fnumber != '01_sys' and fnumber != 'share' and fnumber != '02_sys' and fparentid in (" + SqlBatchUtils.getBatchParamsSql((int)this.rootDataMap.size()) + ")";
        ArrayList<Object[]> params = new ArrayList<Object[]>(10);
        try (DataSet dataSet = DB.queryDataSet((String)"selectRootChildCatalog", (DBRoute)BgBaseConstant.epm, (String)queryRootChildCatalogSql, (Object[])this.rootDataMap.keySet().toArray());){
            while (dataSet != null && dataSet.hasNext()) {
                Row next = dataSet.next();
                Long fparentid = this.rootSelfMap.get(next.getLong("fparentid"));
                if (!IDUtils.isNotNull((Long)fparentid)) continue;
                Object[] objects = new Object[]{fparentid, next.getLong("fid")};
                params.add(objects);
            }
        }
        if (CollectionUtils.isNotEmpty(params)) {
            DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)"update t_eb_reportcatalog set fparentid = ? where fid = ?", params);
        }
    }

    private void updateName() {
        Serializable fid;
        String needUpdateNameSql = "select log.fid,l.flocaleid,log.fstatus,log.fcreatorid,log.fmodelid,log.fenable,log.fisleaf from t_eb_reportcatalog log left join t_eb_reportcatalog_l l on log.fid = l.fid where log.fnumber = 'root'";
        HashMap<String, Set<Long>> needUpdateRootMap = new HashMap<String, Set<Long>>(16);
        ArrayList<Object[]> params = new ArrayList<Object[]>(10);
        try (DataSet dataSet = DB.queryDataSet((String)"t_eb_reportcatalog", (DBRoute)BgBaseConstant.epm, (String)needUpdateNameSql);){
            while (dataSet != null && dataSet.hasNext()) {
                Row next = dataSet.next();
                String locale = next.getString("flocaleid");
                Set longs = needUpdateRootMap.computeIfAbsent(locale, v -> new HashSet(16));
                longs.add(next.getLong("fid"));
                fid = next.getLong("fid");
                Map dataMap = this.rootDataMap.computeIfAbsent((Long)fid, v -> new HashMap(16));
                dataMap.put("fstatus", next.get("fstatus"));
                dataMap.put("fcreatorid", next.get("fcreatorid"));
                dataMap.put("fmodelid", next.getLong("fmodelid"));
                dataMap.put("fenable", next.get("fenable"));
                dataMap.put("fisleaf", next.get("fisleaf"));
            }
        }
        String updateNameSql = "update t_eb_reportcatalog_l set fname = ?,ffullname = ? where fid = ?";
        this.buildUpdateNameParams(needUpdateRootMap, params);
        if (CollectionUtils.isNotEmpty(params)) {
            DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)updateNameSql, params);
        }
        HashMap<String, String> shareNeedUpdateMap = new HashMap<String, String>(16);
        LocaleString shareLocal = ResManager.getLocaleString((String)"\u6211\u7684\u5206\u4eab", (String)"ReportQueryCatalogUpgradeServiceImpl_5", (String)"epm-eb-mservice");
        String needUpdateShareSql = "select  fpkid ,flocaleid from t_eb_reportcatalog_l terl  where  terl .fid  in  (select  ter.fid from  t_eb_reportcatalog ter left join t_eb_reportcatalog_l terl  on ter.fid = terl.fid  where ter.flongnumber  = 'root.share' and terl.fname = '" + shareLocal.getLocaleValue_zh_CN() + "');";
        DataSet dataSet = DB.queryDataSet((String)"t_eb_reportcatalog_l", (DBRoute)BgBaseConstant.epm, (String)needUpdateShareSql);
        fid = null;
        try {
            while (dataSet != null && dataSet.hasNext()) {
                Row next = dataSet.next();
                String locale = next.getString("flocaleid");
                String fpkid = next.getString("fpkid");
                shareNeedUpdateMap.put(fpkid, locale);
            }
        }
        catch (Throwable throwable) {
            fid = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (fid != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)fid).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        if (shareNeedUpdateMap.size() > 0) {
            ArrayList<Object[]> params2 = new ArrayList<Object[]>(10);
            this.buildUpdateShareNameParams(shareNeedUpdateMap, params2);
            String updateNameSql2 = "update t_eb_reportcatalog_l set fname = ?,ffullname = ? where fpkid = ?";
            if (CollectionUtils.isNotEmpty(params2)) {
                DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)updateNameSql2, params2);
            }
        }
    }

    private void buildUpdateNameParams(Map<String, Set<Long>> needUpdateMap, List<Object[]> params) {
        LocaleString rootLocale = ResManager.getLocaleString((String)"\u5168\u90e8\u5206\u7c7b", (String)"ReportQueryCatalogUpgradeServiceImpl_3", (String)"epm-eb-mservice");
        for (Map.Entry<String, Set<Long>> entry : needUpdateMap.entrySet()) {
            String key = entry.getKey();
            Set<Long> value = entry.getValue();
            for (Long aLong : value) {
                Object[] objects = new Object[3];
                if ("zh_CN".equals(key)) {
                    objects[0] = rootLocale.getLocaleValue_zh_CN();
                    objects[1] = rootLocale.getLocaleValue_zh_CN();
                } else if ("zh_TW".equals(key)) {
                    objects[0] = rootLocale.getLocaleValue_zh_TW();
                    objects[1] = rootLocale.getLocaleValue_zh_TW();
                } else if ("en_US".equals(key)) {
                    objects[0] = rootLocale.getLocaleValue_en();
                    objects[1] = rootLocale.getLocaleValue_en();
                }
                objects[2] = aLong;
                if (objects[0] == null || objects[1] == null || objects[2] == null) continue;
                params.add(objects);
            }
        }
    }

    private void buildUpdateShareNameParams(Map<String, String> needUpdateShareNode, List<Object[]> params) {
        LocaleString rootLocale = ResManager.getLocaleString((String)"\u5168\u90e8\u5206\u7c7b", (String)"ReportQueryCatalogUpgradeServiceImpl_3", (String)"epm-eb-mservice");
        LocaleString shareLocale = ResManager.getLocaleString((String)"\u5206\u4eab\u7ed9\u6211\u7684", (String)"ReportQueryCatalogUpgradeServiceImpl_4", (String)"epm-eb-mservice");
        for (Map.Entry<String, String> entry : needUpdateShareNode.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            Object[] objects = new Object[3];
            if ("zh_CN".equals(value)) {
                objects[0] = shareLocale.getLocaleValue_zh_CN();
                objects[1] = rootLocale.getLocaleValue_zh_CN() + "." + shareLocale.getLocaleValue_zh_CN();
            } else if ("zh_TW".equals(value)) {
                objects[0] = shareLocale.getLocaleValue_zh_TW();
                objects[1] = rootLocale.getLocaleValue_zh_TW() + "." + shareLocale.getLocaleValue_zh_TW();
            } else if ("en_US".equals(value)) {
                objects[0] = shareLocale.getLocaleValue_en();
                objects[1] = rootLocale.getLocaleValue_en() + "." + shareLocale.getLocaleValue_en();
            }
            objects[2] = key;
            if (objects[0] == null || objects[1] == null || objects[2] == null) continue;
            params.add(objects);
        }
    }
}

