/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.upgrade;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.service.upgrade.UpgradeResult;
import kd.epm.eb.common.f7.FormulaCondition;
import kd.epm.eb.common.utils.SqlBatchUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.olap.impl.execute.dao.RuleManageJsonUtil;
import kd.epm.eb.service.upgrade.AbstractUpgradeImpl;

public class RuleCaseUpgradeImpl
extends AbstractUpgradeImpl {
    private static final DBRoute DB_EPM = DBRoute.of((String)"epm");

    @Override
    public UpgradeResult beforeExecuteSqlWithResult(UpgradeResult result, Object[] params) {
        Long paramModelId = null;
        if (params != null) {
            paramModelId = (Long)params[0];
        }
        String sql2 = "select fid,fnumber,fname,fmodelid,fbusinessmodelid,fcreatetime,fmodifytime,fcreatorid,fmodifierid from t_eb_executecase where fmodelid not in (select distinct fmodelid from t_eb_ruleexeccase) ";
        if (paramModelId != null) {
            sql2 = sql2 + "and fmodelid = " + paramModelId;
        }
        LinkedList caseList = new LinkedList();
        DB.query((DBRoute)DB_EPM, (String)sql2, rs -> {
            while (rs.next()) {
                Object[] caseObjs = new Object[]{rs.getLong("fid"), rs.getString("fnumber"), rs.getString("fname"), rs.getLong("fmodelid"), rs.getLong("fbusinessmodelid"), rs.getDate("fcreatetime"), rs.getDate("fmodifytime"), rs.getLong("fcreatorid"), rs.getLong("fmodifierid"), "1", "A", "rule"};
                caseList.add(caseObjs);
            }
            return caseList;
        });
        if (caseList.isEmpty()) {
            return result;
        }
        String insertSql1 = "insert into t_eb_ruleexeccase(fid,fnumber,fname,fmodelid,fbizmodelid,fcreatetime,fmodifytime,fcreatorid,fmodifierid,ftype,fupdatestatus,fcurrstep) values(" + SqlBatchUtils.getBatchParamsSql((int)((Object[])caseList.get(0)).length) + ")";
        DB.executeBatch((DBRoute)DB_EPM, (String)insertSql1, caseList);
        String sql3 = "select fentryid,fid,fseq,fbizruleid,fscope from t_eb_executecase_rule where fid in (" + SqlBatchUtils.getBatchParamsSql((int)caseList.size()) + ")";
        Object[] pkids = caseList.stream().map(objs -> objs[0]).toArray();
        LinkedList caseRuleList = new LinkedList();
        DB.query((DBRoute)DB_EPM, (String)sql3, (Object[])pkids, rs -> {
            while (rs.next()) {
                Object[] caseRuleObjs = new Object[5];
                caseRuleObjs[0] = rs.getLong("fid");
                caseRuleObjs[1] = rs.getLong("fentryid");
                caseRuleObjs[2] = rs.getInt("fseq");
                caseRuleObjs[3] = rs.getLong("fbizruleid");
                String scope = rs.getString("fscope");
                if (StringUtils.isEmpty((String)scope)) {
                    caseRuleObjs[4] = scope;
                } else {
                    try {
                        List conditions2 = RuleManageJsonUtil.getConditions2((String)scope);
                        HashMap<String, List> memberConditionMap = new HashMap<String, List>(16);
                        for (FormulaCondition formulaCondition : conditions2) {
                            memberConditionMap.put(formulaCondition.getDimensionNumber(), formulaCondition.getMemberList());
                        }
                        caseRuleObjs[4] = JsonUtils.getJsonString(memberConditionMap);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                caseRuleList.add(caseRuleObjs);
            }
            return caseList;
        });
        if (caseRuleList.isEmpty()) {
            return result;
        }
        String insertSql2 = "insert into t_eb_ruleexeccase_rule(fid,fentryid,fseq,fruleid,frangejson) values(" + SqlBatchUtils.getBatchParamsSql((int)((Object[])caseRuleList.get(0)).length) + ")";
        DB.executeBatch((DBRoute)DB_EPM, (String)insertSql2, caseRuleList);
        return result;
    }
}

