/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.upgrade;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.DBServiceHelper;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.SqlBatchUtils;
import org.apache.commons.collections4.CollectionUtils;

public class WhiteListUpgradeImpl
implements IUpgradeService {
    private static final Log log = LogFactory.getLog(WhiteListUpgradeImpl.class);
    private List<Object[]> whiteSetPropertyList;
    private List<Object[]> whiteSetLangPropertyList;
    private List<Object[]> whiteSetBillPropertyList;
    private List<Object[]> whiteSetEntryPropertyList;

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result;
        try (TXHandle tx = TX.requiresNew((String)"WhiteListUpgrade");){
            try {
                result = this.upgrade();
            }
            catch (Throwable ex) {
                log.error("whiteList.upgrade.error", ex);
                result = new UpgradeResult();
                result.setSuccess(false);
                result.setErrorInfo(ex.getMessage());
                tx.markRollback();
            }
        }
        return result;
    }

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        return null;
    }

    private UpgradeResult upgrade() {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        LogStats stats = new LogStats("budget-upgrade-log:");
        stats.addInfo("begin-whitelist-upgrade.");
        if (SqlBatchUtils.hasData((String)"t_eb_whitelist")) {
            stats.addInfo("whitelist has data.");
            stats.addInfo("end-whitelist-upgrade.");
            result.setLog(stats.toString());
            return result;
        }
        Map<Long, Map<String, Object>> historyWhiteSetMap = this.getHistoryWhiteSetMap();
        if (!historyWhiteSetMap.isEmpty()) {
            Map<Long, List<Map<String, Object>>> historyWhiteSetLangMap = this.getHistoryWhiteSetLangMap(historyWhiteSetMap);
            Map<Long, List<Map<String, Object>>> historyWhiteSetBillMap = this.getHistoryWhiteSetBillMap(historyWhiteSetMap);
            Map<Long, List<Map<String, Object>>> historyWhiteSetEntryMap = this.getHistoryWhiteSetEntry(historyWhiteSetMap);
            this.dealHistoryWhiteParam(historyWhiteSetMap, historyWhiteSetLangMap, historyWhiteSetBillMap, historyWhiteSetEntryMap);
            this.insertWhileList();
            stats.addInfo("whiteSet upgrade success.");
        } else {
            stats.addInfo("whiteSet has no data.");
        }
        stats.addInfo("end-whitelist-upgrade.");
        result.setLog(stats.toString());
        return result;
    }

    private void dealHistoryWhiteParam(Map<Long, Map<String, Object>> historyWhiteSetMap, Map<Long, List<Map<String, Object>>> historyWhiteSetLangMap, Map<Long, List<Map<String, Object>>> historyWhiteSetBillMap, Map<Long, List<Map<String, Object>>> historyWhiteSetEntryMap) {
        String tableNameL = "t_eb_whitelist_l";
        this.whiteSetPropertyList = new ArrayList<Object[]>(16);
        this.whiteSetLangPropertyList = new ArrayList<Object[]>(16);
        this.whiteSetBillPropertyList = new ArrayList<Object[]>(16);
        this.whiteSetEntryPropertyList = new ArrayList<Object[]>(16);
        for (Map.Entry<Long, Map<String, Object>> whiteSetEntry : historyWhiteSetMap.entrySet()) {
            List<Map<String, Object>> list;
            List<Map<String, Object>> whiteSetEntryList;
            Long whiteSetId = whiteSetEntry.getKey();
            long whiteListId = DBServiceHelper.genGlobalLongId();
            Map<String, Object> whiteSet = whiteSetEntry.getValue();
            Object[] objects = new Object[]{whiteListId, whiteSet.get("fnumber"), 0L, 0L, "1", whiteSet.get("fuseassistdata"), whiteSet.get("fcreatorid"), whiteSet.get("fcreatetime"), whiteSet.get("fmodifierid"), whiteSet.get("fmodifytime"), "2"};
            this.whiteSetPropertyList.add(objects);
            List<Map<String, Object>> whiteSetLangList = historyWhiteSetLangMap.get(whiteSetId);
            if (CollectionUtils.isNotEmpty(whiteSetLangList)) {
                for (Map<String, Object> map : whiteSetLangList) {
                    Object[] objectsLang = new Object[]{DBServiceHelper.genStringIds((String)tableNameL, (int)1)[0], whiteListId, map.get("flocaleid"), map.get("fname")};
                    this.whiteSetLangPropertyList.add(objectsLang);
                }
            }
            if (CollectionUtils.isNotEmpty(whiteSetEntryList = historyWhiteSetEntryMap.get(whiteSetId))) {
                for (Map<String, Object> whiteSetEntryMap : whiteSetEntryList) {
                    Object[] objectsEntry = new Object[]{whiteListId, DBServiceHelper.genGlobalLongId(), whiteSetEntryMap.get("fseq"), whiteSetEntryMap.get("fbiznumber"), whiteSetEntryMap.get("fbizname"), whiteSetEntryMap.get("fbizmemberid"), whiteSet.get("fbusinessbasedata"), whiteSet.get("fbusinessbasedataext"), whiteSetEntryMap.get("fbiznumberext"), whiteSetEntryMap.get("fbiznameext"), whiteSetEntryMap.get("fbizmemberiextid"), whiteSetEntryMap.get("fentrystatus")};
                    this.whiteSetEntryPropertyList.add(objectsEntry);
                }
            }
            if (!CollectionUtils.isNotEmpty(list = historyWhiteSetBillMap.get(whiteSetId))) continue;
            for (Map<String, Object> whiteSetBillMap : list) {
                Object[] objectsLang = new Object[]{DBServiceHelper.genGlobalLongId(), whiteListId, whiteSetBillMap.get("fbasedataid")};
                this.whiteSetBillPropertyList.add(objectsLang);
            }
        }
    }

    private Map<Long, List<Map<String, Object>>> getHistoryWhiteSetLangMap(Map<Long, Map<String, Object>> historyWhiteSetMap) {
        LinkedHashMap whiteSetLangMap = Maps.newLinkedHashMap();
        if (historyWhiteSetMap.isEmpty()) {
            return whiteSetLangMap;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fpkid, fid, flocaleid, fname from t_eb_dimmembermapping_l where ", new Object[0]);
        sqlBuilder.appendIn("fid", (Object[])historyWhiteSetMap.keySet().toArray(new Long[0]));
        try (DataSet ds = DB.queryDataSet((String)"queryWhiteSetEntry", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sqlBuilder);){
            if (ds != null) {
                for (Row row : ds) {
                    LinkedHashMap lang = Maps.newLinkedHashMap();
                    lang.put("flocaleid", row.getString("flocaleid"));
                    lang.put("fname", row.getString("fname"));
                    List langs = whiteSetLangMap.computeIfAbsent(row.getLong("fid"), f -> Lists.newLinkedList());
                    langs.add(lang);
                }
            }
        }
        return whiteSetLangMap;
    }

    private void insertWhileList() {
        this.insertRows("fid, fnumber, fmodelid, fbusmodelid, fstatus, fuseextbiz, fcreater, fcreatedate, fmodifier, fmodifydate, fnamelisttype", "t_eb_whitelist", this.whiteSetPropertyList);
        this.insertRows("fpkid, fid, flocaleid, fname", "t_eb_whitelist_l", this.whiteSetLangPropertyList);
        this.insertRows("fid, fentryid, fseq, fbiznumber, fbizname, fbizid, fbiztype, fextbiztype, fextbiznumber, fextbizname, fextbizid, fentrystatus", "t_eb_whiteentry", this.whiteSetEntryPropertyList);
        this.insertRows("fpkid, fid, fbasedataid", "t_eb_whitebill", this.whiteSetBillPropertyList);
    }

    private Map<Long, Map<String, Object>> getHistoryWhiteSetMap() {
        LinkedHashMap historyWhiteListMap = Maps.newLinkedHashMap();
        String sql = "select fid,fcreatorid,fmodifierid,fcreatetime,fmodifytime,fnumber,fuseassistdata,fbusinessbasedata,fbusinessbasedataext from t_eb_dimmembermapping where fisfreetype = '1'";
        try (DataSet ds = DB.queryDataSet((String)"queryWhiteSet", (DBRoute)BgBaseConstant.epm, (String)sql, null);){
            if (ds != null) {
                for (Row row : ds) {
                    Map historyWhite = historyWhiteListMap.computeIfAbsent(row.getLong("fid"), f -> Maps.newLinkedHashMap());
                    historyWhite.put("fcreatorid", row.getLong("fcreatorid"));
                    historyWhite.put("fmodifierid", row.getLong("fmodifierid"));
                    historyWhite.put("fcreatetime", row.getTimestamp("fcreatetime"));
                    historyWhite.put("fmodifytime", row.getTimestamp("fmodifytime"));
                    historyWhite.put("fnumber", row.getString("fnumber"));
                    historyWhite.put("fuseassistdata", row.getString("fuseassistdata"));
                    historyWhite.put("fbusinessbasedata", row.getString("fbusinessbasedata"));
                    historyWhite.put("fbusinessbasedataext", row.getString("fbusinessbasedataext"));
                }
            }
        }
        return historyWhiteListMap;
    }

    private Map<Long, List<Map<String, Object>>> getHistoryWhiteSetBillMap(Map<Long, Map<String, Object>> historyWhiteSetMap) {
        LinkedHashMap whiteSetBillMap = Maps.newLinkedHashMap();
        if (historyWhiteSetMap.isEmpty()) {
            return whiteSetBillMap;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fpkid, fid, fbasedataid from t_eb_whitebill where ", new Object[0]);
        sqlBuilder.appendIn("fid", (Object[])historyWhiteSetMap.keySet().toArray(new Long[0]));
        try (DataSet ds = DB.queryDataSet((String)"queryWhiteSetEntry", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sqlBuilder);){
            if (ds != null) {
                for (Row row : ds) {
                    LinkedHashMap bill = Maps.newLinkedHashMap();
                    bill.put("fbasedataid", row.getLong("fbasedataid"));
                    List bills = whiteSetBillMap.computeIfAbsent(row.getLong("fid"), f -> Lists.newLinkedList());
                    bills.add(bill);
                }
            }
        }
        return whiteSetBillMap;
    }

    private Map<Long, List<Map<String, Object>>> getHistoryWhiteSetEntry(Map<Long, Map<String, Object>> historyWhiteSetMap) {
        LinkedHashMap whiteSetEntryMap = Maps.newLinkedHashMap();
        if (historyWhiteSetMap.isEmpty()) {
            return whiteSetEntryMap;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid, fseq, fentryid, fbizmemberid, fbiznumber, fbizname, fbizmemberiextid, fbiznumberext, fbiznameext, fentrystatus from t_eb_membermapping where ", new Object[0]);
        sqlBuilder.appendIn("fid", (Object[])historyWhiteSetMap.keySet().toArray(new Long[0]));
        try (DataSet ds = DB.queryDataSet((String)"queryWhiteSetEntry", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sqlBuilder);){
            if (ds != null) {
                for (Row row : ds) {
                    LinkedHashMap entry = Maps.newLinkedHashMap();
                    entry.put("fseq", row.getLong("fseq"));
                    entry.put("fbizmemberid", row.getLong("fbizmemberid"));
                    entry.put("fbiznumber", row.getString("fbiznumber"));
                    entry.put("fbizname", row.getString("fbizname"));
                    entry.put("fbizmemberiextid", row.getLong("fbizmemberiextid"));
                    entry.put("fbiznumberext", row.getString("fbiznumberext"));
                    entry.put("fbiznameext", row.getString("fbiznameext"));
                    entry.put("fentrystatus", row.getString("fentrystatus"));
                    List entries = whiteSetEntryMap.computeIfAbsent(row.getLong("fid"), f -> Lists.newLinkedList());
                    entries.add(entry);
                }
            }
        }
        return whiteSetEntryMap;
    }

    private void insertRows(String fieldStr, String ebTableName, List<Object[]> paramsList) {
        StringBuilder sql = new StringBuilder();
        sql.append("insert into ").append(ebTableName).append("(").append(fieldStr).append(") values(");
        int length = fieldStr.split(",").length;
        for (int i = 0; i < length; ++i) {
            sql.append("?,");
        }
        sql.deleteCharAt(sql.length() - 1).append(")");
        if (paramsList != null && paramsList.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)sql.toString(), paramsList);
        }
    }
}

