/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.upgrade.epbs;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.StringJoiner;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.utils.SqlBatchUtils;
import org.apache.commons.collections4.CollectionUtils;

public class EpbsModelUpgradeServiceImpl
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        ArrayList<Object[]> params = new ArrayList<Object[]>(10);
        ArrayList<Object[]> multiLangParams = new ArrayList<Object[]>(10);
        HashSet reporttypes = Sets.newHashSet((Object[])new String[]{ApplicationTypeEnum.EB.getIndex(), ApplicationTypeEnum.BG.getIndex(), ApplicationTypeEnum.BGMD.getIndex()});
        String field = "fid,fnumber,fshownumber,fname,fdescription,fcreatorid,fcreatetime,fmodifierid,fmodifytime,fstatus,fenable,freporttype,fdatasource";
        DataSet dataSet = DB.queryDataSet((String)(this.getClass().getSimpleName() + ".upgrade"), (DBRoute)BgBaseConstant.epm, (String)String.format("select %s from t_eb_model", field));
        ArrayList<Long> pkIds = new ArrayList<Long>(10);
        String[] fieldArr = field.split(",");
        Boolean hasAppNums = SqlBatchUtils.hasColumn((String)"t_epbs_model", (String)"fappnums");
        while (dataSet.hasNext()) {
            Row next = dataSet.next();
            String freporttype = next.getString("freporttype");
            if (!reporttypes.contains(freporttype)) continue;
            ArrayList<Object> list1 = new ArrayList<Object>(10);
            for (String f : fieldArr) {
                if (Objects.equals("freporttype", f)) continue;
                String[] value = next.get(f);
                list1.add(value);
            }
            String appNum = ApplicationTypeEnum.getEnumByIndex((String)freporttype).name().toLowerCase(Locale.ROOT);
            list1.add(appNum);
            if (hasAppNums.booleanValue()) {
                list1.add("," + appNum + ",");
            }
            params.add(list1.toArray());
            pkIds.add(next.getLong("fid"));
        }
        dataSet.close();
        String multiLangField = "fpkid,fid,flocaleid,fname,fdescription";
        dataSet = DB.queryDataSet((String)(this.getClass().getSimpleName() + ".upgrade"), (DBRoute)BgBaseConstant.epm, (String)String.format("select %s from t_eb_model_l", multiLangField));
        int multiLangCount = dataSet.copy().count("fpkid", false);
        String[] pkId = DB.genStringIds((String)"t_epbs_model_l", (int)multiLangCount);
        int index = 0;
        String[] multiLangFieldArr = multiLangField.split(",");
        while (dataSet.hasNext()) {
            Row next = dataSet.next();
            ArrayList<Object> list1 = new ArrayList<Object>(10);
            list1.add(pkId[index]);
            for (String f : multiLangFieldArr) {
                if (Objects.equals("fpkid", f)) continue;
                Object value = next.get(f);
                list1.add(value);
            }
            multiLangParams.add(list1.toArray());
            ++index;
        }
        dataSet.close();
        String deleteSql = String.format("delete from t_epbs_model where fid in (%s)", EpbsModelUpgradeServiceImpl.placeHolder(pkIds.size()));
        String epbsField = "fid,fnumber,fshownumber,fname,fdescription,fcreatorid,fcreatetime,fmodifierid,fmodifytime,fstatus,fenable,fdatasource,fappnum";
        if (hasAppNums.booleanValue()) {
            epbsField = epbsField + ",fappnums";
        }
        String sql = String.format("insert into t_epbs_model (%s) values (%s)", epbsField, EpbsModelUpgradeServiceImpl.placeHolder(epbsField.split(",").length));
        String deletemultiLangSql = String.format("delete from t_epbs_model_l where fid in (%s)", EpbsModelUpgradeServiceImpl.placeHolder(pkIds.size()));
        String multiLangSql = String.format("insert into t_epbs_model_l (%s) values (%s)", multiLangField, EpbsModelUpgradeServiceImpl.placeHolder(multiLangField.split(",").length));
        UpgradeResult result = new UpgradeResult();
        if (CollectionUtils.isEmpty(pkIds)) {
            result.setSuccess(true);
            return result;
        }
        try (TXHandle tx = TX.requiresNew((String)this.getClass().getSimpleName());){
            try {
                DB.execute((DBRoute)BgBaseConstant.epm, (String)deleteSql, (Object[])pkIds.toArray());
                DB.execute((DBRoute)BgBaseConstant.epm, (String)deletemultiLangSql, (Object[])pkIds.toArray());
                DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)sql, params);
                DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)multiLangSql, multiLangParams);
                result.setSuccess(true);
            }
            catch (Exception e) {
                result.setSuccess(false);
                StackTraceElement[] arr = e.getStackTrace();
                StringBuilder sb = new StringBuilder();
                for (StackTraceElement ele : arr) {
                    sb.append(ele.toString()).append("\r\n");
                }
                result.setLog(e.getMessage());
                result.setErrorInfo(sb.toString());
                tx.markRollback();
            }
        }
        return result;
    }

    public static String placeHolder(int size) {
        StringJoiner stringJoiner = new StringJoiner(",");
        for (int i = 0; i < size; ++i) {
            stringJoiner.add("?");
        }
        return stringJoiner.toString();
    }
}

