/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.upgrade.epbs;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.formplugin.SavePlugin;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.trace.util.TraceIdUtil;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.ebcommon.common.log.BcmLogFactory;
import kd.epm.eb.common.ebcommon.common.log.WatchLogger;
import kd.epm.eb.common.ebcommon.common.util.ThrowableHelper;
import kd.epm.eb.service.upgrade.epbs.EbOlapTraceLogUpgradeTask;
import kd.epm.epbs.common.enums.AppTypeEnum;
import kd.epm.epbs.common.util.ScheduleUtil;

public class EpbsOlapTraceLogUpgradeServiceImpl
implements IUpgradeService {
    private static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, EpbsOlapTraceLogUpgradeServiceImpl.class);
    private static String STARTTIME = "starttime";
    private static String ENDTIME = "endtime";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        EpbsOlapTraceLogUpgradeServiceImpl.createSchedule();
        return new UpgradeResult();
    }

    public void upgradeOlapTraceLog(Map<String, Object> map) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date startTime = null;
        Date endTime = null;
        Calendar now = Calendar.getInstance();
        try {
            if (!map.containsKey(STARTTIME)) {
                endTime = now.getTime();
                now.add(2, -2);
                startTime = now.getTime();
            } else {
                startTime = format.parse((String)map.get(STARTTIME));
                endTime = format.parse((String)map.get(ENDTIME));
            }
            while (startTime.getTime() < endTime.getTime()) {
                now = Calendar.getInstance();
                now.setTime(startTime);
                now.add(2, 1);
                Date currentEndTime = now.getTime();
                if (currentEndTime.getTime() > endTime.getTime()) {
                    currentEndTime = endTime;
                }
                this.upgradeOlapTraceLog(format.format(startTime), format.format(currentEndTime));
                startTime = currentEndTime;
                this.updateStartTime(startTime, endTime, map, format);
            }
            this.updateStartTime(startTime, endTime, map, format);
        }
        catch (Exception e) {
            try {
                throw new KDBizException("upgradeOlapTraceLog error: " + ThrowableHelper.toString((Exception)e));
            }
            catch (Throwable throwable) {
                this.updateStartTime(startTime, endTime, map, format);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeOlapTraceLog(String startTime, String endTime) {
        ArrayList paramsPre = new ArrayList(16);
        ArrayList<Object[]> params = new ArrayList<Object[]>(16);
        ArrayList<Long> pkIds = new ArrayList<Long>(16);
        HashSet<Long> userIds = new HashSet<Long>(16);
        int pageSize = 5000;
        int pageIndex = 0;
        int count = pageSize;
        String field = "fid,foperation,fdescription,fcreatetime,ftraceid,fcreatorid,fentitynumber";
        String field_epbs = "fid,fopname,fopdesc,fopdate,ftraceid,funiqueid,fuserid,foptarget,fusername";
        DataSet dataSet = null;
        try {
            while (count == pageSize) {
                Object list1;
                paramsPre.clear();
                params.clear();
                pkIds.clear();
                userIds.clear();
                log.startWatch();
                count = 0;
                String where = String.format(" fcreatetime > '%s' and fcreatetime <= '%s'", startTime, endTime);
                String top = "TOP " + pageSize + "," + pageIndex;
                String selectSql = String.format("select %s %s from t_eb_operationlog where %s order by fid", top, field, where);
                dataSet = this.getDataSet(selectSql);
                log.infoEnd("t_eb_operationlog select " + top + where);
                String[] fieldArr = field.split(",");
                while (dataSet.hasNext()) {
                    ++count;
                    Row next = dataSet.next();
                    list1 = new ArrayList(16);
                    for (String f : fieldArr) {
                        Object value = next.get(f);
                        list1.add(value);
                        if ("ftraceid".equals(f)) {
                            list1.add(TraceIdUtil.hexToId((String)((String)value)));
                        }
                        if (!"fcreatorid".equals(f)) continue;
                        userIds.add((Long)value);
                    }
                    paramsPre.add(list1);
                    pkIds.add(next.getLong("fid"));
                }
                dataSet.close();
                Map<Long, String> userNameMap = QueryServiceHelper.query((String)"bos_user", (String)"id,name", (QFilter[])new QFilter("id", "in", userIds).toArray()).stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e.getString("name")));
                list1 = paramsPre.iterator();
                while (list1.hasNext()) {
                    List list;
                    String username = userNameMap.get((list = (List)list1.next()).get(6));
                    list.add(null != username ? username : "");
                    params.add(list.toArray());
                }
                if (count > 0) {
                    log.startWatch();
                    String deleteSql = String.format("delete from t_epbs_traceoplog where fid in (%s)", EpbsOlapTraceLogUpgradeServiceImpl.placeHolder(pkIds.size()));
                    this.execute(pkIds, deleteSql);
                    String insertSql = String.format("insert into t_epbs_traceoplog (%s) values (%s)", field_epbs, EpbsOlapTraceLogUpgradeServiceImpl.placeHolder(field_epbs.split(",").length));
                    this.executeBatch(params, insertSql);
                    log.infoEnd("t_epbs_traceoplog del and insert " + top + where);
                }
                pageIndex += pageSize;
            }
        }
        finally {
            if (null != dataSet) {
                dataSet.close();
            }
            paramsPre.clear();
            params.clear();
            pkIds.clear();
            userIds.clear();
        }
    }

    private void executeBatch(List<Object[]> params, String insertSql) {
        DB.executeBatch((DBRoute)DBRoute.log, (String)insertSql, params);
    }

    private void execute(List<Long> pkIds, String deleteSql) {
        DB.execute((DBRoute)DBRoute.log, (String)deleteSql, (Object[])pkIds.toArray());
    }

    private DataSet getDataSet(String selectSql) {
        return DB.queryDataSet((String)(this.getClass().getSimpleName() + ".upgrade"), (DBRoute)BgBaseConstant.epm, (String)selectSql);
    }

    private void updateStartTime(Date startTime, Date endTime, Map<String, Object> map, SimpleDateFormat format) {
        if (null != startTime) {
            map.put(STARTTIME, format.format(startTime));
            map.put(ENDTIME, format.format(endTime));
            ScheduleUtil.updateJobParams((String)((String)map.get("job")), map);
        }
    }

    public static String createSchedule() {
        AppTypeEnum appTypeEnum = AppTypeEnum.BGM;
        String scheduleNumber = EpbsOlapTraceLogUpgradeServiceImpl.numberFormat(appTypeEnum.getAppNum(), true);
        DynamicObject scheduleDyn = ScheduleUtil.getScheduleDyn((String)scheduleNumber);
        if (null != scheduleDyn) {
            return (String)scheduleDyn.getPkValue();
        }
        String scheduleName = ResManager.loadKDString((String)"\u9884\u7b97\u591a\u7ef4\u8ffd\u6eaf\u65e5\u5fd7\u5386\u53f2\u6570\u636e\u5347\u7ea7\u8ba1\u5212", (String)"", (String)"epm-eb-mservice", (Object[])new Object[0]);
        Calendar expireTime = Calendar.getInstance();
        expireTime.add(1, 1);
        Calendar planTime = Calendar.getInstance();
        planTime.add(12, 2);
        HashMap<String, String> paramMap = new HashMap<String, String>(4);
        String jobName = ResManager.loadKDString((String)"\u9884\u7b97\u591a\u7ef4\u8ffd\u6eaf\u65e5\u5fd7\u5386\u53f2\u6570\u636e\u5347\u7ea7\u4f5c\u4e1a", (String)"", (String)"epm-eb-mservice", (Object[])new Object[0]);
        String jobNumber = EpbsOlapTraceLogUpgradeServiceImpl.numberFormat(appTypeEnum.getAppNum(), false);
        String className = EbOlapTraceLogUpgradeTask.class.getName();
        ScheduleUtil.createTaskDefine((String)EbOlapTraceLogUpgradeTask.class.getSimpleName(), (String)className, (String)appTypeEnum.getAppId());
        ScheduleUtil.ScheduleModel scheduleModel = new ScheduleUtil.ScheduleModel();
        scheduleModel.setAppId(appTypeEnum.getAppId());
        scheduleModel.setScheduleNumber(scheduleNumber);
        scheduleModel.setScheduleName(scheduleName);
        scheduleModel.setJobNumber(jobNumber);
        scheduleModel.setJobName(jobName);
        scheduleModel.setClassName(className);
        scheduleModel.setExpireTime(expireTime.getTime());
        scheduleModel.setPlanTime(planTime.getTime());
        scheduleModel.setParamMap(paramMap);
        scheduleModel.setTxthost(SavePlugin.getHostIpAddress());
        String scheduleId = ScheduleUtil.createSchedule((ScheduleUtil.ScheduleModel)scheduleModel);
        paramMap.put("job", scheduleModel.getJobId());
        ScheduleUtil.updateJobParams((String)scheduleModel.getJobId(), paramMap);
        return scheduleId;
    }

    private static String numberFormat(String appnum, boolean isSchedule) {
        String number = String.format("%s_%s", appnum, "EpbsOlapTraceLogUpgrade");
        return ScheduleUtil.numberFormat((String)number, (boolean)isSchedule);
    }

    public static String placeHolder(int size) {
        StringJoiner stringJoiner = new StringJoiner(",");
        for (int i = 0; i < size; ++i) {
            stringJoiner.add("?");
        }
        return stringJoiner.toString();
    }
}

