/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.variable;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.ModelUtils;
import kd.epm.eb.common.utils.UserUtils;

public class VariableMemberUpgradeServiceImpl
implements IUpgradeService {
    private static final Log log = LogFactory.getLog(VariableMemberUpgradeServiceImpl.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        HashMap<String, String> ruleInfo;
        HashMap<Long, Map<Long, Map<String, List<String>>>> modelAndPeriodMap;
        Throwable throwable;
        TXHandle tx;
        UpgradeResult result;
        block20: {
            UpgradeResult upgradeResult;
            block21: {
                block22: {
                    result = new UpgradeResult();
                    if (!this.isNeedUpdateVar()) {
                        result.setSuccess(Boolean.FALSE.booleanValue());
                        result.setErrorInfo("hasUpdated");
                        return result;
                    }
                    tx = TX.requiresNew((String)"entityCurrencyUpdate");
                    throwable = null;
                    modelAndPeriodMap = new HashMap<Long, Map<Long, Map<String, List<String>>>>(16);
                    ruleInfo = new HashMap<String, String>(16);
                    this.getPeriodIdInRule(modelAndPeriodMap, ruleInfo);
                    if (modelAndPeriodMap.size() != 0) break block20;
                    result.setSuccess(Boolean.FALSE.booleanValue());
                    upgradeResult = result;
                    if (tx == null) break block21;
                    if (throwable == null) break block22;
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block21;
                }
                tx.close();
            }
            return upgradeResult;
        }
        try {
            try {
                this.clearUseLessData(modelAndPeriodMap);
                for (Map.Entry entry : modelAndPeriodMap.entrySet()) {
                    Long modelId = (Long)entry.getKey();
                    Long periodDimId = this.queryPeriod(modelId);
                    if (periodDimId == 0L) continue;
                    this.batchSave(modelId, periodDimId, (Map)entry.getValue());
                    this.updateQuote(modelId, (Map)entry.getValue(), ruleInfo);
                }
            }
            catch (Exception e) {
                tx.markRollback();
                result.setSuccess(Boolean.FALSE.booleanValue());
                StackTraceElement[] arr = e.getStackTrace();
                StringBuilder sb = new StringBuilder(e.getMessage());
                sb.append(";");
                for (StackTraceElement ele : arr) {
                    sb.append(ele.toString()).append("\r\n");
                }
                result.setLog(sb.toString());
                result.setErrorInfo(sb.toString());
                result.setEl(sb.toString());
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        catch (Throwable throwable4) {
            throw throwable4;
        }
        finally {
            if (tx != null) {
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    tx.close();
                }
            }
        }
        return result;
    }

    private boolean isNeedUpdateVar() {
        String sql = "select fid from t_eb_periodvariable where fnumber not like '@%' and fdimensionid = 0 and fmodelid = 0";
        DataSet dataSet = DB.queryDataSet((String)"VariableMemberUpgradeServiceImpl.queryRulePeriod", (DBRoute)DBRoute.of((String)"epm"), (String)sql);
        return dataSet != null && !dataSet.isEmpty() && dataSet.hasNext();
    }

    private void getPeriodIdInRule(Map<Long, Map<Long, Map<String, List<String>>>> map, Map<String, String> ruleInfo) {
        HashMap modelRuleNameMap = new HashMap(16);
        Set<Long> varIds = this.getAllVars();
        String sql = "select fperiodoffset, fmodel, fid, fnumber, fname, fcreater from t_eb_bizruleset where fperiodoffset != ' '";
        DataSet dataSet = DB.queryDataSet((String)"VariableMemberUpgradeServiceImpl.queryRulePeriod", (DBRoute)DBRoute.of((String)"epm"), (String)sql);
        if (dataSet != null && !dataSet.isEmpty()) {
            Row row = null;
            while (dataSet.hasNext()) {
                ArrayList<String> ruleName;
                row = dataSet.next();
                String periodJson = row.getString("fperiodoffset");
                Long modelId = row.getLong("fmodel");
                Long id = row.getLong("fid");
                Long creator = row.getLong("fcreater");
                String name = row.getString("fname");
                String number = row.getString("fnumber");
                Map<Long, Map<String, List<String>>> periodIdMap = map.get(modelId);
                if (periodIdMap == null) {
                    periodIdMap = new HashMap<Long, Map<String, List<String>>>(16);
                }
                if ((ruleName = (ArrayList<String>)modelRuleNameMap.get(modelId)) == null) {
                    ruleName = new ArrayList<String>(16);
                }
                Map periodMap = (Map)SerializationUtils.fromJsonString((String)periodJson, Map.class);
                for (Map.Entry periodEntry : periodMap.entrySet()) {
                    List<String> keyList;
                    long ruleKey = (Long)periodEntry.getValue();
                    if (!varIds.contains(ruleKey)) continue;
                    Map<String, List<String>> keyMap = periodIdMap.get(ruleKey);
                    if (keyMap == null) {
                        keyMap = new HashMap<String, List<String>>(16);
                    }
                    if ((keyList = keyMap.get(id.toString())) == null) {
                        keyList = new ArrayList<String>(16);
                    }
                    keyList.add((String)periodEntry.getKey());
                    keyMap.put(id.toString(), keyList);
                    keyMap.put("userId", Collections.singletonList(String.valueOf(creator)));
                    periodIdMap.put(ruleKey, keyMap);
                }
                if (periodIdMap.size() == 0) continue;
                map.put(modelId, periodIdMap);
                ruleName.add(name);
                modelRuleNameMap.put(modelId, ruleName);
                ruleInfo.put(id.toString(), number);
            }
        }
        if (modelRuleNameMap.size() != 0) {
            log.info("VariableMemberUpgradeServiceImpl.updateRuleLog: " + ((Object)modelRuleNameMap).toString());
        }
    }

    private void batchSave(Long modelId, Long periodDimId, Map<Long, Map<String, List<String>>> value) {
        ArrayList<Object[]> updateRuleList = new ArrayList<Object[]>(16);
        ArrayList<Object[]> updateVariables = new ArrayList<Object[]>(16);
        ArrayList<Object[]> insertVariables = new ArrayList<Object[]>(16);
        ArrayList<Object[]> saveMultiLanList = new ArrayList<Object[]>(16);
        ArrayList<Object[]> insertVarDimension = new ArrayList<Object[]>(16);
        String creator = null;
        String sql = StringUtils.join((Object[])new String[]{"select fid, fnumber, fname, foffset, fdescription, fcreatetime, fmodifytime, fmodelid from t_eb_periodvariable where fid in ", value.keySet().stream().map(e -> e + "").collect(Collectors.joining(",", "(", ")"))});
        DataSet dataSet = DB.queryDataSet((String)"VariableMemberUpgradeServiceImpl.queryVar", (DBRoute)DBRoute.of((String)"epm"), (String)sql);
        if (dataSet != null && !dataSet.isEmpty()) {
            Row row = null;
            while (dataSet.hasNext()) {
                String number;
                row = dataSet.next();
                long id = row.getLong("fid");
                String name = row.getString("fname");
                long model = row.getLong("fmodelid");
                String tempNum = row.getString("fnumber");
                if (value.get(id).size() == 0) continue;
                creator = value.get(id).get("userId").get(0);
                String string = number = tempNum.startsWith("@") ? tempNum : StringUtils.join((Object[])new String[]{"@", tempNum});
                if (model == 0L) {
                    updateVariables.add(new Object[]{modelId, periodDimId, number, id});
                } else {
                    if (model == modelId) continue;
                    long id_new = GlobalIdUtil.genGlobalLongId();
                    this.getInsertVariables(id_new, row, insertVariables, modelId, periodDimId, number, creator);
                    this.getUpdateRules(id, id_new, value, updateRuleList);
                    id = id_new;
                }
                this.getVarSaveMultiLanguage(id, name, saveMultiLanList);
                this.getInsertVarDimension(modelId, periodDimId, row, insertVarDimension, creator);
            }
        }
        if (insertVarDimension.size() != 0) {
            DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)"insert into t_eb_dimensionvariable(fid,fnumber,fdseq,fmodelid,fdimensionid,fbillstatus,fcreater,fcreatedate,fmodifier,fmodifydate) values(?,?,?,?,?,?,?,?,?,?)", (Object[])((Object[])insertVarDimension.get(0)));
            log.info("VariableMemberUpgradeServiceImpl.insertDimension: " + Arrays.toString((Object[])insertVarDimension.get(0)) + "\n");
        }
        if (insertVariables.size() != 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)"insert into t_eb_periodvariable(fid,fnumber,foffset,fdescription,fcreatetime,fmodifytime,fcreater,fmodifier,fmodelid,fdimensionid) values(?,?,?,?,?,?,?,?,?,?)", insertVariables);
            log.info("VariableMemberUpgradeServiceImpl.insertVariable: " + ((Object)insertVariables).toString() + "\n");
        }
        if (updateVariables.size() != 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)"update t_eb_periodvariable set fmodelid=?,fdimensionid=?,fnumber=? where fid=?", updateVariables);
            log.info("VariableMemberUpgradeServiceImpl.updateVariable: " + ((Object)updateVariables).toString() + "\n");
        }
        if (saveMultiLanList.size() != 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)"insert into t_eb_periodvariable_l(fpkid, fid, flocaleid, fname) values(?,?,?,?)", saveMultiLanList);
            log.info("VariableMemberUpgradeServiceImpl.saveMultiLanguage: " + ((Object)saveMultiLanList).toString() + "\n");
        }
        if (updateRuleList.size() != 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)"update t_eb_bizruleset set fperiodoffset=? where fid =?", updateRuleList);
            log.info("VariableMemberUpgradeServiceImpl.updateRule: " + updateRuleList);
        }
    }

    private void getInsertVarDimension(Long modelId, Long periodDimId, Row row, List<Object[]> insertVarDimension, String creator) {
        if (insertVarDimension == null || insertVarDimension.size() != 0 || this.checkDimensionExist(periodDimId)) {
            return;
        }
        Object[] insertObjects = new Object[]{DB.genGlobalLongId(), SysDimensionEnum.BudgetPeriod.getNumber(), 1, modelId, periodDimId, "A", Long.parseLong(creator), row.getDate("fcreatetime"), Long.parseLong(creator), row.getDate("fmodifytime")};
        insertVarDimension.add(insertObjects);
    }

    private boolean checkDimensionExist(Long periodDimId) {
        String sql = "select fid from t_eb_dimensionvariable where fdimensionid=" + periodDimId;
        DataSet dataSet = DB.queryDataSet((String)"VariableMemberUpgradeServiceImpl.checkDimensionExsit", (DBRoute)DBRoute.of((String)"epm"), (String)sql);
        return dataSet != null && !dataSet.isEmpty() && dataSet.hasNext();
    }

    private void getInsertVariables(long id_new, Row row, List<Object[]> insertVariables, Long modelId, Long dimId, String number, String creator) {
        Object[] insertObjects = new Object[]{id_new, number, row.getLong("foffset"), row.getString("fdescription"), row.getDate("fcreatetime"), row.getDate("fmodifytime"), Long.parseLong(creator), Long.parseLong(creator), modelId, dimId};
        insertVariables.add(insertObjects);
    }

    private void getUpdateRules(Long periodId, Long periodId_new, Map<Long, Map<String, List<String>>> value, List<Object[]> updateRuleList) {
        Map<String, List<String>> valueMap = value.get(periodId);
        String periodStr_new = null;
        String sql = "select fid, fperiodoffset from t_eb_bizruleset where fid in (";
        for (String key : valueMap.keySet()) {
            if ("userId".equals(key)) continue;
            sql = StringUtils.join((Object[])new String[]{sql, key, ","});
        }
        sql = StringUtils.join((Object[])new String[]{sql.substring(0, sql.length() - 1), ")"});
        DataSet dataSet = DB.queryDataSet((String)"VariableMemberUpgradeServiceImpl.queryRule", (DBRoute)DBRoute.of((String)"epm"), (String)sql);
        if (dataSet != null && !dataSet.isEmpty()) {
            Row row = null;
            while (dataSet.hasNext()) {
                row = dataSet.next();
                Long ruleId = row.getLong("fid");
                List<String> periodKey = valueMap.get(ruleId.toString());
                String periodStr = row.getString("fperiodoffset");
                Map periodMap = (Map)SerializationUtils.fromJsonString((String)periodStr, Map.class);
                for (Map.Entry entry : periodMap.entrySet()) {
                    String key = (String)entry.getKey();
                    if (!periodKey.contains(key)) continue;
                    entry.setValue(periodId_new);
                }
                periodStr_new = SerializationUtils.toJsonString((Object)periodMap);
                if (periodId_new == null) continue;
                Object[] ruleInfo = new Object[]{periodStr_new, ruleId};
                updateRuleList.add(ruleInfo);
            }
        }
    }

    private void getVarSaveMultiLanguage(Long id, String name, List<Object[]> saveMultiLanList) {
        if (this.checkExist(id)) {
            return;
        }
        Object[] multiInfo = new Object[]{GlobalIdUtil.genStringId(), id, "zh_CN", name};
        saveMultiLanList.add(multiInfo);
        multiInfo = new Object[]{GlobalIdUtil.genStringId(), id, "zh_TW", name};
        saveMultiLanList.add(multiInfo);
    }

    private boolean checkExist(Long id) {
        String sql = "select fid from t_eb_periodvariable_l where fid = " + id;
        DataSet dataSet = DB.queryDataSet((String)"VariableMemberUpgradeServiceImpl.checkExist", (DBRoute)DBRoute.of((String)"epm"), (String)sql);
        return dataSet != null && !dataSet.isEmpty() && dataSet.hasNext();
    }

    private Long queryPeriod(Long modelId) {
        String sql = "select fid from t_eb_dimension where fmodelid = " + modelId + " and fnumber = 'BudgetPeriod'";
        DataSet dataSet = DB.queryDataSet((String)"VariableMemberUpgradeServiceImpl.queryDimension", (DBRoute)DBRoute.of((String)"epm"), (String)sql);
        if (dataSet != null && !dataSet.isEmpty() && dataSet.hasNext()) {
            return dataSet.next().getLong("fid");
        }
        return 0L;
    }

    private void clearUseLessData(Map<Long, Map<Long, Map<String, List<String>>>> modelAndPeriodMap) {
        HashSet periods = new HashSet(16);
        modelAndPeriodMap.forEach((key, periodMap) -> periods.addAll(periodMap.keySet()));
        String sql = "delete from t_eb_periodvariable where fdimensionid = 0 and fid not in " + periods.stream().map(e -> e + "").collect(Collectors.joining(",", "(", ")"));
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)sql);
    }

    private void updateQuote(Long modelId, Map<Long, Map<String, List<String>>> periodMap, Map<String, String> ruleInfo) {
        List ruleList;
        ArrayList<Object[]> quotes = new ArrayList<Object[]>(16);
        HashMap periodInfoMap = new HashMap(16);
        String modelNumber = ModelUtils.getBizModel((Long)modelId).getNumber();
        long userId = UserUtils.getUserId();
        Timestamp timestamp = new Timestamp(TimeServiceHelper.now().getTime());
        for (Map.Entry<Long, Map<String, List<String>>> entry : periodMap.entrySet()) {
            Map<String, List<String>> rules = entry.getValue();
            ruleList = new ArrayList(16);
            rules.forEach((key, value) -> ruleList.add(key));
            periodInfoMap.put(entry.getKey(), ruleList);
        }
        Map<Long, String> periodNumberMap = this.getPeriodNumber(periodInfoMap.keySet());
        if (periodNumberMap == null || periodNumberMap.size() == 0) {
            return;
        }
        for (Map.Entry period : periodInfoMap.entrySet()) {
            ruleList = (List)period.getValue();
            for (String ruleId : ruleList) {
                String periodVar = periodNumberMap.get(period.getKey());
                String ruleNumber = ruleInfo.get(ruleId);
                String periodNumber = SysDimensionEnum.BudgetPeriod.getNumber();
                if (periodVar == null || ruleNumber == null || this.checkQuote(modelNumber, periodNumber, periodVar, ruleNumber)) continue;
                quotes.add(new Object[]{GlobalIdUtil.genGlobalLongId(), timestamp, userId, modelNumber, periodNumber, periodVar, ruleNumber});
            }
        }
        if (quotes.size() != 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)"insert into t_eb_member_quote(fid,fresource,fcreatedate,fcreatorid,fmodelnumber,fdimensionnumber,fmembernumber,fquotenumber) values(?,'02',?,?,?,?,?,?)", quotes);
            log.info("VariableMemberUpgradeServiceImpl.updateQuote: " + ((Object)quotes).toString());
        }
    }

    private boolean checkQuote(String modelNumber, String periodNumber, String periodVar, String ruleNumber) {
        String sql = "select fid from t_eb_member_quote where fmodelnumber = '" + modelNumber + "' and fdimensionnumber = '" + periodNumber + "' and fmembernumber = '" + periodVar + "' and fquotenumber = '" + ruleNumber + "'";
        DataSet dataSet = DB.queryDataSet((String)"VariableMemberUpgradeServiceImpl.queryQuote", (DBRoute)DBRoute.of((String)"epm"), (String)sql);
        return dataSet != null && !dataSet.isEmpty() && dataSet.hasNext();
    }

    private Map<Long, String> getPeriodNumber(Set<Long> periodInfoMap) {
        String sql = "select fid, fnumber from t_eb_periodvariable where fid in " + periodInfoMap.stream().map(e -> e + "").collect(Collectors.joining(",", "(", ")"));
        DataSet dataSet = DB.queryDataSet((String)"VariableMemberUpgradeServiceImpl.queryPeriod", (DBRoute)DBRoute.of((String)"epm"), (String)sql);
        if (dataSet != null && !dataSet.isEmpty()) {
            Row row = null;
            HashMap<Long, String> map = new HashMap<Long, String>(16);
            while (dataSet.hasNext()) {
                row = dataSet.next();
                map.put(row.getLong("fid"), row.getString("fnumber"));
            }
            return map;
        }
        return null;
    }

    private Set<Long> getAllVars() {
        HashSet<Long> varIds = new HashSet<Long>(16);
        DataSet varInfo = DB.queryDataSet((String)"VariableMemberUpgradeServiceImpl.queryAllVars", (DBRoute)DBRoute.of((String)"epm"), (String)"select fid from t_eb_periodvariable");
        if (varInfo != null && !varInfo.isEmpty()) {
            Row row = null;
            while (varInfo.hasNext()) {
                row = varInfo.next();
                varIds.add(row.getLong("fid"));
            }
        }
        return varIds;
    }
}

