/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.versioncopy;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.ComputingCommandInfo;
import kd.bos.olap.dataSources.FelLambdaExpressionItem;
import kd.bos.olap.dataSources.OlapCommand;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.bgmddatalock.BgmdDataLockService;
import kd.epm.eb.common.bgmddatalock.IBgmdDataLockCache;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.enums.CopyDataEnum;
import kd.epm.eb.common.enums.FacTabFieldDefEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SchemeTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.openapi.entity.EBApiResult;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.util.ShrekIdCodeUtils;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.CommonUtils;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.MetricUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.threadpool.EBThreadPoolExecutor;
import kd.epm.eb.common.versioncopy.VersionCopyConditionDto;
import kd.epm.eb.formplugin.versioncopy.VersionCopyApiUtils;
import kd.epm.eb.formplugin.versioncopy.VersionCopySchemeExecuteEntity;
import kd.epm.eb.service.versioncopy.VersionCopyApiService;
import kd.epm.eb.service.versioncopy.VersionCopyExecuteRequestEntry;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class VersionCopyApiServiceImpl
implements VersionCopyApiService {
    private static final Log log = LogFactory.getLog(VersionCopyApiServiceImpl.class);
    private static final int HEART_RATE = 1200;
    private static final int ORG_MEMBERNUM = 10;
    private static final int ACCOUNT_MEMBERNUM = 50;
    private Map<Long, Double> processMap = new HashMap<Long, Double>(16);
    private static ExecutorService es = new EBThreadPoolExecutor(1, 2, 5L, TimeUnit.MINUTES, new LinkedBlockingQueue());
    private static final List<String> DEFAULT_FILTER_DIM = Arrays.asList(SysDimensionEnum.Entity.getNumber(), SysDimensionEnum.Account.getNumber(), SysDimensionEnum.DataType.getNumber(), SysDimensionEnum.BudgetPeriod.getNumber(), SysDimensionEnum.Version.getNumber(), SysDimensionEnum.AuditTrail.getNumber());

    @Override
    public ApiResult getVersionExecuteProgressV1(Map<String, Object> params) {
        return this.getVersionExecuteProgress((String)params.getOrDefault("modelNumber", ""), (String)params.getOrDefault("recordId", ""));
    }

    @Override
    public ApiResult getVersionExecuteProgress(String modelNumber, String recordId) {
        log.info("getVersionExecuteProgress params-> model{} , recordId:{}", (Object)modelNumber, (Object)recordId);
        if (StringUtils.isEmpty((String)modelNumber)) {
            return EBApiResult.fail((String)ResManager.loadKDString((String)"\u4f20\u5165\u7684\u4f53\u7cfb\u7f16\u7801\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u3002", (String)"VersionCopyApiServiceImpl_0", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)recordId)) {
            return EBApiResult.fail((String)ResManager.loadKDString((String)"\u4f20\u5165\u7684\u8bb0\u5f55id\u4e3a\u7a7a,\u8bf7\u68c0\u67e5", (String)"VersionCopyApiServiceImpl_10", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        BizModel model = CommonUtils.getModel((String)modelNumber);
        Long modelId = model.getId();
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and(new QFilter("id", "=", (Object)IDUtils.toLong((Object)recordId)));
        DynamicObject record = BusinessDataServiceHelper.loadSingle((String)"eb_versioncopyrecord", (String)"status,msg", (QFilter[])qFilter.toArray());
        if (record == null) {
            return EBApiResult.fail((String)ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u8bb0\u5f55\u3002", (String)"VersionCopyApiServiceImpl_11", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        String status = record.getString("status");
        HashMap<String, Object> resultMap = new HashMap<String, Object>(3);
        String message = CopyDataEnum.SUCCESS.getName();
        Integer progress = 0;
        if (CopyDataEnum.SUCCESS.getIndex().equals(status)) {
            progress = 100;
            resultMap.put("progress", progress);
        } else if (CopyDataEnum.FAILED.getIndex().equals(status)) {
            message = record.getString("msg");
        } else if (CopyDataEnum.CANCEL.getIndex().equals(status)) {
            message = record.getString("msg");
        } else if (CopyDataEnum.EXECUTING.getIndex().equals(status)) {
            message = CopyDataEnum.EXECUTING.getName();
            String msg = record.getString("msg");
            if (msg.endsWith("%")) {
                String s = msg.replaceAll("%", "");
                try {
                    Double aDouble = Double.valueOf(s);
                    progress = aDouble.intValue();
                }
                catch (Exception e) {
                    log.error("\u6570\u636e\u8f6c\u6362\u9519\u8bef\uff1a", (Throwable)e);
                }
                resultMap.put("progress", progress);
            }
        }
        resultMap.put("msg", message);
        resultMap.put("status", status);
        return EBApiResult.success(resultMap);
    }

    @Override
    public ApiResult copyExecuteV1(Map<String, Object> params) {
        log.info("copyExecuteParams:{}", params);
        ApiResult apiResult = this.checkReqeustEntry(params);
        if (apiResult != null) {
            return apiResult;
        }
        VersionCopyExecuteRequestEntry requestEntry = (VersionCopyExecuteRequestEntry)JSON.parseObject((String)JSON.toJSONString(params), VersionCopyExecuteRequestEntry.class);
        return this.copyExecute(requestEntry);
    }

    @Override
    public ApiResult copyExecute(VersionCopyExecuteRequestEntry requestEntry) {
        log.info("copyExecuteParams:{}", (Object)requestEntry);
        ApiResult apiResult = this.checkReqeustEntry(requestEntry);
        if (apiResult != null) {
            return apiResult;
        }
        return this.beginCopy(requestEntry);
    }

    @NotNull
    private ApiResult beginCopy(VersionCopyExecuteRequestEntry requestEntry) {
        Object viewsionCopyObj = this.createViewsionCopyObj(requestEntry);
        if (viewsionCopyObj instanceof ApiResult) {
            return (ApiResult)viewsionCopyObj;
        }
        VersionCopySchemeExecuteEntity executeEntity = (VersionCopySchemeExecuteEntity)viewsionCopyObj;
        boolean b = this.checkDimemsionLock(executeEntity);
        if (b) {
            log.info("\u7ef4\u5ea6\u5df2\u9501\u5b9a\uff0c\u4e0d\u5141\u8bb8\u590d\u5236");
            ApiResult fail = ApiResult.fail((String)ResManager.loadKDString((String)"\u65b9\u6848\u8303\u56f4\u5185\u6570\u636e\u5df2\u88ab\u9501\u5b9a\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u590d\u5236\u3002", (String)"VersionCopyExecutePlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return fail;
        }
        DynamicObject recordDyn = BusinessDataServiceHelper.newDynamicObject((String)"eb_versioncopyrecord");
        recordDyn.set("id", (Object)DBServiceHelper.genGlobalLongId());
        log.info("\u63a5\u6536\u6267\u884c\u8bf7\u6c42");
        es.submit(() -> {
            block4: {
                try {
                    log.info("\u5f00\u59cb\u6267\u884c");
                    this.saveExecuteLog("0%", CopyDataEnum.EXECUTING.getIndex(), 0L, executeEntity, true, recordDyn, requestEntry);
                    this.execute(executeEntity, requestEntry, recordDyn);
                }
                catch (Exception e) {
                    log.error("\u7248\u672c\u590d\u5236\u6267\u884c\u5931\u8d25:", (Throwable)e);
                    this.saveExecuteLog(ResManager.loadResFormat((String)"\u7248\u672c\u590d\u5236\u6267\u884c\u5931\u8d25\uff1a%1\u3002", (String)"VersionCopyExecutePlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[]{e.getMessage()}), CopyDataEnum.FAILED.getIndex(), recordDyn.getLong("id"), executeEntity, true, recordDyn, requestEntry);
                    DynamicObject[] load = BusinessDataServiceHelper.load((String)"eb_copyrecord_entity", (String)"id,failmsg", (QFilter[])new QFilter[]{new QFilter("recordid", "=", (Object)recordDyn.getLong("id"))}, (String)" createdate desc", (int)1);
                    if (load == null || load.length <= 0) break block4;
                    String stackTraceStr = CommonServiceHelper.getStackTraceStr((Throwable)e);
                    if (stackTraceStr.length() > 2000) {
                        load[0].set("failmsg", (Object)stackTraceStr.substring(0, 1997));
                    } else {
                        load[0].set("failmsg", (Object)stackTraceStr);
                    }
                    SaveServiceHelper.save((DynamicObject[])load);
                }
            }
        });
        log.info("\u63d0\u4ea4\u6267\u884c\u8bf7\u6c42\u6210\u529f");
        HashMap<String, String> result = new HashMap<String, String>(16);
        result.put("recordId", recordDyn.getString("id"));
        ApiResult success = ApiResult.success(result);
        success.setMessage(ResManager.loadKDString((String)"\u7248\u672c\u590d\u5236\u6267\u884c\u63d0\u4ea4\u6210\u529f\u3002", (String)"VersionCopyApiServiceImpl_12", (String)"epm-eb-mservice", (Object[])new Object[0]));
        return success;
    }

    private void execute(VersionCopySchemeExecuteEntity versionCopyEntity, VersionCopyExecuteRequestEntry requestEntry, DynamicObject recordDyn) {
        log.info("\u7248\u672c\u590d\u5236\u5f00\u59cb");
        long start = System.currentTimeMillis();
        long modelId = versionCopyEntity.getModelId();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)versionCopyEntity.getModelId());
        Long[] datasetIds = DatasetServiceHelper.queryDatasetIds((Long)modelId);
        if (datasetIds.length == 0) {
            return;
        }
        Double percentOfDataset = 100.0 / (double)datasetIds.length;
        Map datasetDimAndMem = VersionCopyApiUtils.getDatasetDimAndMem((IModelCacheHelper)modelCache, (VersionCopySchemeExecuteEntity)versionCopyEntity, (boolean)true, (boolean)false, null);
        int i = 0;
        log.info("\u5171" + datasetIds.length + "\u4e2a\u6570\u636e\u96c6--");
        Double percent = this.processMap.computeIfAbsent(recordDyn.getLong("id"), k -> 0.0);
        Boolean openfilteragg = (Boolean)CommonUtils.getMetaDataFieldDefaultValue((String)"eb_executeversioncopy", (String)"openfilteragg", () -> true);
        log.info("openfilteragg:", (Object)openfilteragg);
        Set metricNumbersHasAgg = openfilteragg != false ? MetricUtils.getMetricNumberHasAgg((Long)modelId) : new HashSet(16);
        for (int i1 = 0; i1 < datasetIds.length; ++i1) {
            Set accounts;
            Long tarBusModelId;
            Long datasetId = datasetIds[i1];
            log.info("\u5f00\u59cb\u590d\u5236\u7b2c" + ++i + "\u4e2a\u6570\u636e\u96c6----datasetid" + datasetId);
            Dataset dataset = Dataset.of((DynamicObject)DatasetServiceHelper.loadDatasets((Long)datasetId));
            this.saveExecuteLog(ConvertUtils.formatDouble((double)percent, (int)2) + "%", CopyDataEnum.EXECUTING.getIndex(), recordDyn.getLong("id"), versionCopyEntity, true, recordDyn, requestEntry);
            Long busModelId = null;
            if (CollectionUtils.isNotEmpty((Collection)versionCopyEntity.getBusinessModelId()) && !(busModelId = (Long)versionCopyEntity.getBusinessModelId().get(0)).equals(tarBusModelId = DatasetServiceHelper.getBusModelIdByDataset((Long)datasetId))) {
                percent = percent + percentOfDataset;
                this.saveExecuteLog(ConvertUtils.formatDouble((double)percent, (int)2) + "%", CopyDataEnum.EXECUTING.getIndex(), recordDyn.getLong("id"), versionCopyEntity, true, recordDyn, requestEntry);
                continue;
            }
            Map memberMap = (Map)datasetDimAndMem.get(datasetId);
            if (requestEntry.getConditionMap() == null || requestEntry.getConditionMap().isEmpty()) {
                HashSet<Member> entity = new HashSet<Member>(16);
                for (String entityNumber : requestEntry.getEntityNumbers()) {
                    Member memberByAnyView = modelCache.getMemberByAnyView(SysDimensionEnum.Entity.getNumber(), entityNumber);
                    if (memberByAnyView == null) continue;
                    entity.add(memberByAnyView);
                }
                memberMap.put(SysDimensionEnum.Entity.getNumber(), entity);
            }
            if ((accounts = (Set)memberMap.get(SysDimensionEnum.Account.getNumber())).size() == 0) {
                percent = percent + percentOfDataset;
                this.saveExecuteLog(ConvertUtils.formatDouble((double)percent, (int)2) + "%", CopyDataEnum.EXECUTING.getIndex(), recordDyn.getLong("id"), versionCopyEntity, true, recordDyn, requestEntry);
                continue;
            }
            Set entList = (Set)memberMap.get(SysDimensionEnum.Entity.getNumber());
            if (entList == null || entList.size() == 0) {
                percent = percent + percentOfDataset;
                this.saveExecuteLog(ConvertUtils.formatDouble((double)percent, (int)2) + "%", CopyDataEnum.EXECUTING.getIndex(), recordDyn.getLong("id"), versionCopyEntity, true, recordDyn, requestEntry);
                continue;
            }
            HashMap metricMap = new HashMap(2);
            if (CollectionUtils.isNotEmpty(metricNumbersHasAgg)) {
                HashSet members = (HashSet)memberMap.get(SysDimensionEnum.Metric.getNumber());
                if (CollectionUtils.isEmpty((Collection)members)) {
                    members = new HashSet(16);
                    members.addAll(modelCache.getMember(SysDimensionEnum.Metric.getNumber(), Long.valueOf(0L), SysDimensionEnum.Metric.getNumber(), RangeEnum.ALL.getIndex()));
                }
                if (CollectionUtils.isNotEmpty((Collection)members)) {
                    Set detail;
                    Set noDetail = members.stream().filter(x -> metricNumbersHasAgg.contains(x.getNumber())).collect(Collectors.toSet());
                    if (CollectionUtils.isNotEmpty(noDetail)) {
                        metricMap.put("hasAgg", noDetail);
                    }
                    if (CollectionUtils.isNotEmpty(detail = members.stream().filter(x -> !metricNumbersHasAgg.contains(x.getNumber())).collect(Collectors.toSet()))) {
                        metricMap.put("noAgg", detail);
                    }
                }
            }
            if (metricMap.isEmpty()) {
                percent = this.doExecute(versionCopyEntity, requestEntry, recordDyn, modelCache, percent, dataset, memberMap, percentOfDataset, null);
                continue;
            }
            double metricpercent = percentOfDataset / (double)metricMap.size();
            for (Map.Entry map : metricMap.entrySet()) {
                if ("noAgg".equals(map.getKey())) {
                    log.info("noAgg");
                    percent = this.doExecute(versionCopyEntity, requestEntry, recordDyn, modelCache, percent, dataset, memberMap, metricpercent, (Set)map.getValue());
                    continue;
                }
                log.info("haAgg");
                HashMap<String, Set<Member>> tempMap = new HashMap<String, Set<Member>>(memberMap.size());
                boolean isEmptyMember = false;
                for (Map.Entry dimMemberMap : memberMap.entrySet()) {
                    if (((String)dimMemberMap.getKey()).equals(SysDimensionEnum.AuditTrail.getNumber())) {
                        tempMap.put((String)dimMemberMap.getKey(), (Set<Member>)dimMemberMap.getValue());
                        continue;
                    }
                    Set collect = ((Set)dimMemberMap.getValue()).stream().filter(x -> x.isLeaf()).collect(Collectors.toSet());
                    if (CollectionUtils.isEmpty(collect)) {
                        isEmptyMember = true;
                        break;
                    }
                    tempMap.put((String)dimMemberMap.getKey(), collect);
                }
                if (isEmptyMember) {
                    percent = percent + metricpercent;
                    continue;
                }
                percent = this.doExecute(versionCopyEntity, requestEntry, recordDyn, modelCache, percent, dataset, tempMap, metricpercent, (Set)map.getValue());
            }
        }
        this.saveExecuteLog(ResManager.loadKDString((String)"\u7248\u672c\u590d\u5236\u6210\u529f\u3002", (String)"VersionCopyExecutePlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]), CopyDataEnum.SUCCESS.getIndex(), recordDyn.getLong("id"), versionCopyEntity, true, recordDyn, requestEntry);
        log.info("\u7248\u672c\u590d\u5236\u6210\u529f \u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
    }

    private Double doExecute(VersionCopySchemeExecuteEntity versionCopyEntity, VersionCopyExecuteRequestEntry requestEntry, DynamicObject recordDyn, IModelCacheHelper modelCache, Double percent, Dataset dataset, Map<String, Set<Member>> memberMap, Double percentOfDataset, Set<Member> metricList) {
        Set<Member> accounts = memberMap.get(SysDimensionEnum.Account.getNumber());
        Integer accountmembernum = (Integer)CommonUtils.getMetaDataFieldDefaultValue((String)"eb_executeversioncopy", (String)"accountmembernum", () -> 50);
        if (accountmembernum > 100 || accountmembernum < 10) {
            accountmembernum = 50;
        }
        log.info("accountmembernum:{}", (Object)accountmembernum);
        List<Set<Member>> sp_accountlist = this.splitList(accounts, accountmembernum);
        Double accountPercent = percentOfDataset / (double)sp_accountlist.size();
        Set<Member> entList = memberMap.get(SysDimensionEnum.Entity.getNumber());
        Integer orgmembernum = (Integer)CommonUtils.getMetaDataFieldDefaultValue((String)"eb_executeversioncopy", (String)"orgmembernum", () -> 10);
        if (orgmembernum > 100 || orgmembernum < 10) {
            orgmembernum = 10;
        }
        log.info("orgmembernum:{}", (Object)orgmembernum);
        List<Set<Member>> sp_entList = this.splitList(entList, orgmembernum);
        Double entPercent = accountPercent / (double)sp_entList.size();
        for (Set<Member> entspList : sp_entList) {
            for (Set<Member> accountlist : sp_accountlist) {
                this.saveExecuteLogDetail(recordDyn.getLong("id"), (Long)versionCopyEntity.getBusinessModelId().get(0), versionCopyEntity, modelCache, dataset, entspList, accountlist, metricList);
                this.copyData(versionCopyEntity, modelCache, dataset, entspList, accountlist, memberMap, metricList);
                percent = percent + entPercent;
                this.saveExecuteLog(ConvertUtils.formatDouble((double)percent, (int)2) + "%", CopyDataEnum.EXECUTING.getIndex(), recordDyn.getLong("id"), versionCopyEntity, true, recordDyn, requestEntry);
            }
        }
        return percent;
    }

    private void copyData(VersionCopySchemeExecuteEntity versionCopyEntity, IModelCacheHelper modelCache, Dataset dataset, Set<Member> entList, Set<Member> accountlist, Map<String, Set<Member>> memberMap, Set<Member> metricList) {
        log.info("copydata begin");
        long start = System.currentTimeMillis();
        ArrayList<String> srcMember = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty((Collection)versionCopyEntity.getTrial_1()) && versionCopyEntity.getTrial_1().size() == 1) {
            srcMember.add(SysDimensionEnum.AuditTrail.getNumber() + '@' + (String)versionCopyEntity.getTrial_1().get(0));
        }
        srcMember.add(SysDimensionEnum.Version.getNumber() + '@' + versionCopyEntity.getVersion_1());
        ArrayList<String> tarMember = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty((Collection)versionCopyEntity.getTrial_2()) && versionCopyEntity.getTrial_2().size() == 1) {
            tarMember.add(SysDimensionEnum.AuditTrail.getNumber() + '@' + (String)versionCopyEntity.getTrial_2().get(0));
        }
        tarMember.add(SysDimensionEnum.Version.getNumber() + '@' + versionCopyEntity.getVersion_2());
        if (!srcMember.isEmpty() && !tarMember.isEmpty()) {
            Set<Member> members;
            ComputingCommandInfo computing = new ComputingCommandInfo();
            List<String> entityList = entList.stream().map(x -> x.getNumber()).collect(Collectors.toList());
            computing.addFilter(SysDimensionEnum.Entity.getNumber(), entityList.toArray(new String[entityList.size()]));
            List<String> accountMemberList = accountlist.stream().map(x -> x.getNumber()).collect(Collectors.toList());
            computing.addFilter(SysDimensionEnum.Account.getNumber(), accountMemberList.toArray(new String[accountMemberList.size()]));
            if (CollectionUtils.isNotEmpty((Collection)versionCopyEntity.getTrial_2()) && versionCopyEntity.getTrial_2().size() > 1) {
                computing.addFilter(SysDimensionEnum.AuditTrail.getNumber(), versionCopyEntity.getTrial_2().toArray(new String[0]));
            } else if (CollectionUtils.isEmpty((Collection)versionCopyEntity.getTrial_2())) {
                members = memberMap.get(SysDimensionEnum.AuditTrail.getNumber());
                List<String> collect = members.stream().map(x -> x.getNumber()).collect(Collectors.toList());
                computing.addFilter(SysDimensionEnum.AuditTrail.getNumber(), collect.toArray(new String[0]));
            }
            members = memberMap.get(SysDimensionEnum.DataType.getNumber());
            List<String> dataType = members.stream().map(x -> x.getNumber()).collect(Collectors.toList());
            computing.addFilter(SysDimensionEnum.DataType.getNumber(), dataType.toArray(new String[0]));
            Set<Member> budgetPeriod = memberMap.get(SysDimensionEnum.BudgetPeriod.getNumber());
            List<String> collect = budgetPeriod.stream().map(x -> x.getNumber()).collect(Collectors.toList());
            computing.addFilter(SysDimensionEnum.BudgetPeriod.getNumber(), collect.toArray(new String[0]));
            for (Map.Entry<String, Set<Member>> stringListEntry : memberMap.entrySet()) {
                if (DEFAULT_FILTER_DIM.contains(stringListEntry.getKey())) continue;
                if (SysDimensionEnum.Metric.getNumber().equals(stringListEntry.getKey()) && CollectionUtils.isNotEmpty(metricList)) {
                    List<String> collect1 = metricList.stream().map(x -> x.getNumber()).collect(Collectors.toList());
                    computing.addFilter(stringListEntry.getKey(), collect1.toArray(new String[0]));
                    continue;
                }
                Set<Member> value = stringListEntry.getValue();
                if (!CollectionUtils.isNotEmpty(value)) continue;
                List<String> collect1 = value.stream().map(x -> x.getNumber()).collect(Collectors.toList());
                computing.addFilter(stringListEntry.getKey(), collect1.toArray(new String[0]));
            }
            FelLambdaExpressionItem expr = new FelLambdaExpressionItem();
            expr.setExpressLeft(StringUtils.join(tarMember, (char)','));
            expr.setExpression("value('" + StringUtils.join(srcMember, (char)',') + "')");
            computing.getExpressionItems().add(expr);
            computing.setMainMeaName(FacTabFieldDefEnum.FIELD_MONEY.getField());
            computing.setMainDimName(SysDimensionEnum.DataType.getNumber());
            ShrekIdCodeUtils.setTraceInfo((CommandInfo)computing, null);
            log.info("copy-computing-data:" + computing.toString());
            OlapCommand command = new OlapCommand(ShrekOlapServiceHelper.getConnection((Model)modelCache.getModelobj(), (Dataset)dataset), (CommandInfo)computing);
            command.executeCompute();
            log.info("copyData end time:{}", (Object)(System.currentTimeMillis() - start));
        } else {
            log.warn("copy-computing-warring:" + JSONUtils.toString((Object)versionCopyEntity));
        }
    }

    private void saveExecuteLogDetail(long id, Long bizModel, VersionCopySchemeExecuteEntity versionCopyEntity, IModelCacheHelper modelCache, Dataset dataset, Set<Member> entList, Set<Member> accountlist, Set<Member> metricList) {
        DynamicObject[] collect;
        if (IDUtils.isNull((long)id)) {
            log.error("saveExecuteLogDetail id is null ");
            return;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"eb_copyrecord_entity");
        dynamicObject.set("dataset", (Object)dataset.getId());
        dynamicObject.set("model", (Object)versionCopyEntity.getModelId());
        dynamicObject.set("bizmodel", (Object)bizModel);
        dynamicObject.set("createdate", (Object)TimeServiceHelper.now());
        dynamicObject.set("creater", (Object)UserUtils.getUserId());
        dynamicObject.set("recordid", (Object)id);
        ArrayList<String> entityNames = new ArrayList<String>(entList.size());
        for (Member member : entList) {
            entityNames.add(member.getNumber() + " " + member.getName());
        }
        dynamicObject.set("entity", (Object)this.getLimitStr(entityNames, 2000));
        ArrayList<String> accountNames = new ArrayList<String>(accountlist.size());
        for (Member member : accountlist) {
            accountNames.add(member.getNumber() + " " + member.getName());
        }
        dynamicObject.set("account", (Object)this.getLimitStr(accountNames, 2000));
        ArrayList arrayList = new ArrayList(16);
        if (CollectionUtils.isNotEmpty(arrayList)) {
            collect = new ArrayList(16);
            if (CollectionUtils.isNotEmpty(metricList)) {
                Dimension dimension = modelCache.getDimension(SysDimensionEnum.Metric.getNumber());
                VersionCopyConditionDto copyConditionDto = new VersionCopyConditionDto();
                copyConditionDto.setViewId(Long.valueOf(0L));
                copyConditionDto.setDimNumber(SysDimensionEnum.Metric.getNumber());
                copyConditionDto.setDimId(dimension.getId());
                ArrayList<MemberCondition> memberConditions = new ArrayList<MemberCondition>(16);
                copyConditionDto.setConditions(memberConditions);
                collect.add(copyConditionDto);
                for (Member member : metricList) {
                    memberConditions.add(new MemberCondition(member.getId(), member.getNumber(), member.getName(), null, RangeEnum.ONLY.getIndStr()));
                }
            }
            if (CollectionUtils.isNotEmpty(collect)) {
                dynamicObject.set("dimmemberjson", (Object)SerializationUtils.toJsonString((Object)collect));
            }
        }
        try {
            collect = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
        catch (Exception e) {
            log.error("saveExecuteLogDetail error:{}", (Object)CommonServiceHelper.getStackTraceStr((Throwable)e));
        }
    }

    private void saveExecuteLog(String msg, String status, long id, VersionCopySchemeExecuteEntity versionCopyEntity, boolean isUpdateLastTime, DynamicObject record, VersionCopyExecuteRequestEntry requestEntry) {
        DynamicObject[] userId;
        log.info("message:{} :Thread name :{}", (Object)msg, (Object)Thread.currentThread().getName());
        if (id == 0L) {
            userId = UserUtils.getUserId();
            record.set("executor", (Object)userId);
            record.set("executetime", (Object)TimeServiceHelper.now());
            record.set("model", (Object)versionCopyEntity.getModelId());
            record.set("iscancel", (Object)false);
            if (versionCopyEntity.getVersion_1_id() != null && versionCopyEntity.getVersion_2() != null) {
                record.set("srcversion", (Object)versionCopyEntity.getVersion_1_id());
                record.set("tarversion", (Object)versionCopyEntity.getVersion_2());
            }
            ArrayList<String> datatypeList = new ArrayList<String>(16);
            ArrayList<String> periodList = new ArrayList<String>(16);
            DynamicObjectCollection ent_datatype = record.getDynamicObjectCollection("ent_datatype");
            ent_datatype.clear();
            this.fillDatatypeEntity(ent_datatype, datatypeList, SysDimensionEnum.DataType.getMemberTreemodel(), "datatype", versionCopyEntity, versionCopyEntity.getModelId(), SysDimensionEnum.DataType.getNumber());
            record.set("ent_datatype", (Object)ent_datatype);
            DynamicObjectCollection ent_period = record.getDynamicObjectCollection("ent_period");
            ent_period.clear();
            this.fillDatatypeEntity(ent_period, periodList, SysDimensionEnum.BudgetPeriod.getMemberTreemodel(), "period", versionCopyEntity, versionCopyEntity.getModelId(), SysDimensionEnum.BudgetPeriod.getNumber());
            record.set("ent_period", (Object)ent_period);
            DynamicObjectCollection ent_trial = record.getDynamicObjectCollection("ent_trial");
            ent_trial.clear();
            this.fillTrialEntity(ent_trial, versionCopyEntity);
            record.set("ent_trial", (Object)ent_trial);
            record.set("periodtext", (Object)this.getLimitStr(periodList, 1000));
            record.set("datatypetext", (Object)this.getLimitStr(datatypeList, 1000));
            record.set("executeparam", (Object)this.createParamString(versionCopyEntity));
            record.set("dimmemberjson", (Object)SerializationUtils.toJsonString((Object)versionCopyEntity.getVersionCopyConditionDtoList()));
            List<Member> members = this.getMemberList(versionCopyEntity, versionCopyEntity.getModelId(), versionCopyEntity.getBusinessModelId());
            if (members != null && members.size() > 0) {
                record.set("entitytext", (Object)members.get(0).getName());
                record.set("entitynum", (Object)members.get(0).getNumber());
                DynamicObjectCollection ent_entity = record.getDynamicObjectCollection("ent_entity");
                ent_entity.clear();
                this.fillEntityEntity(ent_entity, members);
                record.set("ent_entity", (Object)ent_entity);
            }
        }
        record.set("status", (Object)status);
        record.set("msg", (Object)msg);
        record.set("schemenum", (Object)ResManager.loadKDString((String)"\u6570\u636e\u751f\u6548api\u6267\u884c", (String)"VersionCopyApiServiceImpl_13", (String)"epm-eb-mservice", (Object[])new Object[0]));
        record.set("schemename", (Object)ResManager.loadKDString((String)"\u6570\u636e\u751f\u6548api\u6267\u884c", (String)"VersionCopyApiServiceImpl_13", (String)"epm-eb-mservice", (Object[])new Object[0]));
        record.set("businessmodel", (Object)versionCopyEntity.getBusinessModelId());
        record.set("schemetype", (Object)SchemeTypeEnum.DATA_VALIDATION.getValue());
        if (isUpdateLastTime) {
            record.set("lasttime", (Object)TimeServiceHelper.now());
        }
        try {
            userId = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{record});
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u5fc3\u8df3\u65f6\u95f4\u5931\u8d25", (Throwable)e);
            throw e;
        }
    }

    private List<Member> getMemberList(VersionCopySchemeExecuteEntity executeEntity, Long modelId, List<Long> businessModelId) {
        IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)modelId);
        List versionCopyConditionDtoList = executeEntity.getVersionCopyConditionDtoList();
        Optional<VersionCopyConditionDto> first = versionCopyConditionDtoList.stream().filter(x -> x.getDimNumber().equals(SysDimensionEnum.Entity.getNumber())).findFirst();
        ArrayList<Member> entityMembers = new ArrayList<Member>(16);
        if (first.isPresent()) {
            VersionCopyConditionDto versionCopyConditionDto = first.get();
            List conditions = versionCopyConditionDto.getConditions();
            Long viewId = versionCopyConditionDto.getViewId();
            boolean isNullViewId = IDUtils.isNull((Long)viewId);
            for (MemberCondition condition : conditions) {
                for (Long aLong : businessModelId) {
                    Member member;
                    if (isNullViewId) {
                        member = orCreate.getMemberByAnyView(aLong, SysDimensionEnum.Entity.getNumber(), condition.getNumber());
                        if (member == null) continue;
                        entityMembers.add(member);
                        continue;
                    }
                    member = orCreate.getMember(SysDimensionEnum.Entity.getNumber(), viewId, condition.getNumber());
                    if (member == null) continue;
                    entityMembers.add(member);
                }
            }
        }
        log.info("getMemberList:{}", entityMembers);
        return entityMembers;
    }

    private void fillEntityEntity(DynamicObjectCollection ent_entity, List<Member> members) {
        for (Member member : members) {
            DynamicObject row = new DynamicObject(ent_entity.getDynamicObjectType());
            row.set("entity", (Object)member.getId());
            ent_entity.add((Object)row);
        }
    }

    private void fillDatatypeEntity(DynamicObjectCollection ent_datatype, List<String> nameList, String entityName, String fileName, VersionCopySchemeExecuteEntity versionCopyEntity, Long modelId, String dimNumber) {
        Optional<VersionCopyConditionDto> first = versionCopyEntity.getVersionCopyConditionDtoList().stream().filter(x -> x.getDimNumber().equals(dimNumber)).findFirst();
        if (first.isPresent()) {
            List conditions = first.get().getConditions();
            if (CollectionUtils.isEmpty((Collection)conditions)) {
                return;
            }
            for (MemberCondition memberCondition : conditions) {
                nameList.add(memberCondition.getName());
                DynamicObject row = new DynamicObject(ent_datatype.getDynamicObjectType());
                row.set(fileName, (Object)IDUtils.toLong((Object)memberCondition.getId()));
                ent_datatype.add((Object)row);
            }
        }
    }

    private void fillTrialEntity(DynamicObjectCollection ent_trial, VersionCopySchemeExecuteEntity executeEntity) {
        DynamicObject row;
        if (CollectionUtils.isEmpty((Collection)executeEntity.getTrial_1_ids()) || CollectionUtils.isEmpty((Collection)executeEntity.getTrial_2_ids())) {
            return;
        }
        for (Long id : executeEntity.getTrial_1_ids()) {
            row = new DynamicObject(ent_trial.getDynamicObjectType());
            row.set("trial", (Object)id);
            row.set("source", (Object)"0");
            ent_trial.add((Object)row);
        }
        for (Long id : executeEntity.getTrial_2_ids()) {
            row = new DynamicObject(ent_trial.getDynamicObjectType());
            row.set("trial", (Object)id);
            row.set("source", (Object)"1");
            ent_trial.add((Object)row);
        }
    }

    private ApiResult checkReqeustEntry(VersionCopyExecuteRequestEntry requestEntry) {
        if (StringUtils.isEmpty((String)requestEntry.getModelNumber())) {
            return EBApiResult.fail((String)ResManager.loadKDString((String)"\u4f20\u5165\u7684\u4f53\u7cfb\u7f16\u7801\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u3002", (String)"VersionCopyApiServiceImpl_0", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)requestEntry.getBusinessModelNumber())) {
            return EBApiResult.fail((String)ResManager.loadKDString((String)"\u4f20\u5165\u7684\u4e1a\u52a1\u6a21\u578b\u7f16\u7801\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u3002", (String)"VersionCopyApiServiceImpl_1", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)requestEntry.getSrcVersion())) {
            return EBApiResult.fail((String)ResManager.loadKDString((String)"\u4f20\u5165\u7684\u6e90\u7248\u672c\u7f16\u7801\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u3002", (String)"VersionCopyApiServiceImpl_2", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)requestEntry.getTargetVersion())) {
            return EBApiResult.fail((String)ResManager.loadKDString((String)"\u4f20\u5165\u7684\u76ee\u6807\u7248\u672c\u7f16\u7801\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u3002", (String)"VersionCopyApiServiceImpl_3", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        if (requestEntry.getSrcVersion().equals(requestEntry.getTargetVersion())) {
            return EBApiResult.fail((String)ResManager.loadKDString((String)"\u539f\u7248\u672c\u548c\u76ee\u6807\u7248\u672c\u7f16\u7801\u76f8\u540c,\u8bf7\u68c0\u67e5\u3002", (String)"VersionCopyApiServiceImpl_7", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        Map<String, List<Map<String, String>>> conditionMap = requestEntry.getConditionMap();
        if (conditionMap == null || conditionMap.isEmpty()) {
            if (requestEntry.getEntityNumbers() == null || requestEntry.getEntityNumbers().size() == 0) {
                return EBApiResult.fail((String)ResManager.loadKDString((String)"\u4f20\u5165\u7684\u7ec4\u7ec7\u7f16\u7801\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u3002", (String)"VersionCopyApiServiceImpl_5", (String)"epm-eb-mservice", (Object[])new Object[0]));
            }
            if (requestEntry.getDatatypeNumbers() == null || requestEntry.getDatatypeNumbers().size() == 0) {
                return EBApiResult.fail((String)ResManager.loadKDString((String)"\u4f20\u5165\u7684\u6570\u636e\u7c7b\u578b\u7f16\u7801\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u3002", (String)"VersionCopyApiServiceImpl_4", (String)"epm-eb-mservice", (Object[])new Object[0]));
            }
            if (requestEntry.getPriodNumbers() == null || requestEntry.getPriodNumbers().size() == 0) {
                return EBApiResult.fail((String)ResManager.loadKDString((String)"\u4f20\u5165\u7684\u9884\u671f\u671f\u95f4\u7f16\u7801\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u3002", (String)"VersionCopyApiServiceImpl_6", (String)"epm-eb-mservice", (Object[])new Object[0]));
            }
        } else {
            List<Map<String, String>> dataTypeList = conditionMap.get(SysDimensionEnum.DataType.getNumber());
            if (CollectionUtils.isEmpty(dataTypeList)) {
                return EBApiResult.fail((String)ResManager.loadKDString((String)"\u4f20\u5165\u7684\u6570\u636e\u7c7b\u578b\u7f16\u7801\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u3002", (String)"VersionCopyApiServiceImpl_4", (String)"epm-eb-mservice", (Object[])new Object[0]));
            }
            List<Map<String, String>> periodList = conditionMap.get(SysDimensionEnum.BudgetPeriod.getNumber());
            if (CollectionUtils.isEmpty(periodList)) {
                return EBApiResult.fail((String)ResManager.loadKDString((String)"\u4f20\u5165\u7684\u9884\u671f\u671f\u95f4\u7f16\u7801\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u3002", (String)"VersionCopyApiServiceImpl_6", (String)"epm-eb-mservice", (Object[])new Object[0]));
            }
        }
        return null;
    }

    private ApiResult checkReqeustEntry(Map<String, Object> params) {
        if (params == null || params.size() == 0) {
            return EBApiResult.fail((String)ResManager.loadKDString((String)"\u53c2\u6570\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u3002", (String)"VersionCopyApiServiceImpl_14", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        return null;
    }

    private Object createViewsionCopyObj(VersionCopyExecuteRequestEntry requestEntry) {
        VersionCopySchemeExecuteEntity versionCopyEntity = new VersionCopySchemeExecuteEntity();
        BizModel model = CommonUtils.getModel((String)requestEntry.getModelNumber());
        Long modelId = model.getId();
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and(new QFilter("number", "=", (Object)requestEntry.getBusinessModelNumber()));
        DynamicObject businessModel = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_businessmodel", (QFilter[])qFilter.toArray());
        if (businessModel == null) {
            return EBApiResult.fail((String)ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u76f8\u5e94\u7684\u4e1a\u52a1\u6a21\u578b\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"VersionCopyApiServiceImpl_8", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        IModelCacheHelper modelCache = model.getModelCache();
        Member srcVersion = modelCache.getMember(SysDimensionEnum.Version.getNumber(), null, requestEntry.getSrcVersion());
        Member tarVersion = modelCache.getMember(SysDimensionEnum.Version.getNumber(), null, requestEntry.getTargetVersion());
        versionCopyEntity.setModelId(modelId);
        versionCopyEntity.setBusinessModelId(Collections.singletonList(businessModel.getLong("id")));
        List dataSetIdByBusModelIds = DatasetServiceHelper.getDataSetIdByBusModelIds(Collections.singleton(businessModel.getLong("id")));
        List datasets = Dataset.of((DynamicObjectCollection)DatasetServiceHelper.loadDatasets((Long[])dataSetIdByBusModelIds.toArray(new Long[0])));
        versionCopyEntity.setDateSetList(datasets);
        versionCopyEntity.setVersion_1(requestEntry.getSrcVersion());
        versionCopyEntity.setVersionName_1(srcVersion.getName());
        versionCopyEntity.setVersion_1_id(srcVersion.getId());
        versionCopyEntity.setVersion_2(requestEntry.getTargetVersion());
        versionCopyEntity.setVersionName_2(tarVersion.getName());
        versionCopyEntity.setVersion_2_id(tarVersion.getId());
        List<Member> trailLeafNode = this.getTrailLeafNode(modelId);
        if (trailLeafNode != null && trailLeafNode.size() > 0) {
            List numberlist = trailLeafNode.stream().map(x -> x.getNumber()).collect(Collectors.toList());
            versionCopyEntity.setTrial_1(numberlist);
            versionCopyEntity.setTrial_2(numberlist);
            List namelist = trailLeafNode.stream().map(x -> x.getName()).collect(Collectors.toList());
            versionCopyEntity.setTrialName_1(namelist);
            versionCopyEntity.setTrialName_2(namelist);
            List idList = trailLeafNode.stream().map(x -> x.getId()).collect(Collectors.toList());
            versionCopyEntity.setTrial_1_ids(idList);
            versionCopyEntity.setTrial_2_ids(idList);
        }
        Map<String, List<Map<String, String>>> conditionMap = requestEntry.getConditionMap();
        ArrayList<VersionCopyConditionDto> versionCopyConditionDtos = new ArrayList<VersionCopyConditionDto>(16);
        if (conditionMap == null || conditionMap.isEmpty()) {
            List<String> datatypeNumbers = requestEntry.getDatatypeNumbers();
            Dimension dataTypeDim = modelCache.getDimension(SysDimensionEnum.DataType.getNumber());
            VersionCopyConditionDto versionCopyConditionDto = new VersionCopyConditionDto();
            versionCopyConditionDto.setDimId(dataTypeDim.getId());
            versionCopyConditionDto.setViewId(Long.valueOf(0L));
            versionCopyConditionDto.setDimNumber(dataTypeDim.getNumber());
            ArrayList<MemberCondition> conditions = new ArrayList<MemberCondition>(16);
            for (String memberNumber : datatypeNumbers) {
                Member member = modelCache.getMember(dataTypeDim.getNumber(), null, memberNumber);
                if (member == null) continue;
                conditions.add(new MemberCondition(member.getId(), member.getNumber(), member.getName(), null, RangeEnum.ONLY.getIndStr()));
            }
            versionCopyConditionDto.setConditions(conditions);
            versionCopyConditionDtos.add(versionCopyConditionDto);
            List<String> periodNumbers = requestEntry.getPriodNumbers();
            Dimension periodDim = modelCache.getDimension(SysDimensionEnum.BudgetPeriod.getNumber());
            VersionCopyConditionDto versionCopyConditionDtoPeriod = new VersionCopyConditionDto();
            versionCopyConditionDtoPeriod.setDimId(periodDim.getId());
            versionCopyConditionDtoPeriod.setViewId(Long.valueOf(0L));
            versionCopyConditionDtoPeriod.setDimNumber(periodDim.getNumber());
            ArrayList<MemberCondition> conditionsperiod = new ArrayList<MemberCondition>(16);
            for (String memberNumber : periodNumbers) {
                Member member = modelCache.getMember(periodDim.getNumber(), null, memberNumber);
                if (member == null) continue;
                conditionsperiod.add(new MemberCondition(member.getId(), member.getNumber(), member.getName(), null, RangeEnum.ONLY.getIndStr()));
            }
            versionCopyConditionDtoPeriod.setConditions(conditionsperiod);
            versionCopyConditionDtos.add(versionCopyConditionDtoPeriod);
            List<String> entityNumbers = requestEntry.getEntityNumbers();
            Dimension entityDim = modelCache.getDimension(SysDimensionEnum.Entity.getNumber());
            VersionCopyConditionDto versionCopyConditionDtoEntity = new VersionCopyConditionDto();
            versionCopyConditionDtoEntity.setDimId(entityDim.getId());
            versionCopyConditionDtoEntity.setViewId(Long.valueOf(0L));
            versionCopyConditionDtoEntity.setDimNumber(entityDim.getNumber());
            ArrayList<MemberCondition> conditionsEntity = new ArrayList<MemberCondition>(16);
            for (String memberNumber : entityNumbers) {
                Member member = modelCache.getMemberByAnyView(entityDim.getNumber(), memberNumber);
                if (member == null) continue;
                conditionsEntity.add(new MemberCondition(member.getId(), member.getNumber(), member.getName(), null, RangeEnum.ONLY.getIndStr()));
            }
            versionCopyConditionDtoEntity.setConditions(conditionsEntity);
            versionCopyConditionDtos.add(versionCopyConditionDtoEntity);
        } else {
            for (Map.Entry<String, List<Map<String, String>>> condition : conditionMap.entrySet()) {
                List<Map<String, String>> value;
                if (condition.getKey().equals(SysDimensionEnum.Version.getNumber()) || condition.getKey().equals(SysDimensionEnum.AuditTrail.getNumber())) continue;
                Dimension dimension = modelCache.getDimension(condition.getKey());
                if (dimension == null) {
                    log.info("dimension is null  dimNumber:{}", (Object)condition.getKey());
                }
                if (!CollectionUtils.isNotEmpty(value = condition.getValue())) continue;
                VersionCopyConditionDto versionCopyConditionDto = new VersionCopyConditionDto();
                ArrayList<MemberCondition> memberConditions = new ArrayList<MemberCondition>(16);
                for (Map<String, String> map : value) {
                    versionCopyConditionDto.setDimId(dimension.getId());
                    versionCopyConditionDto.setDimNumber(dimension.getNumber());
                    versionCopyConditionDto.setViewId(IDUtils.toLong((Object)map.get("viewId")));
                    Member member = modelCache.getMember(dimension.getNumber(), IDUtils.toLong((Object)map.get("viewId")), map.get("number"));
                    if (member == null) {
                        log.info("member is null:{}", (Object)map.toString());
                        continue;
                    }
                    RangeEnum range = RangeEnum.getRangeByVal((String)map.get("range"));
                    if (range != null) {
                        memberConditions.add(new MemberCondition(member.getId(), member.getNumber(), member.getName(), null, range.getIndStr()));
                        continue;
                    }
                    log.info("range is null\uff1a{}", (Object)map.get("range"));
                    memberConditions.add(new MemberCondition(member.getId(), member.getNumber(), member.getName(), null, RangeEnum.ONLY.getIndStr()));
                }
                versionCopyConditionDto.setConditions(memberConditions);
                versionCopyConditionDtos.add(versionCopyConditionDto);
            }
        }
        versionCopyEntity.setVersionCopyConditionDtoList(versionCopyConditionDtos);
        log.info("versioinCopyEntity:{}", (Object)versionCopyEntity);
        return versionCopyEntity;
    }

    private <T> List<Set<T>> splitList(Set<T> list, int L) {
        ArrayList<Set<T>> parts = new ArrayList<Set<T>>(16);
        if (CollectionUtils.isNotEmpty(list)) {
            ArrayList<T> temp = new ArrayList<T>(list);
            int N = temp.size();
            for (int i = 0; i < N; i += L) {
                parts.add(new HashSet(temp.subList(i, Math.min(N, i + L))));
            }
        }
        return parts;
    }

    private List<Member> getTrailLeafNode(Long modelId) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Long[] datasetIds = DatasetServiceHelper.queryDatasetIds((Long)modelId);
        List<Object> members = new ArrayList<Member>();
        for (Long datasetId : datasetIds) {
            List dimensions = DatasetServiceHelper.getInstance().listDimensionByDatasetId(datasetId);
            for (kd.epm.eb.common.model.Dimension dim : dimensions) {
                if (!dim.getNumber().equals(SysDimensionEnum.AuditTrail.getNumber())) continue;
                String number = dim.getNumber();
                List dimMembers = modelCache.getMembers(dim.getViewId(), number);
                members = dimMembers.stream().collect(Collectors.toList());
            }
        }
        return members;
    }

    private String getLimitStr(List<String> list, Integer limit) {
        if (list == null || list.size() == 0) {
            return "";
        }
        String str = String.join((CharSequence)",", list);
        if (limit == null || limit < 3) {
            log.warn("limit is :{}", (Object)limit);
            return str;
        }
        if (str.length() > limit) {
            String substring = str.substring(0, limit - 3);
            return substring + ResManager.loadKDString((String)"...", (String)"", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        return str;
    }

    private String createParamString(VersionCopySchemeExecuteEntity versionCopyEntity) {
        StringBuilder s = new StringBuilder();
        IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)versionCopyEntity.getModelId());
        Member srcVersion = orCreate.getMember(SysDimensionEnum.Version.getNumber(), Long.valueOf(0L), versionCopyEntity.getVersion_1());
        Member tarVersion = orCreate.getMember(SysDimensionEnum.Version.getNumber(), Long.valueOf(0L), versionCopyEntity.getVersion_2());
        String version_1 = srcVersion != null ? srcVersion.getName() : versionCopyEntity.getVersionName_1();
        String version_2 = tarVersion != null ? tarVersion.getName() : versionCopyEntity.getVersionName_2();
        List trial_1 = versionCopyEntity.getTrialName_1();
        List trial_2 = versionCopyEntity.getTrialName_2();
        s.append(ResManager.loadResFormat((String)"\u6e90\u7248\u672c:[%1],\u76ee\u6807\u7248\u672c:[%2],\u6e90\u7ebf\u7d22:[%3],\u76ee\u6807\u7ebf\u7d22:[%4]", (String)"VersionCopyExecutePlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[]{version_1, version_2, String.join((CharSequence)",", trial_1), String.join((CharSequence)",", trial_2)}));
        String str = s.toString();
        return str.length() > 2000 ? str.substring(0, 2000) : str;
    }

    private boolean checkDimemsionLock(VersionCopySchemeExecuteEntity versionCopyEntity) {
        long modelId = versionCopyEntity.getModelId();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)versionCopyEntity.getModelId());
        List datasets = versionCopyEntity.getDateSetList();
        Map datasetDimAndMem = VersionCopyApiUtils.getDatasetDimAndMem((IModelCacheHelper)modelCache, (VersionCopySchemeExecuteEntity)versionCopyEntity, (boolean)false, (boolean)false, null);
        List businessModelId = versionCopyEntity.getBusinessModelId();
        if (CollectionUtils.isEmpty((Collection)businessModelId)) {
            return false;
        }
        long busModelId = (Long)businessModelId.get(0);
        for (Dataset dataset : datasets) {
            IBgmdDataLockCache checker = BgmdDataLockService.getInstance().getDataLockCache(Long.valueOf(modelId), Long.valueOf(busModelId));
            Map map = (Map)datasetDimAndMem.get(dataset.getId());
            HashMap checkMap = new HashMap(5);
            for (String s : VersionCopyApiUtils.CHECK_LOCK_DIM) {
                Set members = (Set)map.get(s);
                if (!CollectionUtils.isNotEmpty((Collection)members)) continue;
                Set memberNumbers = members.stream().map(x -> x.getNumber()).collect(Collectors.toSet());
                checkMap.put(s, memberNumbers);
            }
            if (checker == null || !checker.isDataLockScope(checkMap)) continue;
            return true;
        }
        return false;
    }
}

