/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.viewmember;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.epm.eb.common.utils.StringUtils;

public class ContactOrgUpdateServiceImpl
implements IUpgradeService {
    private void update(List<Long> modelIds) {
        if (modelIds == null || modelIds.size() == 0) {
            return;
        }
        StringBuilder modelStr = new StringBuilder();
        for (Long aLong : modelIds) {
            modelStr.append(aLong).append(',');
        }
        if (modelStr.length() < 1) {
            return;
        }
        modelStr.deleteCharAt(modelStr.length() - 1);
        HashMap<Long, Long> map = new HashMap<Long, Long>(16);
        StringBuilder sql = new StringBuilder();
        sql.append("select fid,fmodelid from t_eb_dimension where fnumber ='InternalCompany' and fmodelid in (").append((CharSequence)modelStr).append(')');
        try (DataSet ds = DB.queryDataSet((String)"queryDimenion", (DBRoute)DBRoute.of((String)"epm"), (String)sql.toString(), null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                map.put(row.getLong("fmodelid"), row.getLong("fid"));
            }
        }
        if (map.size() == 0) {
            return;
        }
        for (Map.Entry en : map.entrySet()) {
            this.queryView((Long)en.getKey(), (Long)en.getValue());
        }
    }

    private Long getDimensionId(Long modelId, String dimensionNumber) {
        StringBuilder sql = new StringBuilder();
        sql.append("select fid from t_eb_dimension where fnumber ='").append(dimensionNumber).append("' and fmodelid = ").append(modelId);
        try (DataSet ds = DB.queryDataSet((String)"queryDimenion", (DBRoute)DBRoute.of((String)"epm"), (String)sql.toString(), null);){
            if (ds != null && ds.hasNext()) {
                Row row = ds.next();
                Long l = row.getLong("fid");
                return l;
            }
        }
        return null;
    }

    private void queryView(Long modelId, Long dimensionId) {
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>(16);
        StringBuilder sql = new StringBuilder();
        sql.append("select a.fid,a.fnumber,a.fviewid,b.fnumber viewnumber,c.fnumber parentnumber from t_eb_viewmember a left join t_eb_dimensionview b on a.fviewid=b.fid left join t_eb_viewmember c on a.fparentid=c.fid where a.fmodelid =").append(modelId).append(" and a.fdimensionid=").append(dimensionId);
        try (DataSet ds = DB.queryDataSet((String)"queryViewMember", (DBRoute)DBRoute.of((String)"epm"), (String)sql.toString(), null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                String icViewNumber = row.getString("viewnumber");
                if (StringUtils.isEmpty((String)icViewNumber) || icViewNumber.length() <= 3 || !icViewNumber.toLowerCase(Locale.getDefault()).startsWith("ic_")) continue;
                String viewNumber = row.getString("viewnumber").substring(3);
                String number = row.getString("fnumber");
                String parentNumber = row.getString("parentnumber");
                String isInner = "0";
                if ("ICOEntity".equalsIgnoreCase(parentNumber)) {
                    isInner = "1";
                } else {
                    if (!"ICEntity".equalsIgnoreCase(parentNumber)) continue;
                    isInner = "0";
                }
                if (map.containsKey(viewNumber)) {
                    ((Map)map.get(viewNumber)).put(number, isInner);
                    continue;
                }
                HashMap<String, String> map1 = new HashMap<String, String>(16);
                map1.put(number, isInner);
                map.put(viewNumber, map1);
            }
        }
        if (map.size() == 0) {
            return;
        }
        this.updateEntityViewMember(map, modelId);
    }

    private void updateEntityViewMember(Map<String, Map<String, String>> map, Long modelId) {
        Long dimensionId = this.getDimensionId(modelId, "Entity");
        if (dimensionId == null || dimensionId == 0L) {
            return;
        }
        for (Map.Entry<String, Map<String, String>> entry : map.entrySet()) {
            String viewNumbers = entry.getKey();
            Map<String, String> memberNumbers = entry.getValue();
            this.update(viewNumbers, memberNumbers, dimensionId);
        }
    }

    private void update(String viewNumbers, Map<String, String> memberNumbers, Long dimensionId) {
        ArrayList<Object[]> list = new ArrayList<Object[]>(16);
        StringBuilder sb = new StringBuilder();
        if (memberNumbers.size() == 0) {
            return;
        }
        Set<String> numbers = memberNumbers.keySet();
        String members = String.join((CharSequence)"','", numbers);
        sb.append("select a.fid id,a.fnumber mnumber,a.fviewid from t_eb_viewmember a left join t_eb_dimensionview b on a.fviewid = b.fid where b.fdimensionid =").append(dimensionId).append(" and b.fnumber = '").append(viewNumbers).append("' and a.fnumber in ('").append(members).append("') and a.fisinnerorg = 0 and a.fisouterorg = 0");
        try (DataSet ds = DB.queryDataSet((String)"queryEntity", (DBRoute)DBRoute.of((String)"epm"), (String)sb.toString(), null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                String number = row.getString("mnumber");
                String isInner = memberNumbers.get(number);
                if (StringUtils.isEmpty((String)isInner)) continue;
                Long id = row.getLong("id");
                Object[] obj = new Object[3];
                if ("0".equals(isInner)) {
                    obj[0] = 1;
                    obj[1] = 0;
                } else {
                    obj[0] = 0;
                    obj[1] = 1;
                }
                obj[2] = id;
                list.add(obj);
            }
        }
        if (list == null || list.size() == 0) {
            return;
        }
        String sql = "update t_eb_viewmember set fisinnerorg = ? , fisouterorg= ? where fid =?";
        try {
            DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)sql, list);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private List<Long> queryModelIds() {
        ArrayList<Long> modelIds = new ArrayList<Long>(16);
        try (DataSet ds = DB.queryDataSet((String)"createbizModel_queryEpmBizModel", (DBRoute)DBRoute.of((String)"epm"), (String)"select fid from t_eb_model where freporttype='7'", null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                modelIds.add(row.getLong("fid"));
            }
        }
        return modelIds;
    }

    private String checkTableExist() {
        if (!DB.exitsTable((DBRoute)DBRoute.of((String)"epm"), (String)"T_EB_VIEWMEMBER")) {
            return "T_EB_VIEWMEMBER";
        }
        if (!DB.exitsTable((DBRoute)DBRoute.of((String)"epm"), (String)"T_EB_STRUCTOFENT")) {
            return "T_EB_STRUCTOFENT";
        }
        return "";
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        List<Long> modelIds;
        Throwable throwable;
        TXHandle tx;
        UpgradeResult result;
        block24: {
            UpgradeResult upgradeResult;
            block25: {
                block26: {
                    block21: {
                        UpgradeResult upgradeResult2;
                        block22: {
                            block23: {
                                result = new UpgradeResult();
                                tx = TX.requiresNew((String)"BgmdDataSetUpgrade");
                                throwable = null;
                                String msg = this.checkTableExist();
                                if (kd.bos.util.StringUtils.isEmpty((String)msg)) break block21;
                                result.setSuccess(false);
                                result.setLog("table " + msg + " does't exist, so don't need upgrade.");
                                upgradeResult2 = result;
                                if (tx == null) break block22;
                                if (throwable == null) break block23;
                                try {
                                    tx.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                break block22;
                            }
                            tx.close();
                        }
                        return upgradeResult2;
                    }
                    modelIds = this.queryModelIds();
                    if (modelIds != null && modelIds.size() != 0) break block24;
                    result.setSuccess(true);
                    upgradeResult = result;
                    if (tx == null) break block25;
                    if (throwable == null) break block26;
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    break block25;
                }
                tx.close();
            }
            return upgradeResult;
        }
        try {
            try {
                this.update(modelIds);
                result.setSuccess(true);
            }
            catch (Exception e) {
                result.setSuccess(false);
                StackTraceElement[] arr = e.getStackTrace();
                StringBuilder sb = new StringBuilder();
                for (StackTraceElement ele : arr) {
                    sb.append(ele.toString()).append("\r\n");
                }
                result.setLog(e.getMessage());
                result.setErrorInfo(sb.toString());
                tx.markRollback();
            }
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        catch (Throwable throwable5) {
            throw throwable5;
        }
        finally {
            if (tx != null) {
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                } else {
                    tx.close();
                }
            }
        }
        return result;
    }
}

