/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.viewmember;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.epm.eb.common.utils.StringUtils;

public class FixMebmberIdServiceImpl
extends AbstractFormPlugin
implements IUpgradeService {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String msg = this.checkTableExist();
        if (!StringUtils.isEmpty((String)msg)) {
            this.getView().showTipNotification(msg);
            return;
        }
        List<Long> modelIds = this.queryModelIds();
        if (modelIds == null || modelIds.size() == 0) {
            return;
        }
        this.updateMemberId(modelIds);
    }

    private void updateMemberId(List<Long> modelIds) {
        if (modelIds == null || modelIds.size() == 0) {
            return;
        }
        StringBuilder modelStr = new StringBuilder();
        for (Long aLong : modelIds) {
            modelStr.append(aLong).append(',');
        }
        if (modelStr.length() < 1) {
            return;
        }
        modelStr.deleteCharAt(modelStr.length() - 1);
        StringBuilder sql = new StringBuilder();
        HashMap<Long, Set<String>> numbers = new HashMap<Long, Set<String>>(16);
        ArrayList<Long> memberFid = new ArrayList<Long>(16);
        sql.append("select fid,fnumber,fmodelid from t_eb_viewmember where fmemberid =0 and FISOFFSETENTRY ='1' and fmodelid in (").append((CharSequence)modelStr).append(')');
        try (DataSet ds = DB.queryDataSet((String)"queryViewMember", (DBRoute)DBRoute.of((String)"epm"), (String)sql.toString(), null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                Long modelId = row.getLong("fmodelid");
                memberFid.add(row.getLong("fid"));
                if (numbers.containsKey(modelId)) {
                    ((Set)numbers.get(modelId)).add(row.getString("fnumber"));
                    continue;
                }
                HashSet<String> numberSet = new HashSet<String>();
                numberSet.add(row.getString("fnumber"));
                numbers.put(modelId, numberSet);
            }
        }
        this.update(numbers, memberFid);
    }

    private void update(Map<Long, Set<String>> numbers, List<Long> memberFid) {
        if (numbers.size() != 0) {
            for (Map.Entry<Long, Set<String>> entry : numbers.entrySet()) {
                this.queryOffsetEntry(entry.getKey(), entry.getValue());
            }
        }
        if (memberFid.size() > 0) {
            this.updateLongNumber(memberFid);
        }
    }

    private void updateLongNumber(List<Long> memberFid) {
        ArrayList<Object[]> list = new ArrayList<Object[]>(16);
        StringBuilder fids = new StringBuilder();
        for (Long aLong : memberFid) {
            fids.append(aLong).append(',');
        }
        if (fids.length() < 1) {
            return;
        }
        fids.deleteCharAt(fids.length() - 1);
        StringBuilder sql = new StringBuilder();
        sql.append("select a.fid id,a.fnumber fnumber,b.FLONGNUMBER fparentlongnumber from T_EB_VIEWMEMBER a left join T_EB_VIEWMEMBER b on a.FPARENTID=b.fid where a.fid in(").append((CharSequence)fids).append(')');
        try (DataSet ds = DB.queryDataSet((String)"queryLongnumber", (DBRoute)DBRoute.of((String)"epm"), (String)sql.toString(), null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                Object[] obj = new Object[2];
                StringBuilder sb = new StringBuilder();
                sb.append(row.getString("fparentlongnumber")).append("!").append(row.getString("fnumber"));
                obj[0] = sb.toString();
                obj[1] = row.getLong("id");
                list.add(obj);
            }
        }
        if (list.size() == 0) {
            return;
        }
        String updateSql = "update t_eb_viewmember set flongnumber= ? where fid = ?";
        try {
            if (list != null && list.size() > 0) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)updateSql, list);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void queryOffsetEntry(Long modelId, Set<String> numbers) {
        ArrayList<Object[]> list = new ArrayList<Object[]>(16);
        StringBuilder sql = new StringBuilder();
        sql.append("select fid,fnumber,fmodelid from T_EB_STRUCTOFENT where fmodelid =").append(modelId).append(" and fnumber in ('").append(String.join((CharSequence)"','", numbers)).append("')");
        try (DataSet ds = DB.queryDataSet((String)"queryOffsetEntry", (DBRoute)DBRoute.of((String)"epm"), (String)sql.toString(), null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                Object[] obj = new Object[]{row.getLong("fid"), row.getString("fnumber")};
                list.add(obj);
            }
        }
        if (list.size() == 0) {
            return;
        }
        StringBuilder updateSql = new StringBuilder();
        updateSql.append("update t_eb_viewmember set fmemberid=? where fmodelid = ");
        updateSql.append(modelId);
        updateSql.append(" and fnumber= ?");
        try {
            if (list != null && list.size() > 0) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)updateSql.toString(), list);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String checkTableExist() {
        if (!DB.exitsTable((DBRoute)DBRoute.of((String)"epm"), (String)"T_EB_VIEWMEMBER")) {
            return "T_EB_VIEWMEMBER";
        }
        if (!DB.exitsTable((DBRoute)DBRoute.of((String)"epm"), (String)"T_EB_STRUCTOFENT")) {
            return "T_EB_STRUCTOFENT";
        }
        return "";
    }

    private List<Long> queryModelIds() {
        ArrayList<Long> modelIds = new ArrayList<Long>();
        try (DataSet ds = DB.queryDataSet((String)"createbizModel_queryEpmBizModel", (DBRoute)DBRoute.of((String)"epm"), (String)"select fid from t_eb_model where freporttype='7'", null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                modelIds.add(row.getLong("fid"));
            }
        }
        return modelIds;
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        List<Long> modelIds;
        Throwable throwable;
        TXHandle tx;
        UpgradeResult result;
        block24: {
            UpgradeResult upgradeResult;
            block25: {
                block26: {
                    block21: {
                        UpgradeResult upgradeResult2;
                        block22: {
                            block23: {
                                result = new UpgradeResult();
                                tx = TX.requiresNew((String)"BgmdDataSetUpgrade");
                                throwable = null;
                                String msg = this.checkTableExist();
                                if (kd.bos.util.StringUtils.isEmpty((String)msg)) break block21;
                                result.setSuccess(false);
                                result.setLog("table " + msg + " does't exist, so don't need upgrade.");
                                upgradeResult2 = result;
                                if (tx == null) break block22;
                                if (throwable == null) break block23;
                                try {
                                    tx.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                break block22;
                            }
                            tx.close();
                        }
                        return upgradeResult2;
                    }
                    modelIds = this.queryModelIds();
                    if (modelIds != null && modelIds.size() != 0) break block24;
                    result.setSuccess(true);
                    upgradeResult = result;
                    if (tx == null) break block25;
                    if (throwable == null) break block26;
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    break block25;
                }
                tx.close();
            }
            return upgradeResult;
        }
        try {
            try {
                this.updateMemberId(modelIds);
                result.setSuccess(true);
            }
            catch (Exception e) {
                result.setSuccess(false);
                StackTraceElement[] arr = e.getStackTrace();
                StringBuilder sb = new StringBuilder();
                for (StackTraceElement ele : arr) {
                    sb.append(ele.toString()).append("\r\n");
                }
                result.setLog(e.getMessage());
                result.setErrorInfo(sb.toString());
                tx.markRollback();
            }
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        catch (Throwable throwable5) {
            throw throwable5;
        }
        finally {
            if (tx != null) {
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                } else {
                    tx.close();
                }
            }
        }
        return result;
    }
}

