/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.viewmember;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.utils.GlobalIdUtil;

public class ViewRootMemberServiceImpl
implements IUpgradeService {
    private Map<Long, Long> getDimensionId(List<Long> modelIds) {
        StringBuilder modelStr = new StringBuilder();
        for (Long aLong : modelIds) {
            modelStr.append(aLong).append(',');
        }
        if (modelStr.length() < 1) {
            return new HashMap<Long, Long>(16);
        }
        modelStr.deleteCharAt(modelStr.length() - 1);
        StringBuilder sql = new StringBuilder();
        HashMap<Long, Long> dimensionIds = new HashMap<Long, Long>(16);
        sql.append("select fid,fmodelid from t_eb_dimension where fnumber='Entity' and fmodelid in (").append((CharSequence)modelStr).append(')');
        try (DataSet ds = DB.queryDataSet((String)"queryEntity", (DBRoute)DBRoute.of((String)"epm"), (String)sql.toString(), null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                Long dimId = row.getLong("fid");
                Long modelId = row.getLong("fmodelid");
                dimensionIds.put(modelId, dimId);
            }
        }
        return dimensionIds;
    }

    private void insertEntityRoot(List<Long> modelIds) {
        Map<Long, Long> dimIds = this.getDimensionId(modelIds);
        if (dimIds == null || dimIds.size() == 0) {
            return;
        }
        ArrayList<Long> viewIds = new ArrayList<Long>(dimIds.values());
        Map<Long, Set<Long>> viewIdMap = this.queryViewId(viewIds);
        if (viewIdMap == null || viewIdMap.size() == 0) {
            return;
        }
        for (Map.Entry<Long, Set<Long>> entry : viewIdMap.entrySet()) {
            Long modelId = entry.getKey();
            Set<Long> views = entry.getValue();
            Long dimId = dimIds.get(modelId);
            this.beginInsert(modelId, views, dimId);
        }
    }

    private void beginInsert(Long modelId, Set<Long> viewIds, Long dimensionId) {
        StringBuilder viewstr = new StringBuilder();
        for (Long aLong : viewIds) {
            viewstr.append(aLong).append(',');
        }
        if (viewstr.length() < 1) {
            return;
        }
        viewstr.deleteCharAt(viewstr.length() - 1);
        StringBuilder sql = new StringBuilder();
        sql.append("select distinct fviewid from t_eb_membersaveselect where fcurlevel=1 and fviewid in (").append((CharSequence)viewstr).append(')');
        try (DataSet ds = DB.queryDataSet((String)"querySaveSelect", (DBRoute)DBRoute.of((String)"epm"), (String)sql.toString(), null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                Long hasFirstLevelView = row.getLong("fviewid");
                viewIds.remove(hasFirstLevelView);
            }
        }
        if (viewIds.size() == 0) {
            return;
        }
        Long entityId = this.getEntityRootId(modelId);
        if (entityId == null) {
            return;
        }
        ArrayList<Object[]> objs = new ArrayList<Object[]>(16);
        long[] longIds = GlobalIdUtil.genGlobalLongIds((int)viewIds.size());
        int i = 0;
        for (Long viewId : viewIds) {
            Object[] obj = new Object[]{longIds[i], 0, 1, 1, viewId, entityId, dimensionId};
            objs.add(obj);
            ++i;
        }
        if (objs.size() == 0) {
            return;
        }
        String insertSql = "insert into t_eb_membersaveselect(fid,frange,fcurlevel,fsource,fviewid,fmemberid,fdimensionid) values(?,?,?,?,?,?,?)";
        try {
            DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)insertSql, objs);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Long getEntityRootId(Long modelId) {
        StringBuilder sql = new StringBuilder();
        sql.append("select fid from t_eb_structofent where fnumber='Entity' and fmodelid =").append(modelId);
        try (DataSet ds = DB.queryDataSet((String)"queryEntityRoot", (DBRoute)DBRoute.of((String)"epm"), (String)sql.toString(), null);){
            if (ds != null && ds.hasNext()) {
                Row row = ds.next();
                Long l = row.getLong("fid");
                return l;
            }
        }
        return null;
    }

    private Map<Long, Set<Long>> queryViewId(List<Long> dimIdList) {
        StringBuilder dimensionStr = new StringBuilder();
        for (Long aLong : dimIdList) {
            dimensionStr.append(aLong).append(',');
        }
        if (dimensionStr.length() < 1) {
            return new HashMap<Long, Set<Long>>(16);
        }
        dimensionStr.deleteCharAt(dimensionStr.length() - 1);
        StringBuilder sql = new StringBuilder();
        HashMap<Long, Set<Long>> viewIdMap = new HashMap<Long, Set<Long>>(16);
        sql.append("select fid,fmodelid from t_eb_dimensionview where fsource='0' and fdimensionid in (").append((CharSequence)dimensionStr).append(')');
        try (DataSet ds = DB.queryDataSet((String)"queryEntity", (DBRoute)DBRoute.of((String)"epm"), (String)sql.toString(), null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                Long modelId = row.getLong("fmodelid");
                Long viewId = row.getLong("fid");
                if (viewIdMap.containsKey(modelId)) {
                    ((Set)viewIdMap.get(modelId)).add(viewId);
                    continue;
                }
                HashSet<Long> viewSet = new HashSet<Long>(16);
                viewSet.add(viewId);
                viewIdMap.put(modelId, viewSet);
            }
        }
        return viewIdMap;
    }

    private List<Long> queryModelIds() {
        ArrayList<Long> modelIds = new ArrayList<Long>(16);
        try (DataSet ds = DB.queryDataSet((String)"queryModel", (DBRoute)DBRoute.of((String)"epm"), (String)"select fid from t_eb_model where freporttype='7'", null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                modelIds.add(row.getLong("fid"));
            }
        }
        return modelIds;
    }

    private String checkTableExist() {
        if (!DB.exitsTable((DBRoute)DBRoute.of((String)"epm"), (String)"T_EB_VIEWMEMBER")) {
            return "T_EB_VIEWMEMBER";
        }
        if (!DB.exitsTable((DBRoute)DBRoute.of((String)"epm"), (String)"T_EB_STRUCTOFENT")) {
            return "T_EB_STRUCTOFENT";
        }
        if (!DB.exitsTable((DBRoute)DBRoute.of((String)"epm"), (String)"T_EB_MEMBERSAVESELECT")) {
            return "T_EB_MEMBERSAVESELECT";
        }
        return "";
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        List<Long> modelIds;
        Throwable throwable;
        TXHandle tx;
        UpgradeResult result;
        block24: {
            UpgradeResult upgradeResult;
            block25: {
                block26: {
                    block21: {
                        UpgradeResult upgradeResult2;
                        block22: {
                            block23: {
                                result = new UpgradeResult();
                                tx = TX.requiresNew((String)"BgmdViewMemberUpgrade");
                                throwable = null;
                                String msg = this.checkTableExist();
                                if (StringUtils.isEmpty((String)msg)) break block21;
                                result.setSuccess(false);
                                result.setLog("table " + msg + " does't exist, so don't need upgrade.");
                                upgradeResult2 = result;
                                if (tx == null) break block22;
                                if (throwable == null) break block23;
                                try {
                                    tx.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                break block22;
                            }
                            tx.close();
                        }
                        return upgradeResult2;
                    }
                    modelIds = this.queryModelIds();
                    if (modelIds != null && modelIds.size() != 0) break block24;
                    result.setSuccess(true);
                    upgradeResult = result;
                    if (tx == null) break block25;
                    if (throwable == null) break block26;
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    break block25;
                }
                tx.close();
            }
            return upgradeResult;
        }
        try {
            try {
                this.insertEntityRoot(modelIds);
                result.setSuccess(true);
            }
            catch (Exception e) {
                result.setSuccess(false);
                StackTraceElement[] arr = e.getStackTrace();
                StringBuilder sb = new StringBuilder();
                for (StackTraceElement ele : arr) {
                    sb.append(ele.toString()).append("\r\n");
                }
                result.setLog(e.getMessage());
                result.setErrorInfo(sb.toString());
                tx.markRollback();
            }
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        catch (Throwable throwable5) {
            throw throwable5;
        }
        finally {
            if (tx != null) {
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                } else {
                    tx.close();
                }
            }
        }
        return result;
    }
}

