/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.workflow;

import com.google.common.collect.Sets;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.api.constants.WFTaskResultEnum;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordItem;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityImpl;
import kd.epm.eb.business.approveBill.RejectOnReportService;
import kd.epm.eb.business.approvetype.ApproveUtils;
import kd.epm.eb.business.centralapproval.CentralSplitBillService;
import kd.epm.eb.business.utils.WorkFlowUtil;
import kd.epm.eb.common.params.ParamEnum;
import kd.epm.eb.common.params.ParamQueryServiceHelper;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.DateTimeUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.convert.Convert;

public class WorkFlowBizServiceImpl {
    private static final Log log = LogFactory.getLog(WorkFlowBizServiceImpl.class);

    public String getApproveRecordMessage(IApprovalRecordItem item) {
        String businessKey = item.getBusinessKey();
        Long approveBillId = ConvertUtils.toLong((Object)businessKey);
        HashMap<Date, String> approveInfos = new HashMap<Date, String>(16);
        QFilter qFilter = new QFilter("relateid", "=", (Object)approveBillId);
        qFilter.and("type", "=", (Object)"0");
        Map records = BusinessDataServiceHelper.loadFromCache((String)"eb_approveinforecord", (String)"submittime,approveinfo", (QFilter[])new QFilter[]{qFilter});
        if (records.size() == 0) {
            DynamicObject approveBill = QueryServiceHelper.queryOne((String)"eb_approvebill", (String)"approveinfo", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)approveBillId)});
            log.info("ApproveNodeRecordPlugin_key: " + businessKey);
            if (approveBill == null) {
                return item.getMessage();
            }
            String approveInfo = approveBill.getString("approveinfo");
            log.info("ApproveNodeRecordPlugin_approveInfo: " + approveInfo);
            return approveInfo;
        }
        for (DynamicObject record : records.values()) {
            approveInfos.put(record.getDate("submittime"), record.getString("approveinfo"));
        }
        String time = item.getTime();
        Date date = DateTimeUtils.parseToDate((String)time);
        if (date == null) {
            log.info("ApproveNodeRecordPlugin_itemTimeEmpty");
            return "";
        }
        for (Map.Entry approveInfo : approveInfos.entrySet()) {
            Date subTime = (Date)approveInfo.getKey();
            long abs = Math.abs(date.getTime() - subTime.getTime());
            if (abs > 5000L) continue;
            return (String)approveInfo.getValue();
        }
        log.info("ApproveNodeRecordPlugin_notSuitRecord");
        return "";
    }

    public Set<String> getNotDealProcesses(Long businessKey) {
        Set notAllDealProcesses;
        boolean isNotAllDeal;
        ApproveUtils instance = ApproveUtils.getInstance();
        ArrayList processIds = new ArrayList(16);
        HashSet<Long> businessKeys = new HashSet<Long>(16);
        businessKeys.add(businessKey);
        List inRejectApproveBills = instance.getInRejectApproveBills(businessKeys, processIds);
        if (inRejectApproveBills.size() != 0) {
            processIds.addAll(instance.getApproveRefReportProcessIds((Collection)inRejectApproveBills));
        }
        boolean bl = isNotAllDeal = (notAllDealProcesses = instance.getNotAllDealProcesses(processIds, businessKeys)).size() != 0;
        if (!isNotAllDeal) {
            instance.updateRejectBillStatus(Collections.singletonList(businessKey), processIds);
        }
        return notAllDealProcesses;
    }

    public Set<String> getNotDealProcesses(Long businessKey, String auditType) {
        ApproveUtils instance = ApproveUtils.getInstance();
        ArrayList processIds = new ArrayList(16);
        HashSet<Long> businessKeys = new HashSet<Long>(16);
        businessKeys.add(businessKey);
        List inRejectApproveBills = instance.getInRejectApproveBills(businessKeys, processIds);
        if ("approve".equals(auditType) && inRejectApproveBills.size() != 0) {
            processIds.addAll(instance.getApproveRefReportProcessIds((Collection)inRejectApproveBills));
        }
        return instance.getNotAllDealProcesses(processIds, businessKeys);
    }

    public void saveRejectOpinions(Long businessKeyId, String saveRejectInfo, String nodeValue) {
        if (businessKeyId == 0L) {
            return;
        }
        DynamicObject approveBill = QueryServiceHelper.queryOne((String)"eb_approvebill", (String)"modelid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)businessKeyId)});
        if (approveBill == null) {
            return;
        }
        Long modelId = approveBill.getLong("modelid");
        if (!ParamQueryServiceHelper.getBoolean((long)modelId, (ParamEnum)ParamEnum.BG007)) {
            return;
        }
        if (StringUtils.isEmpty((String)saveRejectInfo)) {
            return;
        }
        Map savedInfos = (Map)SerializationUtils.fromJsonString((String)saveRejectInfo, HashMap.class);
        if (savedInfos.size() == 0) {
            return;
        }
        String relateBillsJson = (String)savedInfos.get("relateBills");
        if (relateBillsJson == null) {
            return;
        }
        String[] split = nodeValue.split("_and_");
        if (split.length < 2) {
            return;
        }
        String userStr = split[0].trim().replaceAll("\u3001", "_");
        String nodeId = split[1];
        if (StringUtils.isNotEmpty((String)userStr)) {
            nodeId = nodeId + "#" + userStr.substring(0, userStr.length() - 1);
        }
        List relateProcesses = (List)SerializationUtils.fromJsonString((String)relateBillsJson, ArrayList.class);
        String mustReject = (String)savedInfos.get("mustreject");
        HashMap mustRejectMap = new HashMap(16);
        if (mustReject != null) {
            mustRejectMap.putAll((Map)SerializationUtils.fromJsonString((String)mustReject, HashMap.class));
        }
        String rejectOpinion = (String)savedInfos.get("rejectopinion");
        HashMap rejectOpinionMap = new HashMap(16);
        if (rejectOpinion != null) {
            rejectOpinionMap.putAll((Map)SerializationUtils.fromJsonString((String)rejectOpinion, HashMap.class));
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(16);
        long[] pkIds = DB.genGlobalLongIds((int)relateProcesses.size());
        int index = 0;
        Long userId = UserUtils.getUserId();
        Long taskId = WorkflowServiceHelper.getTaskIdByBusinessKeyAndUserId((String)String.valueOf(businessKeyId), (Long)userId);
        Timestamp timeStamp = new Timestamp(TimeServiceHelper.getTimeStamp());
        String curNodeId = WorkFlowUtil.getCurNodeId((Long)taskId);
        boolean joinAuditNode = ApproveUtils.getInstance().isJoinAuditNode(businessKeyId, curNodeId);
        for (Long relateProcess : relateProcesses) {
            boolean mustRejectValue = Convert.toBool(mustRejectMap.get(String.valueOf(relateProcess)), (Boolean)false);
            String rejectOpinionValue = (String)rejectOpinionMap.get(String.valueOf(relateProcess));
            if (StringUtils.isEmpty((String)rejectOpinionValue)) {
                rejectOpinionValue = "";
            }
            if (joinAuditNode) {
                params.add(new Object[]{pkIds[index++], relateProcess, mustRejectValue ? "1" : "0", rejectOpinionValue, curNodeId, nodeId, userId, timeStamp, businessKeyId});
                continue;
            }
            params.add(new Object[]{pkIds[index++], relateProcess, mustRejectValue ? "1" : "0", rejectOpinionValue, curNodeId, nodeId, "0", userId, timeStamp, "0", "1", businessKeyId});
        }
        if (joinAuditNode) {
            if (params.size() != 0) {
                ApproveUtils.getInstance().saveTmpRejectOpinion(params);
            }
        } else {
            HashSet businessKeyIds = Sets.newHashSet((Object[])new Long[]{businessKeyId});
            Set reportProcessIds = ApproveUtils.getInstance().getApproveRefReportProcessIds((Collection)businessKeyIds);
            ApproveUtils.getInstance().updateRejectBillStatus((Collection)businessKeyIds, new ArrayList(reportProcessIds));
            if (params.size() != 0) {
                ApproveUtils.getInstance().saveRejectOpinion(params);
            }
            ApproveUtils.getInstance().saveApproveBillRejectStatus(Collections.singletonList(new Object[]{DB.genGlobalLongId(), businessKeyId, "1", 0L, userId, timeStamp}));
            this.clearCurApproveBillReadRecord(businessKeyId);
        }
    }

    public void saveTmpRejectOpinions(Long businessKeyId, String saveRejectInfo, String nodeValue) {
        if (businessKeyId == 0L) {
            return;
        }
        DynamicObject approveBill = QueryServiceHelper.queryOne((String)"eb_approvebill", (String)"modelid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)businessKeyId)});
        if (approveBill == null) {
            return;
        }
        Long modelId = approveBill.getLong("modelid");
        if (!ParamQueryServiceHelper.getBoolean((long)modelId, (ParamEnum)ParamEnum.BG007)) {
            return;
        }
        if (StringUtils.isEmpty((String)saveRejectInfo)) {
            return;
        }
        Map savedInfos = (Map)SerializationUtils.fromJsonString((String)saveRejectInfo, HashMap.class);
        if (savedInfos.size() == 0) {
            return;
        }
        String relateBillsJson = (String)savedInfos.get("relateBills");
        if (relateBillsJson == null) {
            return;
        }
        String[] split = nodeValue.split("_and_");
        if (split.length < 2) {
            return;
        }
        String nodeId = split[1] + "#" + split[0].trim().replaceAll("\u3001", "");
        List relateProcesses = (List)SerializationUtils.fromJsonString((String)relateBillsJson, ArrayList.class);
        String mustReject = (String)savedInfos.get("mustreject");
        HashMap mustRejectMap = new HashMap(16);
        if (mustReject != null) {
            mustRejectMap.putAll((Map)SerializationUtils.fromJsonString((String)mustReject, HashMap.class));
        }
        String rejectOpinion = (String)savedInfos.get("rejectopinion");
        HashMap rejectOpinionMap = new HashMap(16);
        if (rejectOpinion != null) {
            rejectOpinionMap.putAll((Map)SerializationUtils.fromJsonString((String)rejectOpinion, HashMap.class));
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(16);
        long[] pkIds = DB.genGlobalLongIds((int)relateProcesses.size());
        int index = 0;
        Long userId = UserUtils.getUserId();
        Long taskId = WorkflowServiceHelper.getTaskIdByBusinessKeyAndUserId((String)String.valueOf(businessKeyId), (Long)userId);
        Timestamp timeStamp = new Timestamp(TimeServiceHelper.getTimeStamp());
        String curNodeId = ApproveUtils.getInstance().getCurNodeId(taskId);
        for (Long relateProcess : relateProcesses) {
            boolean mustRejectValue = Convert.toBool(mustRejectMap.get(String.valueOf(relateProcess)), (Boolean)false);
            String rejectOpinionValue = (String)rejectOpinionMap.get(String.valueOf(relateProcess));
            if (!mustRejectValue && StringUtils.isEmpty((String)rejectOpinion)) continue;
            params.add(new Object[]{pkIds[index++], relateProcess, mustRejectValue ? "1" : "0", rejectOpinionValue, curNodeId, nodeId, userId, timeStamp});
        }
        if (params.size() != 0) {
            ApproveUtils.getInstance().saveTmpRejectOpinion(params);
        }
    }

    public void clearCurApproveBillReadRecord(Long approveBillId) {
        ApproveUtils.getInstance().deleteApproveBillReadRecord(Collections.singleton(approveBillId));
    }

    public void rejectRecord(AgentExecution execution) {
        ApproveUtils instance = ApproveUtils.getInstance();
        String businessKey = execution.getBusinessKey();
        if (StringUtils.isEmpty((String)businessKey)) {
            return;
        }
        Long approveBillId = Long.parseLong(businessKey);
        HashSet selectApproveIds = Sets.newHashSet((Object[])new Long[]{approveBillId});
        boolean joinAuditNode = execution instanceof ExecutionEntityImpl ? ApproveUtils.getInstance().isJoinAuditNode(approveBillId, ((ExecutionEntityImpl)execution).getCurrentActivityId()) : ApproveUtils.getInstance().isJoinAuditNode(approveBillId, true);
        if (!joinAuditNode) {
            return;
        }
        ArrayList processIds = new ArrayList(16);
        List inRejectApproveBills = instance.getInRejectApproveBills((Collection)selectApproveIds, processIds);
        if (inRejectApproveBills.size() != 0) {
            processIds.addAll(instance.getApproveRefReportProcessIds((Collection)inRejectApproveBills));
        }
        instance.updateRejectBillStatus((Collection)inRejectApproveBills, processIds);
        Set reportProcessIds = instance.getApproveRefReportProcessIds((Collection)selectApproveIds);
        instance.saveTmpData((Collection)reportProcessIds, (Collection)selectApproveIds);
        instance.deleteApproveBillReadRecord((Collection)selectApproveIds);
        ArrayList<Object[]> params = new ArrayList<Object[]>(16);
        Long userId = UserUtils.getUserId();
        Timestamp timestamp = new Timestamp(TimeServiceHelper.getTimeStamp());
        long[] pkIds = DB.genGlobalLongIds((int)selectApproveIds.size());
        int index = -1;
        boolean isReject = "reject".equals(execution.getCurrentTaskResult(WFTaskResultEnum.auditType));
        for (Long selectApproveId : selectApproveIds) {
            if (!isReject) continue;
            params.add(new Object[]{pkIds[++index], selectApproveId, "1", 0L, userId, timestamp});
        }
        if (params.size() != 0) {
            instance.saveApproveBillRejectStatus(params);
        }
    }

    public void centralSplitBill(String businessKey, String auditNode, Map<String, Object> paramMap) {
        if (StringUtils.isEmpty((String)businessKey)) {
            return;
        }
        DynamicObject mainApproveBill = BusinessDataServiceHelper.loadSingleFromCache((Object)IDUtils.toLong((Object)businessKey), (String)"eb_approvebill");
        if (mainApproveBill == null) {
            return;
        }
        mainApproveBill.set("auditnode", (Object)auditNode);
        boolean allowMultiSplit = false;
        HashSet<String> schemaNumbers = new HashSet<String>(16);
        if (CollectionUtils.isNotEmpty(paramMap)) {
            for (Object param : paramMap.values()) {
                if (param instanceof Boolean) {
                    allowMultiSplit = (Boolean)param;
                    continue;
                }
                if (!(param instanceof String)) continue;
                schemaNumbers.add((String)param);
            }
        }
        if (CollectionUtils.isNotEmpty(schemaNumbers)) {
            log.info("centralSplitBill==>central schema number: {}", (Object)SerializationUtils.toJsonString(schemaNumbers));
            QFilter qFilter = new QFilter("centralrange.model", "=", (Object)mainApproveBill.getLong("modelid.id"));
            qFilter.and(new QFilter("number", "in", schemaNumbers));
            DynamicObject[] centralSchemaArr = BusinessDataServiceHelper.load((String)"eb_centralrelscheme", (String)"id,entity.id", (QFilter[])qFilter.toArray());
            HashMap<Long, Long> centralSchemaMap = new HashMap<Long, Long>(centralSchemaArr.length);
            for (DynamicObject centralSchema : centralSchemaArr) {
                Long centralSchemaId = centralSchema.getLong("id");
                Long entityId = centralSchema.getLong("entity.id");
                centralSchemaMap.put(centralSchemaId, entityId);
            }
            log.info("centralSplitBill==>centralSchemaMap: {}", (Object)SerializationUtils.toJsonString(centralSchemaMap));
            if (CollectionUtils.isEmpty(centralSchemaMap)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u5f52\u53e3\u65b9\u6848\uff0c\u8bf7\u68c0\u67e5\u5f52\u53e3\u65b9\u6848\u7f16\u7801\u914d\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"WorkFlowBizServiceImpl_1", (String)"epm-eb-mservice", (Object[])new Object[0]));
            }
            CentralSplitBillService.getInstance().splitBill(mainApproveBill, centralSchemaMap, allowMultiSplit);
        } else {
            CentralSplitBillService.getInstance().splitBill(mainApproveBill, null, allowMultiSplit);
        }
    }

    public boolean isOpenRejectOpinion(Long modelId) {
        return ParamQueryServiceHelper.getBoolean((long)modelId, (ParamEnum)ParamEnum.BG007);
    }

    public boolean isOpenRejectOnReport(Long modelId) {
        return RejectOnReportService.getInstance().isOpenRejectOnReport(modelId);
    }

    public int countRejectRptIds(Long approveBillId) {
        Map billRejectRptMap = RejectOnReportService.getInstance().getRejectReportProcessIds(Collections.singleton(approveBillId));
        Set rejectRptIds = (Set)billRejectRptMap.get(approveBillId);
        return rejectRptIds == null ? 0 : rejectRptIds.size();
    }

    public void stopRejectBillWorkFlow(String businessKey, String curNode) {
        RejectOnReportService.getInstance().stopRejectBillWorkFlow(IDUtils.toLong((Object)businessKey), curNode);
    }

    public void jump2NodeAfterSubmit(String businessKey, String curNode) {
        RejectOnReportService.getInstance().jump2NodeAfterSubmit(IDUtils.toLong((Object)businessKey), curNode);
    }
}

