/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.budget.formplugin.AbstractBaseListPlugin;
import kd.epm.eb.budget.formplugin.BCMBaseFunction;
import kd.epm.eb.budget.formplugin.BcmBasePluginUtil;
import kd.epm.eb.budget.formplugin.IOperationLog;
import kd.epm.eb.budget.formplugin.database.BasedataEditSingleMemberF7;
import kd.epm.eb.budget.formplugin.util.ModelUtil;
import kd.epm.eb.budget.formplugin.util.SingleMemberF7Util;
import kd.epm.eb.business.ebupgrades.utils.UpgradeHandler;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.ebcommon.common.enums.SingleF7TypeEnum;
import kd.epm.eb.common.ebcommon.common.log.BcmLogFactory;
import kd.epm.eb.common.ebcommon.common.log.WatchLogger;
import kd.epm.eb.common.pageinteraction.DynamicPage;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.ebBusiness.serviceHelper.MemberPermHelper;
import org.apache.commons.collections4.map.CaseInsensitiveMap;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractBaseFormPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener,
IOperationLog,
BeforeF7SelectListener,
BCMBaseFunction,
UpgradeHandler {
    protected static final String F7KEY2DIM = "f7Key2Dim";
    protected static final String cslscheme = "cslscheme";
    protected Map<String, Control> cacheControls = new CaseInsensitiveMap();
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, AbstractBaseListPlugin.class);
    protected Map<String, SingleF7TypeEnum> map;

    public void initialize() {
        super.initialize();
        this.bcmInit();
    }

    public void registerListener(EventObject e) {
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl(this.getModelSign());
        if (basedataEdit != null) {
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setCSLSchemeF7Visiable(e);
    }

    public void setCSLSchemeF7Visiable(EventObject e) {
        boolean isFalse = false;
        if (e.getSource() instanceof FormView && (this.isCM() || this.isRPT()) && this.getView().getControl(cslscheme) != null) {
            this.getView().setVisible(Boolean.valueOf(isFalse), new String[]{cslscheme});
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String opkey = evt.getItemKey();
        if (!this.getView().getEntityId().equals("eb_template_areasetting") && !opkey.equals("btn_confirm")) {
            this.checkEBPerm(opkey);
        }
    }

    private void checkEBPerm(String opkey) {
        DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"EPMPermissionService", (String)"checkPermission", (Object[])new Object[]{this.getModelId(), UserUtils.getUserId(), AppMetadataCache.getAppInfo((String)this.getBizAppId()).getId(), this.getView().getEntityId(), opkey});
    }

    public void click(EventObject evt) {
        super.click(evt);
        String opkey = ((Control)evt.getSource()).getKey();
        this.checkEBPerm(opkey);
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        int is = BcmBasePluginUtil.checkPermission(this.getUserId(), this.getModelId(), AppMetadataCache.getAppInfo((String)this.getBizAppId()).getId(), this.getView().getEntityId(), "4715a0df000000ac");
        if (is == 0) {
            if (MemberPermHelper.ifUserHasRootPermByModel((long)this.getUserId(), (String)String.valueOf(this.getModelId()))) {
                return;
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6b64\u64cd\u4f5c\u6743\u9650\u3002", (String)"AbstractBaseFormPlugin_0", (String)"epm-eb-budget", (Object[])new Object[0]));
        }
    }

    public <T> T getValueOnModel(String propName) {
        return this.getValueOnModel(this.getModel(), propName.toLowerCase());
    }

    public void setValueOnModel(String propName, Object value) {
        this.setValueOnModel(this.getModel(), propName, value);
    }

    public IClientViewProxy getClientViewProxy() {
        return (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
    }

    public long getScenarioId() {
        String scenarioId = this.getPageCache().get("KEY_SCENARIO_ID");
        if (StringUtils.isEmpty((String)scenarioId)) {
            String string = scenarioId = this.getFormCustomParam("KEY_SCENARIO_ID") == null ? "" : this.getFormCustomParam("KEY_SCENARIO_ID").toString();
        }
        if (StringUtils.isEmpty((String)scenarioId)) {
            this.getPageCache().put("KEY_SCENARIO_ID", "0");
            this.getView().getFormShowParameter().setCustomParam("KEY_SCENARIO_ID", (Object)0);
            return 0L;
        }
        return Long.parseLong(scenarioId);
    }

    public String getModelNumber() {
        String modelNum = this.getPageCache().get("KEY_MODEL_NUMBER");
        if (StringUtils.isEmpty((String)modelNum)) {
            modelNum = (String)this.getFormCustomParam("KEY_MODEL_NUMBER");
        }
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)modelNum), (Object)ResManager.loadKDString((String)"\u83b7\u53d6\u4f53\u7cfb\u7f16\u7801\u4e3a\u7a7a\u3002", (String)"AbstractBaseFormPlugin_1", (String)"epm-eb-budget", (Object[])new Object[0]));
        return modelNum;
    }

    public long getOrgId() {
        return RequestContext.get().getOrgId();
    }

    public Lang getLang() {
        return RequestContext.get().getLang();
    }

    public Date getCurrentSysTime() {
        return TimeServiceHelper.now();
    }

    public boolean isAddNewStatus() {
        return OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus());
    }

    public boolean isEditStatus() {
        return OperationStatus.EDIT.equals((Object)this.getView().getFormShowParameter().getStatus());
    }

    public <T> T getValueOnModel(IDataModel model, String propName) {
        return (T)model.getValue(propName.toLowerCase());
    }

    public void setValueOnModel(IDataModel model, String propName, Object value) {
        model.setValue(propName, value);
    }

    public void setValueOnModelNotFireChangeEvent(String propName, Object value) {
        this.getModel().getDataEntity().set(propName, value);
    }

    public <T> T getDynaObjectPropValue(DynamicObject dynaObj, String propName) {
        return (T)dynaObj.get(propName.toLowerCase());
    }

    public void setFormCustomParam(String key, Object value) {
        this.getView().getFormShowParameter().setCustomParam(key, value);
    }

    public <T> T getFormCustomParam(String key, T defaultVal) {
        return (T)(this.getFormCustomParam(key) == null ? defaultVal : this.getFormCustomParam(key));
    }

    public <T> T getFormCustomParam(FormShowParameter parameter, String key) {
        return (T)parameter.getCustomParam(key);
    }

    protected final void checkValidataInshowTipNotify() {
        try {
            this.checkValidata();
        }
        catch (Exception e) {
            this.getView().showTipNotification(e.getMessage());
        }
    }

    protected void checkValidata() {
    }

    protected final void cacheTrueOrFalseFlag(String key, boolean b) {
        this.getPageCache().put(key, Boolean.toString(b));
    }

    protected final void removeCache(String key) {
        this.getPageCache().remove(key);
    }

    protected void initSingleMemberF7(List<String> dimkeys, SingleF7TypeEnum f7type) {
        HashMap f7map = new HashMap();
        if (dimkeys == null) {
            dimkeys = new ArrayList<String>();
        }
        dimkeys.forEach(dimkey -> f7map.put(dimkey, f7type));
        this.initSingleMemberF7(f7map);
    }

    public void onGetControl(OnGetControlArgs e) {
        this.getBcmControl(e);
        String f7Key = e.getKey();
        String pagekey = e.getKey();
        if (this.getDimKeysFromCache().containsKey(f7Key)) {
            Control ctrl;
            SingleF7TypeEnum type = this.getDimKeysFromCache().get(f7Key);
            Map f7Key2Dim = null;
            if (StringUtils.isNotEmpty((String)this.getPageCache().get(F7KEY2DIM))) {
                f7Key2Dim = (Map)this.deSerializedBytes(this.getPageCache().get(F7KEY2DIM));
                String string = f7Key = f7Key2Dim != null && StringUtils.isNotEmpty((String)((String)f7Key2Dim.get(f7Key))) ? (String)f7Key2Dim.get(f7Key) : f7Key;
            }
            if ((ctrl = this.cacheControls.get(f7Key)) != null) {
                e.setControl(ctrl);
            } else {
                BasedataEditSingleMemberF7 f7 = SingleMemberF7Util.getBasedataEditSingleMemberF7(this.getView(), this.getModel(), this.getModelId(), f7Key, pagekey, ev -> this.getSingleMemberF7Handle(Lists.newArrayList(this.getDimKeysFromCache().keySet())).beforeSingleMemberF7Select(ev), false, type);
                this.initBasedataEditSingleMemberF7(f7Key, f7);
                f7.setDisplayProp("name");
                e.setControl((Control)f7);
                this.cacheControls.put(pagekey, (Control)f7);
            }
        }
    }

    protected void initBasedataEditSingleMemberF7(String f7Key, BasedataEditSingleMemberF7 f7) {
    }

    protected Map<String, SingleF7TypeEnum> getDimKeysFromCache() {
        if (this.map == null) {
            String searialDimKeys = this.getPageCache().get("dimKeyMap2Type");
            this.map = StringUtils.isNotEmpty((String)searialDimKeys) ? (Map)this.deSerializedBytes(searialDimKeys) : new HashMap(0);
        }
        return this.map;
    }

    @Override
    public String getBizEntityNumber() {
        return this.getModel().getDataEntityType().getName();
    }

    @Override
    public String getBizAppId() {
        return this.getView().getFormShowParameter().getAppId();
    }

    @Override
    public void writeLog(String wordKey, String opKey, @NotNull MultiLangEnumBridge opName, MultiLangEnumBridge opDescription, String[] opDescArgs) {
        OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), (String)wordKey, (String)opKey, (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDescription, (String[])opDescArgs);
    }

    public String getModelSign() {
        return "model";
    }

    public void returnDataToParent(Object obj) {
        this.getView().returnDataToParent((Object)this.toByteSerialized(obj));
    }

    public Object getReturnData(ClosedCallBackEvent closedCallBackEvent) {
        String seria = (String)closedCallBackEvent.getReturnData();
        Object obj = this.deSerializedBytes(seria);
        return obj;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        if (((BasedataEdit)beforeF7SelectEvent.getSource()).getKey().equals(this.getModelSign())) {
            if (StringUtils.isNotEmpty((String)this.getModelSign()) && this.getControl(this.getModelSign()) != null) {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl(this.getModelSign())).getQFilters();
                if (qFilterList == null) {
                    qFilterList = new ArrayList<QFilter>();
                }
                qFilterList.addAll(ModelUtil.getModelFilter(this.getView()));
                showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
            }
        } else if (((BasedataEdit)beforeF7SelectEvent.getSource()).getKey().equals("currency")) {
            if (!this.isEntityContainsModel()) {
                return;
            }
            Object model = this.getModel().getValue(this.getModelSign());
            if (model == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"AbstractBaseFormPlugin_4", (String)"epm-eb-budget", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            if (beforeF7SelectEvent.getFormShowParameter() instanceof ListShowParameter) {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl(this.getModelSign())).getQFilters();
                if (qFilterList == null) {
                    qFilterList = new ArrayList<QFilter>();
                }
                qFilterList.add(new QFilter("number", "not in", (Object)new Object[]{"PC", "Currency"}));
                qFilterList.add(new QFilter("model", "=", ((DynamicObject)model).get("id")));
                showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
            }
        }
    }

    private boolean isEntityContainsModel() {
        return this.getModel().getDataEntity(true).getDataEntityType().getProperties().containsKey((Object)this.getModelSign());
    }

    protected boolean isUserDefineDimension(String memberEntityNumber) {
        return BcmBasePluginUtil.isUserDefineDimension(memberEntityNumber);
    }

    protected String getEntityNumByF7key(String f7key) {
        return this.isUserDefineDimension(f7key) ? "epm_userdefinedmembertree" : f7key;
    }

    protected String splitUserDefineDimNumByF7key(String f7key) {
        if (this.isUserDefineDimension(f7key)) {
            return f7key.substring("epm_userdefinedmembertree".length() + 1);
        }
        return null;
    }

    protected String sugarF7Key(String memberEntityNumber, String dimNumber) {
        return BcmBasePluginUtil.sugarF7Key(memberEntityNumber, dimNumber);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        this.setOpenPageTime(e);
        this.bcmPreOpen(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        this.bcmProChange(e);
    }

    @Override
    public AbstractFormPlugin getPlugin() {
        return this;
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        if (this instanceof DynamicPage) {
            this.getBcmEntityType(e);
        } else {
            super.getEntityType(e);
        }
    }

    public void destory() {
        super.destory();
        ModelCacheContext.remove();
        MemberPropCacheService.remove();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        if (evt.getSource() instanceof Control) {
            this.upgradeIntercept(this.getView(), ((Control)evt.getSource()).getKey());
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        this.upgradeIntercept(this.getView(), evt.getItemKey());
    }
}

