/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.dimension;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ValueTextItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.SelectRowsEvent;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.F7SelectedList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.F7SelectedListRemoveEvent;
import kd.bos.list.events.F7SelectedListRemoveListener;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.IntegerField;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.enums.StorageTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.MemberEntity;
import kd.epm.eb.common.permission.DimMembPermUtil;
import kd.epm.eb.common.permission.pojo.DimMembPermTreeNode;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.UserUtils;

public class EbCustomF7Plugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
TreeNodeQueryListener,
SearchEnterListener,
SelectRowsEventListener,
F7SelectedListRemoveListener {
    private String entryKey = "entrysingle";
    private boolean isMulti = false;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = this.getLeftTreeControl();
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        treeView.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        Search search = (Search)this.getControl("searchap1");
        search.addEnterListener((SearchEnterListener)this);
        this.addClickListeners(new String[]{"img_first", "img_pre", "img_next", "img_last", "btnok"});
        F7SelectedList selectedList = (F7SelectedList)this.getControl("f7selectedlistap");
        selectedList.addF7SelectedListRemoveListener((F7SelectedListRemoveListener)this);
        selectedList.addF7SelectedListRemoveAllListener((F7SelectedListRemoveListener)this);
    }

    public void selectRowsChange(SelectRowsEvent evt) {
        List newSelectRows = evt.getNewRows();
        List oldSelectRows = evt.getOldRows();
        List addRows = newSelectRows.stream().filter(num -> !oldSelectRows.contains(num)).collect(Collectors.toList());
        List removeRows = oldSelectRows.stream().filter(num -> !newSelectRows.contains(num)).collect(Collectors.toList());
        List<Long> selectMembIds = null;
        selectMembIds = this.isMulti ? this.getSelectedMembIds() : new ArrayList<Long>();
        IDataModel dataModel = this.getModel();
        DynamicObject row = null;
        if (!addRows.isEmpty()) {
            for (Integer rowNum : addRows) {
                row = dataModel.getEntryRowEntity(this.entryKey, rowNum.intValue());
                selectMembIds.add(row.getLong(this.entryKey + "_id"));
            }
        }
        if (!removeRows.isEmpty()) {
            for (Integer rowNum : removeRows) {
                row = dataModel.getEntryRowEntity(this.entryKey, rowNum.intValue());
                selectMembIds.remove(row.getLong(this.entryKey + "_id"));
            }
        }
        ArrayList<ValueTextItem> valueTextItems = new ArrayList<ValueTextItem>();
        if (!selectMembIds.isEmpty()) {
            F7SelectedList list = (F7SelectedList)this.getControl("f7selectedlistap");
            DimMembPermTreeNode allMembs = this.getCacheMemb();
            for (Long membId : selectMembIds) {
                DimMembPermTreeNode m = allMembs.getChildNodeByNodeId(membId);
                if (m == null) continue;
                ValueTextItem item = new ValueTextItem(String.valueOf(membId), m.getMembName());
                valueTextItems.add(item);
            }
            list.addItems(valueTextItems);
        }
        this.cacheSelectedMembIds(selectMembIds);
    }

    private Map<Long, MemberEntity> getAllMemb() {
        HashMap<Long, MemberEntity> members = new HashMap<Long, MemberEntity>(16);
        MemberEntity memb = null;
        String dimNumber = this.getDimensionNum();
        Long modelId = this.getModelId();
        QFBuilder qf = new QFBuilder("model", "=", (Object)modelId);
        qf.add("dimension.number", "=", (Object)dimNumber);
        SysDimensionEnum dimensionEnum = SysDimensionEnum.getEnumByNumber((String)dimNumber);
        if (dimensionEnum == SysDimensionEnum.Entity) {
            qf.add("fisexchangerate", "=", (Object)"0");
        } else if (dimensionEnum == SysDimensionEnum.AuditTrail) {
            qf.add("number", "not in", Arrays.asList("ADJE", "CWP", "ManualJournal", "AutoJournal"));
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)dimensionEnum.getMemberTreemodel(), (String)"id,number,parent,dseq", (QFilter[])qf.toArray(), null);
        Row row = null;
        while (dataSet.hasNext()) {
            row = dataSet.next();
            Long id = row.getLong("id");
            memb = new MemberEntity(id.longValue(), row.getLong("parent").longValue(), null, row.getString("number"), 0, row.getInteger("dseq").intValue());
            members.put(id, memb);
        }
        if (!members.isEmpty()) {
            members.values().forEach(member -> {
                MemberEntity parent = (MemberEntity)members.get(member.getParentId());
                if (parent != null) {
                    parent.getChilds().add(member);
                }
            });
        }
        return members;
    }

    private List<Long> getNeedDimensionMap() {
        List<Long> childNumbers = new ArrayList<Long>();
        Object children = null;
        ArrayList<Long> containsNumber = new ArrayList<Long>();
        List memberList = this.getDimmensionRang();
        if (memberList.isEmpty()) {
            return containsNumber;
        }
        Map<Long, MemberEntity> allMembs = this.getAllMemb();
        for (Map memberCondition : memberList) {
            childNumbers.clear();
            String range = (String)memberCondition.get("scope");
            if ("10".equals(range)) {
                childNumbers.add(Long.valueOf((String)memberCondition.get("id")));
            } else {
                MemberEntity member = allMembs.get(Long.valueOf((String)memberCondition.get("id")));
                childNumbers = this.queryMemberByRange(range, member, allMembs);
            }
            containsNumber.addAll(childNumbers);
        }
        return containsNumber;
    }

    private List<Long> queryMemberByRange(String range, MemberEntity member, Map<Long, MemberEntity> allMembs) {
        ArrayList<Long> childrenId;
        switch (range) {
            case "20": {
                childrenId = new ArrayList<Long>();
                member.getChilds().forEach(memb -> childrenId.add(memb.getId()));
                break;
            }
            case "30": {
                childrenId = new ArrayList();
                childrenId.add(member.getId());
                member.getChilds().forEach(memb -> childrenId.add(memb.getId()));
                break;
            }
            case "40": {
                childrenId = new ArrayList();
                member.iterate(20, memb -> childrenId.add(memb.getId()));
                childrenId.remove(member.getId());
                break;
            }
            case "50": {
                childrenId = new ArrayList();
                member.iterate(20, memb -> childrenId.add(memb.getId()));
                break;
            }
            case "60": {
                MemberEntity parent = allMembs.get(member.getParentId());
                childrenId = new ArrayList();
                parent.getChilds().forEach(memb -> {
                    if (!memb.getId().equals(member.getId())) {
                        childrenId.add(memb.getId());
                    }
                });
                break;
            }
            case "70": {
                MemberEntity parent = allMembs.get(member.getParentId());
                childrenId = new ArrayList();
                parent.getChilds().forEach(memb -> childrenId.add(memb.getId()));
                break;
            }
            case "90": {
                childrenId = new ArrayList();
                member.iterate(20, memb -> {
                    if (memb.getChilds().isEmpty()) {
                        childrenId.add(memb.getId());
                    }
                });
                break;
            }
            case "110": {
                childrenId = new ArrayList();
                member.iterate(20, memb -> {
                    if (!memb.getChilds().isEmpty()) {
                        childrenId.add(memb.getId());
                    }
                });
                break;
            }
            default: {
                childrenId = new ArrayList();
            }
        }
        return childrenId;
    }

    private List getDimmensionRang() {
        String memberlist = (String)this.getView().getFormShowParameter().getCustomParam("dimRang");
        if (memberlist != null) {
            return SerializationUtils.fromJsonStringToList((String)memberlist, Map.class);
        }
        return new ArrayList();
    }

    public List<Long> getSelectedMembIds() {
        String cacheStr = this.getPageCache().get("selectMembIds");
        ArrayList<Long> membIds = null;
        membIds = cacheStr != null ? (ArrayList<Long>)SerializationUtils.deSerializeFromBase64((String)cacheStr) : new ArrayList<Long>();
        return membIds;
    }

    public void cacheSelectedMembIds(List<Long> membIds) {
        this.getPageCache().put("selectMembIds", SerializationUtils.serializeToBase64(membIds));
    }

    public void setReturnData() {
        List<Long> selectMembIds = this.getSelectedMembIds();
        if (!selectMembIds.isEmpty()) {
            ListSelectedRowCollection selectedRows = new ListSelectedRowCollection();
            ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
            Object needNameAndNum = listShowParameter.getCustomParam("needNameAndNum");
            for (Long membId : selectMembIds) {
                selectedRows.add((Object)new ListSelectedRow((Object)membId));
            }
            if (needNameAndNum != null) {
                DimMembPermTreeNode membs = this.getCacheMemb();
                for (ListSelectedRow row : selectedRows) {
                    DimMembPermTreeNode memb = membs.getChildNodeByNodeId((Long)row.getPrimaryKeyValue());
                    if (memb == null) continue;
                    row.setName(memb.getMembName());
                    row.setNumber(memb.getMembNumber());
                }
            }
            this.getView().returnDataToParent((Object)selectedRows);
        }
        this.getView().close();
    }

    public void initialize() {
        super.initialize();
        this.isMulti = ((ListShowParameter)this.getView().getFormShowParameter()).isMultiSelect();
        if (this.isMulti) {
            this.entryKey = "entrymutil";
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl(this.entryKey);
        entryGrid.addSelectRowsListener((SelectRowsEventListener)this);
    }

    public TreeView getLeftTreeControl() {
        TreeView treeView = (TreeView)this.getControl("treeview1");
        return treeView;
    }

    public BillList getRightListControl() {
        BillList billList = (BillList)this.getControl("billlistap");
        return billList;
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("getall", (Object)Boolean.TRUE);
        this.buildLeftTree();
        this.initEntity();
        this.cacheSelectIdsOnInit();
        this.refleshRightList(true);
    }

    public void cacheSelectIdsOnInit() {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        ArrayList<Long> selectMembIds = new ArrayList<Long>();
        for (ListSelectedRow row : listShowParameter.getListSelectedRowCollection()) {
            selectMembIds.add((Long)row.getPrimaryKeyValue());
        }
        this.cacheSelectedMembIds(selectMembIds);
    }

    public void initEntity() {
        if (this.entryKey.equals("entrymutil")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"entrysingle"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"entrymutil"});
        }
    }

    public void buildLeftTree() {
        ListShowParameter showParameter = (ListShowParameter)this.getView().getFormShowParameter();
        Object model = showParameter.getCustomParam("model");
        if (model == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u4f53\u7cfb\u5931\u8d25", (String)"EbCustomF7Plugin_0", (String)"epm-eb-budget", (Object[])new Object[0]));
        }
        Long modelId = model instanceof String ? Long.valueOf((String)model) : (Long)model;
        String dimNum = (String)showParameter.getCustomParam("dimensionNum");
        if (dimNum == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u7ef4\u5ea6\u7f16\u7801\u5931\u8d25", (String)"EbCustomF7Plugin_1", (String)"epm-eb-budget", (Object[])new Object[0]));
        }
        DimMembPermTreeNode permTreeNode = DimMembPermUtil.getMembTreeNodeWithDataPerm((Long)modelId, (Long)0L, (Long)UserUtils.getUserId(), (String)dimNum, null);
        if (permTreeNode == null) {
            return;
        }
        List qFilters = showParameter.getListFilterParameter().getQFilters();
        this.checkIsOnlyLeft(qFilters);
        Row row = null;
        Long rootId = permTreeNode.getMembId();
        TreeNode leftRoot = new TreeNode();
        leftRoot.setId(String.valueOf(rootId));
        leftRoot.setText(permTreeNode.getMembName());
        List<Long> rangeMemb = this.getNeedDimensionMap();
        HashMap<Long, Integer> validMemb = new HashMap<Long, Integer>(16);
        String selectKeys = "id,storagetype";
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)showParameter.getBillFormId(), (String)selectKeys, (QFilter[])qFilters.toArray(new QFilter[1]), null);
        while (dataSet.hasNext()) {
            row = dataSet.next();
            Long id = row.getLong("id");
            if (!rangeMemb.isEmpty() && !rangeMemb.contains(id)) continue;
            Object storagetype = row.get("storagetype");
            if (storagetype == null || storagetype.equals("")) {
                validMemb.put(id, Integer.parseInt(StorageTypeEnum.STORAGE.getOIndex()));
                continue;
            }
            validMemb.put(id, row.getInteger("storagetype"));
        }
        dataSet.close();
        this.cutTree(permTreeNode, validMemb);
        permTreeNode.iterate(20, node -> {
            if (!node.getChildren().isEmpty()) {
                Collections.sort(node.getChilds());
            }
        });
        if (validMemb.containsKey(permTreeNode.getMembId())) {
            permTreeNode.setEnable(false);
        }
        TreeNode childNode = null;
        HashMap nodeData = null;
        for (DimMembPermTreeNode childMemb : permTreeNode.getChilds()) {
            childNode = new TreeNode();
            childNode.setId(String.valueOf(childMemb.getMembId()));
            childNode.setText(childMemb.getMembName());
            childNode.setParentid(rootId.toString());
            nodeData = new HashMap();
            childNode.setData(nodeData);
            if (!childMemb.getChilds().isEmpty()) {
                childNode.setChildren(new ArrayList());
            }
            leftRoot.addChild(childNode);
        }
        TreeView treeView = this.getLeftTreeControl();
        treeView.deleteAllNodes();
        treeView.addNode(leftRoot);
        treeView.expand(leftRoot.getId());
        treeView.focusNode(leftRoot);
        this.cacheLeftNodeId(leftRoot.getId());
        this.cacheLeftTree(leftRoot);
        this.getPageCache().put("allMember", SerializationUtils.serializeToBase64((Object)permTreeNode));
    }

    private void cutTree(DimMembPermTreeNode pNode, Map<Long, Integer> validMembIds) {
        Integer storageType = null;
        Iterator iterator = pNode.getChildren().iterator();
        while (iterator.hasNext()) {
            DimMembPermTreeNode childNode = (DimMembPermTreeNode)iterator.next();
            storageType = validMembIds.get(childNode.getMembId());
            boolean currentIsValid = false;
            if (storageType != null) {
                currentIsValid = true;
                childNode.getCustomData().put("storageType", storageType);
                childNode.setEnable(false);
            }
            this.cutTree(childNode, validMembIds);
            if (!childNode.getChildren().isEmpty() || currentIsValid) continue;
            iterator.remove();
        }
    }

    private void checkIsOnlyLeft(List<QFilter> qFilters) {
        boolean onlyLeaf = false;
        if (qFilters != null) {
            LinkedList<QFilter> filtersQueues = new LinkedList<QFilter>();
            filtersQueues.addAll(qFilters);
            QFilter qFilter = null;
            while (!filtersQueues.isEmpty()) {
                String val;
                String cp;
                qFilter = (QFilter)filtersQueues.poll();
                if (qFilter == null) continue;
                String prop = qFilter.getProperty().trim();
                if (prop.equals("isleaf") && (cp = qFilter.getCP().trim()).equals("=") && ((val = qFilter.getValue().toString().trim()).equals("true") || val.equals("1"))) {
                    onlyLeaf = true;
                    break;
                }
                for (QFilter.QFilterNest nest : qFilter.getNests(false)) {
                    filtersQueues.add(nest.getFilter());
                }
            }
        }
        if (onlyLeaf) {
            this.getModel().setValue("getall", (Object)Boolean.TRUE);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propKey;
        switch (propKey = e.getProperty().getName()) {
            case "getall": 
            case "page_size_select": {
                this.refleshRightList(false);
                break;
            }
            case "pageinput": {
                int newPageNum = (Integer)e.getChangeSet()[0].getNewValue();
                if (newPageNum <= 0) {
                    return;
                }
                if (newPageNum == 1 && this.getPageCache().get("isinit") != null) {
                    return;
                }
                this.getPageCache().remove("isinit");
                this.pageTurn(newPageNum);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String clickKey = ((Control)evt.getSource()).getKey();
        String currentPageStr = this.getPageCache().get("currentPage");
        String allCountStr = this.getPageCache().get("allCount");
        String pageSizeStr = (String)this.getModel().getValue("page_size_select");
        if (currentPageStr == null || allCountStr == null || pageSizeStr == null) {
            return;
        }
        int currentPage = Integer.parseInt(currentPageStr);
        int allCount = Integer.parseInt(allCountStr);
        int pageSize = Integer.parseInt(pageSizeStr);
        switch (clickKey) {
            case "img_first": {
                this.firstPage(currentPage, allCount, pageSize);
                break;
            }
            case "img_pre": {
                this.prePage(currentPage, allCount, pageSize);
                break;
            }
            case "img_next": {
                this.nextPage(currentPage, allCount, pageSize);
                break;
            }
            case "img_last": {
                this.lastPage(currentPage, allCount, pageSize);
                break;
            }
            case "btnok": {
                this.setReturnData();
                break;
            }
        }
    }

    public void nextPage(int currentPage, int allCount, int pageSize) {
        int allPage = allCount / pageSize + 1;
        if (allCount % pageSize == 0) {
            --allPage;
        }
        if (currentPage + 1 <= allPage) {
            this.getModel().setValue("pageinput", (Object)(currentPage + 1));
        }
    }

    public void prePage(int currentPage, int allCount, int pageSize) {
        if (currentPage > 1) {
            this.getModel().setValue("pageinput", (Object)(currentPage - 1));
        }
    }

    public void firstPage(int currentPage, int allCount, int pageSize) {
        if (currentPage > 1) {
            this.getModel().setValue("pageinput", (Object)1);
        }
    }

    public void lastPage(int currentPage, int allCount, int pageSize) {
        int allPage = allCount / pageSize + 1;
        if (allCount % pageSize == 0) {
            --allPage;
        }
        if (currentPage < allPage) {
            this.getModel().setValue("pageinput", (Object)allPage);
        }
    }

    public void pageTurn(int newPageNum) {
        List searchMatchMemb;
        int pageSize = Integer.parseInt((String)this.getModel().getValue("page_size_select"));
        String cacheStr = this.getPageCache().get("searchMatch");
        if (cacheStr != null && !(searchMatchMemb = (List)SerializationUtils.deSerializeFromBase64((String)cacheStr)).isEmpty()) {
            IDataModel dataModel = this.getModel();
            dataModel.deleteEntryData(this.entryKey);
            int sub = searchMatchMemb.size() - newPageNum * pageSize;
            int membCounts = sub < 0 ? pageSize + sub : pageSize;
            dataModel.batchCreateNewEntryRow(this.entryKey, membCounts);
            DynamicObject row = null;
            DimMembPermTreeNode memb = null;
            String idFile = this.entryKey + "_id";
            String nameFile = this.entryKey + "_name";
            String numberFile = this.entryKey + "_number";
            String storageFile = this.entryKey + "_storagetype";
            int beginIndex = (newPageNum - 1) * pageSize;
            List<Long> selectMembIds = this.getSelectedMembIds();
            ArrayList<Integer> rowNums = new ArrayList<Integer>();
            for (int i = 0; i < membCounts; ++i) {
                row = dataModel.getEntryRowEntity(this.entryKey, i);
                memb = (DimMembPermTreeNode)searchMatchMemb.get(beginIndex + i);
                if (selectMembIds.contains(memb.getMembId())) {
                    rowNums.add(i);
                }
                row.set(idFile, (Object)memb.getMembId());
                row.set(nameFile, (Object)memb.getMembName());
                row.set(numberFile, (Object)memb.getMembNumber());
                row.set(storageFile, memb.getCustomData().get("storageType"));
            }
            this.getView().updateView(this.entryKey);
            if (rowNums.size() > 0) {
                int[] rowIndexs = new int[rowNums.size()];
                for (int i = 0; i < rowNums.size(); ++i) {
                    rowIndexs[i] = (Integer)rowNums.get(i);
                }
                EntryGrid entryGrid = (EntryGrid)this.getControl(this.entryKey);
                entryGrid.selectRows(rowIndexs, rowIndexs[0]);
            }
            this.getPageCache().put("currentPage", String.valueOf(newPageNum));
        }
    }

    public void refleshRightList(boolean selectLeftMemb) {
        TreeView treeView = this.getLeftTreeControl();
        String leftNodeId = treeView.getTreeState().getFocusNodeId();
        boolean isAll = (Boolean)this.getModel().getValue("getall");
        String searchKey = this.getPageCache().get("searchField");
        DimMembPermTreeNode allMemb = this.getCacheMemb();
        if (allMemb == null) {
            return;
        }
        DimMembPermTreeNode leftNode = allMemb.getChildNodeByNodeId(Long.valueOf(leftNodeId));
        ArrayList<DimMembPermTreeNode> listMemb = new ArrayList<DimMembPermTreeNode>();
        if (!isAll) {
            leftNode.iterate(1, child -> {
                if (!child.isEnable()) {
                    listMemb.add((DimMembPermTreeNode)child);
                }
            });
        } else {
            leftNode.iterate(20, child -> {
                if (!child.isEnable()) {
                    listMemb.add((DimMembPermTreeNode)child);
                }
            });
        }
        if (searchKey != null && searchKey.trim().length() > 0) {
            String searchFile = searchKey.trim();
            listMemb.removeIf(child -> !child.getMembName().contains(searchFile) && !child.getMembNumber().contains(searchFile));
        }
        int pageSize = Integer.parseInt((String)this.getModel().getValue("page_size_select"));
        int allMembCount = listMemb.size();
        int maxSize = allMembCount / pageSize + 1;
        if (allMembCount % pageSize == 0) {
            --maxSize;
        }
        this.initPagePanel(allMembCount, maxSize);
        IDataModel iDataModel = this.getModel();
        iDataModel.deleteEntryData(this.entryKey);
        if (allMembCount > 0) {
            iDataModel.batchCreateNewEntryRow(this.entryKey, pageSize < allMembCount ? pageSize : allMembCount);
            DynamicObject row = null;
            DimMembPermTreeNode memb = null;
            List<Long> selectMembIds = null;
            if (!this.isMulti && selectLeftMemb) {
                selectMembIds = new ArrayList<Long>();
                selectMembIds.add(Long.parseLong(leftNodeId));
            } else {
                selectMembIds = this.getSelectedMembIds();
            }
            ArrayList<Integer> rowNums = new ArrayList<Integer>();
            String idFile = this.entryKey + "_id";
            String nameFile = this.entryKey + "_name";
            String numberFile = this.entryKey + "_number";
            String storageFile = this.entryKey + "_storagetype";
            for (int rowIndex = 0; rowIndex < pageSize && rowIndex < allMembCount; ++rowIndex) {
                row = iDataModel.getEntryRowEntity(this.entryKey, rowIndex);
                memb = (DimMembPermTreeNode)listMemb.get(rowIndex);
                if (selectMembIds.contains(memb.getMembId())) {
                    rowNums.add(rowIndex);
                }
                row.set(idFile, (Object)memb.getMembId());
                row.set(nameFile, (Object)memb.getMembName());
                row.set(numberFile, (Object)memb.getMembNumber());
                row.set(storageFile, memb.getCustomData().get("storageType"));
            }
            this.getView().updateView(this.entryKey);
            if (rowNums.size() > 0) {
                int[] rowIndexs = new int[rowNums.size()];
                for (int i = 0; i < rowNums.size(); ++i) {
                    rowIndexs[i] = (Integer)rowNums.get(i);
                }
                EntryGrid entryGrid = (EntryGrid)this.getControl(this.entryKey);
                entryGrid.selectRows(rowIndexs, rowIndexs[0]);
            }
            if (!this.isMulti && selectLeftMemb) {
                if (rowNums.isEmpty()) {
                    selectMembIds.clear();
                }
                this.cacheSelectedMembIds(selectMembIds);
            }
        }
        this.getPageCache().put("searchMatch", SerializationUtils.serializeToBase64(listMemb));
        this.getPageCache().put("currentPage", "1");
        this.getPageCache().put("allCount", String.valueOf(listMemb.size()));
    }

    public DimMembPermTreeNode getCacheMemb() {
        DimMembPermTreeNode allMembs = null;
        String cacheStr = this.getPageCache().get("allMember");
        if (cacheStr != null) {
            allMembs = (DimMembPermTreeNode)SerializationUtils.deSerializeFromBase64((String)cacheStr);
        }
        return allMembs;
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void afterBindData(EventObject e) {
        Label _title;
        super.afterBindData(e);
        if (this.getPageCache().get("firsttime") == null) {
            List<Long> selectIds = this.getSelectedMembIds();
            this.selectRowsOnEntity(selectIds);
            this.getPageCache().put("firsttime", "true");
        }
        Long modelId = this.getModelId();
        String dimNumber = this.getDimensionNum();
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", (Object)modelId);
        builder.add("number", "=", (Object)dimNumber);
        DynamicObject dimension = QueryServiceHelper.queryOne((String)"epm_dimension", (String)"id, name, number", (QFilter[])builder.toArray());
        if (dimension != null && (_title = (Label)this.getControl("title")) != null) {
            _title.setText(dimension.getString("name"));
        }
    }

    public void initPagePanel(int allSize, int maxSize) {
        int pageSize = Integer.parseInt((String)this.getModel().getValue("page_size_select"));
        int pageNum = allSize / pageSize + 1;
        if (allSize % pageSize == 0) {
            --pageNum;
        }
        this.getPageCache().put("isinit", "true");
        this.getModel().setValue("allpage", (Object)pageNum);
        this.getModel().setValue("pageinput", (Object)1);
        this.updatePageSize(maxSize);
    }

    public void updatePageSize(int maxSize) {
        FieldAp fieldAp = new FieldAp();
        fieldAp.setKey("pageinput");
        IntegerField field = new IntegerField();
        field.setKey("pageinput");
        fieldAp.setField((Field)field);
        field.setDataScope("[1," + maxSize + "]");
        this.getView().updateControlMetadata(fieldAp.getKey(), fieldAp.createControl());
    }

    public Set<Long> getNoPermMembIdCache() {
        Set membIds = null;
        String cacheStr = this.getPageCache().get("NoPermMembIdCache");
        membIds = cacheStr == null ? new HashSet() : (Set)SerializationUtils.deSerializeFromBase64((String)cacheStr);
        return membIds;
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String currentNodeId = evt.getNodeId().toString();
        TreeNode root = this.getLeftTreeCache();
        TreeNode currentNode = root.getTreeNode(currentNodeId, 20);
        if (currentNode.getChildren() != null && currentNode.getChildren().isEmpty()) {
            this.expandLeftTreeNode(currentNodeId, true);
        }
        this.refleshRightList(true);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
    }

    public void queryTreeNodeChildren(TreeNodeEvent treeNodeEvent) {
        String leftTreeNodeId = (String)treeNodeEvent.getNodeId();
        this.cacheLeftNodeId(leftTreeNodeId);
        this.expandLeftTreeNode(leftTreeNodeId, false);
    }

    public void expandLeftTreeNode(String leftTreeNodeId, boolean needFocus) {
        TreeNode root = this.getLeftTreeCache();
        TreeNode currentNode = root.getTreeNode(leftTreeNodeId, 20);
        DimMembPermTreeNode allMember = this.getCacheMemb();
        List childMembs = allMember.getChildNodeByNodeId(Long.valueOf(leftTreeNodeId)).getChilds();
        if (childMembs.size() > 0) {
            TreeNode node = null;
            for (DimMembPermTreeNode childNode : childMembs) {
                node = new TreeNode();
                node.setId(childNode.getMembId().toString());
                node.setText(childNode.getMembName());
                node.setParentid(leftTreeNodeId);
                if (!childNode.getChilds().isEmpty()) {
                    node.setChildren(new ArrayList());
                }
                currentNode.addChild(node);
            }
            TreeView treeView = this.getLeftTreeControl();
            treeView.addNode(currentNode);
            treeView.updateNode(currentNode);
            if (needFocus) {
                treeView.focusNode(currentNode);
            }
            treeView.expand(currentNode.getId());
            this.cacheLeftTree(root);
        }
    }

    public String getDimensionNum() {
        ListShowParameter showParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String dimNum = (String)showParameter.getCustomParam("dimensionNum");
        return dimNum;
    }

    public Long getModelId() {
        ListShowParameter showParameter = (ListShowParameter)this.getView().getFormShowParameter();
        Object model = showParameter.getCustomParam("model");
        if (model == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u4f53\u7cfb\u5931\u8d25", (String)"EbCustomF7Plugin_0", (String)"epm-eb-budget", (Object[])new Object[0]));
        }
        Long modelId = model instanceof String ? Long.valueOf((String)model) : (Long)model;
        return modelId;
    }

    public TreeNode getLeftTreeCache() {
        String cacheStr = this.getPageCache().get("LeftTreeCache");
        if (cacheStr == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5de6\u6811\u7f13\u5b58\u5931\u8d25", (String)"EbCustomF7Plugin_2", (String)"epm-eb-budget", (Object[])new Object[0]));
        }
        TreeNode leftTreeNode = (TreeNode)SerializationUtils.deSerializeFromBase64((String)cacheStr);
        return leftTreeNode;
    }

    public void cacheLeftTree(TreeNode leftTreeRoot) {
        this.getPageCache().put("LeftTreeCache", SerializationUtils.serializeToBase64((Object)leftTreeRoot));
    }

    public String getCacheLeftNodeId() {
        String leftNodeId = this.getPageCache().get("CacheLeftNodeId");
        return leftNodeId;
    }

    public void cacheLeftNodeId(String leftTreeNodeId) {
        this.getPageCache().put("CacheLeftNodeId", leftTreeNodeId);
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        TreeNode leftRoot = this.getLeftTreeCache();
        this.getLeftTreeControl().focusNode(leftRoot);
        this.getPageCache().put("searchField", searchEnterEvent.getText());
        this.refleshRightList(false);
    }

    public void RemoveClick(F7SelectedListRemoveEvent f7SelectedListRemoveEvent) {
        Object param = f7SelectedListRemoveEvent.getParam();
        this.removeSelectRow(param);
    }

    public void removeSelectRow(Object membId) {
        List<Long> selectMembs = this.getSelectedMembIds();
        if (membId == null) {
            selectMembs.clear();
        } else {
            Long id = membId instanceof String ? Long.valueOf((String)membId) : (Long)membId;
            selectMembs.remove(id);
        }
        this.selectRowsOnEntity(selectMembs);
        this.cacheSelectedMembIds(selectMembs);
    }

    public void selectRowsOnEntity(List<Long> selectMembs) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(this.entryKey);
        DynamicObjectCollection rows = this.getModel().getEntryEntity(this.entryKey);
        if (selectMembs.size() > 0) {
            ArrayList<Integer> rowNums = new ArrayList<Integer>();
            for (DynamicObject row : rows) {
                if (!selectMembs.contains(row.getLong(this.entryKey + "_id"))) continue;
                rowNums.add(row.getInt("seq") - 1);
            }
            if (rowNums.size() > 0) {
                int[] rowIndexs = new int[rowNums.size()];
                for (int i = 0; i < rowNums.size(); ++i) {
                    rowIndexs[i] = (Integer)rowNums.get(i);
                }
                entryGrid.selectRows(rowIndexs, rowIndexs[0]);
            }
        } else {
            entryGrid.clearEntryState();
        }
    }
}

