/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.ebApproveFlow;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.budget.formplugin.ebApproveFlow.ApproveBill;
import kd.epm.eb.budget.formplugin.ebApproveFlow.ApproveCommon;
import kd.epm.eb.budget.formplugin.util.CodeRuleUtil;
import kd.epm.eb.common.ebcommon.common.Pair;
import kd.epm.eb.common.ebcommon.common.enums.RangeEnum;
import kd.epm.eb.common.ebcommon.common.enums.dimension.SysDimensionEnum;
import kd.epm.eb.common.ebcommon.common.util.EBApproveTempPojo;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;
import kd.epm.eb.common.ebcommon.common.util.QFBuilder;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UserUtils;

public class ApproveBillAutoCreate {
    private static final String CON_MAPFIELD_YEAR = "Year";
    private static final String CON_MAPFIELD_PERIOD = "Period";
    private static final String CON_MAPFIELD_VERSTION = "Version";
    private static final String CON_BEGIN = "begin";
    private static final String CON_END = "end";
    private static final String CON_PRE = "dim_";
    private Pattern pattern = Pattern.compile("[0-9]*?$");

    public Object[] createApproveBillAuto(List<ApproveBill> approveBills) {
        Object[] obj = null;
        if (approveBills == null) {
            return obj;
        }
        List<DynamicObject> needSaveReportDatas = this.getNeedSaveReportData(approveBills);
        if (needSaveReportDatas.size() > 0) {
            obj = SaveServiceHelper.save((IDataEntityType)needSaveReportDatas.get(0).getDataEntityType(), (Object[])needSaveReportDatas.toArray(new Object[0]));
        }
        ArrayList<DynamicObject> needSaveDatas = new ArrayList<DynamicObject>();
        for (ApproveBill approveBill : approveBills) {
            DynamicObject billData;
            if (!this.isCheckOk(approveBill) || (billData = this.setSaveBillValue(approveBill)) == null) continue;
            needSaveDatas.add(billData);
        }
        if (needSaveDatas.size() > 0) {
            obj = SaveServiceHelper.save((IDataEntityType)((DynamicObject)needSaveDatas.get(0)).getDataEntityType(), (Object[])needSaveDatas.toArray(new Object[0]));
        }
        return obj;
    }

    private List<DynamicObject> getNeedSaveReportData(List<ApproveBill> approveBills) {
        ArrayList<DynamicObject> saveDynamicObjects = new ArrayList<DynamicObject>(16);
        for (ApproveBill approveBill : approveBills) {
            long modelId = approveBill.getModelId();
            Map<String, String> dimformMap = ApproveCommon.getDimFormID(modelId);
            DynamicObject year = ApproveCommon.cacheMembDynamicObject(dimformMap.get(SysDimensionEnum.Year.getNumber()), ApproveCommon.getCommonFilter(approveBill.getModelId(), approveBill.getDimYearBegin()));
            Long yearId = year.getLong("id");
            DynamicObject period = ApproveCommon.cacheMembDynamicObject(dimformMap.get(SysDimensionEnum.Period.getNumber()), ApproveCommon.getCommonFilter(approveBill.getModelId(), approveBill.getDimPeriodBegin()));
            Long periodId = period.getLong("id");
            for (Map.Entry<Long, Long> longLongEntry : approveBill.getTemplateTaskProcessId().entrySet()) {
                List<Long> listFromScop;
                Long templateId = longLongEntry.getKey();
                Map<String, List<EBApproveTempPojo>> tempPojoMap = this.getTempPojoFromMap(approveBill);
                if (tempPojoMap == null || (listFromScop = ApproveCommon.getListMemberFromScope(tempPojoMap.get("dim_entity"), modelId)) == null) continue;
                DynamicObjectCollection entities = QueryServiceHelper.query((String)"eb_reportentity", (String)"entity.id", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId), new QFilter("template", "=", (Object)templateId), new QFilter("entity", "in", listFromScop), new QFilter("period", "=", (Object)periodId), new QFilter("fyear", "=", (Object)yearId), new QFilter("version", "=", (Object)IDUtils.toLong((Object)approveBill.getDimVersionID())), new QFilter("currency", "=", (Object)approveBill.getDimCurrencyID())});
                List entityList = entities.stream().map(e -> e.getLong("entity.id")).collect(Collectors.toList());
                listFromScop.removeAll(entityList);
                DynamicObject templateInfo = QueryServiceHelper.queryOne((String)"eb_templateentity_bg", (String)"rptdata, rptspreadjson", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)templateId)});
                for (Long entity : listFromScop) {
                    DynamicObject reportEntity = BusinessDataServiceHelper.newDynamicObject((String)"eb_reportentity");
                    reportEntity.set("model", (Object)modelId);
                    reportEntity.set("version", (Object)approveBill.getDimVersionID());
                    reportEntity.set("fyear", (Object)yearId);
                    reportEntity.set("period", (Object)periodId);
                    reportEntity.set("entity", (Object)entity);
                    reportEntity.set("scene", (Object)approveBill.getDimScenarioID());
                    reportEntity.set("currency", (Object)approveBill.getDimCurrencyID());
                    reportEntity.set("template", (Object)templateId);
                    reportEntity.set("reporttype", (Object)"1");
                    reportEntity.set("reportstatus", (Object)"B");
                    reportEntity.set("spreadjson", (Object)templateInfo.getString("rptspreadjson"));
                    reportEntity.set("data", (Object)templateInfo.getString("rptdata"));
                    reportEntity.set("creator", (Object)UserUtils.getUserId());
                    reportEntity.set("createtime", (Object)TimeServiceHelper.now());
                    reportEntity.set("modifier", (Object)UserUtils.getUserId());
                    reportEntity.set("modifytime", (Object)TimeServiceHelper.now());
                    saveDynamicObjects.add(reportEntity);
                }
            }
        }
        return saveDynamicObjects;
    }

    private boolean isCheckOk(ApproveBill approveBill) {
        if (approveBill.getModelId() == 0L || approveBill.getEbOrgId() == 0L) {
            return false;
        }
        return approveBill.getTemplateDimMapWithScope() != null && approveBill.getTemplateDimMapWithScope().size() != 0;
    }

    private DynamicObject setSaveBillValue(ApproveBill approveBill) {
        Map<String, String> yearBeginEndNumberMap = this.getDimBeginEndNumberMap(CON_MAPFIELD_YEAR, approveBill);
        Map<String, String> periodBeginEndNumberMap = this.getDimBeginEndNumberMap(CON_MAPFIELD_PERIOD, approveBill);
        DynamicObject billData = BusinessDataServiceHelper.newDynamicObject((String)"bcm_eb_approvebill");
        billData.set("modelid", (Object)approveBill.getModelId());
        billData.set("eborgid", (Object)approveBill.getEbOrgId());
        billData.set("dim_datatype", (Object)approveBill.getDimDataType());
        Map<String, List<EBApproveTempPojo>> tempPojoMap = this.getTempPojoFromMap(approveBill);
        billData.set("dimensionjson", (Object)SerializationUtils.serializeToBase64(tempPojoMap));
        if (tempPojoMap != null) {
            this.getTempEntry(approveBill, billData, tempPojoMap);
        }
        String number = CodeRuleUtil.getCodeRuleNumber("bcm_eb_approvebill", "createdate");
        Map<String, String> userInfos = this.getUserInfosFromUserId(approveBill.getDepartment());
        if (userInfos == null) {
            return null;
        }
        billData.set("billno", (Object)number);
        billData.set("createrid", (Object)UserUtils.getUserId());
        billData.set("createorgid", (Object)userInfos.get("createorgid"));
        billData.set("department", (Object)userInfos.get("deptid"));
        billData.set("position", (Object)userInfos.get("position"));
        billData.set("createdate", (Object)TimeServiceHelper.now());
        billData.set("eborgmasterid", (Object)this.getOrgMasterId(approveBill));
        billData.set("approveinfo", (Object)approveBill.getApproveBillDescription());
        billData.set("billtype", (Object)"2");
        billData.set("dim_year", (Object)(this.getNumberFromMap(CON_BEGIN, yearBeginEndNumberMap) + "-" + this.getNumberFromMap(CON_END, yearBeginEndNumberMap)));
        billData.set("dim_period", (Object)(this.getNumberFromMap(CON_BEGIN, periodBeginEndNumberMap) + "-" + this.getNumberFromMap(CON_END, periodBeginEndNumberMap)));
        billData.set("dim_version", (Object)approveBill.getDimVersion());
        billData.set("billstatus", (Object)"A");
        billData.set("handler", (Object)UserUtils.getUserId());
        billData.set("dealdate", (Object)TimeServiceHelper.now());
        return billData;
    }

    private Map<String, String> getUserInfosFromUserId(long depid) {
        HashMap<String, String> returns = new HashMap<String, String>(3);
        returns.put("createorgid", "0");
        returns.put("deptid", "0");
        returns.put("position", "");
        Long userid = UserUtils.getUserId();
        QFBuilder qb = new QFBuilder();
        qb.add("id", "=", (Object)userid);
        DynamicObject dy = this.queryDy("bos_user", qb, "id,dpt,entryentity.position ");
        if (dy == null) {
            return returns;
        }
        DynamicObjectCollection companyInfos = dy.getDynamicObjectCollection("entryentity");
        if (companyInfos.isEmpty()) {
            return returns;
        }
        String deptid = String.valueOf(depid);
        returns.put("deptid", String.valueOf(depid));
        String position = "";
        for (DynamicObject dynamicObject : companyInfos) {
            if (Long.valueOf(deptid).compareTo(dynamicObject.getLong("dpt.id")) != 0) continue;
            position = dynamicObject.getString("position");
            break;
        }
        returns.put("position", position);
        Map company = OrgUnitServiceHelper.getCompanyByOrg((Long)depid);
        if (company == null) {
            return returns;
        }
        if (!company.containsKey("id")) {
            return returns;
        }
        if (String.valueOf(company.get("id")).equalsIgnoreCase("null")) {
            return returns;
        }
        returns.put("createorgid", company.get("id").toString());
        return returns;
    }

    private DynamicObject queryDy(String sFormID, QFBuilder qFBuilder, String strSelectFields) {
        return BusinessDataServiceHelper.loadSingle((String)sFormID, (String)strSelectFields, (QFilter[])qFBuilder.toArray());
    }

    private void getTempEntry(ApproveBill approveBill, DynamicObject billData, Map<String, List<EBApproveTempPojo>> tempPojoMap) {
        DynamicObjectCollection entryCollect = billData.getDynamicObjectCollection("entryentity");
        Map<Long, Map<String, List<Pair<String, Integer>>>> entryList = approveBill.getTemplateDimMapWithScope();
        Map<Long, Long> templateTaskProcessId = approveBill.getTemplateTaskProcessId();
        for (Map.Entry<Long, Map<String, List<Pair<String, Integer>>>> e : entryList.entrySet()) {
            Long tempID = e.getKey();
            DynamicObject entry = entryCollect.addNew();
            entry.set("tempid", (Object)tempID);
            entry.set("taskprocessid", (Object)templateTaskProcessId.get(tempID));
            Set<Long> taskprocess = new HashSet<Long>();
            taskprocess.add(templateTaskProcessId.get(tempID));
            if (tempPojoMap != null && tempPojoMap.get("dim_entity") != null & tempPojoMap.get("dim_entity").get(0).getScope() == RangeEnum.VALUE_50.getValue()) {
                taskprocess = this.getTaskProcessIDList(tempPojoMap, approveBill.getModelId(), tempID, templateTaskProcessId.get(tempID));
            }
            entry.set("taskprocessjson", (Object)ObjectSerialUtil.toByteSerialized(taskprocess));
            entry.set("pagedimjson", (Object)ObjectSerialUtil.toByteSerialized(e.getValue()));
        }
    }

    private Set<Long> queryReport(Long reportId, Long tempId) {
        String selectFields = "model.id as fmodelid,fyear.id as ffyid, period.id as fperiodid,scene.id as fsceneid,currency.id as fcurrencyid,entity.id as fentityid,version.id as fversionid";
        QFBuilder qb = new QFBuilder("id", "=", (Object)reportId);
        DynamicObject conditions = QueryServiceHelper.queryOne((String)"eb_reportentity", (String)selectFields, (QFilter[])qb.toArray());
        if (conditions == null) {
            return null;
        }
        HashSet<Long> returns = new HashSet<Long>(16);
        QFBuilder qbs = new QFBuilder("model.id", "=", (Object)conditions.getLong("fmodelid"));
        qbs.add("fyear.id", "=", (Object)conditions.getLong("ffyid"));
        qbs.add("period.id", "=", (Object)conditions.getLong("fperiodid"));
        qbs.add("scene.id", "=", (Object)conditions.getLong("fsceneid"));
        qbs.add("currency.id", "=", (Object)conditions.getLong("fcurrencyid"));
        qbs.add("version.id", "=", (Object)conditions.getLong("fversionid"));
        qbs.add("template.id", "=", (Object)tempId);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"eb_reportentity", (String)" id ", (QFilter[])qbs.toArray(), null);){
            if (dataSet != null) {
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    returns.add(row.getLong("id"));
                }
            }
        }
        return returns;
    }

    private Set<Long> queryTaskByOrg(List<Long> lstOrg, Long tempid, Long modelid, Long reportid) {
        QFBuilder qb = new QFBuilder();
        qb.add("model.id", "=", (Object)modelid);
        qb.add("entity.id", "in", (Object)lstOrg.toArray());
        qb.add("template.id", "=", (Object)tempid);
        Set<Long> reportids = this.queryReport(reportid, tempid);
        if (reportids != null && reportids.size() > 0) {
            qb.add("id", "in", reportids);
        }
        HashSet<Long> taskProcessIds = new HashSet<Long>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"eb_reportentity", (String)"id as taskprocessid, template.id as tempid ", (QFilter[])qb.toArray(), null);){
            if (dataSet != null) {
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    Long taskprocessid = row.getLong("taskprocessid");
                    if (!IDUtils.isNotNull((Long)taskprocessid)) continue;
                    taskProcessIds.add(taskprocessid);
                }
            }
        }
        return taskProcessIds;
    }

    private Set<Long> getTaskProcessIDList(Map<String, List<EBApproveTempPojo>> headDimMap, Long lngModelID, Long tempid, Long reportid) {
        String Entity = "entity";
        String dimKey = CON_PRE + Entity;
        if (headDimMap == null || headDimMap.get(dimKey) == null) {
            return null;
        }
        List<Long> lstFromScop = ApproveCommon.getListMemberFromScope(headDimMap.get(dimKey), lngModelID);
        Set<Long> taskSet = this.queryTaskByOrg(lstFromScop, tempid, lngModelID, reportid);
        return taskSet;
    }

    private DynamicObject getMembDynamic(ApproveBill approveBill, String dimKey) {
        QFBuilder qf = new QFBuilder();
        qf.add("model", "=", (Object)approveBill.getModelId());
        qf.add("id", "=", (Object)approveBill.getEbOrgId());
        return ApproveCommon.cacheMembDynamicObject(dimKey, qf.toArray());
    }

    private DynamicObject getVerMembDynamic(ApproveBill approveBill, String dimKey) {
        QFBuilder qf = new QFBuilder();
        qf.add("model", "=", (Object)approveBill.getModelId());
        qf.add("number", "=", (Object)approveBill.getDimVersion());
        return ApproveCommon.cacheMembDynamicObject(dimKey, qf.toArray());
    }

    private Map<String, List<EBApproveTempPojo>> getTempPojoFromMap(ApproveBill approveBill) {
        Map<Long, Map<String, List<Pair<String, Integer>>>> dimMap = approveBill.getTemplateDimMapWithScope();
        if (dimMap == null || dimMap.size() == 0) {
            return null;
        }
        String Entity = "Entity";
        HashMap<String, List<EBApproveTempPojo>> ebPojoMap = new HashMap<String, List<EBApproveTempPojo>>();
        ArrayList<EBApproveTempPojo> ebPojoLst = new ArrayList<EBApproveTempPojo>();
        Map<String, String> dimformMap = ApproveCommon.getDimFormID(approveBill.getModelId());
        DynamicObject dimObjOrgDim = this.getMembDynamic(approveBill, dimformMap.get(Entity));
        DynamicObject dimObjOrgRoot = ApproveCommon.cacheMembDynamicObject(dimformMap.get(Entity), ApproveCommon.getCommonFilter(approveBill.getModelId(), Entity));
        DynamicObject dimObjVersion = this.getVerMembDynamic(approveBill, dimformMap.get(CON_MAPFIELD_VERSTION));
        EBApproveTempPojo ebPojo = new EBApproveTempPojo();
        ebPojo.setDimensionId(dimObjOrgRoot.getString("dimension_id"));
        ebPojo.setDimension(ApproveCommon.getDimNumber("entity"));
        ebPojo.setDimid(Long.toString(approveBill.getEbOrgId()));
        ebPojo.setDimName(dimObjOrgDim.getString("name"));
        ebPojo.setDimNumber(dimObjOrgDim.getString("number"));
        approveBill.setDimVersion(dimObjVersion.getString("number"));
        if (dimObjOrgDim.getBoolean("isLeaf")) {
            ebPojo.setScope(RangeEnum.VALUE_10.getValue());
        } else {
            ebPojo.setScope(RangeEnum.VALUE_50.getValue());
        }
        ebPojo.setPid("");
        ebPojoLst.add(ebPojo);
        ebPojoMap.put("dim_entity", ebPojoLst);
        return ebPojoMap;
    }

    private String getNumberFromMap(String key, Map<String, String> beginEndNumberMap) {
        if (beginEndNumberMap == null || !beginEndNumberMap.containsKey(key)) {
            return "";
        }
        String res = beginEndNumberMap.get(key);
        Matcher matcher = this.pattern.matcher(res);
        if (matcher.find()) {
            String retStr = matcher.group().length() > 1 ? matcher.group() : "0" + matcher.group();
            return retStr;
        }
        return "";
    }

    private Map<String, String> getBeginEndFieldMap(String strDimKey, ApproveBill approveBill) {
        HashMap<String, String> mapField = new HashMap<String, String>();
        switch (strDimKey) {
            case "Year": {
                mapField.put(CON_BEGIN, approveBill.getDimYearBegin());
                mapField.put(CON_END, StringUtils.isEmpty((String)approveBill.getDimYearEnd()) ? approveBill.getDimYearBegin() : approveBill.getDimYearEnd());
                break;
            }
            case "Period": {
                mapField.put(CON_BEGIN, approveBill.getDimPeriodBegin());
                mapField.put(CON_END, StringUtils.isEmpty((String)approveBill.getDimPeriodEnd()) ? approveBill.getDimPeriodBegin() : approveBill.getDimPeriodEnd());
                break;
            }
            case "Version": {
                mapField.put(CON_BEGIN, approveBill.getDimVersion());
                mapField.put(CON_END, approveBill.getDimVersion());
                break;
            }
        }
        return mapField;
    }

    private Map<String, String> getDimBeginEndNumberMap(String strDimKey, ApproveBill approveBill) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        Map<String, String> mapField = this.getBeginEndFieldMap(strDimKey, approveBill);
        Map<String, String> dimformMap = ApproveCommon.getDimFormID(approveBill.getModelId());
        if (mapField.get(CON_BEGIN) == null) {
            return returnMap;
        }
        DynamicObject dimCache = ApproveCommon.cacheMembDynamicObject(dimformMap.get(strDimKey), ApproveCommon.getCommonFilter(approveBill.getModelId(), mapField.get(CON_BEGIN)));
        List<DynamicObject> lstMem = ApproveCommon.getListMember(approveBill.getModelId(), strDimKey, dimCache.getString("number"), 10);
        for (DynamicObject member : lstMem) {
            if (member.getLong("id") > 0L && member.getString("number").equalsIgnoreCase(mapField.get(CON_BEGIN))) {
                returnMap.put(CON_BEGIN, member.getString("number"));
            }
            if (member.getLong("id") <= 0L || !member.getString("number").equalsIgnoreCase(mapField.get(CON_END))) continue;
            returnMap.put(CON_END, member.getString("number"));
        }
        return returnMap;
    }

    private Long getOrgMasterId(ApproveBill approveBill) {
        String strSelectFields;
        if (approveBill.getEborgMasterId() > 0L) {
            return approveBill.getEborgMasterId();
        }
        QFilter qFilter = this.getFilter(approveBill);
        DynamicObject dy = this.getDy("epm_entitymembertree", qFilter, strSelectFields = this.getSelectFields("epm_entitymembertree"));
        if (dy == null) {
            return 0L;
        }
        return dy.getLong("owner.id");
    }

    private DynamicObject getDy(String sFormID, QFilter qFilter, String strSelectFields) {
        return QueryServiceHelper.queryOne((String)sFormID, (String)strSelectFields, (QFilter[])new QFilter[]{qFilter});
    }

    private QFilter getFilter(ApproveBill approveBill) {
        Long modelID = approveBill.getModelId();
        Long orgID = approveBill.getEbOrgId();
        QFilter qFilter = new QFilter("model", "=", (Object)modelID);
        qFilter = qFilter.and(new QFilter("id", "=", (Object)orgID));
        return qFilter;
    }

    private String getSelectFields(String key) {
        String strSelect = null;
        switch (key) {
            case "epm_entitymembertree": {
                strSelect = "id,owner ";
                break;
            }
        }
        return strSelect;
    }
}

