/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.ebApproveFlow;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.AttachmentView;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Image;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.session.EncreptSessionUtils;
import kd.bos.url.UrlService;
import kd.epm.eb.budget.formplugin.AbstractBaseFormPlugin;
import kd.epm.eb.budget.formplugin.ebApproveFlow.ApproveBill;
import kd.epm.eb.budget.formplugin.ebApproveFlow.ApproveBillShowRpt;
import kd.epm.eb.budget.formplugin.ebApproveFlow.ApproveCommon;
import kd.epm.eb.common.ebcommon.common.Pair;
import kd.epm.eb.common.ebcommon.common.enums.DimTypesEnum;
import kd.epm.eb.common.ebcommon.common.enums.RangeEnum;
import kd.epm.eb.common.ebcommon.common.util.EBApproveTempPojo;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;
import kd.epm.eb.common.ebcommon.common.util.QFBuilder;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;

public class ApproveBillEditPlugin
extends AbstractBaseFormPlugin
implements ClickListener,
BeforeF7SelectListener,
CellClickListener,
RowClickEventListener {
    private static final String CON_CTL_DIMORG = "dim_entity";
    private static final String CON_CTL_DIMDATATYPE = "dim_datatype";
    private static final String CON_CTL_EBORG = "eborgid";
    private static final String CON_CTL_DIMENSTIONJSON = "dimensionjson";
    private static final String CON_CTL_CREATERID = "createrid";
    private static final String CON_CTL_BTNSAVE = "bnt_save";
    private static final String CON_CTL_BTNSUBMIT = "btn_submit";
    private static final String CON_CTL_BTNAUDIT = "btn_audit";
    private static final String CON_CTL_TEMPID = "tempid";
    private static final String CON_CTL_TEMPTYPENAME = "temptypename";
    private static final String CON_VERSION = "version";
    private static final String CON_NUMBER = "number";
    private static final String CON_CACHE_DATATYPE = "cachedatatype";
    private static final String CON_CACHE_RETURNDATA = "returnDataMessage";
    private static final String CON_LANGEUAGE = "epm-eb-budget";
    private static final String ENTRYENTITY = "entryentity";
    private static final String ENTRYENTITY1 = "entryentity1";
    private static final String CON_MODEL = "modelId";
    private static final String PREVIEW = "preview";
    private static final String DOWNLOAD = "download";
    protected static final List<String> InitHidedimsion = Lists.newArrayList((Object[])new String[]{"dim_changetype", "dim_audittrail", "dim_userdefind1", "dim_userdefind2", "dim_userdefind3", "dim_userdefind4", "dim_userdefind5", "dim_userdefind6"});

    @Override
    public Long getModelId() {
        Long modelId = IDUtils.toLong((Object)this.getPageCache().get("modelid"));
        if (IDUtils.isNull((Long)modelId)) {
            DynamicObject model = (DynamicObject)this.getModel().getValue(CON_MODEL);
            modelId = model.getLong("id");
        }
        return modelId;
    }

    private void checkEBPerm1(String opkey) {
        DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"EPMPermissionService", (String)"checkPermission", (Object[])new Object[]{this.getModelId(), UserUtils.getUserId(), AppMetadataCache.getAppInfo((String)this.getBizAppId()).getId(), this.getView().getEntityId(), opkey});
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        this.checkEBPerm1(evt.getItemKey());
    }

    private void updataUserInfoShow() {
        IDataModel dataModel = this.getModel();
        DynamicObject user = (DynamicObject)dataModel.getValue(CON_CTL_CREATERID);
        Image pic = (Image)this.getControl("userpic");
        if (user != null) {
            Long userId = user.getLong("id");
            ArrayList<Long> userIds = new ArrayList<Long>();
            userIds.add(userId);
            Map userPics = UserServiceHelper.getUserAvatarPath(userIds, (boolean)true);
            pic.setUrl((String)userPics.get(userId));
        }
        this.getView().updateView("userpic");
    }

    @Override
    public void registerListener(EventObject e) {
        EntryGrid grid1;
        super.registerListener(e);
        this.addClickListeners(ApproveCommon.SetAlldimsionValue(ApproveCommon.Alldimsion));
        this.addItemClickListeners(new String[]{"toolbarap", "advcontoolbarap"});
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        if (grid != null) {
            grid.addCellClickListener((CellClickListener)this);
            grid.addRowClickListener((RowClickEventListener)this);
        }
        if ((grid1 = (EntryGrid)this.getView().getControl(ENTRYENTITY1)) != null) {
            grid1.addCellClickListener((CellClickListener)this);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String opType = ((FormOperate)afterDoOperationEventArgs.getSource()).getType();
        if (opType.equalsIgnoreCase("save") || opType.equalsIgnoreCase("submit") || opType.equalsIgnoreCase("unsubmit") || opType.equalsIgnoreCase("close")) {
            this.getModel().setDataChanged(false);
            this.changeItemStatusByFormType();
        }
    }

    public void cellClick(CellClickEvent cellClickEvent) {
        String fieldKey = cellClickEvent.getFieldKey();
        if (PREVIEW.equals(fieldKey)) {
            if (this.previewOrDownload(cellClickEvent, true)) {
                return;
            }
        } else if (DOWNLOAD.equals(fieldKey)) {
            if (this.previewOrDownload(cellClickEvent, false)) {
                return;
            }
        } else if ("viewrpt".equals(fieldKey)) {
            new ApproveBillShowRpt().showReport(this.getView(), this.getModel(), true);
        } else if ("viewpagedim".equals(fieldKey)) {
            this.viewPageDimCellClick(cellClickEvent);
        }
    }

    private void viewPageDimCellClick(CellClickEvent cellClickEvent) {
        DynamicObject tempid = (DynamicObject)this.getModel().getValue(CON_CTL_TEMPID, cellClickEvent.getRow());
        DynamicObject modelid = (DynamicObject)this.getModel().getValue(CON_MODEL);
        String viewpagedim = (String)this.getModel().getValue("pagedimjson", cellClickEvent.getRow());
        String taskprocessjson = (String)this.getModel().getValue("taskprocessjson", cellClickEvent.getRow());
        if (taskprocessjson == null) {
            return;
        }
        Set tasks = (Set)ObjectSerialUtil.deSerializedBytes((String)taskprocessjson);
        HashMap<String, String> templateName = new HashMap<String, String>();
        templateName.put(tempid.get("id").toString(), tempid.getString("name"));
        ApproveBill bill = new ApproveBill();
        if (tasks != null && tasks.size() > 0) {
            Object taskProcessObj = tasks.iterator().next();
            Long taskProcessId = 0L;
            if (taskProcessObj != null && StringUtils.isNotEmpty((String)taskProcessObj.toString())) {
                taskProcessId = IDUtils.toLong((Object)taskProcessObj.toString());
            }
            bill.setTaskProcessId(taskProcessId);
        }
        bill.setDimVersion((String)this.getModel().getValue("dim_version"));
        QFBuilder qf = new QFBuilder();
        qf.add("model", "=", (Object)modelid.getLong("id"));
        qf.add(CON_NUMBER, "=", (Object)bill.getDimVersion());
        DynamicObject verDynamicObject = ApproveCommon.cacheMembDynamicObject(SysDimensionEnum.Version.getMemberTreemodel(), qf.toArray());
        bill.setDimVersionID(verDynamicObject.getString("id"));
        HashMap<Long, Long> templateTaskProcessId = new HashMap<Long, Long>();
        templateTaskProcessId.put(tempid.getLong("id"), bill.getTaskProcessId());
        if (StringUtils.isEmpty((String)viewpagedim)) {
            return;
        }
        Map row = (Map)ObjectSerialUtil.deSerializedBytes((String)viewpagedim);
        HashMap<Long, Map<String, List<Pair<String, Integer>>>> dimInfo = new HashMap<Long, Map<String, List<Pair<String, Integer>>>>();
        dimInfo.put(tempid.getLong("id"), row);
        bill.setTemplateDimMapWithScope(dimInfo);
        bill.setEbOrgId(Long.parseLong(((DynamicObject)this.getModel().getValue(CON_CTL_EBORG)).get("id").toString()));
        this.showDimRangeSelect(modelid.get("id").toString(), bill, templateTaskProcessId, templateName);
    }

    private boolean previewOrDownload(CellClickEvent cellClickEvent, boolean isPreview) {
        EntryGrid grid = (EntryGrid)cellClickEvent.getSource();
        int index = grid.getSelectRows()[0];
        DynamicObjectCollection attachments = this.getModel().getEntryEntity(ENTRYENTITY1);
        if (attachments == null) {
            return true;
        }
        DynamicObject attachment = (DynamicObject)attachments.get(index);
        String url = attachment.getString("file_url");
        String attachmentFullUrl = EncreptSessionUtils.encryptSession((String)UrlService.getAttachmentFullUrl((String)URLEncoder.encode(url)));
        attachmentFullUrl = isPreview ? attachmentFullUrl.replace("download.do", "preview.do") : attachmentFullUrl.replace("preview.do", "download.do");
        if (!attachmentFullUrl.contains("&kdedcba=")) {
            attachmentFullUrl = EncreptSessionUtils.encryptSession((String)attachmentFullUrl);
        }
        attachmentFullUrl = attachmentFullUrl + "&fId=eb_reportattachment_copy";
        String resutlt = AttachmentView.sendGet((String)attachmentFullUrl, (String)null);
        try {
            JSONObject resultMap = (JSONObject)JSON.parse((String)resutlt);
            if (resultMap != null && "error".equals(resultMap.get((Object)"status"))) {
                this.getView().showTipNotification(resultMap.get((Object)"description").toString());
                return true;
            }
            if (resultMap != null && "success".equals(resultMap.get((Object)"status"))) {
                attachmentFullUrl = resultMap.get((Object)"url").toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getView().openUrl(attachmentFullUrl);
        return false;
    }

    private void changeItemStatusByFormType() {
        String billStatus = (String)this.getModel().getValue("billstatus");
        boolean bolEnable = billStatus != null && !billStatus.equals("A");
        this.getView().setEnable(Boolean.valueOf(!bolEnable), new String[]{CON_CTL_BTNSAVE, CON_CTL_BTNSUBMIT, CON_CTL_BTNAUDIT});
        if (billStatus != null && billStatus.equals("B")) {
            this.getView().setEnable(Boolean.TRUE, new String[]{CON_CTL_BTNAUDIT});
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        this.setModelTempToPageChache();
        this.fillDataToPage(e);
        this.updataUserInfoShow();
        this.resetTempleTypeName();
        this.loadDataAttachments(((BillShowParameter)((BillView)e.getSource()).getFormShowParameter()).getPkId());
        this.getModel().setDataChanged(false);
    }

    private void loadDataAttachments(Object billId) {
        Object ftaskprocessjson;
        String sql = "select ftaskprocessjson from t_eb_ebapprovebillentry where fid=" + billId;
        HashSet reportIds = new HashSet(16);
        try (DataSet ds = DB.queryDataSet((String)"", (DBRoute)DBRoute.of((String)"epm"), (String)sql, null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                ftaskprocessjson = row.getString("ftaskprocessjson");
                if (StringUtils.isEmpty((String)ftaskprocessjson)) continue;
                for (String reportId : ((String)ftaskprocessjson).split(",")) {
                    if (!StringUtils.isNotEmpty((String)reportId)) continue;
                    reportIds.addAll((Collection)ObjectSerialUtil.deSerializedBytes((String)reportId));
                }
            }
        }
        if (reportIds.isEmpty()) {
            return;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid from t_eb_reportattachment where ", new Object[0]);
        sqlBuilder.appendIn("ftaskproid", IDUtils.toLongs(reportIds).toArray(new Object[0]));
        HashSet<String> attachmentIds = new HashSet<String>(16);
        DataSet ds = DB.queryDataSet((String)"", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
        ftaskprocessjson = null;
        try {
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                attachmentIds.add(row.getString("fid"));
            }
        }
        catch (Throwable row) {
            ftaskprocessjson = row;
            throw row;
        }
        finally {
            if (ds != null) {
                if (ftaskprocessjson != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable row) {
                        ((Throwable)ftaskprocessjson).addSuppressed(row);
                    }
                } else {
                    ds.close();
                }
            }
        }
        QFilter qfs = new QFilter("fbilltype", "=", (Object)"eb_reportattachment_copy");
        qfs.and("fattachmentpanel", "=", (Object)"attachmentpanelap");
        qfs.and("finterid", "in", attachmentIds);
        String selectFields = "fattachmentname,fextname,fcreatetime,ffileid,fdescription,fattachmentsize,fcreatemen.name";
        DynamicObjectCollection attachments = QueryServiceHelper.query((String)"bos_attachment", (String)selectFields, (QFilter[])qfs.toArray());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (attachments != null && attachments.size() > 0) {
            int[] rows = this.getModel().batchCreateNewEntryRow(ENTRYENTITY1, attachments.size());
            for (int i = 0; i < rows.length; ++i) {
                DynamicObject dynamicObject = this.getModel().getEntryRowEntity(ENTRYENTITY1, rows[i]);
                dynamicObject.set("file_name", (Object)(((DynamicObject)attachments.get(i)).getString("fattachmentname") + "(" + ((DynamicObject)attachments.get(i)).getInt("fattachmentsize") / 1024 + "KB)"));
                dynamicObject.set("file_creator", (Object)((DynamicObject)attachments.get(i)).getString("fcreatemen.name"));
                try {
                    dynamicObject.set("file_createtime", (Object)sdf.format(((DynamicObject)attachments.get(i)).getDate("fcreatetime")));
                }
                catch (Exception e) {
                    dynamicObject.set("file_createtime", (Object)"");
                }
                dynamicObject.set("file_description", (Object)((DynamicObject)attachments.get(i)).getString("fdescription"));
                dynamicObject.set("file_type", (Object)((DynamicObject)attachments.get(i)).getString("fextname"));
                dynamicObject.set("file_url", (Object)((DynamicObject)attachments.get(i)).getString("ffileid"));
            }
            this.getView().updateView(ENTRYENTITY1);
        }
    }

    private void resetTempleTypeName() {
        IDataModel dataModel = this.getModel();
        DynamicObjectCollection templateInfos = dataModel.getDataEntity().getDynamicObjectCollection(ENTRYENTITY);
        if (templateInfos.size() > 0) {
            for (DynamicObject templateInfo : templateInfos) {
                DynamicObject template = (DynamicObject)templateInfo.get(CON_CTL_TEMPID);
                if (template == null) continue;
                String tempType = template.getString("templatetype");
                String tempTypeName = this.getTempleTypeName(tempType);
                templateInfo.set(CON_CTL_TEMPTYPENAME, (Object)tempTypeName);
            }
        }
    }

    private String getTempleTypeName(String type) {
        String name = "";
        if ("0".equalsIgnoreCase(type)) {
            name = ResManager.loadKDString((String)"\u56fa\u5b9a\u6a21\u677f", (String)"ApproveBillEditPlugin_4", (String)CON_LANGEUAGE, (Object[])new Object[0]);
        } else if ("1".equalsIgnoreCase(type)) {
            name = ResManager.loadKDString((String)"\u6d6e\u52a8\u6a21\u677f", (String)"ApproveBillEditPlugin_5", (String)CON_LANGEUAGE, (Object[])new Object[0]);
        } else if ("2".equalsIgnoreCase(type)) {
            name = ResManager.loadKDString((String)"\u5de5\u4f5c\u5e95\u7a3f\u6a21\u677f", (String)"ApproveBillEditPlugin_6", (String)CON_LANGEUAGE, (Object[])new Object[0]);
        }
        return name;
    }

    private void showDimRangeSelect(String modelId, ApproveBill currReportInfo, Map<Long, Long> templateTaskProcessId, Map<String, String> templateName) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("eb_dimrangeselect");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam(CON_MODEL, (Object)modelId);
        parameter.setCustomParam("templateName", templateName);
        parameter.setCustomParam("currReportInfo", (Object)ObjectSerialUtil.toByteSerialized((Object)currReportInfo));
        parameter.setCustomParam("templateTaskProcessId", (Object)ObjectSerialUtil.toByteSerialized(templateTaskProcessId));
        this.getView().showForm(parameter);
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("btn_viewtplreport".equals(itemKey)) {
            new ApproveBillShowRpt().showReport(this.getView(), this.getModel(), true);
        }
    }

    @Override
    public void click(EventObject evt) {
        String buttonkey;
        super.click(evt);
        String dimkey = buttonkey = ((Control)evt.getSource()).getKey();
        if (CON_CTL_EBORG.contains(buttonkey)) {
            dimkey = CON_CTL_DIMORG;
        }
        if (ApproveCommon.Alldimsion.contains(dimkey)) {
            this.addSelectInfoToChache(buttonkey);
            this.openDimensionPage(dimkey, buttonkey);
        }
    }

    private void setModelTempToPageChache() {
        if (this.getModel().getValue("modelid") != null) {
            this.getPageCache().put("modelid", ((DynamicObject)this.getModel().getValue("modelid")).getString("id"));
        } else {
            this.getModel().setValue("modelid", (Object)this.getPageCache().get("modelid"));
        }
    }

    private void openDimensionPage(String dimension, String buttonkey) {
        FormShowParameter para = new FormShowParameter();
        String subdimension = dimension.substring(4, dimension.length());
        DynamicObject clickDimension = this.getClickDimension(subdimension);
        HashMap<String, String> params = new HashMap<String, String>();
        if (clickDimension == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u76f8\u5173\u7ef4\u5ea6\uff0c\u8bf7\u786e\u5b9a\u662f\u5426\u8bbe\u7f6e\u4e86\u7ec4\u7ec7\u3002", (String)"ApproveBillEditPlugin_9", (String)CON_LANGEUAGE, (Object[])new Object[0]));
            return;
        }
        params.put("sign", buttonkey);
        para.setFormId("eb_mulmemberf7base_tem");
        if (subdimension.equalsIgnoreCase(DimTypesEnum.INTERCOMPANY.getNumber())) {
            para.setFormId("eb_mulmemberf7_tem_ic");
        }
        params.put("dimension", clickDimension.getInt("dseq") + "");
        para.setCustomParams(params);
        this.getPageCache().put("KEY_MODEL_ID", this.getPageCache().get("modelid"));
        para.setCaption(ResManager.loadResFormat((String)"\u6210\u5458\u9009\u62e9 - %1", (String)"ApproveBillEditPlugin_10", (String)CON_LANGEUAGE, (Object[])new Object[]{clickDimension.getString("name")}));
        para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, buttonkey));
        para.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(para);
    }

    private DynamicObject getClickDimension(String dimensionNumber) {
        DynamicObjectCollection dimension = ApproveCommon.getIntiDimension(Long.valueOf(this.getPageCache().get("modelid")));
        for (DynamicObject doc : dimension) {
            if (!doc.getString(CON_NUMBER).equalsIgnoreCase(dimensionNumber)) continue;
            return doc;
        }
        return null;
    }

    private void setJsonCache(String strValue) {
        this.getPageCache().put(CON_CACHE_RETURNDATA, strValue);
        this.getModel().setValue(CON_CTL_DIMENSTIONJSON, (Object)strValue);
    }

    private void addSelectInfoToChache(String buttonkey) {
        Map returnDataMap = null;
        if (this.getPageCache().get(CON_CACHE_RETURNDATA) == null) {
            return;
        }
        returnDataMap = (Map)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get(CON_CACHE_RETURNDATA));
        if (returnDataMap.get(buttonkey) != null) {
            ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
            this.setReturnDataToList((List)returnDataMap.get(buttonkey), list);
            this.getPageCache().put(buttonkey, SerializationUtils.toJsonString(list));
        } else {
            this.getPageCache().put(buttonkey, null);
        }
    }

    private void setReturnDataToList(List<EBApproveTempPojo> EBApproveTempPojos, List<Map<String, String>> list) {
        for (EBApproveTempPojo a : EBApproveTempPojos) {
            HashMap<String, String> messageMap = new HashMap<String, String>();
            messageMap.put("id", a.getDimid());
            messageMap.put("scope", a.getScope() + "");
            messageMap.put(CON_NUMBER, a.getDimNumber());
            messageMap.put("name", a.getDimName());
            messageMap.put("pid", "");
            list.add(messageMap);
        }
    }

    private void fillDataToPage(EventObject e) {
        Object pkid = ((BillShowParameter)((BillView)e.getSource()).getFormShowParameter()).getPkId();
        this.getBillAndFilldimension(pkid.toString());
    }

    private void getBillAndFilldimension(String billId) {
        DynamicObject doc = BusinessDataServiceHelper.loadSingle((String)"bcm_eb_approvebill", (String)CON_CTL_DIMENSTIONJSON, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)IDUtils.toLong((Object)billId))});
        if (doc != null) {
            this.fillDimensionRangAndValue(doc, CON_CTL_DIMENSTIONJSON);
        }
    }

    private void setDataTypeControlFilter(List<EBApproveTempPojo> lstScope) {
        List<Long> idfilter = ApproveCommon.getListMemberFromScope(lstScope, Long.valueOf(this.getPageCache().get("modelid")));
        BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl(CON_CTL_DIMDATATYPE);
        basedataEdit.setQFilter(new QFilter("id", "in", idfilter));
        this.getPageCache().put(CON_CACHE_DATATYPE, SerializationUtils.toJsonString(lstScope));
    }

    private void fillDimensionRangAndValue(DynamicObject doc, String jsonField) {
        String saveDimension = doc.getString(jsonField);
        if (saveDimension == null || saveDimension.trim().length() == 0) {
            return;
        }
        Map dimMap = (Map)SerializationUtils.deSerializeFromBase64((String)saveDimension);
        String[] defaultDimesion = new String[dimMap.size()];
        int i = 0;
        for (Map.Entry dimKey : dimMap.entrySet()) {
            String dim = ((String)dimKey.getKey()).toLowerCase(Locale.getDefault());
            if (!ApproveCommon.Alldimsion.contains(dim)) continue;
            if (dim.equalsIgnoreCase(CON_CTL_DIMDATATYPE)) {
                this.setDataTypeControlFilter((List)dimKey.getValue());
                continue;
            }
            String text = null;
            List map = (List)dimKey.getValue();
            if (dim.startsWith("dim_userdefind")) {
                TextEdit textEdit = (TextEdit)this.getControl(dim);
                textEdit.setCaption(new LocaleString(((EBApproveTempPojo)map.get(0)).getDimensionName()));
            }
            for (EBApproveTempPojo EBApproveTempPojo2 : map) {
                if (text == null) {
                    text = ResManager.loadResFormat((String)"%1\u7684%2", (String)"ApproveBillEditPlugin_11", (String)CON_LANGEUAGE, (Object[])new Object[]{EBApproveTempPojo2.getDimName(), RangeEnum.getRangeByVal((int)EBApproveTempPojo2.getScope()).getName()});
                    continue;
                }
                text = ResManager.loadResFormat((String)"%1,%2\u7684%3", (String)"ApproveBillEditPlugin_12", (String)CON_LANGEUAGE, (Object[])new Object[]{text, EBApproveTempPojo2.getDimName(), RangeEnum.getRangeByVal((int)EBApproveTempPojo2.getScope()).getName()});
            }
            this.getModel().setValue(dim, text);
            defaultDimesion[i] = ((EBApproveTempPojo)map.get(0)).getDimensionId();
            ++i;
        }
        this.setJsonCache(SerializationUtils.serializeToBase64((Object)dimMap));
    }

    public void cellDoubleClick(CellClickEvent var1) {
    }
}

