/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.ebApproveFlow;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListView;
import kd.bos.org.utils.DynamicObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordGroup;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordItem;
import kd.bos.workflow.engine.task.TaskInfo;
import kd.epm.eb.budget.formplugin.ebApproveFlow.filterContainerModelListPlugin;
import kd.epm.eb.budget.formplugin.util.UserSelectUtil;
import kd.epm.eb.business.utils.WorkFlowUtil;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.ebBusiness.serviceHelper.MemberPermHelper;

public class ApproveBillListPlugin
extends filterContainerModelListPlugin
implements ClickListener,
BeforeF7SelectListener {
    private static final Set<String> noCheckPermBTN = Sets.newHashSet((Object[])new String[]{"btn_close", "btn_refresh", "btn_viewflow"});

    @Override
    public void initialize() {
        super.initialize();
        this.modelFilterKey = "modelid.name";
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (this.strErrInfo != null && this.strErrInfo.length() > 0) {
            this.getView().showErrorNotification(this.strErrInfo);
        }
    }

    @Override
    public Long getModelId() {
        Long modelId = 0L;
        String modelCache = this.getPageCache().get("permmodelId");
        if (StringUtils.isEmpty((CharSequence)modelCache) || (Long)this.deSerializedBytes(modelCache) == 0L) {
            DynamicObject[] load;
            BillList billlist = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billlist.getSelectedRows();
            if (selectedRows == null || selectedRows.size() == 0) {
                return modelId;
            }
            Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
            if (primaryKeyValues == null || primaryKeyValues.length == 0) {
                return modelId;
            }
            for (DynamicObject doc : load = (DynamicObject[])BusinessDataServiceHelper.load((Object[])primaryKeyValues, (IDataEntityType)BusinessDataServiceHelper.newDynamicObject((String)"bcm_eb_approvebill").getDataEntityType())) {
                modelId = doc.getLong("modelid.id");
            }
        } else {
            modelId = (Long)this.deSerializedBytes(modelCache);
        }
        return modelId;
    }

    @Override
    public String getBizAppId() {
        return this.getView().getFormShowParameter().getAppId();
    }

    @Override
    public void setFilter(SetFilterEvent e) {
        DynamicObject[] modelList = this.queryHasPremModel();
        this.modelIdSet = this.getPermModelIdSet(modelList);
        this.doLog("modelIdSet:" + this.modelIdSet.toString());
        e.getQFilters().add(new QFilter("modelid", "in", (Object)this.modelIdSet));
        this.doLog("e.getQFilters:" + e.getQFilters().toString());
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int arg0, int arg1) {
                long t1 = System.currentTimeMillis();
                DynamicObjectCollection collection = super.getData(arg0, arg1);
                ArrayList pkId = new ArrayList();
                collection.forEach(v -> pkId.add(String.valueOf(v.getPkValue())));
                if (pkId.size() > 0) {
                    try {
                        ApproveBillListPlugin.this.setNextAuditor(collection, pkId);
                    }
                    catch (Exception e) {
                        ApproveBillListPlugin.this.doLog(ResManager.loadResFormat((String)"%1\u8bbe\u7f6e\u5ba1\u6279\u4eba\u65f6\u51fa\u73b0\u5f02\u5e38", (String)"ApproveBillListPlugin_0", (String)"epm-eb-budget", (Object[])new Object[]{"ErWorkFlowFlexListForOtherPlugin >>>>> "}));
                    }
                }
                long t2 = System.currentTimeMillis();
                ApproveBillListPlugin.this.doLog(ResManager.loadResFormat((String)"\u5ba1\u6838\u4eba\u6570\u636e\u52a0\u8f7dB \u7528\u65f6\uff1a %1ms", (String)"ApproveBillListPlugin_1", (String)"epm-eb-budget", (Object[])new Object[]{t2 - t1}));
                return collection;
            }
        });
    }

    private void setNextAuditor(DynamicObjectCollection collection, List<String> pkId) {
        Map<String, String> auditorsNameMap = this.getNextAuditor(pkId);
        for (DynamicObject doc : collection) {
            String pkIdTemp = String.valueOf(doc.getPkValue());
            try {
                if (auditorsNameMap.get(pkIdTemp) == null) continue;
                doc.set("handlertext", (Object)auditorsNameMap.get(pkIdTemp));
            }
            catch (Exception e) {
                this.doLog(ResManager.loadKDString((String)"\u4e0b\u4e00\u6b65\u5ba1\u6279\u4eba\u5b57\u6bb5\u5728\u5217\u8868\u4e2d\u4e0d\u5b58\u5728", (String)"ApproveBillListPlugin_2", (String)"epm-eb-budget", (Object[])new Object[0]));
            }
        }
    }

    private Map<String, String> getNextAuditor(List<String> pkIds) {
        HashMap<String, String> nodeMap = new HashMap<String, String>();
        String[] ids = new String[pkIds.size()];
        pkIds.toArray(ids);
        Map allPro = WorkflowServiceHelper.getBizProcessStatus((String[])ids);
        for (Map.Entry entry : allPro.entrySet()) {
            String pkid = (String)entry.getKey();
            ((List)entry.getValue()).forEach(e -> {
                String nodeStr = e.getCurrentNodeName();
                String auditor = e.getParticipantName();
                if (auditor != null && !"".equals(auditor.trim())) {
                    nodeStr = nodeStr + " / " + auditor;
                }
                nodeMap.put(pkid, nodeStr);
            });
        }
        return nodeMap;
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent var1) {
    }

    @Override
    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        Long modelId;
        super.filterContainerSearchClick(args);
        Object modelFilter = args.getSearchClickEvent().getFilterValue("modelid.id");
        if (modelFilter == null) {
            modelId = 0L;
        } else {
            modelId = (Long)modelFilter;
            UserSelectUtil.saveUserSelectWhenModelChange(this.getView(), modelId.toString());
        }
        this.getPageCache().put("permmodelId", this.toByteSerialized(modelId));
    }

    private void checkEBPerm(String opkey) {
        IFormView view = this.getView();
        String source = this.getView().getEntityId();
        if (view instanceof ListView && "bos_list".equals(source)) {
            source = ((ListView)view).getBillFormId();
        } else if (view instanceof ListView && "bos_templatetreelist".equals(source)) {
            source = ((ListView)view).getBillFormId();
        } else if (view instanceof ListView && "bos_treelist".equals(source)) {
            source = ((ListView)view).getBillFormId();
        }
        DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"EPMPermissionService", (String)"checkPermission", (Object[])new Object[]{this.getModelId(), UserUtils.getUserId(), AppMetadataCache.getAppInfo((String)this.getBizAppId()).getId(), source, opkey});
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if (noCheckPermBTN.contains(itemKey)) {
            return;
        }
        Map<String, String> selectBillIds = this.getSelectBillInfos();
        if (selectBillIds == null || selectBillIds.size() == 0) {
            evt.setCancel(true);
            return;
        }
        this.checkEBPerm(evt.getItemKey());
        switch (itemKey) {
            case "btn_audit": {
                evt.setCancel(this.openApprovePage());
            }
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String opkey;
        super.itemClick(evt);
        switch (opkey = evt.getItemKey()) {
            case "btn_unaudit": {
                this.unAuditBill();
            }
        }
    }

    private boolean openApprovePage() {
        Map<String, String> selectBillIds = this.getSelectBillInfos();
        if (selectBillIds == null || selectBillIds.size() == 0) {
            return true;
        }
        if (selectBillIds.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"ApproveBillListPlugin_3", (String)"epm-eb-budget", (Object[])new Object[0]));
            return true;
        }
        String billId = selectBillIds.entrySet().iterator().next().getKey();
        String status = this.getBillStatus(billId);
        if (!"B".equals(status)) {
            if ("A".equals(status)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u672a\u5728\u6d41\u7a0b\u4e2d\u4e0d\u80fd\u5ba1\u6838\u3002", (String)"ApproveBillListPlugin_4", (String)"epm-eb-budget", (Object[])new Object[0]));
            } else if ("E".equals(status)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u5ba1\u6838\u5df2\u7ecf\u5904\u4e8e\u5ba1\u6838\u901a\u8fc7\u72b6\u6001\u7684\u5355\u636e\u3002", (String)"ApproveBillListPlugin_5", (String)"epm-eb-budget", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5ba1\u6838\u5df2\u63d0\u4ea4\u72b6\u6001\u7684\u5355\u636e\u3002", (String)"ApproveBillListPlugin_6", (String)"epm-eb-budget", (Object[])new Object[0]));
            }
            return true;
        }
        long userId = this.getUserId();
        Long taskId = WorkflowServiceHelper.getTaskIdByBusinessKeyAndUserId((String)billId, (Long)userId);
        if (taskId == null || taskId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u4e0d\u80fd\u5ba1\u6279\u8be5\u5355\u636e\u3002", (String)"ApproveBillListPlugin_7", (String)"epm-eb-budget", (Object[])new Object[0]));
            return true;
        }
        TaskInfo taskInfo = WorkflowServiceHelper.findTaskById((Long)taskId);
        if (taskInfo == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u5ba1\u6279\u4efb\u52a1\u5931\u8d25\u3002", (String)"ApproveBillListPlugin_8", (String)"epm-eb-budget", (Object[])new Object[0]));
            return true;
        }
        FormShowParameter parameter = new FormShowParameter();
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("taskId", taskId);
        customParams.put("type", "toHandle");
        parameter.setCustomParams(customParams);
        parameter.setFormId(taskInfo.getProcessingPage());
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "afterAudit"));
        this.getView().showForm(parameter);
        return false;
    }

    private String getBillStatus(String billId) {
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)ConvertUtils.toLong((Object)billId), (String)"bcm_eb_approvebill");
        if (bill == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u627e\u5ba1\u6279\u5355\u636e\u5931\u8d25\uff0c\u53ef\u80fd\u5355\u636e\u5df2\u7ecf\u5220\u9664\u3002", (String)"ApproveBillListPlugin_9", (String)"epm-eb-budget", (Object[])new Object[0]));
        }
        return bill.getString("billstatus");
    }

    private void unAuditBill() {
        Map<String, String> selectBillInfos = this.getSelectBillInfos();
        if (selectBillInfos == null || selectBillInfos.size() == 0) {
            return;
        }
        HashSet selectBillIds = new HashSet(16);
        selectBillInfos.forEach((key, value) -> selectBillIds.add(IDUtils.toLong((Object)key)));
        int selSize = selectBillIds.size();
        ArrayList<String> errMessage = new ArrayList<String>(16);
        ArrayList<String> unAuditId = new ArrayList<String>(16);
        boolean isModelAdmin = this.isModelAdmin(String.valueOf(this.getModelId()));
        Map bills = BusinessDataServiceHelper.loadFromCache((Object[])selectBillIds.toArray(), (String)"bcm_eb_approvebill");
        for (Map.Entry<String, String> selectBill : selectBillInfos.entrySet()) {
            DynamicObject bill = (DynamicObject)bills.get(ConvertUtils.toLong((Object)selectBill.getKey()));
            if (bill == null) {
                errMessage.add(ResManager.loadResFormat((String)"%1\uff1a\u67e5\u627e\u5ba1\u6279\u5355\u636e\u5931\u8d25\uff0c\u53ef\u80fd\u5355\u636e\u5df2\u7ecf\u5220\u9664\u3002", (String)"ApproveBillListPlugin_10", (String)"epm-eb-budget", (Object[])new Object[]{selectBill.getValue()}));
                continue;
            }
            String billStatus = bill.getString("billstatus");
            if (!"E".equals(billStatus)) {
                errMessage.add(ResManager.loadResFormat((String)"%1\uff1a\u53ea\u80fd\u53cd\u5ba1\u6838\u5ba1\u6279\u901a\u8fc7\u7684\u62a5\u8868\u5355\u636e\u3002", (String)"ApproveBillListPlugin_11", (String)"epm-eb-budget", (Object[])new Object[]{selectBill.getValue()}));
                continue;
            }
            if (!isModelAdmin && !this.isApproveUser(selectBill.getKey())) {
                errMessage.add(ResManager.loadResFormat((String)"%1\uff1a\u53ea\u80fd\u53cd\u5ba1\u6838\u81ea\u5df1\u5ba1\u6838\u7684\u5355\u636e\u3002", (String)"ApproveBillListPlugin_17", (String)"epm-eb-budget", (Object[])new Object[]{selectBill.getValue()}));
                continue;
            }
            unAuditId.add(selectBill.getKey());
        }
        List<String> successBills = this.changeBillStatus(unAuditId, bills, errMessage, selectBillInfos);
        int errSize = errMessage.size();
        String title = ResManager.loadResFormat((String)"\u5171%1\u6761\u5355\u636e\uff0c\u53cd\u5ba1\u6838\u6210\u529f%2\u6761\uff0c\u5931\u8d25%3\u6761", (String)"ApproveBillListPlugin_12", (String)"epm-eb-budget", (Object[])new Object[]{selSize, selSize - errSize, errSize});
        String tipMessage = "";
        if (successBills.size() != 0) {
            String sucBills = successBills.stream().map(selectBillInfos::get).collect(Collectors.joining("\u3001", "", "\uff1a"));
            tipMessage = ResManager.loadResFormat((String)"%1\u6210\u529f\u4fe1\u606f\uff1a", (String)"ApproveBillListPlugin_13", (String)"epm-eb-budget", (Object[])new Object[]{tipMessage}) + "\n" + ResManager.loadResFormat((String)"%1\u53cd\u5ba1\u6838\u6210\u529f", (String)"ApproveBillListPlugin_21", (String)"epm-eb-budget", (Object[])new Object[]{sucBills}) + "\n\n";
        }
        if (errSize != 0) {
            tipMessage = ResManager.loadResFormat((String)"%1\u9519\u8bef\u4fe1\u606f\uff1a\n%2", (String)"ApproveBillListPlugin_14", (String)"epm-eb-budget", (Object[])new Object[]{tipMessage, String.join((CharSequence)"\n", errMessage)});
        }
        if (selSize == 1) {
            if (successBills.size() > 0) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u6210\u529f", (String)"ApproveBillListPlugin_18", (String)"epm-eb-budget", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification((String)errMessage.get(0));
            }
        } else {
            this.showOperationResult(title, tipMessage);
        }
        if (successBills.size() > 0) {
            this.refreshBillList();
        }
    }

    private boolean isApproveUser(String key) {
        long usrId = this.getUserId();
        List allApprovalRecord = WorkFlowUtil.getAllApprovalRecord((String)key);
        for (IApprovalRecordGroup approvalRecord : allApprovalRecord) {
            List children = approvalRecord.getChildren();
            for (IApprovalRecordItem child : children) {
                Long userId;
                String activityName = child.getActivityName();
                if (activityName.contains(ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"ApproveBillListPlugin_19", (String)"epm-eb-budget", (Object[])new Object[0])) || (userId = child.getUserId()) != usrId) continue;
                return true;
            }
        }
        return false;
    }

    private List<String> changeBillStatus(List<String> unAuditIds, Map<Object, DynamicObject> bills, List<String> errMessage, Map<String, String> selectBillInfos) {
        ArrayList<String> successChangeBill = new ArrayList<String>(16);
        if (unAuditIds.size() == 0) {
            return unAuditIds;
        }
        for (String unAuditId : unAuditIds) {
            ArrayList taskProcessIds = new ArrayList(16);
            Long id = ConvertUtils.toLong((Object)unAuditId);
            DynamicObject approveBill = bills.get(id);
            DynamicObject new_Object = BusinessDataServiceHelper.newDynamicObject((String)"bcm_eb_approvebill");
            DynamicObjectUtils.copy((DynamicObject)approveBill, (DynamicObject)new_Object);
            new_Object.set("billstatus", (Object)"A");
            new_Object.set("id", (Object)GlobalIdUtil.genGlobalLongId());
            DynamicObjectCollection entities = approveBill.getDynamicObjectCollection("entryentity");
            if (entities == null || entities.size() == 0) continue;
            entities.forEach(e -> {
                Set tasks;
                String taskProcessJson = e.getString("taskprocessjson");
                if (StringUtils.isNotEmpty((CharSequence)taskProcessJson) && (tasks = (Set)ObjectSerialUtil.deSerializedBytes((String)taskProcessJson)) != null) {
                    taskProcessIds.addAll(tasks);
                }
            });
            Map reports = BusinessDataServiceHelper.loadFromCache((Object[])taskProcessIds.toArray(), (String)"eb_reportentity");
            if (reports != null && reports.size() != 0) {
                reports.forEach((key, value) -> value.set("reportstatus", (Object)"B"));
            }
            TXHandle tx = TX.required((String)"changeBillStatus");
            Throwable throwable = null;
            try {
                try {
                    this.saveDynamicObject(id, reports, new_Object);
                    successChangeBill.add(unAuditId);
                }
                catch (Exception ex) {
                    tx.markRollback();
                    String billNo = selectBillInfos.get(unAuditId);
                    if (errMessage.size() != 0 && errMessage.get(errMessage.size() - 1).contains(billNo)) continue;
                    errMessage.add(ResManager.loadResFormat((String)"%1\uff1a\u66f4\u65b0\u5355\u636e\u72b6\u6001\u5931\u8d25", (String)"ApproveBillListPlugin_15", (String)"epm-eb-budget", (Object[])new Object[]{billNo}));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tx == null) continue;
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                tx.close();
            }
        }
        this.deleteWorkFlowProcess(unAuditIds, selectBillInfos);
        return successChangeBill;
    }

    private void deleteWorkFlowProcess(List<String> keys, Map<String, String> selectBillInfos) {
        ArrayList<String> billNos = new ArrayList<String>(16);
        DynamicObjectCollection executions = QueryServiceHelper.query((String)"wf_execution", (String)"businesskey", (QFilter[])new QFilter[]{new QFilter("businesskey", "in", keys)});
        if (executions != null && executions.size() != 0) {
            for (DynamicObject execution : executions) {
                String businessKey = execution.getString("businesskey");
                try {
                    WorkflowServiceHelper.abandonByBusienssKey((String)businessKey);
                }
                catch (Exception e) {
                    billNos.add(selectBillInfos.get(businessKey));
                }
            }
        } else {
            DeleteServiceHelper.delete((String)"wf_historicalprocesses", (QFilter[])new QFilter[]{new QFilter("businesskey", "in", keys)});
        }
        this.doLog("deleteWorkFlowProcessFail: " + String.join((CharSequence)"\u3001", billNos));
    }

    private void saveDynamicObject(Long id, Map<Object, DynamicObject> reports, DynamicObject new_Object) {
        DeleteServiceHelper.delete((String)"bcm_eb_approvebill", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{new_Object});
        if (reports != null && reports.size() != 0) {
            SaveServiceHelper.save((DynamicObject[])reports.values().toArray(new DynamicObject[0]));
        }
    }

    private void showOperationResult(String title, String errMessage) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_operationresult");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "OperationResult"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("title", (Object)title);
        showParameter.setCustomParam("errorMsg", (Object)errMessage);
        showParameter.setShowTitle(Boolean.FALSE.booleanValue());
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if ("OperationResult".equals(actionId)) {
            this.refreshBillList();
        } else if ("afterAudit".equals(actionId)) {
            this.refreshBillList();
        }
    }

    private void refreshBillList() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.clearSelection();
        billList.refresh();
    }

    private Map<String, String> getSelectBillInfos() {
        HashMap<String, String> billInfos = new HashMap<String, String>(16);
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows == null || selectedRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u884c\u6570\u636e\u3002", (String)"ApproveBillListPlugin_16", (String)"epm-eb-budget", (Object[])new Object[0]));
            return null;
        }
        selectedRows.forEach(e -> billInfos.put(e.getPrimaryKeyValue().toString(), e.getNumber()));
        return billInfos;
    }

    public boolean isModelAdmin(String modelId) {
        return MemberPermHelper.ifUserHasRootPermByModel((long)this.getUserId(), (String)modelId);
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        List filterCol = commonFilterColumns.stream().filter(e -> e.getFieldName().equals("modelid.name")).collect(Collectors.toList());
        if (filterCol == null) {
            return;
        }
        CommonFilterColumn cfc = (CommonFilterColumn)filterCol.get(0);
        String model = UserSelectUtil.getModelIdAfterCreateNewData(this.getView(), "model", false);
        if (StringUtils.isNotEmpty((CharSequence)model)) {
            cfc.setDefaultValue(model);
        } else {
            List defaultValues = cfc.getDefaultValues();
            if (defaultValues != null && defaultValues.size() != 0) {
                model = defaultValues.get(0).toString();
            }
        }
        this.getPageCache().put("permmodelId", kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)model) ? this.toByteSerialized(Long.valueOf(model)) : null);
    }
}

