/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.ebApproveFlow;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.userselect.WholeUserSelect;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.ebcommon.common.enums.dimension.SysDimensionEnum;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;
import kd.epm.eb.common.ebcommon.common.util.QFBuilder;

public class ApproveBillShowRpt {
    private static final Log log = LogFactory.getLog(ApproveBillShowRpt.class);
    private static final String LOGINFO = "epm_showrpt:";
    private static final String ENTRYENTITY = "entryentity";
    private static final String CON_CTL_TEMPID = "tempid";
    private static final String CON_MODEL = "modelId";
    private IFormView formView = null;
    private IDataModel dataModel = null;

    public void showReport(IFormView formView, IDataModel dataModel, boolean isFromTool) {
        this.formView = formView;
        this.dataModel = dataModel;
        Map<String, Object> params = this.getSelectedTplInfo();
        this.showTplReport(isFromTool, params);
    }

    private Map<String, Object> getSelectedTplInfo() {
        HashMap<String, Object> returns = new HashMap<String, Object>(16);
        DynamicObject billObj = this.dataModel.getDataEntity(true);
        DynamicObjectCollection docs = billObj.getDynamicObjectCollection(ENTRYENTITY);
        HashSet<Long> reportIds = new HashSet<Long>(16);
        HashSet<Long> tempids = new HashSet<Long>(16);
        for (DynamicObject doc : docs) {
            DynamicObject template = (DynamicObject)doc.get(CON_CTL_TEMPID);
            tempids.add(template.getLong("id"));
            reportIds.addAll(this.getReportIds(doc));
        }
        if (reportIds.size() == 0) {
            return returns;
        }
        Set<Long> orgids = this.getOrgIds(reportIds);
        WholeUserSelect filterMaps = this.getFilters((Long)reportIds.iterator().next());
        filterMaps.setOrg(Long.valueOf(((DynamicObject)this.dataModel.getValue("eborgid")).get("id").toString()));
        Long modelid = (Long)((DynamicObject)this.dataModel.getValue(CON_MODEL)).get("id");
        Set<Long> orgTreeids = this.getOrgTreeids(modelid, filterMaps.getOrg());
        returns.put("modelid", modelid);
        returns.put("approveReportids", reportIds);
        returns.put("approveTempids", tempids);
        returns.put("approveTreeOrgids", orgTreeids);
        returns.put("approveHeadOrgid", filterMaps.getOrg());
        returns.put("approveEntryOrgids", orgids);
        returns.put("approveFilterMaps", filterMaps);
        returns.put("used", "queryreport");
        returns.put("approve", "1");
        return returns;
    }

    private Set<Long> getOrgTreeids(Long modelid, Long orgid) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelid);
        if (modelCache == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u8be5\u4f53\u7cfbid\u4e0d\u5b58\u5728\u3002%1", (String)"ApproveBillShowRpt_1", (String)"epm-eb-formplugin", (Object[])new Object[]{modelid}));
        }
        Member entityMember = modelCache.getMember(SysDimensionEnum.Entity.getNumber(), Long.valueOf(0L), orgid);
        if (entityMember == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u8be5\u7ec4\u7ec7id\u4e0d\u5b58\u5728\u3002%1", (String)"ApproveBillShowRpt_2", (String)"epm-eb-formplugin", (Object[])new Object[]{orgid}));
        }
        List childrens = modelCache.getChildren(entityMember, true);
        List parants = modelCache.getParents(Long.valueOf(0L), entityMember, true);
        HashSet<Long> returns = new HashSet<Long>(16);
        if (childrens != null) {
            childrens.forEach(e -> returns.add(e.getId()));
        }
        if (parants != null) {
            parants.forEach(e -> returns.add(e.getId()));
        }
        return returns;
    }

    private WholeUserSelect getFilters(Long reportId) {
        WholeUserSelect returns = new WholeUserSelect();
        String selectFields = "model.id as fmodelid,fyear.id as ffyid, period.id as fperiodid,scene.id as fsceneid,currency.id as fcurrencyid,entity.id as fentityid,version.id as fversionid";
        QFBuilder qb = new QFBuilder("id", "=", (Object)reportId);
        DynamicObject conditions = QueryServiceHelper.queryOne((String)"eb_reportentity", (String)selectFields, (QFilter[])qb.toArray());
        if (conditions == null) {
            return returns;
        }
        returns.setCurrency(Long.valueOf(conditions.getLong("fcurrencyid")));
        returns.setModel(Long.valueOf(conditions.getLong("fmodelid")));
        returns.setPeriod(Long.valueOf(conditions.getLong("fperiodid")));
        returns.setScene(Long.valueOf(conditions.getLong("fsceneid")));
        returns.setVersion(Long.valueOf(conditions.getLong("fversionid")));
        returns.setYear(Long.valueOf(conditions.getLong("ffyid")));
        return returns;
    }

    private Set<Long> getOrgIds(Set<Long> reportIds) {
        HashSet<Long> returns = new HashSet<Long>(16);
        if (reportIds == null || reportIds.size() == 0) {
            return returns;
        }
        DynamicObjectCollection reports = QueryServiceHelper.query((String)"eb_reportentity", (String)"entity.id as entityid", (QFilter[])new QFilter[]{new QFilter("id", "in", reportIds)});
        if (reports == null || reports.size() == 0) {
            return returns;
        }
        for (DynamicObject report : reports) {
            returns.add(report.getLong("entityid"));
        }
        return returns;
    }

    private Set<Long> getReportIds(DynamicObject doc) {
        HashSet<Long> reportIds = new HashSet<Long>(16);
        String taskprocessjson = doc.getString("taskprocessjson");
        if (StringUtils.isEmpty((CharSequence)taskprocessjson)) {
            return reportIds;
        }
        Set taskProcesss = (Set)ObjectSerialUtil.deSerializedBytes((String)taskprocessjson);
        if (taskProcesss != null && taskProcesss.size() > 0) {
            taskProcesss.forEach(e -> reportIds.add(Long.valueOf(e.toString())));
        }
        return reportIds;
    }

    private void doLog(String info) {
        log.info(LOGINFO + info);
    }

    private void showTplReport(boolean isFromToolBar, Map<String, Object> params) {
        ListShowParameter formShowParameter = new ListShowParameter();
        formShowParameter.setCustomParams(params);
        formShowParameter.setBillFormId("eb_reportlistentity");
        formShowParameter.setFormId("eb_report_list");
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u5ba1\u6838\u4efb\u52a1", (String)"ApproveBillShowRpt_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        if (isFromToolBar) {
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        } else {
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        }
        IFormView showView = this.formView.getParentView() == null ? this.formView : (this.formView.getParentView().getParentView() == null ? this.formView.getParentView() : this.formView.getParentView().getParentView());
        showView.showForm((FormShowParameter)formShowParameter);
        this.formView.sendFormAction(showView);
    }
}

