/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.ebApproveFlow;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.form.container.TabAp;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.epm.eb.budget.formplugin.ebApproveFlow.ApproveBill;
import kd.epm.eb.budget.formplugin.ebApproveFlow.ApproveBillAutoCreate;
import kd.epm.eb.budget.formplugin.ebApproveFlow.ApproveCommon;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.ebcommon.common.Pair;
import kd.epm.eb.common.ebcommon.common.enums.dimension.SysDimensionEnum;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;
import kd.epm.eb.common.utils.ApproveBill.BasicInfoHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.common.utils.UserUtils;
import org.apache.commons.collections4.map.CaseInsensitiveMap;

public class BgDimRangeSelect
extends AbstractFormPlugin
implements BeforeF7SelectListener,
CellClickListener {
    private static final String CURRENT_TEMPLATE = "CURRENT_TEMPLATE";
    private static final String SET_FIELD_CLASS_NAME = "kd.epm.eb.budget.formplugin.ebApproveFlow.SetFieldUnenable";
    private static final String CUSTOMIZE = "customize";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.updataUserInfoObject();
        this.updataUserInfoShow();
    }

    private void updataUserInfoObject() {
        IDataModel dataModel = this.getModel();
        dataModel.setValue("applier", (Object)UserUtils.getUserId());
        BasicInfoHelper.setFormInfo((IDataModel)dataModel, (IFormView)this.getView(), (boolean)false);
    }

    private void updataUserInfoShow() {
        IDataModel dataModel = this.getModel();
        DynamicObject object = (DynamicObject)dataModel.getValue("applier");
        if (object == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\u3002", (String)"EbAdjustBillEditPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Label label = (Label)this.getControl("appliertag");
        label.setText(object.getString("name"));
        label = (Label)this.getControl("userphone");
        label.setText(object.getString("phone"));
        Image pic = (Image)this.getControl("userpic");
        Long userId = object.getLong("id");
        ArrayList<Long> userIds = new ArrayList<Long>();
        userIds.add(userId);
        Map userPics = UserServiceHelper.getUserAvatarPath(userIds, (boolean)true);
        pic.setUrl((String)userPics.get(userId));
        label = (Label)this.getControl("positiontag");
        label.setText((String)dataModel.getValue("position"));
        label = (Label)this.getControl("companytag");
        object = (DynamicObject)dataModel.getValue("company");
        if (object != null) {
            label.setText(object.getString("name"));
        }
        object = (DynamicObject)dataModel.getValue("department");
        label = (Label)this.getControl("departmenttag");
        if (object != null) {
            label.setText(object.getString("name"));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "switchdept"});
        List<String> dimNumber = this.getAllDim();
        dimNumber.forEach(p -> {
            EntryGrid grid;
            BasedataEdit edit = (BasedataEdit)this.getView().getControl(p);
            if (edit != null) {
                edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            }
            if ((grid = (EntryGrid)this.getView().getControl(p + "entry")) != null) {
                grid.addCellClickListener((CellClickListener)this);
            }
        });
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.addTabSelectListener(p -> this.tabClick(p.getTabKey(), true));
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        FormShowParameter formShowParameter = (FormShowParameter)e.getSource();
        e.getItems().add(this.getTabap(formShowParameter).createControl());
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map<Long, Map<String, List<Pair<String, Integer>>>> templateDimMap = this.getTemplateDimMap();
        this.tabClick(Long.toString((Long)templateDimMap.keySet().toArray()[0]), true);
        if (this.getView().getParentView() != null && "bcm_eb_approvebill".equals(this.getView().getParentView().getEntityId())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"operatepanel"});
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"newrow", "deleterow"});
    }

    private Map<String, String> getNameMap(List<String> dims, Long modelId) {
        CaseInsensitiveMap res = new CaseInsensitiveMap();
        List dimNumber = Arrays.stream(SysDimensionEnum.values()).map(SysDimensionEnum::getNumber).collect(Collectors.toList());
        int current = 1;
        Map<String, String> dimformMap = ApproveCommon.getDimFormID(modelId);
        for (String p : dims) {
            if (dimNumber.contains(p)) {
                res.put((Object)p, (Object)p);
                continue;
            }
            if (current <= 6) {
                DynamicObject cacheDim = ApproveCommon.cacheMembDynamicObject(dimformMap.get(p), ApproveCommon.getCommonFilter(modelId, p));
                res.put((Object)p, (Object)(CUSTOMIZE + current));
                res.put((Object)(CUSTOMIZE + current), (Object)p);
                String key = CUSTOMIZE + current + "flex";
                HashMap<String, String> ctl = new HashMap<String, String>();
                ctl.put("id", key);
                ctl.put("text", (String)new LocaleString(cacheDim.getString("name")));
                ctl.put("type", "flexpanel");
                this.getView().updateControlMetadata(key, ctl);
                ++current;
                continue;
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u7ef4\u5ea6\u8d85\u8fc76\u4e2a\u4e0d\u652f\u6301", (String)"BgDimRangeSelect_0", (String)"epm-eb-budget", (Object[])new Object[0]));
        }
        return res;
    }

    private List<String> getAllDim() {
        ArrayList res = Arrays.stream(SysDimensionEnum.values()).map(SysDimensionEnum::getNumber).collect(Collectors.toCollection(ArrayList::new));
        for (int i = 1; i <= 6; ++i) {
            res.add(CUSTOMIZE + i);
        }
        return res;
    }

    private void setEntryValue(Map<String, String> dimformMap, String dim, Map.Entry<String, List<Pair<String, Integer>>> entry, String finalName, Long modelId, IModelCacheHelper helper) {
        TableValueSetter tableValueSetter = new TableValueSetter(new String[]{finalName.toLowerCase(), finalName.toLowerCase() + "combo", finalName.toLowerCase() + "f7"});
        this.getModel().beginInit();
        for (Pair<String, Integer> number : entry.getValue()) {
            Member member = helper.getMember(dim, null, (String)number.p1);
            tableValueSetter.addRow(new Object[]{member.getId(), ((Integer)number.p2).toString(), member.getName()});
        }
        this.getModel().deleteEntryData(finalName.toLowerCase() + "entry");
        ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow(finalName.toLowerCase() + "entry", tableValueSetter);
        this.getModel().endInit();
        this.getView().updateView(finalName.toLowerCase() + "entry");
    }

    private void showCurrentTemplate(Map<String, List<Pair<String, Integer>>> dimInfo, Long ebOrgId) {
        Long modelId = this.getModelId();
        IModelCacheHelper helper = ModelCacheContext.getOrCreate((Long)modelId);
        Map<String, String> nameMap = this.getNameMap(new ArrayList<String>(dimInfo.keySet()), modelId);
        Map<String, String> dimformMap = ApproveCommon.getDimFormID(modelId);
        this.getPageCache().put("nameMap", ObjectSerialUtil.toByteSerialized(nameMap));
        List<String> dimNumber = this.getAllDim();
        dimNumber.forEach(p -> this.getView().setVisible(Boolean.valueOf(false), new String[]{p.toLowerCase() + "flex"}));
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"entityflex"});
        for (Map.Entry<String, List<Pair<String, Integer>>> entry : dimInfo.entrySet()) {
            String dim = entry.getKey();
            if (entry.getValue() == null || entry.getValue().size() == 0) continue;
            String finalName = nameMap.get(dim);
            if (dim.equalsIgnoreCase("entity")) {
                this.setEntityEntryValue(dim, ebOrgId, finalName, helper);
                continue;
            }
            this.setEntryValue(dimformMap, dim, entry, finalName, modelId, helper);
        }
    }

    private void setEntityEntryValue(String dim, Long ebOrgId, String finalName, IModelCacheHelper helper) {
        Member entityMember = helper.getMember(SysDimensionEnum.Entity.getNumber(), Long.valueOf(0L), ebOrgId);
        if (entityMember == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u8be5\u7ec4\u7ec7id\u4e0d\u5b58\u5728\u3002%1", (String)"ReportListPlugin_45", (String)"epm-eb-budget", (Object[])new Object[]{ebOrgId}));
        }
        TableValueSetter tableValueSetter = new TableValueSetter(new String[]{finalName.toLowerCase(), finalName.toLowerCase() + "combo", finalName.toLowerCase() + "f7"});
        this.getModel().beginInit();
        tableValueSetter.addRow(new Object[]{entityMember.getId(), "50", entityMember.getName()});
        this.getModel().deleteEntryData(finalName.toLowerCase() + "entry");
        ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow(finalName.toLowerCase() + "entry", tableValueSetter);
        this.getModel().endInit();
        this.getView().updateView(finalName.toLowerCase() + "entry");
    }

    private void tabClick(String template, boolean refresh) {
        String beforeTemplate = this.getPageCache().get(CURRENT_TEMPLATE);
        if (StringUtils.isNotBlank((CharSequence)beforeTemplate)) {
            Map<String, List<Pair<String, Integer>>> currentDimRange = this.getCurrentDimRange();
            this.getPageCache().put(beforeTemplate, ObjectSerialUtil.toByteSerialized(currentDimRange));
        }
        this.getPageCache().put(CURRENT_TEMPLATE, template);
        String templateStr = this.getPageCache().get(template);
        ApproveBill approveBill = this.getApproveBill();
        Map templateTaskProcessId = (Map)ObjectSerialUtil.deSerializedBytes((String)((String)this.getView().getFormShowParameter().getCustomParam("templateTaskProcessId")));
        if (templateTaskProcessId == null) {
            return;
        }
        String selectFields = "id,model,fyear,period,period.number periodnumber,entity,template,reportstatus,currency,scene";
        long taskProcessId = (Long)templateTaskProcessId.get(Long.valueOf(template));
        DynamicObject taskList = QueryServiceHelper.queryOne((String)"eb_reportentity", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)taskProcessId)});
        if (taskList == null) {
            return;
        }
        long year = taskList.getLong("fyear");
        String periodNumber = taskList.getString("periodnumber");
        String periodContent = String.format("%s-%s", periodNumber, periodNumber);
        long version = approveBill.getDimVersionID() == null ? 0L : Long.parseLong(approveBill.getDimVersionID());
        long dataType = 0L;
        this.getModel().setValue("baseperiod", (Object)periodContent);
        this.getModel().setItemValueByID("baseyear", (Object)year, 0);
        this.getModel().setItemValueByID("baseversion", (Object)version, 0);
        this.getModel().setItemValueByID("basedatatype", (Object)dataType, 0);
        if (refresh) {
            if (StringUtils.isNotBlank((CharSequence)templateStr)) {
                this.showCurrentTemplate((Map)ObjectSerialUtil.deSerializedBytes((String)templateStr), approveBill.getEbOrgId());
            } else {
                this.showCurrentTemplate(approveBill.getTemplateDimMapWithScope().get(Long.valueOf(template)), approveBill.getEbOrgId());
            }
        }
    }

    private Map<Long, Map<String, List<Pair<String, Integer>>>> getTemplateDimMap() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        ApproveBill billInfp = (ApproveBill)ObjectSerialUtil.deSerializedBytes((String)((String)formShowParameter.getCustomParam("currReportInfo")));
        return billInfp.getTemplateDimMapWithScope();
    }

    private ApproveBill getApproveBill() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        ApproveBill billInfp = (ApproveBill)ObjectSerialUtil.deSerializedBytes((String)((String)formShowParameter.getCustomParam("currReportInfo")));
        return billInfp;
    }

    private Long getModelId() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        return IDUtils.toLong((Object)formShowParameter.getCustomParam("modelId"));
    }

    private TabAp getTabap(FormShowParameter formShowParameter) {
        ApproveBill billInfp = (ApproveBill)ObjectSerialUtil.deSerializedBytes((String)((String)formShowParameter.getCustomParam("currReportInfo")));
        Map<Long, Map<String, List<Pair<String, Integer>>>> templateDimMap = billInfp.getTemplateDimMapWithScope();
        Map templateName = (Map)formShowParameter.getCustomParam("templateName");
        TabAp ap = new TabAp();
        ap.setKey("tabap");
        if (templateDimMap != null && templateDimMap.size() > 0) {
            for (Long template : templateDimMap.keySet()) {
                TabPageAp tabPageAp = new TabPageAp();
                String tabPageId = ((Object)template).toString();
                tabPageAp.setKey(tabPageId);
                tabPageAp.setName(new LocaleString((String)templateName.get(tabPageId)));
                tabPageAp.setGrow(0);
                tabPageAp.setShrink(0);
                tabPageAp.setHeight(new LocaleString("0px"));
                ap.getItems().add(tabPageAp);
            }
        }
        return ap;
    }

    public void afterBindData(EventObject e) {
        OperationResult result;
        super.afterBindData(e);
        if (!this.getView().getFormShowParameter().getCustomParams().containsKey("result")) {
            return;
        }
        String res = (String)this.getView().getFormShowParameter().getCustomParam("result");
        if (StringUtils.isNotBlank((CharSequence)res) && (result = (OperationResult)ObjectSerialUtil.deSerializedBytes((String)res)).getAllErrorInfo().size() > 0) {
            this.getView().showOperationResult(result);
        }
    }

    private Map<String, List<Pair<String, Integer>>> getCurrentDimRange() {
        String template = this.getPageCache().get(CURRENT_TEMPLATE);
        if (StringUtils.isEmpty((CharSequence)template)) {
            return null;
        }
        Map nameMap = (Map)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get("nameMap"));
        Map<Long, Map<String, List<Pair<String, Integer>>>> templateDimMap = this.getTemplateDimMap();
        HashMap<String, List<Pair<String, Integer>>> res = new HashMap<String, List<Pair<String, Integer>>>(templateDimMap.size());
        if (templateDimMap.containsKey(Long.valueOf(template))) {
            Map<String, List<Pair<String, Integer>>> dimInfo = templateDimMap.get(Long.valueOf(template));
            for (Map.Entry<String, List<Pair<String, Integer>>> entry : dimInfo.entrySet()) {
                String dim = entry.getKey();
                String finalName = (String)nameMap.get(dim);
                DynamicObjectCollection members = this.getModel().getEntryEntity(finalName + "entry");
                ArrayList rowInfo = new ArrayList();
                members.forEach(p -> {
                    if (p.get(finalName + ".number") != null) {
                        rowInfo.add(Pair.onePair((Object)p.get(finalName + ".number").toString(), (Object)p.getInt(finalName + "combo")));
                    }
                });
                res.put(dim, rowInfo);
            }
        }
        return res;
    }

    private Map<Long, Map<String, List<Pair<String, Integer>>>> getUserSelectDimInfo() {
        Map<Long, Map<String, List<Pair<String, Integer>>>> templateDimMap = this.getTemplateDimMap();
        HashMap<Long, Map<String, List<Pair<String, Integer>>>> result = new HashMap<Long, Map<String, List<Pair<String, Integer>>>>(templateDimMap.size());
        for (Map.Entry<Long, Map<String, List<Pair<String, Integer>>>> entry : templateDimMap.entrySet()) {
            Long template = entry.getKey();
            String temInfoStr = this.getPageCache().get(template.toString());
            if (StringUtils.isNotBlank((CharSequence)temInfoStr)) {
                Map row = (Map)ObjectSerialUtil.deSerializedBytes((String)temInfoStr);
                result.put(Long.valueOf(template.toString()), row);
                continue;
            }
            result.put(template, entry.getValue());
        }
        return result;
    }

    private boolean checkHasNullDim(Map<Long, Map<String, List<Pair<String, Integer>>>> userSelectDimInfo) {
        if (userSelectDimInfo == null || userSelectDimInfo.size() == 0) {
            return false;
        }
        for (Map.Entry<Long, Map<String, List<Pair<String, Integer>>>> reportSingleEntry : userSelectDimInfo.entrySet()) {
            Map<String, List<Pair<String, Integer>>> reportSingleDims = reportSingleEntry.getValue();
            for (Map.Entry<String, List<Pair<String, Integer>>> reportSingleDimsEntry : reportSingleDims.entrySet()) {
                List<Pair<String, Integer>> dims = reportSingleDimsEntry.getValue();
                if (dims != null && dims.size() != 0) continue;
                return true;
            }
        }
        return false;
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            Map<Long, Map<String, List<Pair<String, Integer>>>> userSelectDimInfo;
            ApproveBillAutoCreate commitHelper = new ApproveBillAutoCreate();
            String modelId = (String)this.getView().getFormShowParameter().getCustomParam("modelId");
            DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"EPMPermissionService", (String)"checkPermission", (Object[])new Object[]{Long.parseLong(modelId), UserUtils.getUserId(), AppMetadataCache.getAppInfo((String)this.getView().getFormShowParameter().getAppId()).getId(), "bcm_eb_approvebill", "btn_submit"});
            this.tabClick(this.getPageCache().get(CURRENT_TEMPLATE), false);
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            ApproveBill currReportInfo = (ApproveBill)ObjectSerialUtil.deSerializedBytes((String)((String)formShowParameter.getCustomParam("currReportInfo")));
            DynamicObject dept = (DynamicObject)this.getModel().getValue("department");
            if (dept != null) {
                currReportInfo.setDepartment(dept.getLong("id"));
            }
            if (this.checkHasNullDim(userSelectDimInfo = this.getUserSelectDimInfo())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u4e3a\u7a7a\u7684\u7ef4\u5ea6\uff0c\u4e0d\u80fd\u63d0\u4ea4\u3002", (String)"BgDimRangeSelect_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            currReportInfo.setTemplateDimMapWithScope(userSelectDimInfo);
            Object[] approveBillIds = commitHelper.createApproveBillAuto(Collections.singletonList(currReportInfo));
            if (approveBillIds != null && approveBillIds.length > 0) {
                MultiLangEnumBridge opName;
                OperateOption op = OperateOption.create();
                op.setVariableValue("currbizappid", "eb");
                OperationResult operationResult = OperationServiceHelper.executeOperate((String)"submit", (String)"bcm_eb_approvebill", (Object[])Arrays.stream(approveBillIds).map(p -> ((DynamicObject)p).get("id")).toArray(), (OperateOption)op);
                if (operationResult.isSuccess()) {
                    opName = new MultiLangEnumBridge("\u62a5\u8868\u63d0\u4ea4", "BgDimRangeSelect_4", "epm-eb-budget");
                    MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u63d0\u4ea4\u6210\u529f", "BgDimRangeSelect_5", "epm-eb-budget");
                    OperationLogUtil.log((String)this.getView().getFormShowParameter().getAppId(), (String)this.getView().getFormShowParameter().getFormId(), null, (String)"submit", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDescription, null);
                    this.getView().returnDataToParent((Object)Boolean.TRUE);
                    this.getView().close();
                } else {
                    this.getView().showOperationResult(operationResult);
                    opName = new MultiLangEnumBridge("\u62a5\u8868\u63d0\u4ea4", "BgDimRangeSelect_4", "epm-eb-budget");
                    ArrayList<String> errInfo = new ArrayList<String>(operationResult.getAllErrorInfo().size());
                    for (OperateErrorInfo operateErrorInfo : operationResult.getAllErrorInfo()) {
                        errInfo.add(operateErrorInfo.getMessage());
                    }
                    MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u63d0\u4ea4\u5931\u8d25:%1$s", "CommitCommand_17", "epm-eb-budget");
                    OperationLogUtil.log((String)this.getView().getFormShowParameter().getAppId(), (String)this.getView().getFormShowParameter().getFormId(), null, (String)"submit", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDescription, (String[])new String[]{String.join((CharSequence)",", ((Object)errInfo).toString())});
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u521b\u5efa\u5ba1\u6279\u5355\u5931\u8d25", (String)"BgDimRangeSelect_2", (String)"epm-eb-budget", (Object[])new Object[0]));
            }
        } else if ("switchdept".equals(key)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setShowTitle(true);
            formShowParameter.setFormId("eb_userdeptlist");
            Object user = this.getModel().getValue("applier");
            Object dept = this.getModel().getValue("department");
            String position = (String)this.getModel().getValue("position");
            if (user instanceof DynamicObject) {
                formShowParameter.setCustomParam("user", (Object)((DynamicObject)user).getString("id"));
                if (dept instanceof DynamicObject) {
                    formShowParameter.setCustomParam("dept.id", (Object)((DynamicObject)dept).getString("id"));
                    if (position != null) {
                        formShowParameter.setCustomParam("position", (Object)position);
                    }
                }
            }
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "switchdept"));
            this.getView().showForm(formShowParameter);
        }
        if (key != null && key.endsWith("f7")) {
            String dimnum = key.replace("entry", "");
            int row = 0;
            String modelId = (String)this.getView().getFormShowParameter().getCustomParam("modelId");
            String pageId = this.getView().getPageId() + key;
            FormShowParameter para = new FormShowParameter();
            if (key.contains("internalcompanyf7")) {
                para.setFormId("eb_mulmemberf7_tem_ic");
            } else {
                para.setFormId("eb_mulmemberf7base_tem");
            }
            para.getOpenStyle().setShowType(ShowType.Modal);
            HashMap<String, String> params = new HashMap<String, String>(2);
            Map nameMap = (Map)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get("nameMap"));
            String finalDimNumber = (String)nameMap.get(dimnum);
            DynamicObject cacheDim = ApproveCommon.cacheMembDynamicObject(dimnum, ApproveCommon.getCommonFilter(Long.valueOf(modelId), finalDimNumber));
            params.put("dimension", cacheDim.get("seq").toString());
            this.getPageCache().put("KEY_MODEL_ID", modelId);
            params.put("sign", finalDimNumber);
            para.setCustomParams(params);
            para.setPageId(pageId);
            para.setCaption(ResManager.loadResFormat((String)"\u6210\u5458\u9009\u62e9 - %1", (String)"BgDimRangeSelect_3", (String)"epm-eb-budget", (Object[])new Object[]{cacheDim.getString("name")}));
            para.addCustPlugin(SET_FIELD_CLASS_NAME);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, dimnum + "-" + row);
            para.setCloseCallBack(closeCallBack);
            this.getView().showForm(para);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("switchdept".equals(actionId)) {
            String data = (String)closedCallBackEvent.getReturnData();
            if (data != null) {
                IDataModel dataModel = this.getModel();
                Map dataMap = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
                BasicInfoHelper.setFormInfo((IDataModel)dataModel, (IFormView)this.getView(), (Map)dataMap);
            }
        } else {
            String[] data = actionId.split("-");
            if (data.length != 2) {
                return;
            }
            String dim = data[0];
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData != null) {
                DynamicObjectCollection doc = (DynamicObjectCollection)closedCallBackEvent.getReturnData();
                Map nameMap = (Map)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get("nameMap"));
                if (doc != null) {
                    ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
                    for (DynamicObject dynamicObject : doc) {
                        HashMap<String, String> map = new HashMap<String, String>(5);
                        map.put("id", dynamicObject.getString("id"));
                        map.put("scope", dynamicObject.getString("scope"));
                        map.put("number", dynamicObject.getString("number"));
                        map.put("name", dynamicObject.getString("name"));
                        map.put("pid", dynamicObject.getString("pid"));
                        list.add(map);
                    }
                    this.getPageCache().put((String)nameMap.get(dim), SerializationUtils.toJsonString(list));
                    this.refreshDim(dim, list);
                }
            }
        }
    }

    private void refreshDim(String dim, List<Map<String, String>> list) {
        this.getModel().deleteEntryData(dim + "entry");
        this.getModel().batchCreateNewEntryRow(dim.toLowerCase() + "entry", list.size());
        int i = 0;
        for (Map<String, String> dimMap : list) {
            this.getModel().setValue(dim.toLowerCase(), (Object)dimMap.get("id"), i);
            DynamicObject object = (DynamicObject)this.getModel().getValue(dim.toLowerCase(), i);
            this.getModel().setValue(dim.toLowerCase() + "f7", (Object)object.getString("name"), i);
            this.getModel().setValue(dim.toLowerCase() + "combo", (Object)dimMap.get("scope"), i);
            ++i;
        }
        this.getView().updateView(dim.toLowerCase() + "entry");
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListShowParameter formShowParameter1 = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        formShowParameter1.setMultiSelect(true);
        ListFilterParameter listFilterParameter = formShowParameter1.getListFilterParameter();
        String key = ((BasedataEdit)beforeF7SelectEvent.getSource()).getKey();
        String template = this.getPageCache().get(CURRENT_TEMPLATE);
        String dimnum = key.replace("f7", "");
        CaseInsensitiveMap nameMap = (CaseInsensitiveMap)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get("nameMap"));
        String number = (String)nameMap.get((Object)dimnum);
        Long modelId = this.getModelId();
        Map<Long, Map<String, List<Pair<String, Integer>>>> templateDimMap = this.getTemplateDimMap();
        List<Pair<String, Integer>> memberNumbers = templateDimMap.get(Long.valueOf(template)).get(number);
        if (memberNumbers.size() > 0) {
            listFilterParameter.getQFilters().add(new QFilter("model", "=", (Object)modelId));
            listFilterParameter.getQFilters().add(new QFilter("id", "in", (Object)IDUtils.toLongs((Object[])memberNumbers.stream().map(p -> (String)p.p1).toArray())));
        } else {
            listFilterParameter.getQFilters().add(new QFilter("1", "=", (Object)2));
        }
        if (key.startsWith(CUSTOMIZE)) {
            listFilterParameter.getQFilters().add(new QFilter("dimension.number", "=", (Object)number));
        }
    }

    public void cellClick(CellClickEvent cellClickEvent) {
        String fieldKey = cellClickEvent.getFieldKey();
        int row = cellClickEvent.getRow();
        if (fieldKey != null && fieldKey.endsWith("f7")) {
            String dimNum = fieldKey.replace("f7", "");
            String modelId = (String)this.getView().getFormShowParameter().getCustomParam("modelId");
            CaseInsensitiveMap nameMap = (CaseInsensitiveMap)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get("nameMap"));
            String number = (String)nameMap.get((Object)dimNum);
            Map<String, String> dimformMap = ApproveCommon.getDimFormID(Long.valueOf(modelId));
            DynamicObject selDim = ApproveCommon.getDimensionByNum(dimformMap.get(number), Long.valueOf(modelId));
            String pageId = this.getView().getPageId() + fieldKey;
            FormShowParameter para = new FormShowParameter();
            if (fieldKey.contains("internalcompanyf7")) {
                para.setFormId("eb_mulmemberf7_tem_ic");
            } else {
                para.setFormId("eb_mulmemberf7base_tem");
            }
            para.getOpenStyle().setShowType(ShowType.Modal);
            HashMap<String, Object> params = new HashMap<String, Object>(2);
            params.put("dimension", selDim.get("dseq").toString());
            this.getPageCache().put("KEY_MODEL_ID", modelId);
            params.put("sign", number);
            Map<Long, Map<String, List<Pair<String, Integer>>>> templateDimMap = this.getTemplateDimMap();
            String currentTemplate = this.getPageCache().get(CURRENT_TEMPLATE);
            if (StringUtils.isNotBlank((CharSequence)currentTemplate)) {
                List<Pair<String, Integer>> dimlst = templateDimMap.get(Long.valueOf(currentTemplate)).get(number);
                ArrayList filter = Lists.newArrayListWithExpectedSize((int)dimlst.size());
                for (int i = 0; i < dimlst.size(); ++i) {
                    Pair<String, Integer> dimPair = dimlst.get(i);
                    Set<String> rangeMembers = ApproveCommon.getMembersByRange(Long.parseLong(modelId), dimformMap.get(number), (String)dimPair.p1, (Integer)dimPair.p2);
                    filter.addAll(rangeMembers);
                }
                params.put("filter", filter);
            }
            para.setCustomParams(params);
            para.setPageId(pageId);
            para.setCaption(ResManager.loadResFormat((String)"\u6210\u5458\u9009\u62e9 - %1", (String)"BgDimRangeSelect_3", (String)"epm-eb-budget", (Object[])new Object[]{selDim.getString("name")}));
            para.addCustPlugin(SET_FIELD_CLASS_NAME);
        }
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }
}

