/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.ebApproveFlow;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.budget.formplugin.ebApproveFlow.ApproveBill;
import kd.epm.eb.budget.formplugin.ebApproveFlow.ApproveCommon;
import kd.epm.eb.budget.formplugin.report.postman.AbstractReportPostman;
import kd.epm.eb.common.ebcommon.common.Pair;
import kd.epm.eb.common.ebcommon.common.enums.dimension.SysDimensionEnum;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.ebBusiness.template.model.TemplateModel;

public class CommitCommand {
    public static final String CURRENT_ORG = "current_org";
    public static final String CURRENT_YEAR = "current_year";
    public static final String CURRENT_PERIOD = "current_period";
    public static final String CURRENT_CURRENCY = "current_currenry";
    public static final String CURRENT_VERSION_ID = "current_version_id";
    public static final String CURRENT_VERSION_NUMBER = "current_version_number";
    public static final String CURRENT_SCENARIO = "current_scenario";
    public static final String CURRENT_REPORT_ID = "current_report_id";
    private String key;
    private IFormPlugin formPlugin;
    private IFormView formView;
    private IPageCache pageCache;
    private static final String DIM_FORM_CLOSE = "DIM_FORM_CLOSE";
    private static int INCLUDE_SELF_AND_CHILDREN = 50;

    public CommitCommand(String key, AbstractFormPlugin formPlugin) {
        this.key = key;
        this.formPlugin = formPlugin;
        this.formView = formPlugin.getView();
        this.pageCache = (IPageCache)this.formView.getService(IPageCache.class);
    }

    public void execute() {
        OperateErrorInfo operateErrorInfo;
        ArrayList<Long> fixTemplates = new ArrayList<Long>();
        HashMap<Long, Set> fixTemplateWithOrg = new HashMap<Long, Set>();
        HashMap<Long, Long> templateTaskProcessId = new HashMap<Long, Long>();
        HashMap<Long, String> tempalteName = new HashMap<Long, String>();
        boolean commitall = false;
        OperationResult result = new OperationResult();
        if ("commitall".equals(this.key)) {
            List tempList = (List)SerializationUtils.fromJsonString((String)this.pageCache.get("selectTemplates"), List.class);
            if (null == tempList || tempList.size() == 0) {
                this.formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u62a5\u8868\u8bb0\u5f55\u3002", (String)"CommitCommand_0", (String)"epm-eb-budget", (Object[])new Object[0]));
                return;
            }
            commitall = true;
            DynamicObject year = (DynamicObject)this.formView.getModel().getValue("year");
            DynamicObject period = (DynamicObject)this.formView.getModel().getValue("period");
            DynamicObject scenario = (DynamicObject)this.formView.getModel().getValue("scenario");
            DynamicObject currency = (DynamicObject)this.formView.getModel().getValue("currency");
            DynamicObject version = (DynamicObject)this.formView.getModel().getValue("version");
            this.pageCache.put(CURRENT_YEAR, year.get("number").toString());
            this.pageCache.put(CURRENT_PERIOD, period.get("number").toString());
            this.pageCache.put(CURRENT_VERSION_NUMBER, version.get("number").toString());
            this.pageCache.put(CURRENT_VERSION_ID, version.get("ID").toString());
            this.pageCache.put(CURRENT_CURRENCY, currency.get("number").toString());
            this.pageCache.put(CURRENT_SCENARIO, scenario.get("number").toString());
            this.pageCache.put(CURRENT_ORG, ((Map)tempList.get(0)).get("entity.id").toString());
            for (Map temp : tempList) {
                Long templateId = (Long)temp.get("template.id");
                Long reportId = Long.valueOf(temp.get("report.id").toString());
                Long orgId = Long.valueOf(temp.get("entity.id").toString());
                String name = temp.get("template.name").toString();
                if (reportId != 0L) {
                    if (!fixTemplates.contains(templateId)) {
                        fixTemplates.add(templateId);
                    }
                    Set orgSet = fixTemplateWithOrg.computeIfAbsent(templateId, f -> new HashSet());
                    orgSet.add(orgId);
                } else {
                    operateErrorInfo = new OperateErrorInfo();
                    operateErrorInfo.setTitle(ResManager.loadKDString((String)"\u62a5\u8868\u672a\u7f16\u8f91", (String)"CommitCommand_1", (String)"epm-eb-budget", (Object[])new Object[0]));
                    operateErrorInfo.setMessage(ResManager.loadResFormat((String)"\u62a5\u8868%s\u672a\u7f16\u8f91", (String)"CommitCommand_2", (String)"epm-eb-budget", (Object[])new Object[]{name}));
                    operateErrorInfo.setLevel(ErrorLevel.Warning);
                    result.addErrorInfo(operateErrorInfo);
                    result.setBillCount(result.getAllErrorInfo().size());
                }
                templateTaskProcessId.put(templateId, reportId);
                tempalteName.put(templateId, name);
            }
        } else {
            DynamicObject version;
            FormShowParameter formShowParameter = this.formView.getFormShowParameter();
            Long orgId = (Long)formShowParameter.getCustomParam("orgId");
            String reportpostman = (String)formShowParameter.getCustomParam("reportpostman");
            AbstractReportPostman postman = (AbstractReportPostman)ObjectSerialUtil.deSerializedBytes((String)reportpostman);
            Long yearPK = (Long)postman.getYearPK();
            Long periodPK = (Long)postman.getPeriodPK();
            Long currencyPK = (Long)postman.getCurrencyPK();
            Long scenarioPK = (Long)postman.getScenarioPK();
            List<Pair<Object, Object>> pairs = postman.getPairs();
            for (Pair<Object, Object> pair : pairs) {
                Long templateId = Long.valueOf(pair.p1.toString());
                Long reportId = Long.valueOf(pair.p2.toString());
                fixTemplates.add(templateId);
                templateTaskProcessId.put(templateId, reportId);
            }
            this.pageCache.put(CURRENT_ORG, orgId.toString());
            DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((String)"epm_periodmembertree", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)periodPK)});
            this.pageCache.put(CURRENT_PERIOD, period.get("number").toString());
            DynamicObject scenario = BusinessDataServiceHelper.loadSingleFromCache((String)"epm_scenemembertree", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)scenarioPK)});
            this.pageCache.put(CURRENT_SCENARIO, scenario.get("number").toString());
            DynamicObject year = this.formView.getModel().getDataEntity().getDataEntityType().getProperties().containsKey((Object)"epm_yearmembertree") ? this.formView.getModel().getDataEntity().getDynamicObject("epm_yearmembertree") : null;
            DynamicObject currency = this.formView.getModel().getDataEntity().getDataEntityType().getProperties().containsKey((Object)"epm_currencymembertree") ? this.formView.getModel().getDataEntity().getDynamicObject("epm_currencymembertree") : null;
            DynamicObject dynamicObject = version = this.formView.getModel().getDataEntity().getDataEntityType().getProperties().containsKey((Object)"epm_versionmembertree") ? this.formView.getModel().getDataEntity().getDynamicObject("epm_versionmembertree") : null;
            if (year != null) {
                this.pageCache.put(CURRENT_YEAR, year.get("number").toString());
            }
            if (currency != null) {
                this.pageCache.put(CURRENT_CURRENCY, currency.get("number").toString());
            }
            if (version != null) {
                this.pageCache.put(CURRENT_VERSION_ID, version.get("id").toString());
                this.pageCache.put(CURRENT_VERSION_NUMBER, version.get("number").toString());
            }
        }
        ArrayList allTemplate = new ArrayList(fixTemplates);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"bcm_eb_approvebill", (String)"id,entryentity.taskprocessjson,entryentity.tempid,billstatus,billno,eborgid", (QFilter[])new QFilter[]{new QFilter("entryentity.tempid", "in", allTemplate)});
        HashMap templateInfo = new HashMap();
        Arrays.stream(load).forEach(h -> {
            DynamicObjectCollection entryentity = h.getDynamicObjectCollection("entryentity");
            String billStatus = h.getString("billstatus");
            for (DynamicObject object : entryentity) {
                Set orgId;
                Long tempId;
                HashMap<String, Object> info = new HashMap<String, Object>();
                Set taskProcessIds = new HashSet();
                String json = object.getString("taskprocessjson");
                if (StringUtils.isNotEmpty((String)json)) {
                    taskProcessIds = (Set)ObjectSerialUtil.deSerializedBytes((String)json);
                }
                if (!templateTaskProcessId.containsKey(tempId = Long.valueOf(object.getDynamicObject("tempid").getLong("id"))) || !taskProcessIds.contains(templateTaskProcessId.get(tempId)) || !(orgId = (Set)fixTemplateWithOrg.get(tempId)).contains(h.getLong("eborgid_id"))) continue;
                info.put("billstatus", billStatus);
                info.put("taskProcessIds", taskProcessIds);
                info.put("self", h);
                List mapList = (List)templateInfo.get(tempId);
                if (mapList != null) {
                    mapList.add(info);
                    continue;
                }
                ArrayList<HashMap<String, Object>> lsInfo = new ArrayList<HashMap<String, Object>>();
                lsInfo.add(info);
                templateInfo.put(tempId, lsInfo);
            }
        });
        ArrayList<Long> removed = new ArrayList<Long>();
        block18: for (Long template : allTemplate) {
            if (!templateInfo.containsKey(template)) continue;
            List info = (List)templateInfo.get(template);
            if (info.size() > 1) {
                OperateErrorInfo operateErrorInfo2 = new OperateErrorInfo();
                operateErrorInfo2.setTitle(ResManager.loadKDString((String)"\u62a5\u8868\u88ab\u63d0\u4ea4\u591a\u6b21", (String)"CommitCommand_3", (String)"epm-eb-budget", (Object[])new Object[0]));
                operateErrorInfo2.setMessage(ResManager.loadResFormat((String)"\u5f53\u524d\u62a5\u8868\u5df2\u63d0\u4ea4\u591a\u6b21\uff0c\u8bf7\u5904\u7406\u7f16\u7801\u4e3a%s\u7684\u5355\u636e", (String)"CommitCommand_4", (String)"epm-eb-budget", (Object[])new Object[]{info.stream().map(p -> ((DynamicObject)p.get("self")).getString("billno")).collect(Collectors.joining("\u3001"))}));
                result.addErrorInfo(operateErrorInfo2);
                removed.add(template);
                continue;
            }
            if (info.size() != 1) continue;
            Map stringObjectMap = (Map)info.get(0);
            String billStatus = (String)stringObjectMap.get("billstatus");
            String billNo = ((DynamicObject)stringObjectMap.get("self")).getString("billno");
            if (commitall) {
                removed.add(template);
            }
            switch (billStatus) {
                case "A": {
                    if (commitall) {
                        operateErrorInfo = new OperateErrorInfo();
                        operateErrorInfo.setTitle(ResManager.loadKDString((String)"\u5df2\u7ecf\u5b58\u5728\u5ba1\u6279\u5355", (String)"CommitCommand_5", (String)"epm-eb-budget", (Object[])new Object[0]));
                        operateErrorInfo.setMessage(ResManager.loadResFormat((String)"\u7f16\u7801\u4e3a%s\u7684\u5355\u636e\uff0c\u8bf7\u63d0\u4ea4\u6216\u8005\u5220\u9664", (String)"CommitCommand_6", (String)"epm-eb-budget", (Object[])new Object[]{billNo}));
                        operateErrorInfo.setLevel(ErrorLevel.Warning);
                        result.addErrorInfo(operateErrorInfo);
                        continue block18;
                    }
                    this.formView.showTipNotification(ResManager.loadResFormat((String)"\u7f16\u7801\u4e3a%s\u7684\u5355\u636e\uff0c\u8bf7\u63d0\u4ea4\u6216\u8005\u5220\u9664", (String)"CommitCommand_6", (String)"epm-eb-budget", (Object[])new Object[]{billNo}));
                    return;
                }
                case "B": 
                case "D": {
                    if (commitall) {
                        operateErrorInfo = new OperateErrorInfo();
                        operateErrorInfo.setTitle(ResManager.loadKDString((String)"\u5df2\u7ecf\u5b58\u5728\u5ba1\u6279\u5355", (String)"CommitCommand_5", (String)"epm-eb-budget", (Object[])new Object[0]));
                        operateErrorInfo.setMessage(ResManager.loadResFormat((String)"\u62a5\u8868%s\u5df2\u7ecf\u63d0\u4ea4\uff0c\u65e0\u9700\u91cd\u590d\u63d0\u4ea4", (String)"CommitCommand_7", (String)"epm-eb-budget", (Object[])new Object[]{tempalteName.get(template)}));
                        operateErrorInfo.setLevel(ErrorLevel.Warning);
                        result.addErrorInfo(operateErrorInfo);
                        continue block18;
                    }
                    return;
                }
                case "C": {
                    if (commitall) {
                        operateErrorInfo = new OperateErrorInfo();
                        operateErrorInfo.setTitle(ResManager.loadKDString((String)"\u5df2\u7ecf\u5b58\u5728\u5ba1\u6279\u5355", (String)"CommitCommand_5", (String)"epm-eb-budget", (Object[])new Object[0]));
                        operateErrorInfo.setMessage(ResManager.loadResFormat((String)"\u7f16\u7801\u4e3a%s\u7684\u5355\u636e\uff0c\u62a5\u8868\u6b63\u5728\u5ba1\u6838\u4e2d\uff0c\u8bf7\u7b49\u5f85", (String)"CommitCommand_8", (String)"epm-eb-budget", (Object[])new Object[]{billNo}));
                        operateErrorInfo.setLevel(ErrorLevel.Warning);
                        result.addErrorInfo(operateErrorInfo);
                        continue block18;
                    }
                    this.formView.showSuccessNotification(ResManager.loadKDString((String)"\u62a5\u8868\u6b63\u5728\u5ba1\u6838\u4e2d\uff0c\u8bf7\u7b49\u5f85", (String)"CommitCommand_9", (String)"epm-eb-budget", (Object[])new Object[0]));
                    return;
                }
                case "E": {
                    if (commitall) {
                        operateErrorInfo = new OperateErrorInfo();
                        operateErrorInfo.setTitle(ResManager.loadKDString((String)"\u5df2\u7ecf\u5b58\u5728\u5ba1\u6279\u5355", (String)"CommitCommand_5", (String)"epm-eb-budget", (Object[])new Object[0]));
                        operateErrorInfo.setMessage(ResManager.loadResFormat((String)"\u62a5\u8868%s\u5df2\u5ba1\u6838\u901a\u8fc7", (String)"CommitCommand_10", (String)"epm-eb-budget", (Object[])new Object[]{tempalteName.get(template)}));
                        operateErrorInfo.setLevel(ErrorLevel.Warning);
                        result.addErrorInfo(operateErrorInfo);
                        continue block18;
                    }
                    this.formView.showSuccessNotification(ResManager.loadKDString((String)"\u62a5\u8868\u5df2\u5ba1\u6838\u901a\u8fc7", (String)"CommitCommand_11", (String)"epm-eb-budget", (Object[])new Object[0]));
                    return;
                }
                case "H": 
                case "I": {
                    if (commitall) {
                        operateErrorInfo = new OperateErrorInfo();
                        operateErrorInfo.setTitle(ResManager.loadKDString((String)"\u5df2\u7ecf\u5b58\u5728\u5ba1\u6279\u5355", (String)"CommitCommand_5", (String)"epm-eb-budget", (Object[])new Object[0]));
                        operateErrorInfo.setMessage(ResManager.loadResFormat((String)"\u5b58\u5728\u7f16\u7801\u4e3a%s\u7684\u5e9f\u5f03\u6216\u8005\u5173\u95ed\u5355\u636e\uff0c\u65e0\u6cd5\u63d0\u4ea4", (String)"CommitCommand_12", (String)"epm-eb-budget", (Object[])new Object[]{billNo}));
                        operateErrorInfo.setLevel(ErrorLevel.Warning);
                        result.addErrorInfo(operateErrorInfo);
                        continue block18;
                    }
                    this.formView.showSuccessNotification(ResManager.loadKDString((String)"\u8be5\u62a5\u8868\u5df2\u5ba1\u6838\u901a\u8fc7", (String)"CommitCommand_13", (String)"epm-eb-budget", (Object[])new Object[0]));
                    return;
                }
            }
            throw new KDBizException(ResManager.loadResFormat((String)"\u7f16\u7801\u4e3a%1\u7684\u201c\u6211\u7684\u5355\u636e\u201d\u9047\u5230\u4e86\u9519\u8bef\u7684\u5355\u636e\u72b6\u6001%2", (String)"CommitCommand_14", (String)"epm-eb-budget", (Object[])new Object[]{billNo, billStatus}));
        }
        result.setBillCount(allTemplate.size());
        if (!commitall) {
            this.formPlugin.itemClick(new ItemClickEvent((Object)this, "btn_save", "donothing"));
        }
        fixTemplates.removeAll(removed);
        if (result.getBillCount() > 0 && !result.getAllErrorInfo().isEmpty()) {
            fixTemplates.clear();
            this.formView.showOperationResult(result);
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u6279\u91cf\u63d0\u4ea4", "CommitCommand_16", "epm-eb-budget");
            ArrayList<String> errInfo = new ArrayList<String>(result.getAllErrorInfo().size());
            for (OperateErrorInfo operateErrorInfo2 : result.getAllErrorInfo()) {
                errInfo.add(operateErrorInfo2.getMessage());
            }
            MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u63d0\u4ea4\u5931\u8d25:%1$s", "CommitCommand_17", "epm-eb-budget");
            OperationLogUtil.log((String)this.formView.getFormShowParameter().getAppId(), (String)this.formView.getFormShowParameter().getFormId(), null, (String)"submit", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDescription, (String[])new String[]{String.join((CharSequence)",", ((Object)errInfo).toString())});
        }
        if (!fixTemplates.isEmpty()) {
            this.commitCurrReport(fixTemplates, result, templateTaskProcessId);
        }
    }

    ArrayList<Integer> range(int start, int end) {
        ArrayList<Integer> res = new ArrayList<Integer>();
        for (int i = start; i <= end; ++i) {
            res.add(i);
        }
        return res;
    }

    private void commitCurrReport(List<Long> fixTemplates, OperationResult result, Map<Long, Long> templateTaskProcessId) {
        HashMap<String, String> templateName = new HashMap<String, String>();
        ApproveBill currReportInfo = new ApproveBill();
        Long modelId = Long.valueOf(this.pageCache.get("KEY_MODEL_ID"));
        String current_org = this.pageCache.get(CURRENT_ORG);
        if (current_org == null || current_org.trim().length() == 0) {
            return;
        }
        currReportInfo.setModelId(modelId);
        currReportInfo.setEbOrgId(Long.parseLong(current_org));
        currReportInfo.setCreateOrgId(Long.parseLong(current_org));
        String yearNumber = this.pageCache.get(CURRENT_YEAR);
        String versionNumber = this.pageCache.get(CURRENT_VERSION_NUMBER);
        String periodNumber = this.pageCache.get(CURRENT_PERIOD);
        currReportInfo.setDimYearBegin(yearNumber);
        currReportInfo.setDimYearEnd(yearNumber);
        currReportInfo.setDimVersion(versionNumber);
        currReportInfo.setDimVersionID(this.pageCache.get(CURRENT_VERSION_ID));
        currReportInfo.setDimPeriodBegin(periodNumber);
        currReportInfo.setDimPeriodEnd(periodNumber);
        currReportInfo.setTemplateTaskProcessId(templateTaskProcessId);
        currReportInfo.setDimScenarioID(((DynamicObject)this.formView.getModel().getValue("scenario")).getLong("id"));
        currReportInfo.setDimCurrencyID(((DynamicObject)this.formView.getModel().getValue("currency")).getLong("id"));
        HashMap<String, List<String>> variNum = new HashMap<String, List<String>>();
        variNum.put(SysDimensionEnum.Year.getNumber(), Collections.singletonList(yearNumber));
        variNum.put(SysDimensionEnum.Version.getNumber(), Collections.singletonList(versionNumber));
        variNum.put(SysDimensionEnum.Period.getNumber(), Collections.singletonList(periodNumber));
        HashMap<Long, Map<String, List<Pair<String, Integer>>>> templateDimMap = new HashMap<Long, Map<String, List<Pair<String, Integer>>>>(16);
        fixTemplates.forEach(templateId -> {
            HashMap dimCollect = new HashMap();
            TemplateModel templateModel = this.loadTemplateById((long)templateId);
            templateName.put(templateId.toString(), templateModel.getName());
            templateModel.getPageDimensionEntries().forEach(view -> {
                String dimKey = view.getDimension().getNumber();
                if (dimKey.equalsIgnoreCase("Entity")) {
                    dimCollect.put(view.getDimension().getNumber(), new ArrayList(new HashSet(ApproveCommon.getListMemberByID(modelId, view.getDimension().getNumber(), Long.parseLong(this.pageCache.get(CURRENT_ORG)), 50).stream().map(k -> Pair.onePair((Object)k.getString("number"), (Object)INCLUDE_SELF_AND_CHILDREN)).collect(Collectors.toList()))));
                } else {
                    dimCollect.put(view.getDimension().getNumber(), new ArrayList(new HashSet(view.getMembers().stream().map(p -> ApproveCommon.getListMember(modelId, view.getDimension().getNumber(), p.getNumber(), p.getScope())).flatMap(Collection::stream).map(k -> Pair.onePair((Object)k.getString("number"), (Object)INCLUDE_SELF_AND_CHILDREN)).collect(Collectors.toList()))));
                }
            });
            templateDimMap.put((Long)templateId, dimCollect);
        });
        currReportInfo.setTemplateDimMapWithScope(templateDimMap);
        this.dealWithBaseVariable(currReportInfo, variNum);
        if (templateDimMap.size() > 0) {
            this.showDimRangeSelect(Long.toString(modelId), currReportInfo, templateName, result, templateTaskProcessId);
        } else {
            this.formView.showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u52a8\u6001\u62a5\u8868\u6216\u8005\u7f16\u5236\u4e2d\u7684\u56fa\u5b9a\u62a5\u8868", (String)"CommitCommand_15", (String)"epm-eb-budget", (Object[])new Object[0]));
        }
    }

    private void dealWithBaseVariable(ApproveBill currReportInfo, Map<String, List<String>> variNum) {
        Map<Long, Map<String, List<Pair<String, Integer>>>> templateDimMapWithScope = currReportInfo.getTemplateDimMapWithScope();
        for (Map.Entry<Long, Map<String, List<Pair<String, Integer>>>> e : templateDimMapWithScope.entrySet()) {
            Map<String, List<Pair<String, Integer>>> dimInfo = e.getValue();
            for (Map.Entry<String, List<String>> entry : variNum.entrySet()) {
                String vari = entry.getKey();
                if (!dimInfo.containsKey(vari)) continue;
                dimInfo.put(vari, entry.getValue().stream().map(p -> Pair.onePair((Object)p, (Object)INCLUDE_SELF_AND_CHILDREN)).collect(Collectors.toList()));
            }
            if (!dimInfo.containsKey(SysDimensionEnum.AuditTrail.getNumber())) continue;
            dimInfo.get(SysDimensionEnum.AuditTrail.getNumber()).removeIf(p -> Arrays.asList("ADJE", "CWP", "ManualJournal", "AutoJournal").contains(p.p1));
        }
    }

    private void showDimRangeSelect(String modelId, ApproveBill currReportInfo, Map<String, String> templateName, OperationResult result, Map<Long, Long> templateTaskProcessId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("eb_dimrangeselect");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("modelId", (Object)modelId);
        parameter.setCustomParam("templateName", templateName);
        parameter.setCustomParam("currReportInfo", (Object)ObjectSerialUtil.toByteSerialized((Object)currReportInfo));
        parameter.setCustomParam("result", (Object)ObjectSerialUtil.toByteSerialized((Object)result));
        parameter.setCustomParam("templateTaskProcessId", (Object)ObjectSerialUtil.toByteSerialized(templateTaskProcessId));
        CloseCallBack closeCallBack = new CloseCallBack(this.formPlugin, DIM_FORM_CLOSE);
        parameter.setCloseCallBack(closeCallBack);
        this.formView.showForm(parameter);
    }

    protected TemplateModel loadTemplateById(long templateId) {
        DynamicObject dyna = BusinessDataReader.loadSingle((Object)templateId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"eb_templateentity_bg"));
        TemplateModel template = new TemplateModel();
        template.loadDynaObj2Model(dyna);
        return template;
    }
}

