/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.intergration.formula;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.epm.eb.budget.formplugin.util.ResourcesLoaderUtil;
import kd.epm.eb.common.ebcommon.common.util.MapInitHelper;
import kd.epm.eb.ebBusiness.formula.register.ExternalFormulaLoader;

public class FormulaConfig {
    private static final String formula_catalog_path = "formula/rpt_formulas_catalog_list.json";
    private static final String formula_list_path = "formula/rpt_formulas_list.json";
    private static FormulaConfig instance = new FormulaConfig();
    private List<Map<String, String>> catalogList = new ArrayList<Map<String, String>>();
    private List<Map<String, String>> formulaList = new ArrayList<Map<String, String>>();
    private Set<String> internalFormulaSet = new HashSet<String>();

    public static FormulaConfig getInstance() {
        return instance;
    }

    private FormulaConfig() {
        this.readConfig();
    }

    public List<Map<String, String>> getCatalogList() {
        return this.catalogList;
    }

    public List<Map<String, String>> getFormulaList() {
        return this.formulaList;
    }

    public Set<String> getFormulaNumberSet() {
        HashSet<String> numbers = new HashSet<String>(16);
        for (Map<String, String> map : this.formulaList) {
            numbers.add(map.get("number").toLowerCase());
        }
        return numbers;
    }

    private void readConfig() {
        this.readInnerConfig();
        this.readExternalConfig();
    }

    private void readInnerConfig() {
        List<Map> formulaCatalogs = ResourcesLoaderUtil.getMapListFromResources(formula_catalog_path);
        for (Map formulaCatalog : formulaCatalogs) {
            String number = (String)formulaCatalog.get("number");
            String name = (String)formulaCatalog.get("name");
            this.catalogList.add(MapInitHelper.ofMap((Object)"number", (Object)number, (Object)"name", (Object)name));
        }
        List<Map> formulas = ResourcesLoaderUtil.getMapListFromResources(formula_list_path);
        this.readFormula(formulas, true);
    }

    private void readExternalConfig() {
        ExternalFormulaLoader.getInstance().loadExternalFormulaConfig().forEach(cfg -> {
            cfg.getCatlogs().forEach(c -> this.catalogList.add(MapInitHelper.ofMap((Object)"number", (Object)c.getNumber(), (Object)"name", (Object)c.getName())));
            this.readFormula(cfg.getFormulas(), false);
        });
    }

    private void readFormula(List<Map> formulas, boolean isInternalFormula) {
        for (Map formula : formulas) {
            String number = (String)formula.get("number");
            String catalog = (String)formula.get("catalog");
            String name = (String)formula.get("name");
            String description = (String)formula.get("description");
            this.formulaList.add(MapInitHelper.ofMap((Object)"number", (Object)number, (Object)"catalog", (Object)catalog, (Object)"name", (Object)name, (Object)"description", (Object)description));
            if (!isInternalFormula) continue;
            this.internalFormulaSet.add(number.toUpperCase());
        }
    }

    public boolean isInternalFormula(String formulaName) {
        return this.internalFormulaSet.contains(formulaName.toUpperCase());
    }
}

