/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.report;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.budget.formplugin.report.dynamic.DynamicUtils;
import kd.epm.eb.budget.formplugin.template.AbstractTemplateBasePlugin;
import kd.epm.eb.budget.formplugin.util.MarkSpecialCell;
import kd.epm.eb.budget.formplugin.util.ModelUtil;
import kd.epm.eb.budget.formplugin.util.ObjectConvertUtils;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.ebComputing.bizrule.BizRuleExecParam;
import kd.epm.eb.common.ebcommon.common.Pair;
import kd.epm.eb.common.ebcommon.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.ebcommon.common.enums.CurrencyEnum;
import kd.epm.eb.common.ebcommon.common.enums.DimTypesEnum;
import kd.epm.eb.common.ebcommon.common.enums.RangeEnum;
import kd.epm.eb.common.ebcommon.common.enums.dimension.SysDimensionEnum;
import kd.epm.eb.ebBusiness.olap.IRelaMembSupplier;
import kd.epm.eb.ebBusiness.olap.OrgRelaMembSupplier;
import kd.epm.eb.ebBusiness.serviceHelper.MemberServiceHelper;
import kd.epm.eb.ebBusiness.serviceHelper.OrgCurrencyServiceHelper;
import kd.epm.eb.ebBusiness.template.model.PageDimensionEntry;
import kd.epm.eb.ebBusiness.template.model.TemplateModel;
import kd.epm.eb.ebBusiness.template.model.ViewPointDimensionEntry;
import kd.epm.eb.ebSpread.common.util.StringUtil;
import kd.epm.eb.ebSpread.domain.PageDimDomain;
import kd.epm.eb.ebSpread.domain.ViewPointDimDomain;
import kd.epm.eb.ebSpread.domain.view.FilterView;
import kd.epm.eb.ebSpread.domain.view.SpreadManager;
import kd.epm.eb.ebSpread.domain.view.builder.ReportDataRefleshService;
import kd.epm.eb.ebSpread.domain.view.builder.dynamic.DynaMembScopeInfo;
import kd.epm.eb.ebSpread.model.DimMember;
import kd.epm.eb.ebSpread.model.IDimMember;
import kd.epm.eb.ebSpread.model.IDimension;
import kd.epm.eb.ebSpread.util.FillDataUtils;

public abstract class AbstractReportBasePlugin
extends AbstractTemplateBasePlugin {
    private long templateId;
    protected static final String SPREAD_KEY = "report";
    protected boolean needExecuteAggRule = true;
    private Map<String, IRelaMembSupplier<String, String>> pool = null;

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    protected boolean isTemplatePlugin() {
        return false;
    }

    @Override
    public String getSpreadKey() {
        return SPREAD_KEY;
    }

    public boolean isOrgInRanks() {
        String isOrgInRanks = this.getPageCache().get("isOrgInRanks");
        if (!StringUtil.isEmptyString((String)isOrgInRanks)) {
            return Boolean.parseBoolean(isOrgInRanks);
        }
        List viewPointDimensionEntries = this.getTemplateModel().getViewPointDimensionEntries();
        for (ViewPointDimensionEntry viewPointDimensionEntry : viewPointDimensionEntries) {
            if (!StringUtil.equals((String)viewPointDimensionEntry.getDimension().getNumber(), (String)SysDimensionEnum.Entity.getNumber())) continue;
            this.getPageCache().put("isOrgInRanks", String.valueOf(false));
            return false;
        }
        List pageDimensionEntries = this.getTemplateModel().getPageDimensionEntries();
        for (PageDimensionEntry pageDimensionEntry : pageDimensionEntries) {
            if (!StringUtil.equals((String)pageDimensionEntry.getDimension().getNumber(), (String)SysDimensionEnum.Entity.getNumber())) continue;
            this.getPageCache().put("isOrgInRanks", String.valueOf(false));
            return false;
        }
        this.getPageCache().put("isOrgInRanks", String.valueOf(true));
        return true;
    }

    public String[] getECPCByNumber(String number) {
        List virtualCurrs;
        String ECPCCache = this.getPageCache().get("ECPC");
        if (StringUtil.isEmptyString((String)ECPCCache) && (virtualCurrs = FillDataUtils.getVirtualCurr((Object)this.getRealOrgInfo().p1)).size() == 2) {
            ECPCCache = String.format("%s,%s;%s,%s", ((DimMember)virtualCurrs.get(0)).getNumber(), ((DimMember)virtualCurrs.get(0)).getName(), ((DimMember)virtualCurrs.get(1)).getNumber(), ((DimMember)virtualCurrs.get(1)).getName());
            this.getPageCache().put("ECPC", ECPCCache);
        }
        return ECPCCache.split(";")[StringUtil.equals((String)number, (String)CurrencyEnum.EC.getNumber()) ? 0 : 1].split(",");
    }

    @Override
    public TemplateModel getTemplateModel() {
        if (this.template == null) {
            Predicate<String> p = t -> StringUtils.isEmpty((String)t);
            String serial = this.getPageCache().get(this.KEY_TEMPLATE_MODEL);
            this.template = p.test(serial) ? this.loadTemplateById(this.getTemplateId()) : this.getTemplateModelFromSerial(serial);
        }
        this.getPageCache().put(this.KEY_TEMPLATE_MODEL, this.toSerialTemplateModel(this.template));
        return this.template;
    }

    protected long getTemplateId() {
        this.templateId = (Long)this.getFormCustomParam("template_id");
        if (this.templateId == 0L) {
            throw new RuntimeException(ResManager.loadResFormat((String)"\u6a21\u677fID\uff1a%1\u65e0\u6548\u3002", (String)"AbstractReportBasePlugin_0", (String)"epm-eb-budget", (Object[])new Object[]{this.template}));
        }
        return this.templateId;
    }

    protected TemplateModel loadTemplateById(long templateId) {
        DynamicObject dyna = BusinessDataReader.loadSingle((Object)templateId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"eb_templateentity_bg"));
        TemplateModel template = new TemplateModel();
        template.loadDynaObj2Model(dyna);
        return template;
    }

    @Override
    public SpreadManager getSpreadModel() {
        SpreadManager spm = super.getSpreadModel();
        this.initSpreadFilter(spm);
        return spm;
    }

    protected Set<String> getMemberByRange(DynaMembScopeInfo scopeInfo) {
        IDimMember member = scopeInfo.getMember();
        RangeEnum range = scopeInfo.getRange();
        return (Set)DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"ModelCacheService", (String)"getMemberByRange", (Object[])new Object[]{member.getDimension().getNumber(), member.getNumber(), range.getValue(), this.getModelId()});
    }

    protected String getCommonFilterDimensionInfo() {
        return (String)this.getFormCustomParam("FilterDimensinInfo");
    }

    protected void initSpreadFilter(SpreadManager spm) {
        if (spm.getFilter() == null) {
            kd.epm.eb.ebBusiness.template.model.Member m;
            TemplateModel template = this.getTemplateModel();
            ViewPointDimDomain view = new ViewPointDimDomain();
            PageDimDomain page = new PageDimDomain();
            IDimension dim = null;
            IDimMember member = null;
            for (ViewPointDimensionEntry v : template.getViewPointDimensionEntries()) {
                dim = ObjectConvertUtils.toIDimension(v.getDimension());
                member = ObjectConvertUtils.toDimMember(v.getMember(), dim);
                dim.addMember(member);
                view.addDimension(dim);
            }
            String filterDimensinInfo = this.getCommonFilterDimensionInfo();
            JSONObject dims = new JSONObject();
            if (StringUtils.isNotEmpty((String)filterDimensinInfo)) {
                dims = JSONObject.parseObject((String)filterDimensinInfo);
            }
            for (PageDimensionEntry v : template.getPageDimensionEntries()) {
                dim = ObjectConvertUtils.toIDimension(v.getDimension());
                String entityNumber = v.getDimension().getMemberEntityNumber();
                if (dims.containsKey((Object)entityNumber)) {
                    JSONObject item = (JSONObject)dims.get((Object)entityNumber);
                    kd.epm.eb.ebBusiness.template.model.Member m2 = new kd.epm.eb.ebBusiness.template.model.Member();
                    m2.setName(item.getString("name"));
                    m2.setNumber(item.getString("number"));
                    member = ObjectConvertUtils.toDimMember(m2, dim);
                } else if (v.getMembers().isEmpty() && "epm_entitymembertree".equals(entityNumber)) {
                    member = this.initEntityMember(dim);
                } else {
                    m = (kd.epm.eb.ebBusiness.template.model.Member)v.getMembers().get(0);
                    Object[] obj = this.getMember(m, dim);
                    if (obj != null) {
                        member = (IDimMember)obj[0];
                    }
                }
                dim.addMember(member);
                page.addDimension(dim);
            }
            for (PageDimensionEntry v : template.getPagePropEntries()) {
                dim = ObjectConvertUtils.toIDimension(v.getDimension());
                if (dims.containsKey((Object)v.getDimension().getMemberEntityNumber())) {
                    JSONObject item = (JSONObject)dims.get((Object)v.getDimension().getMemberEntityNumber());
                    m = new kd.epm.eb.ebBusiness.template.model.Member();
                    m.setName(item.getString("name"));
                    m.setNumber(item.getString("number"));
                    member = ObjectConvertUtils.toDimMember(m, dim);
                    dim.addMember(member);
                }
                page.addDimension(dim);
            }
            spm.setFilter(new FilterView(view, page));
        }
    }

    protected Object[] getMember(kd.epm.eb.ebBusiness.template.model.Member m, IDimension dim) {
        int scope = m.getScope();
        long memberid = m.getId();
        DimMember member = null;
        boolean needCheckShareMemb = MemberServiceHelper.needCheckShareMemb((String)dim.getNumber());
        if (scope == RangeEnum.VALUE_20.getValue() || scope == RangeEnum.VALUE_40.getValue()) {
            DynamicObject dot = BusinessDataServiceHelper.loadSingleFromCache((String)m.getDataEntityNumber(), (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("parent", "=", (Object)memberid)});
            if (dot == null && needCheckShareMemb) {
                dot = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_dimsharemember", (String)"id as sharememberid memberid as id,name,number", (QFilter[])new QFilter[]{new QFilter("parent", "=", (Object)memberid)});
            }
            this.checkRangeMemberExists(m, dot, RangeEnum.getRangeByVal((int)scope));
            if (dot != null) {
                member = new DimMember(dot.getString("name"), dot.getString("number"), dot.getString("name"), dim);
                return new Object[]{member, dot.getLong("id")};
            }
            return null;
        }
        if (scope == RangeEnum.VALUE_60.getValue()) {
            QFilter qf = new QFilter("id", "=", (Object)memberid);
            DynamicObject dot = BusinessDataServiceHelper.loadSingleFromCache((String)m.getDataEntityNumber(), (String)"parent", (QFilter[])new QFilter[]{qf});
            this.checkRangeMemberExists(m, dot, RangeEnum.getRangeByVal((int)scope));
            if (dot == null) {
                return null;
            }
            long parentid = dot.getLong("parent");
            QFilter qf1 = new QFilter("parent", "=", (Object)parentid);
            QFilter qf2 = new QFilter("id", "!=", (Object)memberid);
            dot = BusinessDataServiceHelper.loadSingleFromCache((String)m.getDataEntityNumber(), (String)"id,name,number,simpleName", (QFilter[])new QFilter[]{qf1, qf2});
            if (dot == null && needCheckShareMemb) {
                dot = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_dimsharemember", (String)"id as sharememberid,memberid as id,name,number", (QFilter[])new QFilter[]{new QFilter("parent", "=", (Object)memberid)});
            }
            this.checkRangeMemberExists(m, dot, RangeEnum.getRangeByVal((int)scope));
            if (dot != null) {
                member = new DimMember(dot.getString("name"), dot.getString("number"), dot.getString("simpleName"), dim);
                return new Object[]{member, dot.getLong("id")};
            }
            return null;
        }
        if (scope == RangeEnum.VALUE_90.getValue() || scope == RangeEnum.VALUE_110.getValue()) {
            DynamicObject dot = null;
            if (needCheckShareMemb) {
                HashSet baseParentOfShareMembs = (HashSet)MemberServiceHelper.getShareMembInfo((Long)this.getModelId()).get(dim.getNumber());
                if (baseParentOfShareMembs == null) {
                    baseParentOfShareMembs = new HashSet();
                }
                Member member1 = ModelCacheContext.getOrCreate((Long)this.getModelId()).getMember(dim.getNumber(), null, m.getNumber());
                boolean needLeaf = scope == RangeEnum.VALUE_90.getValue();
                for (Member memb : member1.getAllMembers()) {
                    if ((!needLeaf || !memb.isLeaf() || baseParentOfShareMembs.contains(memb.getId())) && (needLeaf || memb.isLeaf() && !baseParentOfShareMembs.contains(memb.getId()))) continue;
                    member = new DimMember(memb.getName(), memb.getNumber(), memb.getName(), dim);
                    return new Object[]{member, memb.getId()};
                }
            } else {
                String pLongNum = BusinessDataServiceHelper.loadSingleFromCache((Object)m.getId(), (String)m.getDataEntityNumber(), (String)"longnumber").getString("longnumber");
                dot = BusinessDataServiceHelper.loadSingleFromCache((String)m.getDataEntityNumber(), (String)"id,name,number,simpleName", (QFilter[])new QFilter[]{new QFilter("longnumber", "like", (Object)(pLongNum + '!' + "%")).or("longnumber", "=", (Object)pLongNum), new QFilter("model", "=", (Object)this.getModelId()), new QFilter("isleaf", "=", (Object)(scope == RangeEnum.VALUE_90.getValue() ? 1 : 0))});
                this.checkRangeMemberExists(m, dot, RangeEnum.getRangeByVal((int)scope));
                if (dot != null) {
                    member = new DimMember(dot.getString("name"), dot.getString("number"), dot.getString("simpleName"), dim);
                }
            }
            if (member == null) {
                this.checkRangeMemberExists(m, null, RangeEnum.getRangeByVal((int)scope));
            }
            if (dot != null) {
                return new Object[]{member, dot.getLong("id")};
            }
            return null;
        }
        member = new DimMember(m.getName(), m.getNumber(), m.getName(), dim);
        return new Object[]{member, memberid};
    }

    private void checkRangeMemberExists(kd.epm.eb.ebBusiness.template.model.Member sourceMemb, DynamicObject targMemb, RangeEnum scope) {
        if (targMemb == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(ResManager.loadResFormat((String)"\u67e5\u627e\u6210\u5458[%1]\u8303\u56f4-->%2\u4e0d\u5b58\u5728\u6210\u5458\uff01", (String)"AbstractReportBasePlugin_2", (String)"epm-eb-budget", (Object[])new Object[]{sourceMemb.getName(), scope.getName()}));
            log.error(sb.toString());
            this.getView().showErrorNotification(sb.toString());
        }
    }

    protected IDimMember initEntityMember(IDimension dim) {
        throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u6210\u5458\u9ed8\u8ba4\u6210\u5458\u672a\u8bbe\u7f6e\u3002", (String)"AbstractReportBasePlugin_5", (String)"epm-eb-budget", (Object[])new Object[0]));
    }

    protected void refreshReport() {
        if (!this.checkFilterConditionIsAllFilled()) {
            return;
        }
        SpreadManager sm = this.getSpreadModel();
        this.setCurrencyFilter(sm);
        if (this.needExecuteAggRule && ApplicationTypeEnum.isEBOrBGMDOrBGBDOrBGM((ApplicationTypeEnum)ModelUtil.queryApp(this.getView()))) {
            this.executeAggRuleAndFormula(this.getBGMDBizRuleExecParam(true), false);
        }
        if (DynamicUtils.isDynamicReport(sm)) {
            this.autoFloat();
            this.setFloatF7Cell();
            MarkSpecialCell.drawMarkPoint(this.getPageCache(), this.getView(), this.getSpreadModel(), SPREAD_KEY);
        }
        new ReportDataRefleshService().reflesh(this.getSpreadModel(), this.getModelNumber(), this.getOrgRelaMembSupplier(), FillDataUtils.getVirtualCurr((Object)this.getRealOrgInfo().p1));
    }

    protected boolean executeAggRuleAndFormula(BizRuleExecParam param, boolean isSave) {
        return false;
    }

    protected BizRuleExecParam getBGMDBizRuleExecParam(boolean isNeedDealFloatArea) {
        return null;
    }

    protected void autoFloat() {
    }

    protected void setFloatF7Cell() {
    }

    protected void autoCircular() {
    }

    protected void enableControl() {
    }

    protected abstract Pair<Long, String> getCurrentOrgInfo();

    protected Pair<Long, String> getRealOrgInfo() {
        return this.getCurrentOrgInfo();
    }

    protected IRelaMembSupplier<String, String> getOrgRelaMembSupplier() {
        OrgRelaMembSupplier supplier;
        Pair<Long, String> orgInfo = this.getRealOrgInfo();
        if (this.pool == null) {
            String serial = this.getPageCache().get("Rela_Supplier_key");
            this.pool = StringUtils.isEmpty((String)serial) ? new HashMap<String, IRelaMembSupplier<String, String>>() : (Map)this.deSerializedBytes(serial);
        }
        if ((supplier = this.pool.get(String.valueOf(orgInfo.p1))) == null) {
            supplier = new OrgRelaMembSupplier((Long)orgInfo.p1, (String)orgInfo.p2, this.getModelId());
            this.pool.put(String.valueOf(orgInfo.p1), (IRelaMembSupplier<String, String>)supplier);
            this.getPageCache().put("Rela_Supplier_key", this.toByteSerialized(this.pool));
        }
        return supplier;
    }

    protected void setCurrencyFilter(SpreadManager sm) {
    }

    protected String getNumOfOrgWhenOnRowOrColDim() {
        throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u5728\u884c\u5217\u7ef4\u4e0a\u65f6\uff0c\u672a\u5b9e\u73b0\u83b7\u53d6\u7ec4\u7ec7\u7f16\u7801\u65b9\u6cd5\u3002", (String)"AbstractReportBasePlugin_6", (String)"epm-eb-budget", (Object[])new Object[0]));
    }

    protected IDimension getDimensionInAllDomain(DimTypesEnum dimType, List<IDimension> list) {
        for (IDimension dimension : list) {
            if (!dimType.getNumber().equals(dimension.getNumber())) continue;
            return dimension;
        }
        return null;
    }

    protected DynamicObject getCurrencyDynaObjByOrgId(long orgId, Long yearId, Long periodId) {
        return OrgCurrencyServiceHelper.getCurrencyDynById((Long)orgId, (Long)yearId, (Long)periodId);
    }

    protected boolean checkFilterConditionIsAllFilled() {
        if (this.getSpreadModel().getFilter() != null && this.getSpreadModel().getFilter().getPageDomain() != null) {
            boolean isNotAllFilled = this.getSpreadModel().getFilter().getPageDomain().getDimensions().stream().anyMatch(e -> e.getMembers().isEmpty());
            if (isNotAllFilled) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u7ef4\u5ea6\u672a\u8bbe\u7f6e\u6210\u5458\uff0c\u65e0\u6cd5\u6267\u884c\u67e5\u8be2\u6570\u636e\u3002", (String)"AbstractReportBasePlugin_7", (String)"epm-eb-budget", (Object[])new Object[0]));
                return false;
            }
            return true;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u8fc7\u6ee4\u6761\u4ef6\u4e3a\u7a7a\u3002", (String)"AbstractReportBasePlugin_8", (String)"epm-eb-budget", (Object[])new Object[0]));
    }

    @Override
    public void showFormulaPanel(int row, int col) {
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u62a5\u8868\u6682\u4e0d\u652f\u6301\u516c\u5f0f\u5411\u5bfc", (String)"AbstractReportBasePlugin_9", (String)"epm-eb-budget", (Object[])new Object[0]));
    }
}

