/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.report;

import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IPageCache;
import kd.bos.mvc.list.ListDataProvider;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.ebBusiness.util.EntityVersioningUtil;

public class ReportListDataProvider
extends ListDataProvider {
    private String modelId;
    private String yearNum;
    private String periodId;
    private IPageCache pageCache;

    public ReportListDataProvider(String modelId, String yearNum, String periodId) {
        this.modelId = modelId;
        this.yearNum = yearNum;
        this.periodId = periodId;
    }

    public ReportListDataProvider(String modelId, String yearNum, String periodId, IPageCache pageCache) {
        this.modelId = modelId;
        this.yearNum = yearNum;
        this.periodId = periodId;
        this.pageCache = pageCache;
    }

    public DynamicObjectCollection getData(int start, int limit) {
        DynamicObjectCollection doc = super.getData(start, limit);
        if (doc.size() <= 0) {
            return doc;
        }
        this.pageCache.put("billCount", String.valueOf(doc.size()));
        EntityVersioningUtil.filterOrgOnReportList((DynamicObjectCollection)doc, (Object)this.modelId, (String)this.yearNum, (Object)this.periodId);
        Map<Long, Integer> reportRowIds = doc.stream().collect(Collectors.toMap(e -> e.getLong("report_id"), e -> e.getInt("fseq"), (n1, n2) -> n2));
        this.pageCache.put("pkIds", ObjectSerialUtil.toByteSerialized(reportRowIds));
        return doc;
    }

    public int getRealCount() {
        return super.getRealCount();
    }

    public int getBillDataCount() {
        return this.pageCache.get("billCount") == null ? 0 : Integer.parseInt(this.pageCache.get("billCount"));
    }
}

