/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.report.attachment;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.common.enums.AttachementTypeEnum;
import kd.epm.eb.common.utils.UserUtils;
import org.apache.commons.lang3.StringUtils;

public class EbReportAttachmentPlugin
extends AbstractFormPlugin {
    private static final String ATTACHMENT_COUNT = "attachment_count";

    public void initialize() {
        super.initialize();
        this.setControlTilte();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initValues();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getModel().setDataChanged(false);
        this.getPageCache().put(ATTACHMENT_COUNT, String.valueOf(this.getModel().getValue("attachmentcount")));
    }

    private void initValues() {
        IDataModel model = this.getModel();
        FormShowParameter fromShowParams = this.getView().getFormShowParameter();
        Long modelId = (Long)fromShowParams.getCustomParam("modelId");
        Long templateId = (Long)fromShowParams.getCustomParam("templateId");
        String membersKey = (String)fromShowParams.getCustomParam("membersKey");
        Object taskProId = fromShowParams.getCustomParam("taskproid");
        String type = (String)fromShowParams.getCustomParam("type");
        if (fromShowParams.getStatus() == OperationStatus.ADDNEW) {
            model.setValue("number", (Object)(templateId + "_number"));
            model.setValue("name", (Object)(templateId + "_name"));
            model.setValue("type", (Object)type);
            model.setValue("modelid_id", (Object)modelId);
            model.setValue("taskproid_id", (Object)Long.parseLong(taskProId.toString()));
            model.setValue("templateId_id", (Object)templateId);
            model.setValue("memberskey", (Object)membersKey);
            model.setValue("creator_id", (Object)UserUtils.getUserId());
            model.setValue("createtime", (Object)TimeServiceHelper.now());
        }
    }

    private void setControlTilte() {
        FormShowParameter fromShowParams = this.getView().getFormShowParameter();
        String type = (String)fromShowParams.getCustomParam("type");
        String caption = ResManager.loadKDString((String)"\u9644\u6ce8\uff1a", (String)"ReportAttachmentPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        if (AttachementTypeEnum.TEMPLATE.getValue().equals(type)) {
            caption = ResManager.loadResFormat((String)"\u62a5\u8868%1", (String)"ReportAttachmentPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[]{caption});
        }
        LocaleString captionLocal = new LocaleString();
        captionLocal.put(Lang.defaultLang().toString(), (Object)caption);
        TextEdit edit = (TextEdit)this.getView().getControl("remark");
        edit.setCaption(captionLocal);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String type = ((AbstractOperate)e.getSource()).getOperateKey();
        if (type.equals("save")) {
            boolean issuccess = e.getOperationResult().getValidateResult().isSuccess();
            if (issuccess) {
                HashMap<String, Object> backData = new HashMap<String, Object>(16);
                String memberskey = (String)this.getView().getFormShowParameter().getCustomParam("memberskey");
                String tagType = (String)this.getView().getFormShowParameter().getCustomParam("type");
                backData.put("memberskey", memberskey);
                backData.put("type", tagType);
                backData.put("remark", this.getModel().getValue("remark"));
                this.getView().returnDataToParent((Object)SerializationUtils.serializeToBase64(backData));
                this.getView().close();
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25", (String)"ReportAttachmentPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String attachmentCount;
        super.beforeClosed(e);
        if (this.getModel().getDataChanged() && !(attachmentCount = String.valueOf(this.getModel().getValue("attachmentcount"))).equals(this.getPageCache().get(ATTACHMENT_COUNT))) {
            Object id = this.getModel().getValue("id");
            DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)("update t_eb_reportattachment set fattachmentcount='" + attachmentCount + "' where fid=" + id));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        String type = ((AbstractOperate)e.getSource()).getOperateKey();
        if (type.equals("save")) {
            String remark = this.getModel().getDataEntity().getString("remark");
            int count = this.getModel().getDataEntity().getInt("attachmentcount");
            if (StringUtils.isEmpty((CharSequence)remark) && count == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9644\u6ce8\u548c\u9644\u4ef6\u4fe1\u606f\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\u3002", (String)"EbReportAttachmentPlugin_1", (String)"epm-eb-budget", (Object[])new Object[0]));
                e.cancel = true;
            }
        }
    }
}

