/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.report.cache;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.ebcommon.common.enums.DataTypeEnum;
import kd.epm.eb.common.ebcommon.common.util.QFBuilder;

public class DataTypeAcctCacheInfo
implements Serializable {
    private static final long serialVersionUID = 5837583443464601533L;
    public static final String CACHE_KEY = "DataTypeAcctCacheKey";
    private Map<String, DataTypeEnum> dataTypeLookupMap = new HashMap<String, DataTypeEnum>();

    public DataTypeAcctCacheInfo(Object modelId, String entity) {
        this.autowireCacheInfo(modelId, entity, null);
    }

    public DataTypeAcctCacheInfo(Object modelId, String entity, String dim) {
        this.autowireCacheInfo(modelId, entity, dim);
    }

    private void autowireCacheInfo(Object modelId, String entity, String dim) {
        QFBuilder qf = new QFBuilder();
        qf.add("model", "=", modelId);
        qf.add("datatype", "!=", (Object)DataTypeEnum.DEFAULT.index);
        if (StringUtils.isNotEmpty((String)dim)) {
            qf.add("dimension.number", "=", (Object)dim);
        }
        Collection cols = BusinessDataServiceHelper.loadFromCache((String)entity, (String)"dimension.number,number,datatype", (QFilter[])qf.toArray()).values();
        for (DynamicObject dyn : cols) {
            this.dataTypeLookupMap.put(dyn.getString("dimension.number") + "_" + dyn.getString("number"), DataTypeEnum.getDataTypeEnumByIndex((String)dyn.getString("datatype")));
        }
    }

    public DataTypeEnum getMemberDataTypeEnum(String dimNumber, String number) {
        DataTypeEnum result = this.dataTypeLookupMap.get(dimNumber + "_" + number);
        return result != null ? result : DataTypeEnum.DEFAULT;
    }

    public String getMemberDataType(String dimNumber, String number) {
        return this.getMemberDataTypeEnum(dimNumber, number).getOIndex();
    }
}

