/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.report.csl;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.container.Tab;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.olap.common.CellSet;
import kd.bos.olap.dataSources.SaveCommandInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import kd.epm.eb.budget.formplugin.report.MultiTabReportProcessPlugin;
import kd.epm.eb.budget.formplugin.report.style.StyleContext;
import kd.epm.eb.budget.formplugin.spread.SpreadClientInvoker;
import kd.epm.eb.budget.formplugin.spread.SpreadEasyInvoker;
import kd.epm.eb.budget.formplugin.tree.ITreeNode;
import kd.epm.eb.budget.formplugin.tree.TreeModel;
import kd.epm.eb.budget.formplugin.util.SpreadMemUtil;
import kd.epm.eb.common.ebcommon.common.PresetConstant;
import kd.epm.eb.common.ebcommon.common.enums.CurrencyEnum;
import kd.epm.eb.common.ebcommon.common.enums.DimTypesEnum;
import kd.epm.eb.common.ebcommon.common.enums.FacTabFieldDefEnum;
import kd.epm.eb.common.ebcommon.common.enums.ReportStatusEnum;
import kd.epm.eb.common.ebcommon.common.util.ExcelUtils;
import kd.epm.eb.common.ebcommon.common.util.MapInitHelper;
import kd.epm.eb.common.ebcommon.common.util.QFBuilder;
import kd.epm.eb.common.ebcommon.common.util.ThrowableHelper;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.ebBusiness.chkcheck.model.DimensionCombination;
import kd.epm.eb.ebBusiness.serviceHelper.OrgCurrencyServiceHelper;
import kd.epm.eb.ebBusiness.util.TemplateRangeService;
import kd.epm.eb.ebSpread.domain.Cell;
import kd.epm.eb.ebSpread.domain.view.builder.PositionInfo;
import kd.epm.eb.ebSpread.domain.view.event.NotifyEvent;
import kd.epm.eb.ebSpread.domain.view.js.SpreadProperties;
import kd.epm.eb.ebSpread.model.IDimMember;
import kd.epm.eb.ebSpread.model.IDimension;

public class CslReportProcessPlugin
extends MultiTabReportProcessPlugin
implements UploadListener {
    private static final String data_txt = "txt";
    private static final String data_number = "number";
    private static final String data_number_unleaf = "number_unleaf";
    private static final String data_old = "oldData";
    private static final String action_scheme_collect = "btn_schemecollect";
    private static final String tabkey_lastselected = "tabkey_lastselected";
    private static final String flag_notfirelistener = "isNotFireTabSelectListener";
    private List<Map<String, Object>> urls;

    @Override
    protected boolean isCsl() {
        return false;
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setViewSpreadJs();
        SpreadEasyInvoker spreadEasyInvoker = new SpreadEasyInvoker(this.getClientViewProxy(), "report");
        spreadEasyInvoker.addContextMenuItem(SpreadProperties.InsertMethod.INSERTROW.k(), ResManager.loadKDString((String)"\u63d2\u5165\u884c", (String)"CslReportProcessPlugin_1", (String)"epm-eb-budget", (Object[])new Object[0]), new String[]{"rowHeader", "viewport"});
        spreadEasyInvoker.addContextMenuItem(SpreadProperties.InsertMethod.INSERTCOL.k(), ResManager.loadKDString((String)"\u63d2\u5165\u5217", (String)"CslReportProcessPlugin_2", (String)"epm-eb-budget", (Object[])new Object[0]), new String[]{"colHeader", "viewport"});
        spreadEasyInvoker.addContextMenuItem(SpreadProperties.DelMethod.DELROW.k(), ResManager.loadKDString((String)"\u5220\u9664\u884c", (String)"CslReportProcessPlugin_3", (String)"epm-eb-budget", (Object[])new Object[0]), new String[]{"rowHeader", "viewport"});
        spreadEasyInvoker.addContextMenuItem(SpreadProperties.DelMethod.DELCOL.k(), ResManager.loadKDString((String)"\u5220\u9664\u5217", (String)"CslReportProcessPlugin_4", (String)"epm-eb-budget", (Object[])new Object[0]), new String[]{"colHeader", "viewport"});
    }

    @Override
    public void initialize() {
        super.initialize();
        Tab reporttab = (Tab)this.getControl("annotatetab");
        reporttab.addTabSelectListener(this::annotateTabSelected);
        AttachmentPanel panel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
        panel.addUploadListener((UploadListener)this);
    }

    private void annotateTabSelected(TabSelectEvent e) {
        String tabKey = e.getTabKey();
        this.getPageCache().put("tabselect", tabKey);
        switch (tabKey) {
            case "attachment": {
                this.showAttachmentPanel();
                break;
            }
        }
    }

    public void showAttachmentPanel() {
        DimensionCombination dc = this.pakageDimensionCombination();
        if (dc == null) {
            return;
        }
        QFilter filter = new QFilter("noteinfo.model", "=", (Object)this.getModelId());
        QFilter dimStrFilter = new QFilter("noteinfo.dimensionstr", "=", (Object)dc.getDimensionCombineStr());
        DynamicObject[] dys = BusinessDataServiceHelper.load((String)"eb_chkattachment", (String)this.getSelectedProperties(), (QFilter[])new QFilter[]{filter, dimStrFilter});
        HashSet<Long> notefoIds = new HashSet<Long>(16);
        for (DynamicObject dy : dys) {
            notefoIds.add(dy.getLong("noteinfo.id"));
        }
        ArrayList attachs = new ArrayList(16);
        for (Long notefoId : notefoIds) {
            attachs.addAll(AttachmentServiceHelper.getAttachments((String)"eb_chknoteinfo", (Object)notefoId, (String)"attachmentpanelap"));
        }
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl("attachmentpanelap");
        attachmentPanel.bindData(attachs);
    }

    private void saveAttachment() {
        DimensionCombination dimCombination = this.pakageDimensionCombination();
        if (dimCombination == null) {
            return;
        }
        if (this.getPageCache().get("urls") == null) {
            return;
        }
        DynamicObject noteInfo = this.getCHKNoteInfo(dimCombination);
        try {
            this.urls = (List)JSONUtils.cast((String)this.getPageCache().get("urls"), List.class);
        }
        catch (IOException e) {
            log.error("io error", (Throwable)e);
        }
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        long[] globalIds = DB.genGlobalLongIds((int)this.urls.size());
        PrimitiveIterator.OfLong iterator = Arrays.stream(globalIds).iterator();
        for (Map<String, Object> url : this.urls) {
            String tempurl = url.get("url").toString();
            String tempName = url.get("name").toString();
            String urlstr = AttachmentServiceHelper.saveTempToFileService((String)tempurl, (String)"epm", (String)"eb_chknoteinfo", (Object)noteInfo.getLong("id"), (String)tempName);
            DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)"eb_chkattachment");
            dy.set("id", (Object)iterator.next());
            dy.set("noteinfo", (Object)noteInfo);
            dy.set("modifydate", (Object)TimeServiceHelper.now());
            dy.set("modifier", (Object)UserUtils.getUserId());
            dy.set("name", url.get("name"));
            dy.set("size", url.get("size"));
            dy.set("uid", url.get("uid"));
            dy.set("url", (Object)urlstr);
            dy.set("type", url.get("type"));
            dy.set("description", url.get("description"));
            list.add(dy);
            this.saveAttachmentData(url, noteInfo, urlstr);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{noteInfo});
        SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
    }

    private void saveAttachmentData(Map<String, Object> url, DynamicObject noteInfo, String urlstr) {
        DynamicObject dynObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_attachment");
        dynObj.set("fBillType", (Object)"eb_chknoteinfo");
        dynObj.set("fnumber", url.get("uid"));
        dynObj.set("fInterID", noteInfo.get("id"));
        dynObj.set("fFileId", (Object)urlstr);
        dynObj.set("fAttachmentName", url.get("name"));
        dynObj.set("fExtName", url.get("type"));
        dynObj.set("fAttachmentSize", url.get("size"));
        dynObj.set("FBillStatus", (Object)"A");
        dynObj.set("fCreateMen_Id", url.get("creator"));
        dynObj.set("fCreateTime", url.get("createdate"));
        dynObj.set("fModifyMen_Id", url.get("creator"));
        dynObj.set("fModifyTime", url.get("lastModified"));
        dynObj.set("fattachmentpanel", (Object)"attachmentpanelap");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynObj});
    }

    public void afterUpload(UploadEvent evt) {
        this.urls = new ArrayList<Map<String, Object>>(10);
        for (Object o : evt.getUrls()) {
            this.urls.add((Map)o);
        }
        try {
            this.getPageCache().put("urls", JSONUtils.toString(this.urls));
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
        this.saveAttachment();
    }

    @Override
    protected void chkNote(NotifyEvent e) {
        super.chkNote(e);
        Tab reporttab = (Tab)this.getControl("annotatetab");
        if ("attachment".equals(reporttab.getCurrentTab())) {
            this.showAttachmentPanel();
        }
    }

    private DynamicObject getCHKNoteInfo(DimensionCombination dimCombination) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("model", "=", (Object)this.getModelId());
        qfBuilder.add("dimensionstr", "=", (Object)dimCombination.getDimensionCombineStr());
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((String)"eb_chknoteinfo", (String)"id", (QFilter[])qfBuilder.toArray());
        if (dy == null) {
            dy = BusinessDataServiceHelper.newDynamicObject((String)"eb_chknoteinfo");
            dy.set("id", (Object)DB.genGlobalLongId());
            dy.set("model", (Object)this.getModelId());
            dy.set("dimensionstr", (Object)dimCombination.getDimensionCombineStr());
            dy.set("dimensionsum", (Object)dimCombination.keySet().size());
        }
        return dy;
    }

    public DimensionCombination pakageDimensionCombination() {
        int i;
        try {
            this.getSpreadSelector();
        }
        catch (KDBizException e) {
            return null;
        }
        Cell cell = this.getEffectiveSheet().getCell(this.getSpreadSelector().getStartRow(), this.getSpreadSelector().getStartCol());
        if (!cell.isMdDataDomain()) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>(16);
        for (IDimMember iDimMember : cell.getMemberFromUserObject()) {
            map.put(iDimMember.getDimension().getNumber(), iDimMember.getNumber());
        }
        List viewpointList = this.getSpreadModel().getFilter().getViewPointDomain().getDimensions();
        List viewMembList = this.getSpreadModel().getFilter().getViewPointDomain().getAllMembers();
        List pageList = this.getSpreadModel().getFilter().getPageDomain().getDimensions();
        List pageMembList = this.getSpreadModel().getFilter().getPageDomain().getAllMembers();
        for (i = 0; i < viewpointList.size(); ++i) {
            map.put(((IDimension)viewpointList.get(i)).getNumber(), ((IDimMember)viewMembList.get(i)).getNumber());
        }
        for (i = 0; i < pageList.size(); ++i) {
            map.put(((IDimension)pageList.get(i)).getNumber(), ((IDimMember)pageMembList.get(i)).getNumber());
        }
        DimensionCombination dimCombination = new DimensionCombination(this.getModelId().longValue());
        dimCombination.putAll(map);
        return dimCombination;
    }

    private String getSelectedProperties() {
        return "url,name,size,uid,type,description,modifier,modifydate,noteinfo";
    }

    @Override
    protected void lockToolbar(boolean success) {
        this.getView().setEnable(Boolean.valueOf(success), new String[]{"btn_save", "btn_batchoprt", "btn_modify", "btn_selectdynaitem", "btn_dataunit", "query_export", "btn_datatrace", "btn_more", "btn_more_normal", "btn_calculate", "btn_refresh", "ebexport", "ebimport"});
    }

    @Override
    public void actionSaveSpreadJson(String spreadJson) {
        boolean isSuccess;
        try {
            this.saveRecord(spreadJson);
            this.setModified(false);
            isSuccess = true;
        }
        catch (Throwable t) {
            this.getPageCache().put("isSaveFail", "true");
            this.getView().showErrorNotification(t.getMessage());
            log.error("actionSave------------" + ThrowableHelper.toString((Throwable)t));
            isSuccess = false;
        }
        String selectKey = this.getPageCache().get("tabkey_selected");
        String currentKey = this.getReportTabInfoManager().getCurrSelectReportTabInfo().getTabKey();
        if (selectKey != null && !selectKey.equals(currentKey)) {
            if (isSuccess) {
                this.actionRefresh();
            } else {
                String tabkey = this.getPageCache().get(tabkey_lastselected);
                this.getPageCache().put("tabkey_selected", tabkey);
                this.getPageCache().remove(tabkey_lastselected);
                Tab tab = (Tab)this.getControl("reporttab");
                this.getPageCache().put(flag_notfirelistener, "true");
                tab.activeTab(tabkey);
            }
        } else if (isSuccess) {
            this.actionRefresh();
        }
        this.getView().hideLoading();
        if ("1".equals(this.getPageCache().get("attachment_saved"))) {
            this.getPageCache().remove("attachment_saved");
            this.showAttachementForm();
        }
        this.closeTab();
    }

    private void saveRecord(String spreadJson) {
        this.saveReportRecord(spreadJson, null, false);
        this.saveParentEntityRecord();
    }

    private void saveParentEntityRecord() {
        Map<String, Long> commonFilterMap = this.commonFilterMap();
        Long entityId = commonFilterMap.get(SysDimensionEnum.Entity.getMemberTreemodel());
        if (entityId == null || entityId == 0L) {
            return;
        }
        long templateId = this.getTemplateId();
        DynamicObject templateInfo = QueryServiceHelper.queryOne((String)"eb_templateentity_bg", (String)"rptdata, rptspreadjson", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)templateId)});
        String entity_cache = (String)this.getView().getFormShowParameter().getCustomParam("cache_treeentity");
        List<Long> parentEntity = this.getParentEntity(entity_cache, entityId, commonFilterMap);
        if (parentEntity.size() != 0) {
            ArrayList<DynamicObject> save = new ArrayList<DynamicObject>(16);
            for (Long parentId : parentEntity) {
                DynamicObject record = BusinessDataServiceHelper.newDynamicObject((String)"eb_reportentity");
                commonFilterMap.keySet().forEach(e -> {
                    if ("epm_entitymembertree".equals(e)) {
                        record.set("entity", (Object)this.getEntityBaseMemberId(parentId));
                    } else {
                        record.set(this.getPropertyName((String)e), this.getFilterVal((String)e, commonFilterMap));
                    }
                });
                this.handleEntityFilter(commonFilterMap).ifPresent(e -> record.set(this.getPropertyName("epm_entitymembertree"), (Object)this.getEntityBaseMemberId(e.getValue())));
                record.set("reportstatus", (Object)ReportStatusEnum.WEAVING.status());
                record.set("modifier", (Object)this.getUserId());
                record.set("modifytime", (Object)this.getCurrentSysTime());
                record.set("template", (Object)templateId);
                record.set("model", (Object)this.getModelId());
                record.set("spreadjson", (Object)templateInfo.getString("rptspreadjson"));
                record.set("data", (Object)templateInfo.getString("rptdata"));
                Object currency = this.getCurrentReportCommonParam(data_number).get(DimTypesEnum.CURRENCY);
                if (CurrencyEnum.EC.getNumber().equals(currency)) {
                    DynamicObject currencyDynaObj = OrgCurrencyServiceHelper.getCurrencyDynByIdThrow((Long)parentId, (Long)commonFilterMap.get(SysDimensionEnum.Year.getMemberTreemodel()), (Long)commonFilterMap.get(SysDimensionEnum.Period.getMemberTreemodel()));
                    record.set("currency", (Object)currencyDynaObj.getLong("id"));
                }
                record.set("reporttype", (Object)"1");
                record.set("creator", (Object)this.getUserId());
                record.set("createtime", (Object)this.getCurrentSysTime());
                save.add(record);
            }
            SaveServiceHelper.save((DynamicObject[])save.toArray(new DynamicObject[0]));
        }
    }

    private List<Long> getParentEntity(String entity_cache, Long entityId, Map<String, Long> commonFilterMap) {
        ArrayList<Long> parentIds = new ArrayList<Long>(16);
        TreeModel entityTree = (TreeModel)ObjectSerialUtil.deSerializedBytes((String)entity_cache);
        Object root = entityTree.getRoot();
        ITreeNode<Object> currentNode = this.getCurrentNode((ITreeNode<Object>)root, entityId);
        if (currentNode == null) {
            return parentIds;
        }
        parentIds.addAll(this.getParents(currentNode, commonFilterMap));
        return parentIds;
    }

    private ITreeNode<Object> getCurrentNode(ITreeNode<Object> root, Long entityId) {
        ITreeNode<Object> currentNode = null;
        List<ITreeNode<Object>> children = root.getChildren();
        if (children == null) {
            return null;
        }
        for (ITreeNode<Object> child : children) {
            if (child.getId().equals(entityId.toString())) {
                currentNode = child;
                break;
            }
            ITreeNode<Object> node = this.getCurrentNode(child, entityId);
            if (node == null) continue;
            currentNode = node;
            break;
        }
        return currentNode;
    }

    private List<Long> getParents(ITreeNode<Object> currentNode, Map<String, Long> commonFilterMap) {
        ArrayList<Long> parentIds = new ArrayList<Long>(16);
        HashMap<String, Long> filter = new HashMap<String, Long>(commonFilterMap);
        ITreeNode<Object> node = currentNode.getParent();
        long templateId = this.getTemplateId();
        Map template2OrgMapOfDispense = TemplateRangeService.getTemplate2OrgMapOfDispense((Long)this.getModelId(), new HashSet<Long>(Collections.singleton(templateId)), new HashSet());
        Set entities = (Set)template2OrgMapOfDispense.get(templateId);
        while (node.getParent() != null) {
            long entityId = Long.parseLong(node.getId());
            if (entities.contains(entityId)) {
                filter.put(SysDimensionEnum.Entity.getMemberTreemodel(), entityId);
                DynamicObject record = this.queryReportRecord(filter, null, true);
                if (record == null || ReportStatusEnum.UNWEAVE.number().equals(record.getString("reportstatus"))) {
                    parentIds.add(IDUtils.toLong((Object)node.getId()));
                }
            }
            node = node.getParent();
        }
        return parentIds;
    }

    @Override
    protected void reportTabSelected(TabSelectEvent evt) {
        if (this.isTrueFlagInCache(flag_notfirelistener)) {
            this.getPageCache().remove(flag_notfirelistener);
            return;
        }
        super.reportTabSelected(evt);
        this.getCurrentReportCommonParam(data_number).get(DimTypesEnum.PERIOD);
        this.mutexControl();
        this.annotateTabSelected(evt);
        super.initReportStatus();
    }

    @Override
    protected void afterDealFloatData() {
        super.afterDealFloatData();
    }

    @Override
    protected void saveCvtData2Null() {
        String process;
        if (!this.isView() && StringUtils.isNotEmpty((String)(process = SpreadMemUtil.getMemFromFilter(this.getSpreadModel(), DimTypesEnum.PROCESS.getNumber()))) && ("IRpt".equals(process) || "CS".equals(process))) {
            Map<String, Map<String, ? extends Object>> allData = this.getAllData();
            Map<String, String> commonMemberMap = this.getCommonMemberMap();
            List<String> dimAll = this.getAllDim();
            this.doCleanData(allData, commonMemberMap, dimAll);
        }
    }

    private Map<String, Set<String>> getCrossDimMap(Set<String> crossDims) {
        HashMap<String, Set<String>> crossDimMap = new HashMap<String, Set<String>>();
        crossDims.forEach(k -> {
            String[] pairs;
            for (String pair : pairs = k.split(",")) {
                HashSet<String> members;
                String[] member = pair.split(":");
                String d = member[0];
                String m = member[1];
                HashSet<String> set = (HashSet<String>)crossDimMap.get(d);
                if (set != null) {
                    members = set;
                } else {
                    members = new HashSet<String>();
                    crossDimMap.put(d, members);
                }
                members.add(m);
            }
        });
        return crossDimMap;
    }

    private void doCleanData(Map<String, Map<String, ? extends Object>> allData, Map<String, String> commonMemberMap, List<String> dimAll) {
        HashSet<String> cells = new HashSet<String>(16);
        cells.addAll(allData.get(data_number).keySet());
        cells.addAll(allData.get(data_number_unleaf).keySet());
        cells.addAll(allData.get(data_txt).keySet());
        if (cells.isEmpty()) {
            return;
        }
        String measure = FacTabFieldDefEnum.FIELD_MONEY.getField();
        SaveCommandInfo info = new SaveCommandInfo();
        info.setMeasures(new String[]{measure});
        info.setDimensions(dimAll.toArray(new String[0]));
        CellSet cellSets = new CellSet(dimAll.toArray(new String[0]), new String[]{measure});
        cells.forEach(k -> {
            String[] ds;
            ArrayList members = new ArrayList(10);
            ArrayList difMembers = new ArrayList(10);
            HashMap<String, String> memberMap = new HashMap<String, String>(16);
            memberMap.putAll(commonMemberMap);
            for (String dim : ds = k.split(",")) {
                String[] pair = dim.split(":");
                memberMap.put(pair[0], pair[1]);
            }
            dimAll.forEach(d -> {
                if (!this.isEPM() && d.equals(PresetConstant.AUDITTRIAL_DIM)) {
                    members.add("EntityInputTraDif");
                    difMembers.add("TraDif");
                } else {
                    members.add(memberMap.get(d));
                    difMembers.add(memberMap.get(d));
                }
            });
        });
    }

    private Map<String, String> getCommonMemberMap() {
        HashMap<String, String> commonMemberMap = new HashMap<String, String>();
        this.getSpreadModel().getFilter().getPageDomain().getAllMembers().forEach(m -> commonMemberMap.put(m.getDimension().getNumber(), m.getNumber()));
        this.getSpreadModel().getFilter().getViewPointDomain().getAllMembers().forEach(m -> commonMemberMap.put(m.getDimension().getNumber(), m.getNumber()));
        return commonMemberMap;
    }

    private List<String> getAllDim() {
        ArrayList<String> allDim = new ArrayList<String>();
        QueryServiceHelper.query((String)"epm_dimension", (String)data_number, (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.getModelId())}, (String)"dseq").forEach(e -> allDim.add(e.getString(data_number)));
        return allDim;
    }

    private Map<String, Map<String, ? extends Object>> getAllData() {
        HashMap<String, Map<String, ? extends Object>> data = new HashMap<String, Map<String, ? extends Object>>();
        HashMap<String, BigDecimal> numberData = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> unleafNumberData = new HashMap<String, BigDecimal>();
        HashMap<String, String> txtData = new HashMap<String, String>();
        StringBuilder sb = new StringBuilder();
        StyleContext ctx = this.getStyleContext(true);
        for (PositionInfo p : this.getSpreadModel().getAreaManager().getPostionInfoSet()) {
            String[] range = p.getAreaRange().split(":");
            int[] startXY = ExcelUtils.pos2Point((String)range[0]).toArray();
            int[] endXY = ExcelUtils.pos2Point((String)range[1]).toArray();
            for (int r = startXY[1]; r <= endXY[1]; ++r) {
                for (int c = startXY[0]; c <= endXY[0]; ++c) {
                    boolean isLeaf;
                    Cell cell = this.getEffectiveSheet().getCell(r, c);
                    if (!this.isDiffableCell(ctx, cell)) continue;
                    sb.setLength(0);
                    cell.getMemberFromUserObject().stream().sorted((a, b) -> a.getDimension().getNumber().compareTo(b.getDimension().getNumber())).forEach(m -> sb.append(m.getDimension().getNumber()).append(':').append(m.getNumber()).append(','));
                    boolean bl = isLeaf = !cell.getMemberFromUserObject().stream().anyMatch(m -> ctx.contrainsNoneLeafOrLableMemberOnRowColDim(m.getDimension().getNumber() + "|" + m.getNumber()));
                    if (sb.length() <= 0) continue;
                    if (!cell.getVariant().isNumber()) {
                        txtData.put(sb.deleteCharAt(sb.length() - 1).toString(), cell.getValue() != null ? cell.getValue().toString() : null);
                        continue;
                    }
                    if (isLeaf) {
                        numberData.put(sb.deleteCharAt(sb.length() - 1).toString(), cell.getVariant().toBigDecimal());
                        continue;
                    }
                    unleafNumberData.put(sb.deleteCharAt(sb.length() - 1).toString(), cell.getVariant().toBigDecimal());
                }
            }
        }
        data.put(data_number, numberData);
        data.put(data_number_unleaf, unleafNumberData);
        data.put(data_txt, txtData);
        return data;
    }

    private boolean isDiffableCell(StyleContext ctx, Cell cell) {
        return cell.isMdDataDomain() && cell.getMemberFromUserObject() != null && !cell.getMemberFromUserObject().isEmpty();
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if ("import".equals(actionId) && evt.getReturnData() != null) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f", (String)"CslReportProcessPlugin_8", (String)"epm-eb-budget", (Object[])new Object[0]));
            this.setModified(false);
            this.refresh();
        }
    }

    private void setViewSpreadJs() {
        ArrayList<Map> MenuItems = new ArrayList<Map>();
        MenuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.pasteValues, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)false));
        MenuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.pasteValuesFormatting, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)false));
        MenuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.pasteAll, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        MenuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.pasteFormula, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        MenuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.pasteFormatting, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        MenuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.pasteFormulaFormatting, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        MenuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.filter, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        MenuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.sort, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        MenuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.hideRows, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        MenuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.unhideRows, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        MenuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.hideColumns, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        MenuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.unhideColumns, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        SpreadClientInvoker.invokeHideContextMenuItems(this.getClientViewProxy(), this.getSpreadKey(), MenuItems);
    }
}

