/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.report.export;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.cache.PageCache;
import kd.bos.schedule.api.MessageHandler;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.budget.formplugin.report.export.POICslReportProcessPlugin;
import kd.epm.eb.budget.formplugin.report.export.POISheetMergeHelper;
import kd.epm.eb.budget.formplugin.report.postman.AbstractReportPostman;
import kd.epm.eb.budget.formplugin.report.postman.ITabSort;
import kd.epm.eb.budget.formplugin.report.postman.ReportPostmanFactory;
import kd.epm.eb.business.utils.ImportAndExportUtil;
import kd.epm.eb.common.cache.threadlocal.EpmThreadLocalUtils;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.enums.status.ExportFileStatusEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.ebSpread.util.SpreadUtils;
import kd.epm.eb.spread.control.BGPOISpreadContainer;
import kd.epm.eb.spread.report.excel.util.FileUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jetbrains.annotations.Nullable;

public class BGExportDataTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(BGExportDataTask.class);
    private IFormView formView;
    private IPageCache pageCache;
    public static final String EXPORTFILE_ID = "exportfileid";

    public MessageHandler getMessageHandle() {
        return null;
    }

    public IFormView getFormView() {
        return this.formView;
    }

    public void setFormView(IFormView formView) {
        this.formView = formView;
    }

    public IPageCache getPageCache() {
        return this.pageCache;
    }

    public void setPageCache(IPageCache pageCache) {
        this.pageCache = pageCache;
    }

    public void execute(RequestContext requestContext, Map<String, Object> map1) throws KDException {
        log.info("bgexport start");
        if (map1 == null) {
            return;
        }
        List tempList = (List)map1.get("tempList");
        Map allPageDimMemberMap = (Map)map1.get("pageMember");
        String pageId = (String)map1.get("pageId");
        IFormView view = SessionManager.getCurrent().getView(pageId);
        PageCache pageCache = new PageCache(pageId);
        view.addService(IPageCache.class, (Object)pageCache);
        this.setFormView(view);
        this.pageCache = pageCache;
        String fileName = ResManager.loadKDString((String)"\u6587\u4ef6\u5bfc\u51fa", (String)"BgExportDataplugin_2", (String)"epm-eb-budget", (Object[])new Object[0]);
        String errorMessage = null;
        String exportFileId = null;
        try {
            this.beforeExecute(tempList, fileName);
            exportFileId = this.formView.getPageCache().get(EXPORTFILE_ID);
            this.updatePrecent(0, null, null);
            this.doExecute(tempList, allPageDimMemberMap, view, fileName);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            String message = e.getMessage();
            if (StringUtils.isNotEmpty((CharSequence)message) && message.contains("Java heap space")) {
                message = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff1a\u5185\u5b58\u6ea2\u51fa\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e", (String)"BGExportDataTask_2", (String)"epm-eb-budget", (Object[])new Object[0]);
            }
            errorMessage = this.handleError(exportFileId, message);
            this.formView.showErrorNotification(e.getMessage());
        }
        catch (OutOfMemoryError error) {
            log.error((Throwable)error);
            errorMessage = this.handleError(exportFileId, ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff1a\u5185\u5b58\u6ea2\u51fa\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e", (String)"BGExportDataTask_2", (String)"epm-eb-budget", (Object[])new Object[0]));
        }
        this.afterExecute(errorMessage, exportFileId);
    }

    protected void afterExecute(String errorMessage, String exportFileId) {
        HashMap<String, String> returnDataMap = new HashMap<String, String>(16);
        returnDataMap.put("errorMessage", errorMessage);
        returnDataMap.put("exportFileId", exportFileId);
        this.feedbackCustomdata(returnDataMap);
        this.updatePrecent(100, ResManager.loadKDString((String)"\u6267\u884c\u5b8c\u6210", (String)"BGExportDataTask_1", (String)"epm-eb-budget", (Object[])new Object[0]), null);
    }

    @Nullable
    private String handleError(String exportFileId, String message) {
        DynamicObject dynamicObject;
        if (StringUtils.isNotEmpty((CharSequence)exportFileId) && (dynamicObject = BusinessDataServiceHelper.loadSingle((Object)exportFileId, (String)"eb_exportfilelist")) != null) {
            dynamicObject.set("status", (Object)ExportFileStatusEnum.EXPORT_FAIL.getIndex());
            if (StringUtils.isNotEmpty((CharSequence)message)) {
                dynamicObject.set("errormsg", (Object)(message.length() > 2000 ? message.substring(0, 2000) : message));
            }
            SaveServiceHelper.update((DynamicObject)dynamicObject);
        }
        return message;
    }

    public void updatePrecent(int process, String message, Map<String, Object> customData) {
        if (StringUtils.isNotEmpty((CharSequence)message)) {
            this.feedbackProgress(process, message, customData);
        } else {
            this.feedbackProgress(process);
        }
        String exportFileId = this.formView.getPageCache().get(EXPORTFILE_ID);
        if (StringUtils.isNotEmpty((CharSequence)exportFileId)) {
            DB.update((DBRoute)BgBaseConstant.epm, (String)"update t_eb_exportfilelist set fmodifydate = ?,fprogress = ? where fid = ?", (Object[])new Object[]{TimeServiceHelper.now(), process + "%", IDUtils.toLong((Object)exportFileId)});
        }
    }

    private void beforeExecute(List<Map<String, Object>> tempList, String fileName) {
        if (CollectionUtils.isNotEmpty(tempList)) {
            Map<String, Object> tempMap = tempList.get(0);
            DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)"eb_exportfilelist");
            dy.set("model", tempMap.get("model.id"));
            dy.set("fileName", (Object)fileName);
            dy.set("creater", (Object)UserUtils.getUserId());
            dy.set("createdate", (Object)TimeServiceHelper.now());
            dy.set("downloadcount", (Object)0);
            dy.set("status", (Object)ExportFileStatusEnum.EXPORT_ING.getIndex());
            dy.set("filetype", (Object)Character.valueOf('0'));
            dy.set("modifier", (Object)UserUtils.getUserId());
            dy.set("modifydate", (Object)TimeServiceHelper.now());
            Object[] save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dy});
            this.formView.getPageCache().put(EXPORTFILE_ID, ((DynamicObject)save[0]).getString("id"));
        }
    }

    private void doExecute(List<Map<String, Object>> tempList, Map<String, Map<String, String>> allPageDimMemberMap, IFormView view, String fileName) {
        BGPOISpreadContainer poiSpreadContainer = new BGPOISpreadContainer(fileName);
        ArrayList<String> sheetNames = new ArrayList<String>(16);
        SpreadUtils.SetLicenseKey((boolean)true);
        int pluginIndex = 0;
        SXSSFWorkbook baseWorkBook = null;
        XSSFWorkbook workbook = null;
        HashMap<Integer, Short> styleMap = new HashMap<Integer, Short>(16);
        POICslReportProcessPlugin poiCslReportProcessPlugin = null;
        EpmThreadLocalUtils.setBudgetExportFlag();
        int index = 0;
        for (Map<String, Object> map : tempList) {
            String sheetName = map.get("entity.name") + "_" + map.get("template.name");
            String newSheetName = sheetNames.contains(sheetName = FileUtil.filterSpecialCharacter((String)sheetName, (String)"-")) ? (sheetName.length() > 31 - (index + "").length() ? sheetName.substring(0, 31 - (index + "").length()) + index : sheetName + index) : (sheetName.length() > 31 ? sheetName.substring(0, 31) : sheetName);
            if (sheetNames.contains(newSheetName)) {
                newSheetName = newSheetName.length() > 31 - (index + "").length() ? newSheetName.substring(0, 31 - (index + "").length()) + index : newSheetName + index;
            }
            sheetNames.add(newSheetName);
            ++index;
            AbstractReportPostman postman = ReportPostmanFactory.getReportPostmanByMap(ITabSort.SortEnum.SORT_ENT, map);
            if (postman.isSortByEntity()) {
                postman.addPair(map.get("template.id"), map.get("report.id"));
            } else {
                postman.addPair(map.get("entity.id"), map.get("report.id"));
            }
            postman.addReportListId(IDUtils.toLong((Object)map.get("id")));
            Map<String, String> pageMemberMap = allPageDimMemberMap.get(map.get("report.id") + "");
            poiSpreadContainer.setCurrentSheet(newSheetName);
            poiCslReportProcessPlugin = new POICslReportProcessPlugin(poiSpreadContainer, postman, pageMemberMap);
            poiCslReportProcessPlugin.setView(view);
            poiCslReportProcessPlugin.getPageCache().remove("f7MapFields");
            poiCslReportProcessPlugin.initialize();
            poiCslReportProcessPlugin.afterCreateNewData(null);
            workbook = poiSpreadContainer.getWorkbook();
            workbook.setSheetName(0, newSheetName);
            if (pluginIndex == 0) {
                baseWorkBook = new SXSSFWorkbook(workbook, 100);
            } else {
                POISheetMergeHelper.mergeWorkBook(baseWorkBook, (Workbook)workbook, styleMap);
                workbook = null;
            }
            poiCslReportProcessPlugin.destory();
            Double aDouble = (double)(++pluginIndex) / ((double)tempList.size() * 0.01);
            int intValue = aDouble.intValue();
            Integer bfb = intValue;
            this.updatePrecent(bfb, null, null);
        }
        this.downloadWorkBook((Workbook)baseWorkBook, fileName);
    }

    public void downloadWorkBook(Workbook workbook, String fileName) {
        if (workbook == null) {
            return;
        }
        try {
            String url = ImportAndExportUtil.writeFile((Workbook)workbook, (String)fileName, (int)43200);
            String processType = this.formView.getPageCache().get("current_rpt_type");
            if (StringUtils.isNotEmpty((CharSequence)processType)) {
                ImportAndExportUtil.addTempFileCheck((String)url, (String)(ProcessTypeEnum.TASK.getNumber().equals(processType) ? "eb_executetask" : "bgm_rptpreparation"), (String)ApplicationTypeEnum.BGM.getAppnum(), (int)10000);
            }
            ((IClientViewProxy)this.formView.getService(IClientViewProxy.class)).addAction("download", (Object)url);
            String exportFileId = this.formView.getPageCache().get(EXPORTFILE_ID);
            this.updateExportFileStatus(exportFileId, url, ExportFileStatusEnum.EXPORT_END.getIndex());
        }
        catch (IOException ex) {
            String exportFileId = this.formView.getPageCache().get(EXPORTFILE_ID);
            this.updateExportFileStatus(exportFileId, null, ExportFileStatusEnum.EXPORT_FAIL.getIndex());
            throw new KDException(ex.getMessage());
        }
        finally {
            try {
                workbook.close();
            }
            catch (IOException ex) {
                log.error((Throwable)ex);
            }
        }
    }

    private void updateExportFileStatus(String exportFileId, String url, String status) {
        DynamicObject dynamicObject;
        if (StringUtils.isNotEmpty((CharSequence)exportFileId) && (dynamicObject = BusinessDataServiceHelper.loadSingle((Object)exportFileId, (String)"eb_exportfilelist")) != null) {
            if (StringUtils.isNotBlank((CharSequence)url)) {
                dynamicObject.set("url", (Object)url);
            }
            dynamicObject.set("status", (Object)status);
            SaveServiceHelper.update((DynamicObject)dynamicObject);
        }
    }
}

