/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.report.export;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.IFormView;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.utils.UserUtils;
import org.jetbrains.annotations.NotNull;

public class BGReportExportController {
    private static final Log log = LogFactory.getLog(BGReportExportController.class);

    public static BGReportExportController getInstance() {
        return InnerClass.INSTANCE;
    }

    private BGReportExportController() {
    }

    public void exportData(List<Map<String, Object>> tempList, Map<Long, Map<String, String>> allPageDimMemberMap, IFormView view, CloseCallBack closeCallBack) {
        JobFormInfo jobFormInfo = this.getJobFormInfo(tempList, allPageDimMemberMap, view);
        jobFormInfo.setCloseCallBack(closeCallBack);
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)view);
    }

    @NotNull
    private JobFormInfo getJobFormInfo(List<Map<String, Object>> tempList, Map<Long, Map<String, String>> allPageDimMemberMap, IFormView view) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setTaskClassname("kd.epm.eb.budget.formplugin.report.export.BGExportDataTask");
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)tempList.get(0).get("model.id"), (String)"epm_model");
        String name = ResManager.loadResFormat((String)"%1-\u5bfc\u51fa\u6570\u636e", (String)"BGReportExportController_0", (String)"epm-eb-budget", (Object[])new Object[]{dynamicObject.getString("name")});
        jobInfo.setName(name);
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setCanStop(Boolean.valueOf(true));
        jobInfo.setCaption(name);
        jobInfo.setFailNotify(true);
        jobInfo.setTimeout(86400000);
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setAppId(view.getFormShowParameter().getServiceAppId());
        jobInfo.setRunByUserId(UserUtils.getUserId().longValue());
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("tempList", tempList);
        params.put("pageMember", allPageDimMemberMap);
        params.put("pageId", view.getPageId());
        params.put("modelId", tempList.get(0).get("model.id"));
        params.put("appId", view.getFormShowParameter().getServiceAppId());
        FormConfig formConfig = view.getFormShowParameter().getFormConfig();
        params.put("formConfig", formConfig.getEntityTypeId());
        params.put("parentPageId", view.getFormShowParameter().getPageId());
        params.put("rootPageId", view.getFormShowParameter().getRootPageId());
        jobInfo.setParams(params);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setJobInfo(jobInfo);
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setClickClassName("kd.epm.eb.formplugin.report.excel.controller.ReportExportTaskClick");
        jobFormInfo.setParentPageId(view.getFormShowParameter().getPageId());
        jobFormInfo.setRootPageId(view.getFormShowParameter().getRootPageId());
        return jobFormInfo;
    }

    private static class InnerClass {
        private static final BGReportExportController INSTANCE = new BGReportExportController();

        private InnerClass() {
        }
    }
}

