/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.report.export;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.budget.formplugin.report.export.BGReportExportController;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.ebcommon.common.util.QFBuilder;
import kd.epm.eb.common.ebcommon.common.util.ThrowableHelper;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.status.ExportFileStatusEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;

public class BgExportDataPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String REPORT_ENTITY = "report_entity";
    private static final String PAGEDIM_ENTITY = "pagedim_entity";
    private static final String DIM_MEMBER_SELECTRANGE_ID = "dimmebselectrangeid";
    private static final String ALL_TEMPLATE_PAGEMEMBER = "alltemplatepagemember";
    private static final String REPORT_ENTITYNAME = "reportEntityName";
    private static final BGReportExportController bgReportExportController = BGReportExportController.getInstance();
    private static final Log log = LogFactory.getLog(BgExportDataPlugin.class);
    private Map<Long, Map<String, Object>> orgInfoMap = new HashMap<Long, Map<String, Object>>(16);

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"pagedimmember"});
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl(REPORT_ENTITY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        this.initBasicInfo();
        this.cachePageMemberInfo(true);
        this.cacheReportEntityName();
    }

    private void cacheReportEntityName() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(REPORT_ENTITY);
        HashMap<Long, String> reportEntity = new HashMap<Long, String>(entryEntity.size());
        for (DynamicObject dynamicObject : entryEntity) {
            reportEntity.put(dynamicObject.getLong("report"), dynamicObject.getString("org.name"));
        }
        this.getPageCache().put(REPORT_ENTITYNAME, SerializationUtils.toJsonString(reportEntity));
    }

    private void cachePageMemberInfo(boolean isDefault) {
        if (isDefault) {
            HashMap reportPageMemberMap = new HashMap(16);
            Map<Long, DynamicObjectCollection> allTemplatePageMember = this.getAllTemplatePageMember();
            Map<String, Long> defaultDimensionMemberMap = this.getDefaultDimensionMemberMap();
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(REPORT_ENTITY);
            for (DynamicObject dynamicObject : entryEntity) {
                long templateId = dynamicObject.getLong("templatenumber_id");
                DynamicObjectCollection dynamicObjectCollection = allTemplatePageMember.get(templateId);
                if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) continue;
                long reportId = dynamicObject.getLong("report");
                Map<String, List<Long>> dimSelectMemberIdsMap = this.getDimSelectMemberIdsMap(reportId, dynamicObjectCollection, modelCacheHelper);
                HashMap<String, String> dimMemberNumberMap = new HashMap<String, String>(16);
                for (DynamicObject dimMember : dynamicObjectCollection) {
                    DynamicObject pagedimension = dimMember.getDynamicObject("pagedimension");
                    String dimNumber = pagedimension.getString("number");
                    Long defaultMemberId = defaultDimensionMemberMap.get(dimNumber);
                    Member member = modelCacheHelper.getMember(dimNumber, null, defaultMemberId);
                    List<Long> longs = dimSelectMemberIdsMap.get(dimNumber);
                    if (CollectionUtils.isNotEmpty(longs) && !longs.contains(defaultMemberId)) {
                        log.info("cachePageMemberInfo clear:{}", (Object)dimMember);
                        member = null;
                    }
                    if (member != null) {
                        dimMemberNumberMap.put(dimNumber, member.getNumber());
                        continue;
                    }
                    if (CollectionUtils.isNotEmpty(longs)) {
                        DynamicObject auditTrialDefaultMember;
                        if (SysDimensionEnum.AuditTrail.getNumber().equals(dimNumber) && (auditTrialDefaultMember = this.getAuditTrialDefaultMember()) != null && longs.contains(auditTrialDefaultMember.getLong("id"))) {
                            dimMemberNumberMap.put(dimNumber, auditTrialDefaultMember.getString("number"));
                            continue;
                        }
                        member = modelCacheHelper.getMember(dimNumber, null, longs.get(0));
                        dimMemberNumberMap.put(dimNumber, member == null ? null : member.getNumber());
                        continue;
                    }
                    dimMemberNumberMap.put(dimNumber, null);
                }
                reportPageMemberMap.put(reportId, dimMemberNumberMap);
                this.getPageCache().put(ALL_TEMPLATE_PAGEMEMBER, SerializationUtils.serializeToBase64(reportPageMemberMap));
            }
        } else {
            DynamicObjectCollection entryRowEntity = this.getModel().getEntryEntity(PAGEDIM_ENTITY);
            HashMap<String, String> updatePageDimMap = new HashMap<String, String>();
            for (DynamicObject object : entryRowEntity) {
                updatePageDimMap.put(object.getString("pagedimension.number"), object.getString("pagedimmembernumber"));
            }
            EntryGrid entryGrid = (EntryGrid)this.getControl(REPORT_ENTITY);
            int[] selectRows = entryGrid.getSelectRows();
            Map<Long, Map<String, String>> allPageDimMemberMap = this.getAllPageDimMemberMap();
            DynamicObject tempDyn = this.getModel().getEntryRowEntity(REPORT_ENTITY, selectRows[0]);
            long reportId = tempDyn.getLong("report");
            allPageDimMemberMap.put(reportId, updatePageDimMap);
            this.getView().getPageCache().put(ALL_TEMPLATE_PAGEMEMBER, SerializationUtils.serializeToBase64(allPageDimMemberMap));
        }
    }

    private Map<String, List<Long>> getDimSelectMemberIdsMap(Long reportId, DynamicObjectCollection dyn, IModelCacheHelper modelCacheHelper) {
        Map dimSelectMemberIdsMap = new HashMap(16);
        String allDimSelectMeberIdsStr = this.getPageCache().get(DIM_MEMBER_SELECTRANGE_ID);
        if (StringUtils.isNotEmpty((String)allDimSelectMeberIdsStr) && (dimSelectMemberIdsMap = (Map)SerializationUtils.deSerializeFromBase64((String)allDimSelectMeberIdsStr)).containsKey(reportId)) {
            return (Map)dimSelectMemberIdsMap.get(reportId);
        }
        HashMap dimMemberMap = new HashMap(16);
        for (DynamicObject dimMember : dyn) {
            DynamicObject pagedimension = dimMember.getDynamicObject("pagedimension");
            String dimNumber = pagedimension.getString("number");
            List ids = (List)dimMemberMap.get(dimNumber);
            if (SysDimensionEnum.Entity.getNumber().equals(dimNumber)) {
                Map<Long, Map<String, Object>> orgInfoMap = this.getOrgInfoMap();
                Map<String, Object> map = orgInfoMap.get(reportId);
                if (!map.containsKey("entity.id")) continue;
                Long aLong = IDUtils.toLong((Object)map.get("entity.id"));
                Member member = modelCacheHelper.getMember(dimNumber, null, aLong);
                List member1 = modelCacheHelper.getMember(dimNumber, null, member.getNumber(), RangeEnum.ALL.getIndex());
                List collect = member1.stream().map(x -> x.getId()).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty((Collection)ids)) {
                    ids.addAll(collect);
                    dimMemberMap.put(dimNumber, ids);
                    continue;
                }
                dimMemberMap.put(dimNumber, collect);
                continue;
            }
            Member pagememberid = modelCacheHelper.getMember(dimNumber, null, Long.valueOf(dimMember.getLong("pagemembid")));
            List membbound = modelCacheHelper.getMember(dimNumber, null, pagememberid.getNumber(), dimMember.getInt("membbound"));
            List collect = membbound.stream().map(x -> x.getId()).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty((Collection)ids)) {
                ids.addAll(collect);
                dimMemberMap.put(dimNumber, ids);
                continue;
            }
            dimMemberMap.put(dimNumber, collect);
        }
        dimSelectMemberIdsMap.put(reportId, dimMemberMap);
        this.getPageCache().put(DIM_MEMBER_SELECTRANGE_ID, SerializationUtils.serializeToBase64(dimSelectMemberIdsMap));
        return (Map)dimSelectMemberIdsMap.get(reportId);
    }

    private Map<String, Long> getDefaultDimensionMemberMap() {
        HashMap<String, Long> defalutDimensionMemberMap = new HashMap<String, Long>(5);
        DynamicObject fyear = (DynamicObject)this.getModel().getValue("year");
        DynamicObject period = (DynamicObject)this.getModel().getValue("period");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        DynamicObject version = (DynamicObject)this.getModel().getValue("version");
        DynamicObject scene = (DynamicObject)this.getModel().getValue("scene");
        defalutDimensionMemberMap.put(SysDimensionEnum.Year.getNumber(), fyear.getLong("id"));
        defalutDimensionMemberMap.put(SysDimensionEnum.Period.getNumber(), period.getLong("id"));
        defalutDimensionMemberMap.put(SysDimensionEnum.Currency.getNumber(), currency.getLong("id"));
        defalutDimensionMemberMap.put(SysDimensionEnum.Version.getNumber(), version.getLong("id"));
        defalutDimensionMemberMap.put(SysDimensionEnum.Scenario.getNumber(), scene.getLong("id"));
        return defalutDimensionMemberMap;
    }

    public Map<Long, Map<String, Object>> getOrgInfoMap() {
        if (this.orgInfoMap.size() == 0) {
            Object template = this.getView().getFormShowParameter().getCustomParam("template");
            List tempList = (List)SerializationUtils.fromJsonString((String)((String)template), List.class);
            for (Map map : tempList) {
                HashMap temp = new HashMap(3);
                temp.put("entity.id", map.get("entity.id"));
                temp.put("entity.number", map.get("entity.number"));
                temp.put("entity.name", map.get("entity.name"));
                this.orgInfoMap.put(IDUtils.toLong(map.get("report.id")), temp);
            }
        }
        return this.orgInfoMap;
    }

    private Map<Long, DynamicObjectCollection> getAllTemplatePageMember() {
        HashMap<Long, DynamicObjectCollection> result = new HashMap<Long, DynamicObjectCollection>(16);
        Object template = this.getView().getFormShowParameter().getCustomParam("template");
        List tempList = (List)SerializationUtils.fromJsonString((String)((String)template), List.class);
        HashSet<Long> templateIds = new HashSet<Long>(16);
        for (Map map : tempList) {
            templateIds.add(IDUtils.toLong(map.get("template.id")));
        }
        QFilter qFilter = new QFilter("id", "in", templateIds);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"eb_templateentity_bg", (String)this.getSimpleModelSeleter(), (QFilter[])qFilter.toArray());
        if (load == null || load.length == 0) {
            return result;
        }
        for (DynamicObject dynamicObject : load) {
            result.put(dynamicObject.getLong("id"), dynamicObject.getDynamicObjectCollection("pagemembentry"));
        }
        return result;
    }

    public String getSimpleModelSeleter() {
        StringBuilder select = new StringBuilder();
        select.append("id,pagemembentry.seq,pagemembentry.pagemembid,pagemembentry.pagedimension,pagemembentry.membbound,");
        return select.toString();
    }

    protected DynamicObject getAuditTrialDefaultMember() {
        QFBuilder qf = new QFBuilder();
        qf.add("model", "=", (Object)this.getModelId());
        qf.add("number", "=", (Object)"EntityInput");
        DynamicObject dyna = BusinessDataServiceHelper.loadSingleFromCache((String)"epm_audittrialmembertree", (String)"id,number,name,dimension", (QFilter[])qf.toArray());
        return dyna;
    }

    private void initBasicInfo() {
        this.getModel().deleteEntryData(REPORT_ENTITY);
        this.getModel().deleteEntryData(PAGEDIM_ENTITY);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object templateData = customParams.get("template");
        if (templateData == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5bfc\u51fa\u7684\u62a5\u8868\u3002", (String)"BgExportDataplugin_0", (String)"epm-eb-budget", (Object[])new Object[0]));
        }
        List tempList = (List)SerializationUtils.fromJsonString((String)((String)templateData), List.class);
        this.getModel().batchCreateNewEntryRow(REPORT_ENTITY, tempList.size());
        int i = 0;
        for (Map map : tempList) {
            this.getModel().setValue("templatenumber", map.get("template.id"), i);
            this.getModel().setValue("org", map.get("entity.id"), i);
            this.getModel().setValue("report", map.get("report.id"), i);
            ++i;
        }
        this.getModel().beginInit();
        this.getModel().setValue("model", customParams.get("model"));
        this.getModel().setValue("year", customParams.get("fyear"));
        this.getModel().setValue("period", customParams.get("period"));
        this.getModel().setValue("currency", customParams.get("currency"));
        this.getModel().setValue("version", customParams.get("version"));
        this.getModel().setValue("scene", customParams.get("scene"));
        this.getModel().endInit();
        this.getView().updateView(REPORT_ENTITY);
        EntryGrid entryGrid = (EntryGrid)this.getControl(REPORT_ENTITY);
        entryGrid.selectRows(1);
    }

    private Long getModelId() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object o = customParams.get("model");
        if (o == null) {
            return 0L;
        }
        return IDUtils.toLong(o);
    }

    public void entryRowClick(RowClickEvent evt) {
        int row = evt.getRow();
        this.setPageDimEntryEntity(row);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String opkey = ((Control)evt.getSource()).getKey();
        if (StringUtils.equals((String)opkey, (String)"pagedimmember")) {
            this.openPageDimMemberF7();
        }
    }

    private void openPageDimMemberF7() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(PAGEDIM_ENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        EntryGrid entryGrid1 = (EntryGrid)this.getControl(REPORT_ENTITY);
        int[] selectRows1 = entryGrid1.getSelectRows();
        DynamicObject pageDimension = (DynamicObject)this.getModel().getValue("pagedimension", selectRows[0]);
        String dimNumber = pageDimension.getString("number");
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(REPORT_ENTITY, selectRows1[0]);
        long reportId = entryRowEntity.getLong("report");
        List<QFilter> filters = this.getCurrentDimFilters(reportId, dimNumber);
        Long modelId = this.getModelId();
        MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNumber), (String)ListSelectedRow.class.getName());
        f7Param.setBusModelId(Long.valueOf(0L));
        f7Param.addCustomFilter(filters);
        NewF7Utils.openF7((IFormView)this.getView(), (MemberF7Parameter)f7Param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, PAGEDIM_ENTITY));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (actionId) {
            case "pagedim_entity": {
                this.dealPageDimCloseCallBack(returnData);
                this.cachePageMemberInfo(false);
                break;
            }
            case "exportCloseCallBack": {
                this.exportCloseCallBack(returnData);
                break;
            }
        }
    }

    private void dealPageDimCloseCallBack(Object returnData) {
        ListSelectedRow listSelectedRow = ((ListSelectedRowCollection)returnData).get(0);
        String dimMemberNumber = listSelectedRow.getNumber();
        String name = listSelectedRow.getName();
        EntryGrid entryGrid = (EntryGrid)this.getControl(PAGEDIM_ENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        this.getModel().setValue("pagedimmember", (Object)name, selectRows[0]);
        this.getModel().setValue("pagedimmembernumber", (Object)dimMemberNumber, selectRows[0]);
    }

    private List<QFilter> getCurrentDimFilters(Long reportId, String dimNumber) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        Map<String, List<Long>> dimSelectMemberIds = this.getDimMemberSelectIdByReportId(reportId);
        List<Long> selectMemberIds = dimSelectMemberIds.get(dimNumber);
        if (CollectionUtils.isNotEmpty(selectMemberIds)) {
            filters.add(new QFilter("id", "in", selectMemberIds));
        }
        if ("Entity".equals(dimNumber)) {
            filters.clear();
            filters.add(new QFilter("longnumber", "like", (Object)(this.getOrgLongNumber() + "!" + "%")).or(new QFilter("longnumber", "=", (Object)this.getOrgLongNumber())));
        }
        return filters;
    }

    private String getOrgLongNumber() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Map orgMap = (Map)SerializationUtils.fromJsonString((String)((String)customParams.get("org")), Map.class);
        IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)this.getModelId());
        Member member = orCreate.getMember("Entity", null, IDUtils.toLong(orgMap.get("id")));
        if (member != null) {
            return member.getLongNumber();
        }
        return null;
    }

    private Map<String, List<Long>> getDimMemberSelectIdByReportId(Long reportId) {
        Map dimSelectMemberIdsMap = new HashMap(16);
        String allDimSelectMeberIdsStr = this.getPageCache().get(DIM_MEMBER_SELECTRANGE_ID);
        if (StringUtils.isNotEmpty((String)allDimSelectMeberIdsStr) && (dimSelectMemberIdsMap = (Map)SerializationUtils.deSerializeFromBase64((String)allDimSelectMeberIdsStr)).containsKey(reportId)) {
            return (Map)dimSelectMemberIdsMap.get(reportId);
        }
        return new HashMap<String, List<Long>>(16);
    }

    private void setPageDimEntryEntity(int row) {
        this.getModel().deleteEntryData(PAGEDIM_ENTITY);
        if (row == -1) {
            return;
        }
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(REPORT_ENTITY, row);
        long reportId = entryRowEntity.getLong("report");
        Map<String, String> dimMemberNumberMap = this.getPageDimMemberMap(reportId);
        if (dimMemberNumberMap == null || dimMemberNumberMap.size() == 0) {
            return;
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        int[] entryRows = this.getModel().batchCreateNewEntryRow(PAGEDIM_ENTITY, dimMemberNumberMap.size());
        int i = 0;
        for (Map.Entry<String, String> entry : dimMemberNumberMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            Dimension dimension = modelCacheHelper.getDimension(key);
            Member member = modelCacheHelper.getMember(key, null, value);
            this.getModel().setValue("pagedimension", (Object)dimension.getId(), entryRows[i]);
            if (member != null) {
                this.getModel().setValue("pagedimmember", (Object)member.getName(), entryRows[i]);
                this.getModel().setValue("pagedimmembernumber", (Object)member.getNumber(), entryRows[i]);
            } else {
                log.info("clear member info:{}", (Object)dimension.getNumber());
                this.getModel().setValue("pagedimmember", null, entryRows[i]);
                this.getModel().setValue("pagedimmembernumber", null, entryRows[i]);
            }
            this.getView().setEnable(Boolean.valueOf(this.isPageDimMemberEnable(key)), entryRows[i], new String[]{"pagedimmember"});
            ++i;
        }
    }

    private boolean isPageDimMemberEnable(String dimNumber) {
        return !dimNumber.equals(SysDimensionEnum.Period.getNumber()) && !dimNumber.equals(SysDimensionEnum.Version.getNumber()) && !dimNumber.equals(SysDimensionEnum.Year.getNumber()) && !dimNumber.equals(SysDimensionEnum.Currency.getNumber());
    }

    private Map<Long, Map<String, String>> getAllPageDimMemberMap() {
        String allPageDimMemberMapCache = this.getView().getPageCache().get(ALL_TEMPLATE_PAGEMEMBER);
        if (allPageDimMemberMapCache != null) {
            return (Map)SerializationUtils.deSerializeFromBase64((String)allPageDimMemberMapCache);
        }
        return new HashMap<Long, Map<String, String>>();
    }

    private Map<String, String> getPageDimMemberMap(Long templateId) {
        return this.getAllPageDimMemberMap().get(templateId);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("btn_export".equals(itemKey)) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Object templateData = customParams.get("template");
            if (templateData == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5bfc\u51fa\u7684\u62a5\u8868\u3002", (String)"BgExportDataplugin_0", (String)"epm-eb-budget", (Object[])new Object[0]));
            }
            List tempList = (List)SerializationUtils.fromJsonString((String)((String)templateData), List.class);
            DynamicObjectCollection entity = this.getModel().getEntryEntity(REPORT_ENTITY);
            ArrayList<Map<String, Object>> processList = new ArrayList<Map<String, Object>>(tempList.size());
            block0: for (DynamicObject dynamicObject : entity) {
                long templateId = dynamicObject.getLong("templatenumber_id");
                long orgId = dynamicObject.getLong("org_id");
                for (Map map : tempList) {
                    if ((Long)map.get("template.id") != templateId || (Long)map.get("entity.id") != orgId) continue;
                    processList.add(map);
                    continue block0;
                }
            }
            Map<Long, Map<String, String>> allPageDimMemberMap = this.getAllPageDimMemberMap();
            this.batchExport(processList, allPageDimMemberMap);
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u6570\u636e\u5bfc\u51fa", "BgExportDataplugin_3", "epm-eb-budget");
            MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u5bfc\u51fa\u63d0\u4ea4", "BgExportDataplugin_4", "epm-eb-budget");
            OperationLogUtil.log((String)this.getView().getFormShowParameter().getAppId(), (String)this.getView().getFormShowParameter().getFormId(), null, (String)"export", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDescription, null);
        } else if ("btn_download".equals(itemKey)) {
            this.openDownloadPage();
        }
    }

    private void openDownloadPage() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("eb_exportfilelist");
        OpenStyle openStyle = showParameter.getOpenStyle();
        openStyle.setShowType(ShowType.Modal);
        StyleCss css = new StyleCss();
        css.setWidth("960");
        css.setHeight("580");
        openStyle.setInlineStyleCss(css);
        showParameter.setMultiSelect(true);
        showParameter.setShowTitle(true);
        showParameter.setLookUp(false);
        showParameter.setCustomParam("model", (Object)this.getModelId());
        showParameter.setCustomParam("creater", (Object)UserUtils.getUserId());
        showParameter.setCustomParam("sourceFormId", (Object)this.getView().getFormShowParameter().getFormId());
        ArrayList filters = Lists.newArrayList((Object[])new QFilter[]{new QFilter("model", "=", (Object)this.getModelId())});
        filters.add(new QFilter("creater", "=", (Object)UserUtils.getUserId()));
        showParameter.getListFilterParameter().setQFilters((List)filters);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void batchExport(List<Map<String, Object>> tempList, Map<Long, Map<String, String>> allPageDimMemberMap) {
        try {
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "exportCloseCallBack");
            bgReportExportController.exportData(tempList, allPageDimMemberMap, this.getView(), closeCallBack);
        }
        catch (Exception e) {
            DynamicObject dynamicObject;
            String exportFileId = this.getPageCache().get("exportfileid");
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)exportFileId) && (dynamicObject = BusinessDataServiceHelper.loadSingle((Object)exportFileId, (String)"eb_exportfilelist")) != null) {
                dynamicObject.set("status", (Object)ExportFileStatusEnum.EXPORT_FAIL.getIndex());
                SaveServiceHelper.update((DynamicObject)dynamicObject);
            }
            log.error(((Object)((Object)this)).getClass().getName());
            log.error((Throwable)e);
            if (e instanceof KDBizException) {
                throw new KDBizException(e.getMessage());
            }
            throw new KDBizException(ThrowableHelper.toString((Exception)e));
        }
    }

    private void exportCloseCallBack(Object returnData) {
        Map data;
        Map taskInfo;
        Map returnMap = (Map)returnData;
        if (returnMap != null && returnMap.size() > 0 && (taskInfo = (Map)SerializationUtils.fromJsonString((String)((String)returnMap.get("taskinfo")), HashMap.class)) != null && taskInfo.size() > 0 && (data = (Map)SerializationUtils.fromJsonString((String)((String)taskInfo.get("data")), HashMap.class)) != null && data.size() > 0) {
            DynamicObject dynamicObject;
            String errorMessage = (String)data.get("errorMessage");
            String exportFileId = (String)data.get("exportFileId");
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)errorMessage)) {
                this.getView().showErrorNotification(errorMessage);
            } else if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)exportFileId) && (dynamicObject = BusinessDataServiceHelper.loadSingle((Object)exportFileId, (String)"eb_exportfilelist")) != null && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)dynamicObject.getString("url"))) {
                ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)dynamicObject.getString("url"));
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f\u3002", (String)"BgmReportExportDataPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                int download = dynamicObject.getInt("downloadcount") + 1;
                dynamicObject.set("downloadcount", (Object)download);
                SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dynamicObject});
            }
        }
    }
}

