/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.report.export;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.PaneInformation;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFDrawing;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;

public class POISheetMergeHelper {
    public static void copyCell(Workbook wb, Cell fromCell, Cell toCell, Map<Short, Short> styles) {
        short index = fromCell.getCellStyle().getIndex();
        Short stylesOrDefault = styles.getOrDefault(index, (short)Short.MIN_VALUE);
        CellStyle newstyle = wb.getCellStyleAt((int)stylesOrDefault.shortValue());
        if (newstyle == null) {
            newstyle = wb.createCellStyle();
            POISheetMergeHelper.copyCellStyle(fromCell.getCellStyle(), newstyle);
            styles.put(fromCell.getCellStyle().getIndex(), newstyle.getIndex());
        }
        toCell.setCellStyle(newstyle);
        if (fromCell.getCellComment() != null) {
            toCell.setCellComment(fromCell.getCellComment());
        }
        POISheetMergeHelper.copyCellValue(toCell, fromCell);
    }

    public static void copyCellStyle(CellStyle fromStyle, CellStyle toStyle) {
        toStyle.cloneStyleFrom(fromStyle);
    }

    public static void copyCellValue(Cell cell, Cell fromCell) {
        CellType cellType = fromCell.getCellType();
        SXSSFCell toCell = (SXSSFCell)cell;
        if (cellType != CellType.FORMULA) {
            toCell.setCellType(cellType);
        }
        switch (cellType) {
            case STRING: {
                toCell.setCellValue(fromCell.getRichStringCellValue());
                break;
            }
            case NUMERIC: {
                toCell.setCellValue(fromCell.getNumericCellValue());
                break;
            }
            case FORMULA: {
                POISheetMergeHelper.copyCtCellFormulaValue(fromCell, (Cell)toCell);
                break;
            }
            case BOOLEAN: {
                toCell.setCellValue(fromCell.getBooleanCellValue());
                break;
            }
            case ERROR: {
                toCell.setCellValue((double)fromCell.getErrorCellValue());
                break;
            }
            case BLANK: {
                toCell.setBlank();
                break;
            }
        }
    }

    private static void copyCtCellFormulaValue(Cell fromCell, Cell toCell) {
        POISheetMergeHelper.updateCtCellFormulaValue(toCell, fromCell.getCellFormula());
    }

    private static void updateCtCellFormulaValue(Cell cell, String shiftedFormula) {
        if (shiftedFormula != null) {
            try {
                cell.removeFormula();
                cell.setCellFormula(shiftedFormula);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void copyCol(Sheet sheetAt, int startRowIndex, int rowCount, int oldCol, int toCol, Map<Short, Short> styles) {
        for (int i = startRowIndex; i < startRowIndex + rowCount; ++i) {
            Cell oldCell;
            Row row = sheetAt.getRow(i);
            if (row == null || (oldCell = row.getCell(oldCol)) == null) continue;
            Cell toCell = row.getCell(toCol);
            if (toCell == null) {
                toCell = row.createCell(toCol);
            }
            POISheetMergeHelper.copyCell(sheetAt.getWorkbook(), oldCell, toCell, styles);
        }
    }

    public static void copyRow(Sheet sheetAt, int oldRowIndex, int toRowIndex, int startCol, int colCount, Map<Short, Short> styles) {
        Row oldRow = sheetAt.getRow(oldRowIndex);
        Row toRow = sheetAt.getRow(toRowIndex);
        if (oldRow == null || toRow == null) {
            return;
        }
        toRow.setRowStyle(oldRow.getRowStyle());
        for (int i = startCol; i < startCol + colCount; ++i) {
            Cell cell = oldRow.getCell(i);
            if (cell == null) continue;
            Cell newCell = toRow.getCell(i);
            if (newCell == null) {
                newCell = toRow.createCell(i);
            }
            POISheetMergeHelper.copyCell(sheetAt.getWorkbook(), cell, newCell, styles);
        }
    }

    public static void mergeWorkBook(Workbook baseWorkBook, Workbook fromWorkBook, Map<Integer, Short> styleMap) {
        boolean freezePane;
        Sheet fromSheet = fromWorkBook.getSheetAt(0);
        SXSSFSheet sheet = (SXSSFSheet)baseWorkBook.createSheet(fromSheet.getSheetName());
        int defaultColumnWidth = fromSheet.getDefaultColumnWidth();
        short defaultRowHeight = fromSheet.getDefaultRowHeight();
        float defaultRowHeightInPoints = fromSheet.getDefaultRowHeightInPoints();
        sheet.setDefaultColumnWidth(defaultColumnWidth);
        sheet.setDefaultRowHeight(defaultRowHeight);
        sheet.setDefaultRowHeightInPoints(defaultRowHeightInPoints);
        List mergedRegions = fromSheet.getMergedRegions();
        for (CellRangeAddress mergedRegion : mergedRegions) {
            try {
                sheet.addMergedRegion(mergedRegion);
            }
            catch (Exception exception) {}
        }
        PaneInformation paneInformation = fromSheet.getPaneInformation();
        if (paneInformation != null && (freezePane = paneInformation.isFreezePane())) {
            short horizontalSplitPosition = paneInformation.getHorizontalSplitPosition();
            short verticalSplitPosition = paneInformation.getVerticalSplitPosition();
            short horizontalSplitTopRow = paneInformation.getHorizontalSplitTopRow();
            short verticalSplitLeftColumn = paneInformation.getVerticalSplitLeftColumn();
            sheet.createFreezePane((int)verticalSplitPosition, (int)horizontalSplitPosition, (int)verticalSplitLeftColumn, (int)horizontalSplitTopRow);
        }
        int i = 0;
        for (Row fromRow : fromSheet) {
            if (fromRow == null) continue;
            SXSSFRow row = sheet.createRow(fromRow.getRowNum());
            CellStyle fromRowStyle = fromRow.getRowStyle();
            if (fromRowStyle != null) {
                int fromHashCode = fromRowStyle.hashCode();
                Short index = styleMap.get(fromHashCode);
                if (index == null) {
                    CellStyle rowStyle = baseWorkBook.createCellStyle();
                    rowStyle.cloneStyleFrom(fromRowStyle);
                    row.setRowStyle(rowStyle);
                    styleMap.put(fromHashCode, rowStyle.getIndex());
                } else {
                    CellStyle cellStyleAt = baseWorkBook.getCellStyleAt((int)index.shortValue());
                    cellStyleAt.cloneStyleFrom(fromRowStyle);
                    row.setRowStyle(cellStyleAt);
                }
            }
            short height = fromRow.getHeight();
            row.setHeight(height);
            int j = 0;
            for (Cell fromCell : fromRow) {
                int columnWidth;
                if (fromCell == null) continue;
                CellStyle fromColumnStyle = fromSheet.getColumnStyle(j);
                if (fromColumnStyle != null) {
                    Integer fromHashCode = fromColumnStyle.hashCode();
                    Short index = styleMap.get(fromHashCode);
                    if (index == null) {
                        CellStyle cellStyle = baseWorkBook.createCellStyle();
                        cellStyle.cloneStyleFrom(fromColumnStyle);
                        sheet.setDefaultColumnStyle(j, cellStyle);
                        styleMap.put(fromHashCode, cellStyle.getIndex());
                    } else {
                        CellStyle cellStyleAt = baseWorkBook.getCellStyleAt((int)index.shortValue());
                        sheet.setDefaultColumnStyle(j, cellStyleAt);
                    }
                }
                Cell cell = row.createCell(fromCell.getColumnIndex());
                POISheetMergeHelper.copyCellValue(cell, fromCell);
                CellStyle fromCellStyle = fromCell.getCellStyle();
                if (fromCellStyle != null) {
                    int fromHashCode = fromCellStyle.hashCode();
                    Short index = styleMap.get(fromHashCode);
                    if (index == null) {
                        CellStyle cellStyle = baseWorkBook.createCellStyle();
                        cellStyle.cloneStyleFrom(fromCellStyle);
                        cell.setCellStyle(cellStyle);
                        styleMap.put(fromHashCode, cellStyle.getIndex());
                    } else {
                        CellStyle cellStyleAt = baseWorkBook.getCellStyleAt((int)index.shortValue());
                        cell.setCellStyle(cellStyleAt);
                    }
                }
                if ((columnWidth = fromSheet.getColumnWidth(j)) > 65280) {
                    columnWidth = 65280;
                }
                sheet.setColumnWidth(j, columnWidth);
                Comment fromCellComment = fromCell.getCellComment();
                if (fromCellComment != null) {
                    ClientAnchor clientAnchor = fromCellComment.getClientAnchor();
                    XSSFClientAnchor xssfClientAnchor = new XSSFClientAnchor();
                    xssfClientAnchor.setDx1(clientAnchor.getDx1());
                    xssfClientAnchor.setDx2(clientAnchor.getDx2());
                    xssfClientAnchor.setDy1(clientAnchor.getDy1());
                    xssfClientAnchor.setDy2(clientAnchor.getDy2());
                    xssfClientAnchor.setCol1((int)clientAnchor.getCol1());
                    xssfClientAnchor.setCol2((int)clientAnchor.getCol2());
                    xssfClientAnchor.setRow1(clientAnchor.getRow1());
                    xssfClientAnchor.setRow2(clientAnchor.getRow2());
                    RichTextString text = fromCellComment.getString();
                    SXSSFDrawing drawingPatriarch = sheet.createDrawingPatriarch();
                    Comment cellComment = drawingPatriarch.createCellComment((ClientAnchor)xssfClientAnchor);
                    cellComment.setString(text);
                    cell.setCellComment(cellComment);
                }
                ++j;
            }
            ++i;
        }
        try {
            sheet.flushRows();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

