/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.report.floatreport;

import com.google.common.collect.Multimap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.budget.formplugin.AbstractBaseFormPlugin;
import kd.epm.eb.budget.formplugin.report.AbstractMultiReportPlugin;
import kd.epm.eb.budget.formplugin.report.floatreport.FloatLogicImpl;
import kd.epm.eb.budget.formplugin.report.style.adjust.FloatDataProvider;
import kd.epm.eb.budget.formplugin.spread.SpreadClientInvoker;
import kd.epm.eb.budget.formplugin.template.model.AskExcuteInfo;
import kd.epm.eb.budget.formplugin.template.model.SpreadDataModel;
import kd.epm.eb.budget.formplugin.template.util.TemplateFloatUtil;
import kd.epm.eb.budget.formplugin.util.DimensionUtil;
import kd.epm.eb.budget.formplugin.util.MarkSpecialCell;
import kd.epm.eb.budget.formplugin.util.ObjectConvertUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.ebcommon.common.Pair;
import kd.epm.eb.common.ebcommon.common.Recorder;
import kd.epm.eb.common.ebcommon.common.enums.DimTypesEnum;
import kd.epm.eb.common.ebcommon.common.enums.FacTabFieldDefEnum;
import kd.epm.eb.common.ebcommon.common.enums.RowColExcuteEnum;
import kd.epm.eb.common.ebcommon.common.util.ExcelUtils;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;
import kd.epm.eb.common.ebcommon.common.util.RangeModel;
import kd.epm.eb.common.ebcommon.common.util.SpreadAreaUtil;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.ebBusiness.olap.IRelaMembSupplier;
import kd.epm.eb.ebBusiness.sql.DimGroupKey;
import kd.epm.eb.ebBusiness.sql.MDResultSet;
import kd.epm.eb.ebBusiness.sql.MemberGroupKey;
import kd.epm.eb.ebBusiness.sql.Row;
import kd.epm.eb.ebBusiness.template.model.TemplateModel;
import kd.epm.eb.ebSpread.domain.Cell;
import kd.epm.eb.ebSpread.domain.Domain;
import kd.epm.eb.ebSpread.domain.view.Sheet;
import kd.epm.eb.ebSpread.domain.view.SpreadManager;
import kd.epm.eb.ebSpread.domain.view.builder.PositionInfo;
import kd.epm.eb.ebSpread.domain.view.builder.dynamic.BasePointInfo;
import kd.epm.eb.ebSpread.domain.view.builder.dynamic.BasePointInnerLineInfo;
import kd.epm.eb.ebSpread.domain.view.builder.dynamic.event.AdjustRangeEvent;
import kd.epm.eb.ebSpread.domain.view.js.SpreadProperties;
import kd.epm.eb.ebSpread.model.DimMember;
import kd.epm.eb.ebSpread.model.IDimMember;
import kd.epm.eb.ebSpread.model.IDimension;
import kd.epm.eb.ebSpread.model.dao.MDDataHandleService;

public class AutoFloatLogicImpl {
    private static final String MatchBaseInfoWithRowCol = "matchbaseinfowithrowcol";
    private AbstractMultiReportPlugin plugin;
    private AbstractBaseFormPlugin abplugin;
    private TemplateModel templateModel;
    private IFormView view;
    private String spread_key;
    private SpreadManager sm;
    private List<Map<String, Object>> cellValues;
    private Map<String, Map<String, Map<String, String>>> result;
    private Map<String, String> orgname;
    private String reportOrgNumber;
    private List<Row> rowslimitfix;
    private PositionInfo positionInfo;
    private BasePointInfo basePointInfo;
    private IRelaMembSupplier<String, String> relaMembSupplier;
    private Log log = LogFactory.getLog(this.getClass());
    private Multimap<String, Row> mcMap;
    private Multimap<String, Row> icMap;

    public AutoFloatLogicImpl(AbstractMultiReportPlugin plugin) {
        this.plugin = plugin;
        this.sm = plugin.getSpreadModel();
    }

    public AutoFloatLogicImpl(AbstractBaseFormPlugin plugin, SpreadManager sm, IFormView view, String spread_key, TemplateModel templateModel) {
        this.abplugin = plugin;
        this.sm = sm;
        this.view = view;
        this.spread_key = spread_key;
        this.templateModel = templateModel;
    }

    public void setRelaMembSupplier(IRelaMembSupplier<String, String> relaMembSupplier) {
        this.relaMembSupplier = relaMembSupplier;
    }

    public void autoFloat(boolean isCsl, boolean isBase64, String orgNumber) {
        this.reportOrgNumber = orgNumber;
        AbstractBaseFormPlugin currentPlugin = this.plugin == null ? this.abplugin : this.plugin;
        Map<String, MDResultSet> setmap = FloatDataProvider.queryMDResultSetMapByPageAndView(this.sm, this.getModelId(), FloatLogicImpl.isDirectHoriz(currentPlugin.getPageCache()), this.relaMembSupplier);
        this.cellValues = new ArrayList<Map<String, Object>>();
        this.fillBackDimName();
        Iterator<PositionInfo> iterator = FloatLogicImpl.sortPositionInfo(this.sm.getAreaManager().getPostionInfoSet(), FloatLogicImpl.isDirectHoriz(currentPlugin.getPageCache())).iterator();
        while (iterator.hasNext()) {
            PositionInfo ps;
            this.positionInfo = ps = iterator.next();
            if (this.positionInfo.getBasePoints() == null || this.positionInfo.getBasePoints().isEmpty()) continue;
            Iterator<BasePointInfo> iterator2 = FloatLogicImpl.sortBasePoint(this.positionInfo.getBasePoints()).iterator();
            while (iterator2.hasNext()) {
                BasePointInfo bpi;
                this.basePointInfo = bpi = iterator2.next();
                List<String> dmNumberLis = this.getDmNumberLis();
                if (dmNumberLis == null) continue;
                List<Row> rows = this.getRows(isCsl, setmap);
                if (rows.isEmpty()) {
                    if (!this.isNoRecord(setmap, bpi) || this.isBlankAreaNoCrossDimCell(bpi.getDataArea(ps))) continue;
                    this.clearNoValueRowOrCol();
                    continue;
                }
                if (this.positionInfo.getFloatSummaryWay() == PositionInfo.FloatSummaryWay.NONSUPPORT) {
                    this.checkAndFloatForDifferentOrg(dmNumberLis, rows);
                    continue;
                }
                this.checkAndFloat(dmNumberLis, rows, currentPlugin.getPageCache());
            }
        }
        this.fillValue2Cell(setmap);
        if (isBase64) {
            SpreadClientInvoker.invokeUpdataValueMethod(currentPlugin.getClientViewProxy(), this.plugin == null ? this.spread_key : this.plugin.getSpreadKey(), this.cellValues);
        }
    }

    private void fillBackDimName() {
        ArrayList<IDimension> noNameDim = new ArrayList<IDimension>(16);
        Set postionInfoSet = this.sm.getAreaManager().getPostionInfoSet();
        for (PositionInfo positionInfo : postionInfoSet) {
            List basePoints = positionInfo.getBasePoints();
            for (BasePointInfo basePointInfo : basePoints) {
                List basePointInnerLineInfo = basePointInfo.getBasePointInnerLineInfo();
                for (BasePointInnerLineInfo innerLineInfo : basePointInnerLineInfo) {
                    IDimension dimension = innerLineInfo.getDimension();
                    if (dimension.getName() != null) continue;
                    noNameDim.add(dimension);
                }
            }
        }
        if (!noNameDim.isEmpty()) {
            long modelId = this.plugin.getModelId();
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
            for (IDimension dimension : noNameDim) {
                Dimension cacheDim = modelCacheHelper.getDimension(dimension.getNumber());
                if (cacheDim == null) continue;
                dimension.setName(cacheDim.getName());
            }
        }
    }

    private boolean isNoRecord(Map<String, MDResultSet> valueMap, BasePointInfo bp) {
        MDResultSet rs = valueMap.get(bp.getOriginalDynaRange());
        boolean isNoRecord = rs == null || rs.getCount() <= 0;
        rs = valueMap.get(bp.getOriginalDynaRange() + "unleaf");
        return isNoRecord && (rs == null || rs.getCount() <= 0);
    }

    private boolean isBlankAreaNoCrossDimCell(RangeModel range) {
        Recorder bool = new Recorder((Object)false);
        this.getEffectiveSheet().iteratorRangeByPredicateBreak(range.getY_start(), range.getY_end(), range.getX_start(), range.getX_end(), cell -> {
            bool.setRecord((Object)cell.isMdDataDomain());
            return cell.isMdDataDomain();
        });
        return (Boolean)bool.getRecord() == false;
    }

    private void fillValue2Cell(Map<String, MDResultSet> valueMap) {
        List rowTuples = null;
        List colTuples = null;
        MDResultSet rs = null;
        HashMap allSets = new HashMap();
        for (Map.Entry e : this.sm.getAreaManager()) {
            if (((PositionInfo)e.getKey()).getBasePoints() == null || ((PositionInfo)e.getKey()).getBasePoints().isEmpty()) continue;
            rowTuples = MDDataHandleService.genTuples((Domain)this.sm.getAreaManager().getRowDimDoman((PositionInfo)e.getKey()));
            colTuples = MDDataHandleService.genTuples((Domain)this.sm.getAreaManager().getColDimDomain((PositionInfo)e.getKey()));
            if (rowTuples.size() == 0 || colTuples.size() == 0) continue;
            List selectDimKey = MDDataHandleService.genDimKeySet((List[])new List[]{rowTuples, colTuples});
            for (BasePointInfo bp : ((PositionInfo)e.getKey()).getBasePoints()) {
                rs = valueMap.get(bp.getOriginalDynaRange());
                if (rs != null) {
                    allSets.putAll(rs.asMap("", selectDimKey));
                }
                if ((rs = valueMap.get(bp.getOriginalDynaRange() + "unleaf")) == null) continue;
                allSets.putAll(rs.asMap("", selectDimKey));
            }
        }
        MDDataHandleService.updateCellValues((SpreadManager)this.sm, allSets, (boolean)false);
    }

    private void clearNoValueRowOrCol() {
        AskExcuteInfo insexcuteinfo;
        int i;
        int originacolorrow;
        RangeModel rangeModel = new RangeModel(this.basePointInfo.getDynaRange());
        RangeModel originaldynaRange = new RangeModel(this.basePointInfo.getOriginalDynaRange());
        ArrayList<Integer> deledata = new ArrayList<Integer>(10);
        ArrayList<Integer> insertdata = new ArrayList<Integer>(10);
        int n = originacolorrow = this.basePointInfo.isDirectHoriz() ? originaldynaRange.getX_end() - originaldynaRange.getX_start() + 1 : originaldynaRange.getY_end() - originaldynaRange.getY_start() + 1;
        if (this.basePointInfo.isDirectHoriz()) {
            for (i = rangeModel.getX_start(); i < rangeModel.getX_end(); ++i) {
                deledata.add(i);
            }
            deledata.add(rangeModel.getY_end() + originacolorrow);
        } else {
            for (i = rangeModel.getY_start(); i < rangeModel.getY_end(); ++i) {
                deledata.add(i);
            }
            deledata.add(rangeModel.getY_end() + originacolorrow);
        }
        int start2insert = this.basePointInfo.isDirectHoriz() ? rangeModel.getX_end() : rangeModel.getY_end();
        for (int i2 = 0; i2 < originacolorrow; ++i2) {
            insertdata.add(start2insert);
        }
        AskExcuteInfo askExcuteInfo = insexcuteinfo = this.basePointInfo.isDirectHoriz() ? new AskExcuteInfo(1, RowColExcuteEnum.INSERTCOL, insertdata) : new AskExcuteInfo(0, RowColExcuteEnum.INSERTROW, insertdata);
        if (!this.basePointInfo.isDirectHoriz()) {
            insexcuteinfo.setCon(true);
        }
        if (this.plugin != null) {
            this.plugin.adjustSheetModelAndJs(insexcuteinfo);
            AskExcuteInfo excuteinfo = this.basePointInfo.isDirectHoriz() ? new AskExcuteInfo(1, RowColExcuteEnum.DELETECOL, deledata) : new AskExcuteInfo(0, RowColExcuteEnum.DELETEROW, deledata);
            this.plugin.adjustSheetModelAndJs(excuteinfo);
        }
    }

    private void checkAndFloatForDifferentOrg(List<String> dmNumberLis, List<Row> rows) {
        Map<MemberGroupKey, List<Row>> rowMap = this.toRowMap(rows, dmNumberLis);
        this.orgname = FloatDataProvider.getOrgNameMap(this.getModelId(), rows);
        this.mcMap = null;
        this.icMap = FloatLogicImpl.getRowTable(rows, DimTypesEnum.INTERCOMPANY.getNumber());
        Map fixmem = this.basePointInfo.getFixMemberPosition();
        Set fixmemset = fixmem.entrySet();
        for (Map.Entry entry : fixmemset) {
            int startvalueindex;
            int rangeendindex;
            int entryKey = (Integer)entry.getKey();
            ArrayList<String> floatnumber = new ArrayList<String>();
            List dimMembers = (List)entry.getValue();
            MemberGroupKey key = this.getRowKey(dimMembers, dmNumberLis);
            this.rowslimitfix = rowMap.get(key);
            if (this.rowslimitfix == null || this.rowslimitfix.isEmpty()) continue;
            this.filterFloatDim(rows, floatnumber);
            if (this.rowslimitfix.size() == 0) continue;
            String range = this.basePointInfo.getDynaRange();
            int rangestartindex = this.basePointInfo.isDirectHoriz() ? ExcelUtils.pos2X((String)range.split(":")[0]) : ExcelUtils.pos2Y((String)range.split(":")[0]);
            if (this.checkHasFloat(entryKey, floatnumber, rangestartindex, rangeendindex = this.basePointInfo.isDirectHoriz() ? ExcelUtils.pos2X((String)range.split(":")[1]) : ExcelUtils.pos2Y((String)range.split(":")[1]), startvalueindex = this.basePointInfo.isDirectHoriz() ? ExcelUtils.pos2Y((String)this.positionInfo.getStartPosition().split(":")[0]) : ExcelUtils.pos2X((String)this.positionInfo.getStartPosition().split(":")[0]), new HashSet<Integer>()) || this.rowslimitfix == null || this.rowslimitfix.isEmpty()) continue;
            FloatDataProvider.sortRowByDim(this.rowslimitfix, floatnumber.toArray(new String[0]));
            this.result = FloatLogicImpl.collectMemMsg(this.rowslimitfix, this.basePointInfo, this.getModelId());
            int start2insert = this.findStart2insertIndex(range, this.basePointInfo.isDirectHoriz());
            if (this.plugin != null) {
                this.plugin.insertRank(start2insert, this.rowslimitfix.size(), this.basePointInfo.getDynaRange(), this.basePointInfo.isDirectHoriz());
            } else {
                this.insertRank(start2insert, this.rowslimitfix.size(), this.basePointInfo.getDynaRange(), this.basePointInfo.isDirectHoriz(), this.abplugin.getPageCache());
            }
            this.updataSheetValue(entryKey, startvalueindex, start2insert);
        }
    }

    private void checkAndFloat(List<String> dmNumberLis, List<Row> rows, IPageCache pageCache) {
        Map fixmem = this.basePointInfo.getFixMemberPosition();
        Set fixmemset = fixmem.entrySet();
        String range = this.basePointInfo.getDynaRange();
        int rangestartindex = this.basePointInfo.isDirectHoriz() ? ExcelUtils.pos2X((String)range.split(":")[0]) : ExcelUtils.pos2Y((String)range.split(":")[0]);
        int rangeendindex = this.basePointInfo.isDirectHoriz() ? ExcelUtils.pos2X((String)range.split(":")[1]) : ExcelUtils.pos2Y((String)range.split(":")[1]);
        int startvalueindex = this.basePointInfo.isDirectHoriz() ? ExcelUtils.pos2Y((String)this.positionInfo.getStartPosition().split(":")[0]) : ExcelUtils.pos2X((String)this.positionInfo.getStartPosition().split(":")[0]);
        ArrayList<String> floatnumber = new ArrayList<String>();
        HashSet<Integer> existRowIndex = new HashSet<Integer>(16);
        if (fixmemset.size() == 0) {
            return;
        }
        this.filterFloatDim(rows, floatnumber);
        rows = this.filterByFixMembers(rows);
        if (rows.size() == 0) {
            return;
        }
        this.rowslimitfix = rows;
        if (this.checkHasFloat((Integer)fixmem.keySet().iterator().next(), floatnumber, rangestartindex, rangeendindex, startvalueindex, existRowIndex)) {
            return;
        }
        FloatDataProvider.sortRowByDim(this.rowslimitfix, floatnumber.toArray(new String[0]));
        Map<MemberGroupKey, List<Row>> rowMap = this.toRowMap(rows, floatnumber);
        DimGroupKey dimkey = new DimGroupKey(floatnumber);
        this.orgname = FloatDataProvider.getOrgNameMap(this.plugin == null ? this.abplugin.getModelId() : this.plugin.getModelId(), rows);
        int start2insert = this.findStart2insertIndex(range, this.basePointInfo.isDirectHoriz());
        this.result = FloatLogicImpl.collectMemMsg(this.rowslimitfix, this.basePointInfo, this.getModelId());
        int addSize = this.plugin != null ? this.plugin.insertRank(start2insert, rowMap.size(), this.basePointInfo.getDynaRange(), this.basePointInfo.isDirectHoriz()) : this.insertRank(start2insert, rowMap.size(), this.basePointInfo.getDynaRange(), this.basePointInfo.isDirectHoriz(), pageCache);
        RangeModel rangeModel = new RangeModel(this.basePointInfo.getDynaRange());
        int missIndex = -1;
        if (start2insert == rangestartindex) {
            if (!existRowIndex.isEmpty()) {
                missIndex = start2insert;
            }
        } else {
            missIndex = addSize + start2insert + 1;
        }
        for (MemberGroupKey dimlist : rowMap.keySet()) {
            if (start2insert == missIndex) {
                ++start2insert;
            }
            this.updataSheetModel(dimlist, start2insert, rangeModel, dimkey);
            ++start2insert;
        }
    }

    private List<Row> filterByFixMembers(List<Row> rows) {
        ArrayList<Row> realrows = new ArrayList<Row>(10);
        List samplemems = (List)this.basePointInfo.getFixMemberPosition().values().iterator().next();
        if (samplemems.size() < 1) {
            return rows;
        }
        ArrayList<String> fixdim = new ArrayList<String>(samplemems.size());
        for (IDimMember m : samplemems) {
            fixdim.add(m.getDimension().getNumber());
        }
        Map<MemberGroupKey, List<Row>> rowMap = this.toRowMap(rows, fixdim);
        for (List members : this.basePointInfo.getFixMemberPosition().values()) {
            ArrayList<String> objMembers = new ArrayList<String>(10);
            for (IDimMember m : members) {
                objMembers.add(m.getNumber());
            }
            MemberGroupKey key = MemberGroupKey.create(objMembers);
            List<Row> list = rowMap.get(key);
            if (list == null) continue;
            realrows.addAll(list);
        }
        return realrows;
    }

    private void filterFloatDim(List<Row> rows, List<String> floatnumber) {
        for (BasePointInnerLineInfo info : this.basePointInfo.getBasePointInnerLineInfo()) {
            Set<String> numbers;
            if (info.isFloated()) {
                floatnumber.add(info.getDimension().getNumber());
            }
            if (!info.isFloated() || FloatDataProvider.isIncludeFilterDim(info.getDimension().getNumber()) || (numbers = TemplateFloatUtil.getNumbersByInnerInfo(info, this.plugin.getModelId())) == null) continue;
            if (DimTypesEnum.MYCOMPANY.getNumber().equals(info.getDimension().getNumber()) && this.mcMap == null) {
                this.mcMap = FloatLogicImpl.getRowTable(rows, DimTypesEnum.MYCOMPANY.getNumber());
            }
            Multimap<String, Row> filtermap = DimTypesEnum.MYCOMPANY.getNumber().equals(info.getDimension().getNumber()) ? this.mcMap : this.icMap;
            for (String fkey : filtermap.keySet()) {
                if (numbers.contains(fkey)) continue;
                this.rowslimitfix.removeAll(filtermap.get((Object)fkey));
            }
            if (this.rowslimitfix.size() != 0) continue;
            break;
        }
    }

    private List<String> getDmNumberLis() {
        Iterator it = this.basePointInfo.getFixMemberPosition().values().iterator();
        ArrayList<String> dmNumberLis = new ArrayList<String>();
        if (it.hasNext()) {
            List dmList = (List)it.next();
            for (IDimMember dm : dmList) {
                dmNumberLis.add(dm.getDimension().getNumber());
            }
        } else {
            return null;
        }
        return dmNumberLis;
    }

    private List<Row> getRows(boolean isCsl, Map<String, MDResultSet> setmap) {
        List<Row> rows = this.basePointInfo.getDirect() == 1 || this.basePointInfo.getDirect() == 2 ? FloatDataProvider.getResultRowByArea(this.plugin == null ? this.templateModel : this.plugin.getTemplateModel(), this.sm, setmap, this.positionInfo, this.basePointInfo) : FloatDataProvider.getResultRowByArea(setmap, this.basePointInfo.getOriginalDynaRange());
        return rows;
    }

    private boolean checkHasFloat(int entryKey, List<String> floatnumber, int rangestartindex, int rangeendindex, int startvalueindex, Set<Integer> existRowIndex) {
        Map<MemberGroupKey, List<Row>> mapData = null;
        ArrayList<Integer> deledata = new ArrayList<Integer>();
        int moneyColIndex = -1;
        boolean gobyfilter = false;
        boolean entityOnFixMemb = this.checkEntityOnFixMemb();
        ArrayList<Pair> k = new ArrayList<Pair>();
        for (int i = rangestartindex; i <= rangeendindex; ++i) {
            Cell cell;
            Cell cell2 = cell = this.basePointInfo.isDirectHoriz() ? this.getEffectiveSheet().getCell(startvalueindex + entryKey, i) : this.getEffectiveSheet().getCell(i, startvalueindex + entryKey);
            if (!cell.isMdDataDomain()) continue;
            gobyfilter = true;
            List mems = cell.getMemberFromUserObject();
            if (mems != null && !mems.isEmpty()) {
                Object mem2;
                boolean floatEntity = false;
                for (Object mem2 : mems) {
                    if (!floatnumber.contains(mem2.getDimension().getNumber())) continue;
                    k.add(Pair.onePair((Object)mem2.getDimension().getNumber(), (Object)mem2.getNumber()));
                    if (!DimTypesEnum.ENTITY.getNumber().equals(mem2.getDimension().getNumber())) continue;
                    floatEntity = true;
                }
                if (cell.getUserObject("entity") != null) {
                    k.add(Pair.onePair((Object)DimTypesEnum.ENTITY.getNumber(), (Object)((String)cell.getUserObject("entity"))));
                } else if (!floatEntity && !entityOnFixMemb) {
                    k.add(Pair.onePair((Object)DimTypesEnum.ENTITY.getNumber(), (Object)this.reportOrgNumber));
                }
                if (mapData == null) {
                    moneyColIndex = this.rowslimitfix.get(0).getColIndex(FacTabFieldDefEnum.FIELD_MONEY.getField());
                    ArrayList<String> dims = new ArrayList<String>(k.size());
                    for (Pair p : k) {
                        dims.add(p.p1.toString());
                    }
                    mapData = this.toRowMap(this.rowslimitfix, dims);
                }
                ArrayList<Object> members = new ArrayList<Object>(k.size());
                mem2 = k.iterator();
                while (mem2.hasNext()) {
                    Pair p;
                    p = (Pair)mem2.next();
                    members.add(p.p2);
                }
                MemberGroupKey key = MemberGroupKey.create(members);
                if (mapData.containsKey(key)) {
                    FloatDataProvider.dealRowByPack(mapData, key, this.cellValues, cell, this.reportOrgNumber, moneyColIndex);
                    existRowIndex.add(i);
                } else {
                    deledata.add(i);
                }
            }
            k.clear();
        }
        if (deledata.size() > 0) {
            AskExcuteInfo excuteinfo = this.basePointInfo.isDirectHoriz() ? new AskExcuteInfo(1, RowColExcuteEnum.DELETECOL, deledata) : new AskExcuteInfo(0, RowColExcuteEnum.DELETEROW, deledata);
            this.plugin.adjustSheetModelAndJs(excuteinfo);
            RangeModel rangeModel = new RangeModel(this.basePointInfo.getDynaRange());
            ArrayList<Integer> insertdata = new ArrayList<Integer>(deledata.size());
            for (int i = 0; i < deledata.size(); ++i) {
                insertdata.add(this.basePointInfo.isDirectHoriz() ? rangeModel.getX_end() : rangeModel.getY_end());
            }
            AskExcuteInfo insertinfo = this.basePointInfo.isDirectHoriz() ? new AskExcuteInfo(1, RowColExcuteEnum.INSERTCOL, insertdata) : new AskExcuteInfo(0, RowColExcuteEnum.INSERTROW, insertdata);
            this.plugin.adjustSheetModelAndJs(insertinfo);
        }
        if (gobyfilter) {
            if (mapData == null || mapData.isEmpty()) {
                return true;
            }
            this.rowslimitfix.clear();
            for (List rs : mapData.values()) {
                this.rowslimitfix.addAll(rs);
            }
        }
        return false;
    }

    private boolean checkEntityOnFixMemb() {
        List dimMembers;
        if (!this.basePointInfo.getFixMemberPosition().isEmpty() && (dimMembers = (List)this.basePointInfo.getFixMemberPosition().entrySet().iterator().next().getValue()) != null) {
            for (IDimMember member : dimMembers) {
                if (!SysDimensionEnum.Entity.getNumber().equals(member.getDimension().getNumber())) continue;
                return true;
            }
        }
        return false;
    }

    private void updataSheetModel(MemberGroupKey dimlist, int startIndex, RangeModel rangeModel, DimGroupKey dimkey) {
        int row = 0;
        int col = 0;
        int checkRowIndex = -1;
        int checkColIndex = -1;
        ArrayList<DimMember> members = new ArrayList<DimMember>();
        for (BasePointInnerLineInfo info : this.basePointInfo.getBasePointInnerLineInfo()) {
            DimMember member;
            if (!info.isFloated()) continue;
            members.clear();
            int offset = info.getOffset();
            if (info.isSeq()) {
                offset = 0;
            }
            if (this.basePointInfo.isDirectHoriz()) {
                row = rangeModel.getY_start() + offset;
                col = startIndex;
            } else {
                col = rangeModel.getX_start() + offset;
                row = startIndex;
            }
            if (checkColIndex == -1) {
                checkColIndex = col;
            }
            if (checkRowIndex == -1) {
                checkRowIndex = row;
            }
            IDimension dimension = info.getDimension();
            String numbernum = dimlist.getValue(dimkey.getIndex(info.getDimension().getNumber())).toString();
            Map<String, Map<String, String>> mems = this.result.get(dimension.getNumber());
            if (mems != null && mems.size() > 0) {
                Map<String, String> membermsg = mems.get(numbernum);
                member = new DimMember(membermsg.get("name"), membermsg.get("number"), null, dimension);
            } else {
                DynamicObject dynaObj = QueryServiceHelper.queryOne((String)DimensionUtil.getDimMembEntityNumByDimNum(info.getDimension().getNumber()), (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)numbernum).and(new QFilter("dimension.number", "=", (Object)info.getDimension().getNumber()))});
                member = ObjectConvertUtils.toDimMember(dynaObj, dimension);
            }
            members.add(member);
            if (info.isSeq()) {
                this.getEffectiveSheet().getCell(row, col).setUserObject("seqobject", (Object)member);
            } else {
                this.getEffectiveSheet().getCell(row, col).addDims2UserObject(members);
            }
            PositionInfo.FloatMemDisplayPattern pattern = this.positionInfo.getFloatMemDisplayPattern();
            int ordinal = pattern == null ? 0 : pattern.ordinal() + 1;
            String msg = this.getEffectiveSheet().getCell(row, col).displayDimMsg(ordinal);
            this.getEffectiveSheet().getCell(row, col).setValue((Object)msg);
            if (this.plugin != null) {
                this.cellValues.add(this.plugin.packedUpdateCellMap(row, col, msg));
                continue;
            }
            this.cellValues.add(this.packedUpdateCellMap(row, col, msg));
        }
        if (checkColIndex != -1 || checkRowIndex != -1) {
            TemplateFloatUtil.setMsgBack2Cell(this.getModelId(), this.sm, checkRowIndex, checkColIndex, null, true, false, this.positionInfo, this.basePointInfo);
        }
    }

    public Map<String, Object> packedUpdateCellMap(int r, int c, Object value) {
        HashMap<String, Object> valMap = new HashMap<String, Object>();
        valMap.put(SpreadProperties.UpdataValueMethod.R.k(), r);
        valMap.put(SpreadProperties.UpdataValueMethod.C.k(), c);
        valMap.put(SpreadProperties.UpdataValueMethod.V.k(), value);
        return valMap;
    }

    private void updataSheetValue(int entryKey, int startvalueindex, int start2insert) {
        String range = this.basePointInfo.getDynaRange();
        int row = 0;
        int col = 0;
        ArrayList<DimMember> members = new ArrayList<DimMember>();
        for (Row r : this.rowslimitfix) {
            Cell cell;
            if (this.basePointInfo.isDirectHoriz()) {
                col = start2insert++;
            } else {
                row = start2insert++;
            }
            for (BasePointInnerLineInfo info : this.basePointInfo.getBasePointInnerLineInfo()) {
                DimMember member;
                if (!info.isFloated()) continue;
                members.clear();
                int offset = info.getOffset();
                if (info.isSeq()) {
                    offset = 0;
                }
                if (this.basePointInfo.isDirectHoriz()) {
                    row = ExcelUtils.pos2Y((String)range.split(":")[0]) + offset;
                } else {
                    col = ExcelUtils.pos2X((String)range.split(":")[0]) + offset;
                }
                IDimension dimension = info.getDimension();
                String numbernum = r.getString(info.getDimension().getNumber());
                Map<String, Map<String, String>> mems = this.result.get(dimension.getNumber());
                if (mems != null && mems.size() > 0) {
                    Map<String, String> membermsg = mems.get(numbernum);
                    member = new DimMember(membermsg.get("name"), membermsg.get("number"), null, dimension);
                } else {
                    DynamicObject dynaObj = QueryServiceHelper.queryOne((String)DimensionUtil.getDimMembEntityNumByDimNum(info.getDimension().getNumber()), (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)numbernum).and(new QFilter("dimension.number", "=", (Object)info.getDimension().getNumber()))});
                    member = ObjectConvertUtils.toDimMember(dynaObj, dimension);
                }
                members.add(member);
                if (info.isSeq()) {
                    this.getEffectiveSheet().getCell(row, col).setUserObject("seqobject", (Object)member);
                } else {
                    this.getEffectiveSheet().getCell(row, col).addDims2UserObject(members);
                }
                PositionInfo.FloatMemDisplayPattern pattern = TemplateFloatUtil.findFloatDisplayPattern(this.sm, row, col);
                int ordinal = pattern == null ? 0 : pattern.ordinal() + 1;
                String msg = this.getEffectiveSheet().getCell(row, col).displayDimMsg(ordinal);
                this.getEffectiveSheet().getCell(row, col).setValue((Object)msg);
                this.cellValues.add(this.plugin.packedUpdateCellMap(row, col, msg));
                TemplateFloatUtil.setMsgBack2Cell(this.getModelId(), this.sm, row, col, r.getString(DimTypesEnum.ENTITY.getNumber()), true, false);
            }
            Map<Object, Object> orgvalMap = new HashMap();
            String dataOregNumber = r.getString(DimTypesEnum.ENTITY.getNumber());
            if (this.basePointInfo.isDirectHoriz()) {
                cell = this.getEffectiveSheet().getCell(startvalueindex + entryKey, col);
                cell.setValue(r.getOriginalValue(FacTabFieldDefEnum.FIELD_MONEY.getField()));
                if (!this.plugin.isEPM()) {
                    this.log.info("not update value r:" + cell.getRow() + " c:" + cell.getCol());
                    cell.setUserObject("notupdata", (Object)(!dataOregNumber.equals(this.reportOrgNumber) ? 1 : 0));
                }
                cell.setUserObject("floatmd", (Object)true);
                if (this.positionInfo.getOrgMemColIndex() != -1) {
                    String name = this.orgname.get(r.getString(DimTypesEnum.ENTITY.getNumber()));
                    orgvalMap = this.plugin.packedUpdateCellMap(startvalueindex + this.positionInfo.getOrgMemColIndex(), col, name);
                }
            } else {
                cell = this.getEffectiveSheet().getCell(row, startvalueindex + entryKey);
                cell.setValue(r.getOriginalValue(FacTabFieldDefEnum.FIELD_MONEY.getField()));
                if (!this.plugin.isEPM()) {
                    this.log.info("not update value r:" + cell.getRow() + " c:" + cell.getCol());
                    cell.setUserObject("notupdata", (Object)(!dataOregNumber.equals(this.reportOrgNumber) ? 1 : 0));
                }
                cell.setUserObject("floatmd", (Object)true);
                if (this.positionInfo.getFloatSummaryWay() == PositionInfo.FloatSummaryWay.NONSUPPORT) {
                    String name = this.orgname.get(r.getString(DimTypesEnum.ENTITY.getNumber()));
                    orgvalMap = this.plugin.packedUpdateCellMap(row, startvalueindex + this.positionInfo.getOrgMemColIndex(), name);
                }
            }
            this.cellValues.add(orgvalMap);
        }
    }

    private long getModelId() {
        if (this.plugin == null) {
            return this.abplugin.getModelId();
        }
        return this.plugin.getModelId();
    }

    private Map<MemberGroupKey, List<Row>> toRowMap(List<Row> rows, List<String> dims) {
        int[] colIndeies = new int[dims.size()];
        for (int i = 0; i < dims.size(); ++i) {
            colIndeies[i] = rows.get(0).getColIndex(dims.get(i));
        }
        LinkedHashMap<MemberGroupKey, List<Row>> rowMap = new LinkedHashMap<MemberGroupKey, List<Row>>();
        for (Row row : rows) {
            MemberGroupKey key = MemberGroupKey.create((int[])colIndeies, (Row)row);
            ArrayList<Row> rs = (ArrayList<Row>)rowMap.get(key);
            if (rs == null) {
                rs = new ArrayList<Row>();
                rowMap.put(key, rs);
            }
            rs.add(row);
        }
        return rowMap;
    }

    private MemberGroupKey getRowKey(List<IDimMember> dimMembers, List<String> dmNumberList) {
        ArrayList<String> members = new ArrayList<String>(dimMembers.size());
        for (String dimNumber : dmNumberList) {
            for (IDimMember mem : dimMembers) {
                if (!dimNumber.equals(mem.getDimension().getNumber())) continue;
                members.add(mem.getNumber());
            }
        }
        if (members.size() != dmNumberList.size()) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\u3002", (String)"AutoFloatLogicImpl_0", (String)"epm-eb-budget", (Object[])new Object[0]));
        }
        MemberGroupKey key = MemberGroupKey.create(members);
        return key;
    }

    public int findStart2insertIndex(String range, boolean isCol) {
        int start2insert;
        String start = range.split(":")[0];
        String end = range.split(":")[1];
        int n = start2insert = isCol ? ExcelUtils.pos2X((String)end) : ExcelUtils.pos2Y((String)end);
        if (isCol) {
            for (int i = ExcelUtils.pos2X((String)end); i >= ExcelUtils.pos2X((String)start); --i) {
                for (int j = ExcelUtils.pos2Y((String)end); j >= ExcelUtils.pos2Y((String)start); --j) {
                    Cell cell = this.getEffectiveSheet().getCell(j, i);
                    if (cell.getMemberFromUserObject() == null || cell.getMemberFromUserObject().size() == 0) {
                        start2insert = i;
                        continue;
                    }
                    if (cell.getValue() == null) {
                        start2insert = i;
                        continue;
                    }
                    return start2insert;
                }
            }
        } else {
            for (int i = ExcelUtils.pos2Y((String)end); i >= ExcelUtils.pos2Y((String)start); --i) {
                for (int j = ExcelUtils.pos2X((String)end); j >= ExcelUtils.pos2X((String)start); --j) {
                    Cell cell = this.getEffectiveSheet().getCell(i, j);
                    if (cell.getMemberFromUserObject() == null || cell.getMemberFromUserObject().size() == 0) {
                        start2insert = i;
                        continue;
                    }
                    if (cell.getValue() == null) {
                        start2insert = i;
                        continue;
                    }
                    return start2insert;
                }
            }
        }
        return start2insert;
    }

    private Sheet getEffectiveSheet() {
        return this.sm.getBook().getSheet(0);
    }

    private void adjustPositonInfo(AskExcuteInfo excuteinfo, IPageCache pageCache) {
        List matchbaseinfos;
        String serial = pageCache.get(MatchBaseInfoWithRowCol);
        if (serial != null) {
            matchbaseinfos = (List)ObjectSerialUtil.deSerializedBytes((String)serial);
        } else {
            boolean isdirectHoriz = excuteinfo.getOperation() == 1;
            matchbaseinfos = (List)ObjectSerialUtil.deSerializedBytes((String)ObjectSerialUtil.toByteSerialized(this.matchBasePositonWithOperationdata(isdirectHoriz, excuteinfo, this.sm, pageCache)));
        }
        pageCache.remove(MatchBaseInfoWithRowCol);
        matchbaseinfos.forEach(matchbaseinfo -> {
            BasePointInfo currentbasepositinfo = matchbaseinfo.getBasepoint();
            if (currentbasepositinfo != null) {
                MarkSpecialCell.markSpecialCells(currentbasepositinfo, false, this.view, this.spread_key);
            }
        });
        this.returndatatoView(excuteinfo, this.view);
        boolean deleteOrAdd = excuteinfo.getMethod() == RowColExcuteEnum.DELETECOL || excuteinfo.getMethod() == RowColExcuteEnum.DELETEROW;
        excuteinfo.getOperationdata().forEach(dealdata -> {
            AdjustRangeEvent adjust = new AdjustRangeEvent(dealdata.intValue(), excuteinfo.getOperation(), deleteOrAdd ? -1 : 1);
            adjust.setCheck(excuteinfo.isCheck());
            this.sm.getAreaManager().getPostionInfoSet().forEach(pos -> pos.adjustRange(adjust));
            matchbaseinfos.forEach(matchbaseinfo -> {
                BasePointInfo currentbasepositinfo = matchbaseinfo.getBasepoint();
                if (currentbasepositinfo != null) {
                    currentbasepositinfo.adjustRange(adjust);
                }
            });
        });
        matchbaseinfos.forEach(matchbaseinfo -> {
            BasePointInfo currentbasepositinfo = matchbaseinfo.getBasepoint();
            if (currentbasepositinfo != null) {
                MarkSpecialCell.markSpecialCells(currentbasepositinfo, true, this.view, this.spread_key);
            }
        });
    }

    private void returndatatoView(AskExcuteInfo excuteinfo, IFormView view) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("status", true);
        if (excuteinfo.isCon() && excuteinfo.getOperationdata().size() > 0) {
            ArrayList rangeList = new ArrayList();
            HashMap<String, Integer> data = new HashMap<String, Integer>();
            data.put("index", excuteinfo.getOperationdata().get(0));
            data.put("count", excuteinfo.getOperationdata().size());
            rangeList.add(data);
            map.put("data", rangeList);
        } else {
            map.put("data", excuteinfo.getOperationdata());
        }
        ((IClientViewProxy)view.getService(IClientViewProxy.class)).invokeControlMethod(this.spread_key, excuteinfo.getMethod().getMethod(), new Object[]{map});
    }

    private List<MatchBaseInfo> matchBasePositonWithOperationdata(boolean direct, AskExcuteInfo excuteinfo, SpreadManager sm, IPageCache pageCache) {
        List operationdata = (List)ObjectSerialUtil.deSerializedBytes((String)ObjectSerialUtil.toByteSerialized(excuteinfo.getOperationdata()));
        return this.matchBasePositonWithOperationdata(direct, operationdata, sm, pageCache);
    }

    private List<MatchBaseInfo> matchBasePositonWithOperationdata(boolean direct, List<Integer> operationdata, SpreadManager sm, IPageCache pageCache) {
        ArrayList<MatchBaseInfo> matchbaseinfos = new ArrayList<MatchBaseInfo>();
        sm.getAreaManager().getPostionInfoSet().forEach(position -> position.getBasePoints().forEach(basepoint -> {
            MatchBaseInfo matchbaseinfo = new MatchBaseInfo((PositionInfo)position, (BasePointInfo)basepoint, (List<Integer>)new ArrayList<Integer>());
            RangeModel rangemodel = SpreadAreaUtil.getRangModel((String)basepoint.getDynaRange());
            Iterator dataiterator = operationdata.iterator();
            while (dataiterator.hasNext()) {
                Integer data = (Integer)dataiterator.next();
                if (direct) {
                    if (data >= rangemodel.getX_start() && data <= rangemodel.getX_end()) {
                        matchbaseinfo.getRowOrcols().add(data);
                        dataiterator.remove();
                    }
                    if (rangemodel.getX_start() != rangemodel.getX_end()) continue;
                    matchbaseinfo.setOnlyOneRowCol(true);
                    continue;
                }
                if (data >= rangemodel.getY_start() && data <= rangemodel.getY_end()) {
                    matchbaseinfo.getRowOrcols().add(data);
                    dataiterator.remove();
                }
                if (rangemodel.getY_start() != rangemodel.getY_end()) continue;
                matchbaseinfo.setOnlyOneRowCol(true);
            }
            if (matchbaseinfo.getRowOrcols().size() > 0) {
                matchbaseinfos.add(matchbaseinfo);
            }
        }));
        matchbaseinfos.add(new MatchBaseInfo(null, null, operationdata));
        pageCache.put(MatchBaseInfoWithRowCol, ObjectSerialUtil.toByteSerialized(matchbaseinfos));
        return matchbaseinfos;
    }

    public int insertRank(int start2insert, int num, String range, boolean isCol, IPageCache pageCache) {
        ArrayList<Integer> insertdata = new ArrayList<Integer>();
        boolean ischeck = true;
        int beginindex = isCol ? ExcelUtils.pos2X((String)range.split(":")[0]) : ExcelUtils.pos2Y((String)range.split(":")[0]);
        int endindex = isCol ? ExcelUtils.pos2X((String)range.split(":")[1]) : ExcelUtils.pos2Y((String)range.split(":")[1]);
        num -= endindex - start2insert;
        if (start2insert == beginindex) {
            ArrayList<Integer> tem = new ArrayList<Integer>();
            tem.add(start2insert);
            ++start2insert;
            AskExcuteInfo excuteinfo = isCol ? new AskExcuteInfo(1, RowColExcuteEnum.INSERTCOL, insertdata) : new AskExcuteInfo(0, RowColExcuteEnum.INSERTROW, tem);
            pageCache.put(MatchBaseInfoWithRowCol, ObjectSerialUtil.toByteSerialized(this.matchBasePositonWithOperationdata(isCol, excuteinfo, this.sm, this.abplugin.getPageCache())));
            ischeck = false;
        }
        if (num > 0) {
            for (int i = 0; i <= num; ++i) {
                insertdata.add(start2insert);
            }
        }
        AskExcuteInfo excuteinfo = isCol ? new AskExcuteInfo(1, RowColExcuteEnum.INSERTCOL, insertdata) : new AskExcuteInfo(0, RowColExcuteEnum.INSERTROW, insertdata);
        excuteinfo.setCheck(ischeck);
        excuteinfo.setCon(true);
        this.adjustInsertIndex(excuteinfo, range);
        SpreadDataModel.adjustSheet(excuteinfo, this.sm);
        this.adjustPositonInfo(excuteinfo, pageCache);
        return num < 0 ? 0 : num;
    }

    private void adjustInsertIndex(AskExcuteInfo excuteinfo, String range) {
        int start;
        if (RowColExcuteEnum.DELETECOL == excuteinfo.getMethod() || RowColExcuteEnum.DELETEROW == excuteinfo.getMethod()) {
            return;
        }
        String startPoint = range.split(":")[0];
        int n = start = RowColExcuteEnum.INSERTCOL == excuteinfo.getMethod() ? ExcelUtils.pos2X((String)startPoint) : ExcelUtils.pos2Y((String)startPoint);
        if (excuteinfo.getOperationdata().size() == 1 && excuteinfo.getOperationdata().get(0) == start) {
            excuteinfo.getOperationdata().clear();
            excuteinfo.getOperationdata().add(start + 1);
        }
    }

    static class MatchBaseInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private BasePointInfo basepoint;
        private PositionInfo positioninfo;
        private List<Integer> rowOrcols = new ArrayList<Integer>();
        private boolean isOnlyOneRowCol = false;

        public MatchBaseInfo(PositionInfo positioninfo, BasePointInfo basepoint, List<Integer> rowOrcols) {
            this.positioninfo = positioninfo;
            this.setBasepoint(basepoint);
            this.rowOrcols = rowOrcols;
        }

        public PositionInfo getPositioninfo() {
            return this.positioninfo;
        }

        public void setPositioninfo(PositionInfo positioninfo) {
            this.positioninfo = positioninfo;
        }

        public BasePointInfo getBasepoint() {
            return this.basepoint;
        }

        public final void setBasepoint(BasePointInfo basepoint) {
            this.basepoint = basepoint;
        }

        public List<Integer> getRowOrcols() {
            return this.rowOrcols;
        }

        public void setRowOrcols(List<Integer> rowOrcols) {
            this.rowOrcols = rowOrcols;
        }

        public boolean isOnlyOneRowCol() {
            return this.isOnlyOneRowCol;
        }

        public void setOnlyOneRowCol(boolean isOnlyOneRowCol) {
            this.isOnlyOneRowCol = isOnlyOneRowCol;
        }
    }
}

