/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.report.floatreport;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.budget.formplugin.template.util.TemplateFloatUtil;
import kd.epm.eb.common.ebcommon.common.util.ExcelUtils;
import kd.epm.eb.common.ebcommon.common.util.QFBuilder;
import kd.epm.eb.ebSpread.domain.Cell;
import kd.epm.eb.ebSpread.domain.ColumnDimDomain;
import kd.epm.eb.ebSpread.domain.RowDimDomain;
import kd.epm.eb.ebSpread.domain.view.Sheet;
import kd.epm.eb.ebSpread.domain.view.SpreadManager;
import kd.epm.eb.ebSpread.domain.view.builder.PositionInfo;
import kd.epm.eb.ebSpread.domain.view.builder.dynamic.BasePointInfo;
import kd.epm.eb.ebSpread.domain.view.builder.dynamic.BasePointInnerLineInfo;
import kd.epm.eb.ebSpread.domain.view.builder.dynamic.DynaMembScopeInfo;
import kd.epm.eb.ebSpread.model.DimMember;
import kd.epm.eb.ebSpread.model.Dimension;
import kd.epm.eb.ebSpread.model.IDimMember;
import kd.epm.eb.ebSpread.model.IDimension;
import kd.epm.eb.ebSpread.model.dao.Tuple;

public class SeqLogicImpl {
    protected SpreadManager spread;
    protected String dimnumber;
    protected List<String> seqnumbers = new ArrayList<String>();
    protected boolean isH;

    public List<String> getSeqnumbers() {
        return this.seqnumbers;
    }

    public String getDimnumber() {
        return this.dimnumber;
    }

    public SeqLogicImpl(SpreadManager spread, long modelId, boolean isH) {
        this.spread = spread;
        String membernumber = null;
        block0: for (PositionInfo ps : spread.getAreaManager().getPostionInfoSet()) {
            for (BasePointInfo bs : ps.getBasePoints()) {
                for (BasePointInnerLineInfo line : bs.getBasePointInnerLineInfo()) {
                    if (!line.isSeq()) continue;
                    this.dimnumber = line.getDimension().getNumber();
                    membernumber = ((DynaMembScopeInfo)line.getDynaMembScopes().get(0)).getMember().getNumber();
                    break block0;
                }
            }
        }
        if (StringUtils.isNotEmpty(membernumber)) {
            QFBuilder qb = new QFBuilder();
            qb.add(new QFilter("model", "=", (Object)modelId));
            qb.and(new QFilter("dimension.number", "=", (Object)this.dimnumber));
            qb.and(new QFilter("parent.number", "=", membernumber));
            DynamicObjectCollection doc = QueryServiceHelper.query((String)"epm_userdefinedmembertree", (String)"number,dseq", (QFilter[])qb.toArray(), (String)"dseq");
            if (doc != null && doc.size() > 0) {
                this.seqnumbers = new ArrayList<String>(doc.size());
                for (DynamicObject obj : doc) {
                    this.seqnumbers.add(obj.getString("number"));
                }
            }
        }
    }

    public boolean fillBackSeq() {
        HashMap<Integer, DimMember> dimmap = new HashMap<Integer, DimMember>();
        if (this.seqnumbers.size() != 0) {
            this.spread.getAreaManager().getPostionInfoSet().forEach(p -> p.getBasePoints().forEach(b -> b.reCollectUsedSeq(this.spread)));
            Sheet sheet = this.spread.getBook().getSheet(0);
            for (int row = 0; row < sheet.getMaxRowCount(); ++row) {
                for (int col = 0; col < sheet.getMaxColumnCount(); ++col) {
                    DimMember mem;
                    int memindex;
                    Cell cell = sheet.getCell(row, col);
                    if (cell.getUserObject("needseq") == null) continue;
                    BasePointInfo bs = TemplateFloatUtil.getBasePointInfoByMdCell(this.spread, cell.getRow(), cell.getCol(), this.isH);
                    String key = SeqLogicImpl.getFloatKey(bs, cell);
                    int n = memindex = this.isH ? cell.getCol() : cell.getRow();
                    if (dimmap.get(memindex) != null) {
                        mem = (DimMember)dimmap.get(memindex);
                    } else {
                        String curMemberNumber = this.getCurSeq(bs, key);
                        if (curMemberNumber == null) {
                            return false;
                        }
                        mem = new DimMember(null, curMemberNumber, null, (IDimension)new Dimension(null, this.dimnumber, null));
                        dimmap.put(memindex, mem);
                        this.fillbackTuple(cell, mem);
                        this.fillBackseqObj(bs, mem, cell);
                        bs.setUsedSeq(key, mem.getNumber());
                    }
                    List mems = cell.getMemberFromUserObject();
                    for (int i = 0; i < mems.size(); ++i) {
                        IDimMember m = (IDimMember)mems.get(i);
                        if (!this.dimnumber.equals(m.getDimension().getNumber())) continue;
                        int midex = mems.indexOf(m);
                        mems.remove(m);
                        mems.add(midex, mem);
                        break;
                    }
                    cell.removeUserObject("needseq");
                }
            }
            return true;
        }
        return false;
    }

    private void fillbackTuple(Cell cell, DimMember mem) {
        String point = ExcelUtils.xy2Pos((int)cell.getCol(), (int)cell.getRow());
        PositionInfo pInfo = TemplateFloatUtil.getPositionInfobyCell(this.spread, point);
        Tuple randc = this.spread.getAreaManager().getRowAndColDomainByPosition(pInfo);
        List dimlist = !this.isH ? ((RowDimDomain)randc.k).getDimensions() : ((ColumnDimDomain)randc.v).getDimensions();
        boolean iscon = false;
        for (IDimension dim : dimlist) {
            if (!dim.getNumber().equals(mem.getDimension().getNumber())) continue;
            dim.addMember((IDimMember)mem);
            iscon = true;
            break;
        }
        if (!iscon) {
            Dimension dim = new Dimension(mem.getDimension().getName(), mem.getDimension().getNumber(), mem.getDimension().getUqCode());
            dim.addMember((IDimMember)mem);
            dimlist.add(dim);
        }
    }

    private String getCurSeq(BasePointInfo bs, String key) {
        Map usedMap = bs.getUsedSeq();
        List usedset = (List)usedMap.get(key);
        if (usedset != null) {
            int usedSetSize = usedset.size();
            if (usedSetSize < this.seqnumbers.size() && !usedset.contains(this.seqnumbers.get(usedSetSize))) {
                boolean allMatch = true;
                for (int i = 0; i < usedset.size(); ++i) {
                    if (((String)usedset.get(i)).equals(this.seqnumbers.get(i))) continue;
                    allMatch = false;
                    break;
                }
                if (allMatch) {
                    return this.seqnumbers.get(usedSetSize);
                }
            }
            for (String s : this.seqnumbers) {
                if (usedset.contains(s)) continue;
                return s;
            }
            return null;
        }
        if (this.seqnumbers.size() > 0) {
            return this.seqnumbers.get(0);
        }
        return null;
    }

    private void fillBackseqObj(BasePointInfo bs, DimMember mem, Cell cell) {
        int x = 0;
        int y = 0;
        String range = bs.getDynaRange();
        if (!this.isH) {
            y = cell.getRow();
            x = ExcelUtils.pos2X((String)range.split(":")[0]);
        }
        this.spread.getBook().getSheet(0).getCell(y, x).setUserObject("seqobject", (Object)mem);
    }

    public static DimMember getFirstSeqMem(long modelId) {
        DimMember member = (DimMember)ThreadCache.get((Object)("dimmember_" + modelId));
        if (member != null) {
            return member;
        }
        QFBuilder qb = new QFBuilder();
        qb.add(new QFilter("model", "=", (Object)modelId));
        qb.add(new QFilter("isseq", "=", (Object)"1"));
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"epm_userdefinedmembertree", (String)"id,dimension.number,number", (QFilter[])qb.toArray());
        if (doc != null && doc.size() > 0) {
            if (doc.size() == 1) {
                qb = new QFBuilder();
                qb.add(new QFilter("model", "=", (Object)modelId));
                qb.and(new QFilter("parent", "=", ((DynamicObject)doc.get(0)).get("id")));
                qb.and(new QFilter("dseq", "=", (Object)1));
                DynamicObject first = QueryServiceHelper.queryOne((String)"epm_userdefinedmembertree", (String)"id,dimension.number,dimension.name,number,name", (QFilter[])qb.toArray());
                if (first != null) {
                    String dimnum = first.getString("dimension.number");
                    String memnum = first.getString("number");
                    String dimname = first.getString("dimension.name");
                    String memname = first.getString("name");
                    Dimension dim = new Dimension(dimname, dimnum, null);
                    member = new DimMember(memname, memnum, null, (IDimension)dim);
                    member.setId(first.getLong("id"));
                    ThreadCache.put((Object)("dimmember_" + modelId), (Object)member);
                    return member;
                }
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u4f5c\u4e3a\u5e8f\u53f7\u7684\u6210\u5458\u4e0d\u552f\u4e00\u3002", (String)"SeqLogicImpl_0", (String)"epm-eb-budget", (Object[])new Object[0]));
            }
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5e8f\u53f7\u6210\u5458\u3002", (String)"SeqLogicImpl_1", (String)"epm-eb-budget", (Object[])new Object[0]));
    }

    public static DimMember getParentSeqMem(long modelId) {
        QFBuilder qb = new QFBuilder();
        qb.add(new QFilter("model", "=", (Object)modelId));
        qb.add(new QFilter("isseq", "=", (Object)"1"));
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"epm_userdefinedmembertree", (String)"id,dimension.number,dimension.name,number,name", (QFilter[])qb.toArray());
        if (doc != null && doc.size() > 0) {
            if (doc.size() == 1) {
                DynamicObject first = (DynamicObject)doc.get(0);
                String dimnum = first.getString("dimension.number");
                String memnum = first.getString("number");
                String dimname = first.getString("dimension.name");
                String memname = first.getString("name");
                Dimension dim = new Dimension(dimname, dimnum, null);
                DimMember member = new DimMember(memname, memnum, null, (IDimension)dim);
                member.setId(first.getLong("id"));
                return member;
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u4f5c\u4e3a\u5e8f\u53f7\u7684\u6210\u5458\u4e0d\u552f\u4e00\u3002", (String)"SeqLogicImpl_0", (String)"epm-eb-budget", (Object[])new Object[0]));
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5e8f\u53f7\u6210\u5458\u3002", (String)"SeqLogicImpl_1", (String)"epm-eb-budget", (Object[])new Object[0]));
    }

    public static String getFloatKey(BasePointInfo bs, Cell cell) {
        return BasePointInfo.getFloatKey((BasePointInfo)bs, (List)cell.getMemberFromUserObject());
    }
}

