/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.report.multi;

import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.budget.formplugin.report.multi.ReportModelTypeEnum;
import kd.epm.eb.budget.formplugin.report.multi.ReportTabInfo;
import kd.epm.eb.budget.formplugin.report.multi.ReportTabModel;
import kd.epm.eb.budget.formplugin.spread.SpreadUtils;
import kd.epm.eb.budget.formplugin.template.multiview.TempFormulaUtil;
import kd.epm.eb.common.cache.GlobalCacheServiceHelper;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;
import kd.epm.eb.common.ebcommon.enums.TemplateTypeEnum;
import kd.epm.eb.ebBusiness.serviceHelper.AppCacheServiceHelper;
import kd.epm.eb.ebBusiness.template.model.TemplateModel;
import kd.epm.eb.ebBusiness.util.MyTemplateUtil;
import kd.epm.eb.ebSpread.domain.view.JsonSerializerUtil;
import kd.epm.eb.ebSpread.domain.view.SpreadManager;

public class ModelDataProvider {
    private static final Log log = LogFactory.getLog(ModelDataProvider.class);

    public ReportTabModel query4Cache(ReportTabInfo tab, IPageCache cache) {
        ReportTabModel item = new ReportTabModel(tab.getTabKey(), cache);
        TemplateModel template = ModelDataProvider.getTemplateModel(tab.getTemplateId());
        String spreadSerial = null;
        String spreadJson = null;
        boolean isFromTemplateModel = false;
        String orgid = tab.getTabKey().split("\\|")[0];
        if (ReportModelTypeEnum.REPORT == tab.getModelType() && !template.getTemplateType().equals(TemplateTypeEnum.DYNA.getType())) {
            log.info(" current report id is :{}", tab.getReportId());
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"", (String)"eb_reportentity", (String)"spreadjson,data", (QFilter[])new QFilter("id", "=", tab.getReportId()).toArray(), null);){
                if (ds.hasNext()) {
                    Row row = ds.next();
                    spreadJson = row.getString("spreadjson");
                    spreadSerial = row.getString("data");
                }
            }
            if (StringUtils.isEmpty((String)spreadJson)) {
                DynamicObject orgTmp;
                spreadJson = template.getRptSpreadJson();
                spreadSerial = StringUtils.isNotEmpty((String)template.getRptData()) ? template.getRptData() : template.getData();
                isFromTemplateModel = true;
                if (!template.isSaveByDim() && (orgTmp = MyTemplateUtil.getOrgTemplate((TemplateModel)template, (long)Long.parseLong(orgid))) != null) {
                    spreadJson = orgTmp.getString("spreadjson");
                    spreadSerial = orgTmp.getString("data");
                    SpreadManager sm = JsonSerializerUtil.toSpreadManager((String)spreadSerial);
                    spreadJson = TempFormulaUtil.removeAccFormula(sm, spreadJson);
                    isFromTemplateModel = false;
                }
            }
        } else {
            DynamicObject orgTmp;
            isFromTemplateModel = true;
            spreadJson = template.getRptSpreadJson();
            String string = spreadSerial = StringUtils.isNotEmpty((String)template.getRptData()) ? template.getRptData() : template.getData();
            if (!template.isSaveByDim() && (orgTmp = MyTemplateUtil.getOrgTemplate((TemplateModel)template, (long)Long.parseLong(orgid))) != null) {
                spreadJson = orgTmp.getString("spreadjson");
                spreadSerial = orgTmp.getString("data");
                SpreadManager sm = JsonSerializerUtil.toSpreadManager((String)spreadSerial);
                spreadJson = TempFormulaUtil.removeAccFormula(sm, spreadJson);
                isFromTemplateModel = false;
            }
        }
        item.initReportTabModel(spreadJson, spreadSerial, !isFromTemplateModel);
        item.setTemplateModel(template);
        SpreadUtils.updateCellOnUnchangeState(item.getSpreadModel().getBook(), false);
        return item;
    }

    public TemplateModel initTemplateModel(Object tempId) {
        String tempIdStr = tempId.toString();
        String templateSerial = (String)AppCacheServiceHelper.get((String)tempIdStr, String.class);
        DynamicObject templateDy = null;
        TemplateModel template = new TemplateModel();
        if (StringUtils.isEmpty((String)templateSerial)) {
            templateDy = new TemplateDataProvider().query(tempId);
            template.loadDynaObj2Model(templateDy);
            AppCacheServiceHelper.put((String)tempIdStr, (Object)ObjectSerialUtil.toByteSerialized((Object)template));
        } else {
            template = (TemplateModel)ObjectSerialUtil.deSerializedBytes((String)templateSerial);
        }
        return template;
    }

    public static TemplateModel getTemplateModel(Object templateId) {
        String templateIdStr = templateId.toString();
        TemplateModel template = (TemplateModel)GlobalCacheServiceHelper.getImmutableTemplateModelOn((String)templateIdStr, () -> {
            String templateSerial = (String)AppCacheServiceHelper.get((String)templateIdStr, String.class);
            DynamicObject templateDy = null;
            TemplateModel templateRef = null;
            if (StringUtils.isEmpty((String)templateSerial)) {
                templateDy = new TemplateDataProvider().query(templateId);
                templateRef = TemplateModel.genImmutableModel((DynamicObject)templateDy);
                AppCacheServiceHelper.put((String)templateIdStr, (Object)ObjectSerialUtil.toByteSerialized((Object)templateRef));
            } else {
                templateRef = (TemplateModel)ObjectSerialUtil.deSerializedBytes((String)templateSerial);
            }
            return templateRef;
        });
        return template;
    }

    static interface IDataProvider {
        public DynamicObject query(Object var1);

        default public DynamicObject toPlainQuery(String entityName, String selectFields, QFilter[] filters) {
            return QueryServiceHelper.queryOne((String)entityName, (String)selectFields, (QFilter[])filters);
        }

        default public DynamicObject queryModel(String entityName, Object pk) {
            return BusinessDataServiceHelper.loadSingle((Object)pk, (String)entityName);
        }
    }

    static class ReportDataProvider
    implements IDataProvider {
        ReportDataProvider() {
        }

        @Override
        public DynamicObject query(Object pk) {
            return this.toPlainQuery("eb_reportentity", "spreadjson,data", new QFilter[]{new QFilter("id", "=", pk)});
        }
    }

    static class TemplateDataProvider
    implements IDataProvider {
        TemplateDataProvider() {
        }

        @Override
        public DynamicObject query(Object pk) {
            return this.queryModel("eb_templateentity_bg", pk);
        }
    }
}

