/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.report.multi;

import java.io.Serializable;
import kd.bos.cache.ThreadCache;
import kd.bos.form.IPageCache;
import kd.bos.util.StringUtils;
import kd.epm.eb.budget.formplugin.report.multi.ModelDataProvider;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;
import kd.epm.eb.ebBusiness.template.model.TemplateModel;
import kd.epm.eb.ebSpread.domain.view.JsonSerializerUtil;
import kd.epm.eb.ebSpread.domain.view.SpreadManager;

public class ReportTabModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SPREAD_SERIAL = "_spreadserial";
    public static final String SPREAD_JSON = "_spreadjson";
    public static final String ORI_SPREAD_SERIAL = "_ori_spreadserial";
    public static final String REPORT_TAB_MODEL = "report_tab_model";
    private transient SpreadManager sm;
    private transient TemplateModel templateModel;
    private String cacheKey;
    private transient String spreadJson;
    private transient String initSpreadModelSerial;
    private transient IPageCache cache;
    private transient boolean isOverWriteOriginalData = false;
    private Object templateId;

    public ReportTabModel(String cacheKey, IPageCache cache) {
        this.cacheKey = cacheKey;
        this.cache = cache;
    }

    public String getCacheKey() {
        return this.cacheKey;
    }

    public void setPageCache(IPageCache cache) {
        this.cache = cache;
    }

    public void setSpreadModel(SpreadManager sm) {
        this.sm = sm;
    }

    public TemplateModel getTemplateModel() {
        if (this.templateModel == null) {
            this.templateModel = ModelDataProvider.getTemplateModel(this.templateId);
        }
        return this.templateModel;
    }

    public void setTemplateModel(TemplateModel templateModel) {
        this.templateModel = templateModel;
        this.templateId = templateModel.getId();
    }

    public void setSpreadJson(String spreadJson) {
        this.spreadJson = spreadJson;
    }

    public void setSpreadJson(String spreadJson, SpreadManager spread) {
        this.spreadJson = spreadJson;
        this.setInitSpreadModelSerial(JsonSerializerUtil.toJson((SpreadManager)spread));
        this.isOverWriteOriginalData = true;
    }

    public void setSpreadJson(String spreadJson, String spread) {
        this.spreadJson = spreadJson;
        this.setInitSpreadModelSerial(spread);
        this.isOverWriteOriginalData = true;
    }

    public void initReportTabModel(String spreadJson, String spread, boolean isOverWriteOriginalData) {
        this.spreadJson = spreadJson;
        this.setInitSpreadModelSerial(spread);
        this.isOverWriteOriginalData = isOverWriteOriginalData;
        this.sm = JsonSerializerUtil.toSpreadManager((String)spread);
    }

    public void setInitSpreadModelSerial(String initSpreadModelSerial) {
        this.initSpreadModelSerial = initSpreadModelSerial;
    }

    public SpreadManager getSpreadModel() {
        if (this.sm == null) {
            String spreadSerial = this.cache.get(this.getCacheKey() + SPREAD_SERIAL);
            this.sm = spreadSerial != null ? JsonSerializerUtil.toSpreadManager((String)spreadSerial) : JsonSerializerUtil.toSpreadManager((String)this.getOriginalSpreadModelSerial());
        }
        return this.sm;
    }

    private String getOriginalSpreadModelSerial() {
        if (this.initSpreadModelSerial == null) {
            this.initSpreadModelSerial = this.cache.get(this.getCacheKey() + ORI_SPREAD_SERIAL);
            if (StringUtils.isEmpty((String)this.initSpreadModelSerial)) {
                this.initSpreadModelSerial = this.getTemplateModel().getRptData();
            }
        }
        return this.initSpreadModelSerial;
    }

    public String getSpreadJson() {
        if (this.spreadJson == null) {
            this.spreadJson = this.cache.get(this.getCacheKey() + SPREAD_JSON);
            if (StringUtils.isEmpty((String)this.spreadJson)) {
                this.spreadJson = this.getTemplateModel().getRptSpreadJson();
            }
        }
        return this.spreadJson;
    }

    public void reInitSpreadModel() {
        SpreadManager initSm = JsonSerializerUtil.toSpreadManager((String)this.getOriginalSpreadModelSerial());
        initSm.setFilter(this.getSpreadModel().getFilter());
        this.sm = initSm;
    }

    public void cache() {
        ThreadCache.put((Object)(REPORT_TAB_MODEL + this.cacheKey), (Object)this);
        this.cache.put(this.getCacheKey(), ObjectSerialUtil.toByteSerialized((Object)this));
        if (this.isOverWriteOriginalData) {
            if (this.initSpreadModelSerial != null) {
                this.cache.put(this.getCacheKey() + ORI_SPREAD_SERIAL, this.initSpreadModelSerial);
            }
            if (this.spreadJson != null) {
                this.cache.put(this.getCacheKey() + SPREAD_JSON, this.spreadJson);
            }
        }
        if (this.sm != null) {
            this.cache.put(this.getCacheKey() + SPREAD_SERIAL, JsonSerializerUtil.toJson((SpreadManager)this.sm));
        }
    }

    public void lightCache() {
        this.cache.put(this.getCacheKey(), ObjectSerialUtil.toByteSerialized((Object)this));
    }
}

