/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.report.style;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.form.IClientViewProxy;
import kd.epm.eb.budget.formplugin.report.style.IStyleController;
import kd.epm.eb.budget.formplugin.report.style.StyleContext;
import kd.epm.eb.common.datalock.DataLockKey;
import kd.epm.eb.common.datalock.DataLockService;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.ebSpread.domain.Cell;
import kd.epm.eb.ebSpread.domain.view.Sheet;
import kd.epm.eb.ebSpread.model.IDimMember;

public class DataLockController
implements IStyleController {
    private static final DataLockService service = DataLockService.getInstance();
    private static final Set<String> controlDimensionsKey = Sets.newHashSet((Object[])new String[]{SysDimensionEnum.Year.getNumber(), SysDimensionEnum.Currency.getNumber(), SysDimensionEnum.Version.getNumber()});
    private static final List<String> controlDimensionList = Arrays.asList(SysDimensionEnum.Year.getNumber(), SysDimensionEnum.Currency.getNumber(), SysDimensionEnum.Version.getNumber(), SysDimensionEnum.Entity.getNumber(), SysDimensionEnum.Period.getNumber());
    public static final Map<String, Integer> controlDimensionMap = Maps.newHashMap();
    public static final String dataLocked = "dataLocked";

    @Override
    public void controlStyle(StyleContext ctx, IClientViewProxy view) {
        List pageMembers;
        Long modelId = ctx.getModelId();
        List viewMembers = ctx.getSpreadManager().getFilter().getViewPointDomain().getAllMembers();
        Map<String, Set<String>> controlMaps = this.getLockControlMembers(viewMembers, pageMembers = ctx.getSpreadManager().getFilter().getPageDomain().getAllMembers(), ctx.getSpreadManager().getBook().getSheet(0));
        if (!(controlMaps.containsKey(SysDimensionEnum.Year.getNumber()) && controlMaps.containsKey(SysDimensionEnum.Currency.getNumber()) && controlMaps.containsKey(SysDimensionEnum.Version.getNumber()))) {
            return;
        }
        Map dataLockMap = service.getDataLockMap(modelId, controlMaps);
        if (dataLockMap.isEmpty()) {
            return;
        }
        String[] initialString = this.getinitalString(controlMaps);
        ctx.getSpreadManager().getBook().getSheet(0).iteratorCells(c -> {
            boolean isLock;
            boolean bl = isLock = c.getUserObject().get((Object)"locked") != null && (Boolean)c.getUserObject().get((Object)"locked") != false;
            if (!isLock && c.isMdDataDomain()) {
                List cellMembers = c.getMemberFromUserObject();
                String[] cellNumber = this.getCellNumber(cellMembers, initialString);
                DataLockKey dataLockKey = new DataLockKey(cellNumber[0], cellNumber[1], cellNumber[2]);
                Map stringSetMap = (Map)dataLockMap.get(dataLockKey);
                if (stringSetMap != null) {
                    Set periods = (Set)stringSetMap.get(cellNumber[3]);
                    if (periods != null && periods.contains(cellNumber[4])) {
                        c.getUserObject().put((Object)dataLocked, (Object)Boolean.TRUE);
                        ctx.lockCell((Cell)c);
                    } else {
                        ctx.unlockCell((Cell)c);
                        c.getUserObject().put((Object)dataLocked, (Object)Boolean.FALSE);
                    }
                } else {
                    ctx.unlockCell((Cell)c);
                    c.getUserObject().put((Object)dataLocked, (Object)Boolean.FALSE);
                }
            }
        });
    }

    private String[] getinitalString(Map<String, Set<String>> controlMaps) {
        String[] initialString = new String[5];
        for (int i = 0; i < controlDimensionList.size(); ++i) {
            String dimNumber = controlDimensionList.get(i);
            Set<String> strings = controlMaps.get(dimNumber);
            if (strings == null || strings.size() != 1) continue;
            initialString[i] = strings.iterator().next();
        }
        return initialString;
    }

    private String[] getCellNumber(List<IDimMember> cellMembers, String[] initialString) {
        String[] strings = Arrays.copyOf(initialString, 5);
        for (IDimMember iDimMember : cellMembers) {
            String dimNumber = iDimMember.getDimension().getNumber();
            if (!controlDimensionMap.containsKey(dimNumber)) continue;
            Integer index = controlDimensionMap.get(dimNumber);
            strings[index.intValue()] = iDimMember.getNumber();
        }
        return strings;
    }

    private Map<String, Set<String>> getLockControlMembers(List<IDimMember> viewMembers, List<IDimMember> pageMembers, Sheet sheet) {
        HashMap controlMaps = Maps.newHashMapWithExpectedSize((int)controlDimensionMap.size());
        for (IDimMember iDimMember : viewMembers) {
            if (!controlDimensionMap.containsKey(iDimMember.getDimension().getNumber())) continue;
            controlMaps.put(iDimMember.getDimension().getNumber(), Sets.newHashSet((Object[])new String[]{iDimMember.getNumber()}));
        }
        for (IDimMember iDimMember : pageMembers) {
            if (!controlDimensionMap.containsKey(iDimMember.getDimension().getNumber())) continue;
            controlMaps.put(iDimMember.getDimension().getNumber(), Sets.newHashSet((Object[])new String[]{iDimMember.getNumber()}));
        }
        if (controlMaps.containsKey(SysDimensionEnum.Year.getNumber()) && controlMaps.containsKey(SysDimensionEnum.Currency.getNumber()) && controlMaps.containsKey(SysDimensionEnum.Version.getNumber())) {
            return controlMaps;
        }
        sheet.iteratorCells(c -> {
            boolean isLock;
            boolean bl = isLock = c.getUserObject().get((Object)"locked") != null && (Boolean)c.getUserObject().get((Object)"locked") != false;
            if (!isLock && c.isMdDataDomain()) {
                List members = c.getMemberFromUserObject();
                for (IDimMember iDimMember : members) {
                    if (!controlDimensionsKey.contains(iDimMember.getDimension().getNumber())) continue;
                    Set sets = controlMaps.computeIfAbsent(iDimMember.getDimension().getNumber(), k -> Sets.newHashSetWithExpectedSize((int)16));
                    sets.add(iDimMember.getNumber());
                }
            }
        });
        return controlMaps;
    }

    static {
        controlDimensionMap.put(SysDimensionEnum.Year.getNumber(), 0);
        controlDimensionMap.put(SysDimensionEnum.Currency.getNumber(), 1);
        controlDimensionMap.put(SysDimensionEnum.Version.getNumber(), 2);
        controlDimensionMap.put(SysDimensionEnum.Entity.getNumber(), 3);
        controlDimensionMap.put(SysDimensionEnum.Period.getNumber(), 4);
    }
}

