/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.report.style;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.budget.formplugin.report.style.DataLockController;
import kd.epm.eb.budget.formplugin.report.style.StyleContext;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.datalock.DataLockEntry;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.lazytree.ITreeNode;
import kd.epm.eb.common.lazytree.datalock.EntityTree;
import kd.epm.eb.common.lazytree.datalock.PeriodEnable;
import kd.epm.eb.ebSpread.domain.Cell;
import kd.epm.eb.ebSpread.model.IDimMember;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class DataLockUtils {
    private static final List<String> controlDimensionList = Arrays.asList(SysDimensionEnum.Year.getNumber(), SysDimensionEnum.Period.getNumber(), SysDimensionEnum.Currency.getNumber(), SysDimensionEnum.Version.getNumber(), SysDimensionEnum.Entity.getNumber());
    private static final String selectFields = "id,name,number,parent,longnumber,isleaf";
    private static final int PAGE_SIZE = 1000;
    public static final String LOAD_MORE_NUMBER = "...loadMore...";

    public static String getTips(StyleContext ctx, Cell cell, long modelId) {
        List viewMembers = ctx.getSpreadManager().getFilter().getViewPointDomain().getAllMembers();
        List pageMembers = ctx.getSpreadManager().getFilter().getPageDomain().getAllMembers();
        HashMap controlMaps = Maps.newHashMapWithExpectedSize((int)5);
        for (IDimMember iDimMember : viewMembers) {
            if (!DataLockController.controlDimensionMap.containsKey(iDimMember.getDimension().getNumber())) continue;
            controlMaps.put(iDimMember.getDimension().getNumber(), iDimMember.getName());
        }
        for (IDimMember iDimMember : pageMembers) {
            if (!DataLockController.controlDimensionMap.containsKey(iDimMember.getDimension().getNumber())) continue;
            controlMaps.put(iDimMember.getDimension().getNumber(), iDimMember.getName());
        }
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        List members = cell.getMemberFromUserObject();
        for (IDimMember iDimMember : members) {
            if (!DataLockController.controlDimensionMap.containsKey(iDimMember.getDimension().getNumber())) continue;
            Member member = modelCache.getMember(iDimMember.getDimension().getNumber(), null, iDimMember.getNumber());
            controlMaps.put(iDimMember.getDimension().getNumber(), member.getName());
        }
        Object[] strings = new String[5];
        for (int i = 0; i < controlDimensionList.size(); ++i) {
            strings[i] = (String)controlMaps.get(controlDimensionList.get(i));
        }
        return StringUtils.join((Object[])strings, (String)";");
    }

    public static EntityTree buildTree(long modelId, Map<String, Set<String>> dataLockData) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Member rootMember = modelCache.getMember(SysDimensionEnum.Entity.getNumber(), null, SysDimensionEnum.Entity.getNumber());
        List<Member> members = modelCache.getMembers(null, SysDimensionEnum.Period.getNumber());
        members = members.stream().filter(member -> !member.getNumber().equals(SysDimensionEnum.Period.getNumber())).collect(Collectors.toList());
        List<PeriodEnable> beginPeriodEnables = dataLockData.containsKey(rootMember.getNumber()) ? DataLockUtils.getPeriodEnables(members, dataLockData.get(rootMember.getNumber())) : DataLockUtils.getDefaultPeriodEnables(members);
        EntityTree rootTree = new EntityTree(rootMember.getId().longValue(), rootMember.getName(), rootMember.getNumber(), null, null, beginPeriodEnables);
        rootTree.setChildren(DataLockUtils.createChildren(rootTree, rootMember, members, dataLockData));
        return rootTree;
    }

    public static EntityTree buildPageTree(long modelId, Map<String, Set<String>> dataLockData, QFilter qFilter, EntityTree parent, Boolean isSearch) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        List<Member> members = modelCache.getMembers(null, SysDimensionEnum.Period.getNumber());
        if (parent == null) {
            QFilter qFilter1 = new QFilter("level", "=", (Object)1).and("model", "=", (Object)modelId);
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)SysDimensionEnum.Entity.getMemberTreemodel(), (String)selectFields, (QFilter[])qFilter1.toArray());
            if (dynamicObject == null) {
                return null;
            }
            members = members.stream().filter(member -> !member.getNumber().equals(SysDimensionEnum.Period.getNumber())).collect(Collectors.toList());
            String rootNumber = dynamicObject.getString("number");
            List<PeriodEnable> beginPeriodEnables = dataLockData.containsKey(rootNumber) ? DataLockUtils.getPeriodEnables(members, dataLockData.get(rootNumber)) : DataLockUtils.getDefaultPeriodEnables(members);
            parent = new EntityTree(dynamicObject.getLong("id"), dynamicObject.getString("name"), rootNumber, null, null, beginPeriodEnables);
        }
        QFilter qFilter2 = qFilter.and("model", "=", (Object)modelId);
        DataLockUtils.initPageChildren(parent, members, dataLockData, qFilter2, 0, isSearch);
        return parent;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DynamicObjectCollection queryPage(String memberKey, String selectFields, QFilter[] filters, String orderBys, int off, int len) {
        ORM orm = ORM.create();
        try (DataSet ds = orm.queryDataSet("kd.epm.eb.common.datalock.DataLockUtils", memberKey, selectFields, filters, orderBys, off * 1000, len);){
            DynamicObjectCollection dynamicObjectCollection = orm.toPlainDynamicObjectCollection(ds);
            return dynamicObjectCollection;
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static List<PeriodEnable> getPeriodEnables(List<Member> members, Set<String> periods) {
        ArrayList<PeriodEnable> periodEnables = new ArrayList<PeriodEnable>(members.size());
        members.forEach(member -> {
            String periodNumber = member.getNumber();
            periodEnables.add(new PeriodEnable(periodNumber.toLowerCase(), periods.contains(periodNumber)));
        });
        return periodEnables;
    }

    private static EntityTree initPageChildren(EntityTree parent, List<Member> members, Map<String, Set<String>> dataLockData, QFilter qFilter, int off, Boolean isSearch) {
        DynamicObjectCollection query = DataLockUtils.queryPage(SysDimensionEnum.Entity.getMemberTreemodel(), selectFields, qFilter.toArray(), "level,dseq", off, 1001);
        if (CollectionUtils.isNotEmpty((Collection)query)) {
            ArrayList<EntityTree> entityTrees = new ArrayList<EntityTree>(query.size());
            int i = 0;
            for (DynamicObject dynamicObject : query) {
                if (i == 1000) {
                    EntityTree entityTree = new EntityTree(dynamicObject.getLong("id"), ResManager.loadKDString((String)"...\u52a0\u8f7d\u66f4\u591a...", (String)"RuleControlAllotOrgPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]), LOAD_MORE_NUMBER, parent, null, null);
                    entityTree.setChildren(null);
                    entityTrees.add(entityTree);
                    break;
                }
                String number = dynamicObject.getString("number");
                Boolean isleaf = isSearch != false ? true : dynamicObject.getBoolean("isleaf");
                List<PeriodEnable> periodEnables = dataLockData.containsKey(number) ? DataLockUtils.getPeriodEnables(members, dataLockData.get(number)) : null;
                EntityTree entityTree = new EntityTree(dynamicObject.getLong("id"), dynamicObject.getString("name"), number, parent, null, periodEnables);
                if (!isleaf.booleanValue()) {
                    entityTree.setChildren(new ArrayList(16));
                }
                entityTrees.add(entityTree);
                ++i;
            }
            parent.setChildren(entityTrees);
        }
        return parent;
    }

    private static List<ITreeNode> createChildren(EntityTree parent, Member rootMember, List<Member> members, Map<String, Set<String>> dataLockData) {
        List children = rootMember.getChildren(true);
        if (CollectionUtils.isNotEmpty((Collection)children)) {
            ArrayList<ITreeNode> entityTrees = new ArrayList<ITreeNode>(children.size());
            for (Member child : children) {
                List<PeriodEnable> periodEnables = dataLockData.containsKey(child.getNumber()) ? DataLockUtils.getPeriodEnables(members, dataLockData.get(child.getNumber())) : null;
                EntityTree entityTree = new EntityTree(child.getId().longValue(), child.getName(), child.getNumber(), parent, null, periodEnables);
                entityTree.setChildren(DataLockUtils.createChildren(entityTree, child, members, dataLockData));
                entityTrees.add((ITreeNode)entityTree);
            }
            return entityTrees;
        }
        return null;
    }

    public static List<PeriodEnable> getDefaultPeriodEnables(List<Member> members) {
        ArrayList<PeriodEnable> periodEnables = new ArrayList<PeriodEnable>(members.size());
        members.forEach(member -> periodEnables.add(new PeriodEnable(member.getNumber().toLowerCase(), false)));
        return periodEnables;
    }

    public static Map<String, String> getPeriod2ParentMapping(IModelCacheHelper modelCache) {
        Member rootMember = modelCache.getMember(SysDimensionEnum.Period.getNumber(), null, "Period");
        HashMap<String, String> periodMapping = new HashMap<String, String>(16);
        DataLockUtils.getPeriod2ParentMapping(rootMember, periodMapping);
        return periodMapping;
    }

    private static void getPeriod2ParentMapping(Member rootMember, Map<String, String> periodMapping) {
        List children = rootMember.getChildrenNotWithCosmic();
        if (CollectionUtils.isNotEmpty((Collection)children)) {
            String parentNumber = rootMember.getNumber().toLowerCase();
            for (Member child : children) {
                String number = child.getNumber().toLowerCase(Locale.getDefault());
                if (!number.endsWith("yeartotal")) {
                    periodMapping.put(number, parentNumber);
                }
                DataLockUtils.getPeriod2ParentMapping(child, periodMapping);
            }
        }
    }

    public static Map<String, Set<String>> getPeriodMapping(IModelCacheHelper modelCache) {
        Member rootMember = modelCache.getMember(SysDimensionEnum.Period.getNumber(), null, "Period");
        HashMap<String, Set<String>> periodMapping = new HashMap<String, Set<String>>(16);
        DataLockUtils.gePeriodMapping(rootMember, periodMapping);
        return periodMapping;
    }

    private static void gePeriodMapping(Member rootMember, Map<String, Set<String>> periodMapping) {
        List children = rootMember.getChildrenNotWithCosmic();
        if (CollectionUtils.isNotEmpty((Collection)children)) {
            String number = rootMember.getNumber().toLowerCase(Locale.getDefault());
            if (!"period".equals(number)) {
                periodMapping.put(number, children.stream().map(member -> member.getNumber().toLowerCase()).collect(Collectors.toSet()));
            }
            for (Member child : children) {
                DataLockUtils.gePeriodMapping(child, periodMapping);
            }
        }
    }

    public static List<String> getPeriods(IModelCacheHelper modelCache, boolean isLow) {
        List periodSort = modelCache.getMemberSort(SysDimensionEnum.Period.getNumber(), null, "Period", RangeEnum.ALL_EXCLUDE.getIndex());
        List<String> collect = periodSort.stream().map(BaseCache::getNumber).collect(Collectors.toList());
        if (isLow) {
            collect = collect.stream().map(String::toLowerCase).collect(Collectors.toList());
        }
        return collect;
    }

    public static List<PeriodEnable> getPeriodEnables(DynamicObject currRow, List<String> periods) {
        ArrayList<PeriodEnable> periodEnables = new ArrayList<PeriodEnable>(16);
        if (currRow == null) {
            return periodEnables;
        }
        for (String period : periods) {
            periodEnables.add(new PeriodEnable(period, currRow.getBoolean(period)));
        }
        return periodEnables;
    }

    public static List<DataLockEntry> getNeedSaveList(EntityTree treeRoot, IModelCacheHelper modelCache) {
        List<String> periods = DataLockUtils.getPeriods(modelCache, true);
        int emptyPeriodInt = DataLockUtils.getEmptyPeriodInt(periods);
        ArrayList<DataLockEntry> dataLockEntitys = new ArrayList<DataLockEntry>(16);
        DataLockUtils.getPeriodInt(treeRoot, periods, dataLockEntitys, emptyPeriodInt, emptyPeriodInt);
        return dataLockEntitys;
    }

    private static int getEmptyPeriodInt(List<String> allLeafMembers) {
        StringBuilder sb = new StringBuilder();
        sb.append('1');
        for (int i = 0; i < allLeafMembers.size(); ++i) {
            sb.append('0');
        }
        return Integer.parseInt(sb.toString(), 2);
    }

    private static void getPeriodInt(EntityTree treeNode, List<String> addMembers, List<DataLockEntry> dataLockEntitys, int emptyPeriodInt, int parentPeriodInt) {
        List children;
        List periodEnables = treeNode.getPeriodEnables();
        int periodInt = parentPeriodInt;
        if (periodEnables != null) {
            StringBuilder sb = new StringBuilder();
            sb.append('1');
            Map<String, Boolean> collect = periodEnables.stream().collect(Collectors.toMap(PeriodEnable::getPeriodNumber, PeriodEnable::isEnable));
            for (String periodNumber : addMembers) {
                sb.append(collect.get(periodNumber) != false ? (char)'1' : '0');
            }
            periodInt = Integer.parseInt(sb.toString(), 2);
        }
        if (periodInt != parentPeriodInt) {
            dataLockEntitys.add(new DataLockEntry(treeNode.getId(), periodInt));
        }
        if ((children = treeNode.getChildren()) != null) {
            for (ITreeNode child : children) {
                DataLockUtils.getPeriodInt((EntityTree)child, addMembers, dataLockEntitys, emptyPeriodInt, parentPeriodInt);
            }
        }
    }
}

