/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.report.style;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.util.StringUtils;
import kd.epm.eb.budget.formplugin.report.AbstractMultiReportPlugin;
import kd.epm.eb.budget.formplugin.util.SpreadMemUtil;
import kd.epm.eb.common.ebcommon.common.PairList;
import kd.epm.eb.common.ebcommon.common.enums.DimTypesEnum;
import kd.epm.eb.ebBusiness.serviceHelper.ConvertSchemeServiceHelper;

public class LockSheetLogic {
    public static final String LOCKSHEET = "locksheet";
    private AbstractMultiReportPlugin pulgin;
    private Map<DimTypesEnum, Object> map;
    private DynamicObject orgCurrency;
    private boolean isLeaf;
    private boolean isView;
    private boolean isCSTE;
    private boolean isCWP;

    public LockSheetLogic(AbstractMultiReportPlugin pulgin, Map<DimTypesEnum, Object> map, DynamicObject orgCurrency, boolean isLeaf, boolean isCSTE, boolean isCWP, boolean isView) {
        this.pulgin = pulgin;
        this.map = map;
        this.orgCurrency = orgCurrency;
        this.isLeaf = isLeaf;
        this.isCSTE = isCSTE;
        this.isCWP = isCWP;
        this.isView = isView;
    }

    public boolean checkIsOnlyRead() {
        if (this.isView) {
            return true;
        }
        String process = SpreadMemUtil.getMemFromFilter(this.pulgin.getSpreadModel(), DimTypesEnum.PROCESS.getNumber());
        String audittrail = SpreadMemUtil.getMemFromFilter(this.pulgin.getSpreadModel(), DimTypesEnum.AUDITTRIAL.getNumber());
        if (this.isCSTE) {
            return !"CSTE".equals(process) || !"EntityInput".equals(audittrail);
        }
        if (this.isCWP) {
            return false;
        }
        CurType ct = this.getCur();
        if (this.isLeaf) {
            if ("IRpt".equals(process) && "EntityInput".equals(audittrail) || "CWP".equals(audittrail)) {
                return false;
            }
            return !StringUtils.isEmpty((String)process) && !StringUtils.isEmpty((String)audittrail);
        }
        if ("CWP".equals(audittrail)) {
            return false;
        }
        if (CurType.EC == ct) {
            if ("CS".equals(process) && "EntityInput".equals(audittrail)) {
                return false;
            }
            if ("CS".equals(process) && "ATTotal".equals(audittrail)) {
                return false;
            }
            return !StringUtils.isEmpty((String)process) && !StringUtils.isEmpty((String)audittrail);
        }
        if ("CS".equals(process) && "EntityInput".equals(audittrail)) {
            return false;
        }
        return !StringUtils.isEmpty((String)process) && !StringUtils.isEmpty((String)audittrail);
    }

    private CurType getCur() {
        DynamicObject currency;
        DynamicObject dynamicObject = currency = this.pulgin.getView().getModel().getDataEntity().getDataEntityType().getProperties().containsKey((Object)"epm_currencymembertree") ? this.pulgin.getView().getModel().getDataEntity().getDynamicObject("epm_currencymembertree") : null;
        if (currency != null) {
            boolean isCvtCurreny;
            String cuNumber = currency.getString("number");
            String orgCurNum = this.orgCurrency.getString("number");
            if ("EC".equals(cuNumber) || cuNumber.equals(orgCurNum)) {
                return CurType.EC;
            }
            PairList cvtPath = ConvertSchemeServiceHelper.getOrgConvertPath((Object)this.pulgin.getModelId(), (Object)this.map.get(DimTypesEnum.SCENARIO), (Object)this.map.get(DimTypesEnum.ENTITY), (Object)this.map.get(DimTypesEnum.YEAR), (Long)Long.valueOf(this.map.get(DimTypesEnum.PERIOD).toString()));
            List cvtlist = cvtPath.toList();
            if (cvtlist.size() > 0) {
                cvtlist.remove(0);
            }
            boolean bl = isCvtCurreny = "PC".equals(currency.getString("number")) || cvtPath.toList().stream().anyMatch(p -> ((String)p.p2).equals(currency.getString("number")));
            if (isCvtCurreny) {
                return CurType.INPATHPC;
            }
            return CurType.NOTINPATHPC;
        }
        return null;
    }

    static enum CurType {
        EC,
        INPATHPC,
        NOTINPATHPC;

    }
}

